$Global:ErrorActionPreference="SilentlyContinue"
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

if($args.count -eq 0)
{
	Write-Host "Please supply the remote AAD server name"
	break
}

$RemoteADDServer = $args[0]

$localStagingStatus = $null
$remoteStagingStatus = $null
$localCycleStatus = $null
$remoteCycleStatus = $null

$StagingTrue = """StagingModeEnabled"":true"
$SyncCycleEnabledTrue = """SyncCycleEnabled"":true"
$StagingFalse = """StagingModeEnabled"":false"
$SyncCycleEnabledFalse = """SyncCycleEnabled"":false"

# Review local AAD Scheduler details
$localAAD = Get-ADSyncScheduler
$localAADstr = $localAAD.ToString()

if ($localAADstr -match $StagingTrue) {$localStagingStatus = "true"} 

if ($localAADstr -match $SyncCycleEnabledTrue) {$localCycleStatus = "true" }

if ($localAADstr -match $StagingFalse) {$localStagingStatus = "false" }

if ($localAADstr -match $SyncCycleEnabledFalse) {$localCycleStatus = "false" }

# Connect to remote AAD connect server
$remoteAAD = Invoke-Command -ComputerName $RemoteADDServer -ScriptBlock { Get-ADSyncScheduler }
$remoteAADstr = $remoteAAD.ToString()

if ($remoteAADstr -match $StagingTrue) {$remoteStagingStatus = "true"}

if ($remoteAADstr -match $StagingFalse) {$remoteStagingStatus = "false"}

if ($remoteAADstr -match $SyncCycleEnabledTrue) {$remoteCycleStatus = "true"}

if ($remoteAADstr -match $SyncCycleEnabledFalse) {$remoteCycleStatus = "false"}

if ($debug)
{
	Write-Host "local staging status:" $localStagingStatus
	Write-Host "local cycle status:" $localCycleStatus
	Write-Host "remote staging status:" $remoteStagingStatus
	Write-Host "remote cycle status:" $remoteCycleStatus
}

# Interpret results

Write-Host "Summary of AAD Connect server:" $env:computername

# OK
if ($localStagingStatus -eq "true" -and $localCycleStatus -eq "true" -and $remoteStagingStatus -eq "false" -and $remoteCycleStatus -eq "true")
{
	$Message = "Local server operating in ACTIVE STANDBY mode. Remote server operating in ACTIVE PRODUCTION mode."
	Write-Host "Operational Status: Ok."
	Write-Host "Message: " $Message
}
if ($localStagingStatus -eq "false" -and $localCycleStatus -eq "true" -and $remoteStagingStatus -eq "true" -and $remoteCycleStatus -eq "true")
{ 
	$Message = "Local server operating in ACTIVE PRODUCTION mode. Remote server operating in ACTIVE STANDBY mode."
	Write-Host "Operational Status: Ok."
	Write-Host "Message: " $Message
}

# Warning
if ($localStagingStatus -eq "true" -and $localCycleStatus -eq "false" -and $remoteStagingStatus -eq "false" -and $remoteCycleStatus -eq "true")
{
	$Message = "Local server operating in OFFLINE STANDBY mode. Remote server operating in ACTIVE PRODUCTION mode."
	Write-Host "Operational Status: Warning."
	Write-Host "Message: " $Message
}
if ($localStagingStatus -eq "false" -and $localCycleStatus -eq "true" -and $remoteStagingStatus -eq "null" -and $remoteCycleStatus -eq "null")
{
	$Message = "Local server operating in ACTIVE PRODUCTION mode. Remote server cannot be contacted, could be OFFLINE"
	Write-Host "Operational Status: Warning."
	Write-Host "Message: " $Message
}

# Offline Alert
if ($remoteStagingStatus -eq "null" -and $remoteCycleStatus -eq "null")
{ 
	$Message = "Local server operating in STANDBY mode. Remote server cannot be contacted, could be OFFLINE"
	Write-Host "Operational Status: Error."
	Write-Host "Message: " $Message
}

# Major Alert, confirmed configuration issue
if ($localCycleStatus -eq "false" -and $remoteCycleStatus -eq "false")
{
	$Message = "Both servers have their cycles disabled. Review immediately."
	Write-Host "Operational Status: Configuration Issue."
	Write-Host "Message: " $Message
}
if ($localStagingStatus -eq "true" -and $remoteStagingStatus -eq "true")
{
	$Message = "Both servers are in Staging mode. Review immediately." 
	Write-Host "Operational Status: Configuration Issue."
	Write-Host "Message: " $Message
}
if ($localStagingStatus -eq "false" -and $localCycleStatus -eq "true" -and $remoteCycleStatus -eq "true" -and $remoteStagingStatus -eq "false")
{ 
	$Message = "Both servers are in ACTIVE PRODUCTION mode. This violates Microsoft best practice and could cause replication problems. Review immediately."
	Write-Host "Operation Status: Configuration Issue."
	Write-Host "Message: " $Message
}


