$Global:ErrorActionPreference="SilentlyContinue"
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

if($args.Count -eq 0)
{
	"Syntax: CitrixCloudConnector.ps1 <CustomerId> <Path_of_secureclientfile> [Optional]<eG_Install_Dir> [Optional]<ProxySettings>"
	return
}

function GetBearerToken
{
	param (
	[Parameter(Mandatory=$true)]
	[string] $clientId,
	[Parameter(Mandatory=$true)]
	[string] $clientSecret
	)
  
	$postHeaders = @{"Content-Type"="application/json"}
	$body = @{
	"ClientId"=$clientId;
	"ClientSecret"=$clientSecret
	}
	$trustUrl = "https://trust.citrixworkspacesapi.net/root/tokens/clients"

	$response = Invoke-RestMethod -Uri $trustUrl -Method POST -Body (ConvertTo-Json $body) -Headers $postHeaders
	$bearerToken = $response.token

	return $bearerToken;
}

Add-PSSnapin Citrix*
$ProxyHost = 'none'
$ProxyUser = 'none'
$ProxyPwd = 'none'

if($args.Length -eq 2)
{
	$CustomerId = $args[0]
	$SecureClientFile = $args[1]
}
elseif($args.Length -eq 4)
{
	$CustomerId = $args[0]
	$SecureClientFile = $args[1]
	$eGInstallDir = $args[2]
	# The format is https://ip:port#user#password
	$ProxyArr = $args[3].ToString().Split('#') 
	if($ProxyArr.Length -eq 3)
	{
		$ProxyHost = $ProxyArr[0]
		$ProxyUser = $ProxyArr[1]
		$ProxyPwd = $ProxyArr[2]
		$OEPath = $eGInstallDir + "\lib\OE.exe"
		$ProxyPwd = & $OEPath $ProxyPwd
	}
}

if($ProxyHost -ne 'none')
{
	[system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($ProxyHost)
	if($ProxyUser -ne 'none' -and $ProxyPwd -ne 'none')
	{
		$proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $ProxyUser, $(convertto-securestring $ProxyPwd -asplaintext -force)
		[system.net.webrequest]::defaultwebproxy.credentials = $proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
		[system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
	}
}

Set-XDCredentials -CustomerId $CustomerId -SecureClientFile $SecureClientFile -ProfileType CloudApi -StoreAs "default"
Get-XDCredentials -ProfileName "default" | out-null

$Site = Get-BrokerSite
if ($Site -ne $null)
{
	Write-Host "Site Name="$Site.Name
}

Remove-PSSnapin Citrix*


