Import-Module FailoverClusters -EA SilentlyContinue
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$fqdn = (Get-WmiObjectwin32_computersystem).Domain
$cluster = get-itemproperty -path HKLM:\Cluster -ea 0
if($cluster)
{
	"Cluster Name:" + $cluster.ClusterName+"."+$fqdn   
}
if($cluster)
{
	$nodeNames = New-ObjectSystem.Collections.ArrayList
	$nodes = Get-ChildItem -Path HKLM:\Cluster\Nodes
	if($nodes)
	{
		foreach($node in $nodes)
		{
			$items = get-itemproperty $node.PsPath -ea 0
			ForEach ($Item in $Items)
			{
				$adapters = get-clusternode $item.NodeName | get-clusternetworkinterface
				if($adapters)
				{
					if($adapters.count -gt 0)
					{
						$adapterList = $adapters[0].Address
						"NodeName"+":"+$item.NodeName+"."+$fqdn+":"+$adapterList
						$null = $nodeNames.Add($item.NodeName+"."+$fqdn)
					}
				}
			}
		}
	}

    $nodeNames = $nodeNames | Sort-Object
	$IsHyperV = $false
	$NameSpace = Get-WMIObject -class __Namespace -namespace root\virtualization | select name
	if ($NameSpace)
	{
		$IsHyperV = $true
	}
	if ($IsHyperV)
	{
        $IsServer = $false
		# Get all virtual machine objects on the server in question
		$VMs = Get-CimInstance -namespace root\virtualization\v2 Msvm_ComputerSystem -filter "Caption = 'Virtual Machine'" 
		# Go over each of the virtual machines
		foreach ($VM in [array] $VMs) 
		{
			# Get the KVP Object
			$Kvp = Get-CimAssociatedInstance -InputObject $vm -Association Msvm_SystemDevice -ResultClassName Msvm_KvpExchangeComponent

			# Get the OSName value out of the guest KVP data
			$xml = [xml]($Kvp.GuestIntrinsicExchangeItems | ? {$_ -match "OSName"})
			$entry = $xml.Instance.Property | ?{$_.Name -eq "Data"}

			# Filter out offline virtual machines and virtual machines which did not return KVP data
			if ($entry.Value) 
			{
				$value = $entry.Value
				if ($value.indexOf("2008") -or $value.indexOf("2012") -or $value.indexOf("2016") -or $value.indexOf("2019") -or $value.indexOf("2022") -or $value.indexOf("server") -or $value.indexOf("Server"))
				{
					$IsServer = $true
 					break
				}
			}
		}
 
        foreach ($nodeName in $nodeNames)
        {
	        "NodeType:" + $nodeName + "=" + $IsServer
        }
    }
}



