﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy
clear

$testargs=$args
#<#
$userName=$testargs[0]
$Password=Eg-O365Dcr -EncStr $testargs[1]
$proxyUsr=$testargs[2]
$proxyPass=Eg-O365Dcr -EncStr $testargs[3]
$rptTopNDD=[int]$testargs[4]
$otherdetails=$testargs[5]
$details=$otherdetails.split("#")
$toHideAdminTrfic=$details[0]
$reportingname='EXO/'+$details[1]
$proxyserverip=($details[2]).ToString().trim()
$ExcludeMails=$details[3]
$rptNamFrMT=$details[1]
$appDetails=$testargs[6]
#>

if($proxyUsr.toString().toLower().Trim() -eq 'none') { $proxyUsr=$proxyUsr.toString().toLower().Trim() }
if($proxyPass.toString().toLower().Trim() -eq 'none') { $proxyPass=$proxyPass.toString().toLower().Trim() }
if($proxyserverip.toString().toLower().Trim().Contains('none')) { $proxyserverip=$proxyserverip.toString().toLower().Trim() }
$proxyserver='http://'+$proxyserverip

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

$filepath=$egurkhaPath+'/agent/'+$reportingname+'/'
try{
    $filereaded=Get-ChildItem -Path $filepath |Where-Object {$_.Name -like 'msgs*.dat'}| Sort-Object LastWriteTime -Descending | Select-Object -First 2 
    if($filereaded.Length -eq 2){
        if($filereaded[0].Length -lt 100 -and $filereaded[1].Length -ge 100){
            $fileName=([String]$filereaded[0].Name).Trim()
            if([System.IO.File]::Exists(($filepath+$fileName)) -eq 'True'){
                Remove-Item $filepath$fileName
            }
        }
    }  
    $readfiles1=Eg-ReadFile -ComntRptPath $reportingname -FileName "msgs" -keyFileName "kmsgs" -EgPath $egurkhaPath
    if($readfiles1 -ne $null -and [System.IO.File]::Exists($readfiles1[1]) -eq 'True'){
        $datafile1=$readfiles1[1] -replace (".csv",".dat") 
        $csvfile1=Unprotect-File $datafile1 -Algorithm AES -KeyAsPlainText $readfiles1[0]
        $MessageTracetemp= import-csv $csvfile1 -Encoding $encTyp  
        Remove-Item $csvfile1
        Eg-DeleteFiles -FilePath $readfiles1[2] -Pattern 'msgs' -InputFile $readfiles1[3]
        Eg-DeleteFiles -FilePath $readfiles1[2] -Pattern 'kmsgs' -InputFile $readfiles1[4]
        Write-Host 'ReadFile:'$readfiles1[3]
    }
}
catch{
    $errmsg=$_.Exception.Message
    Write-Error -Message $errmsg
}
[System.GC]::GetTotalMemory($true) | out-null
if ( Test-Path $filepath -PathType Container ) {
    if($rptNamFrMT -match '_exd'){
        $alldomainnames=@()
        $dhash=@{}
        $dmnshash=Eg-O635Domains -username $userName -password $Password -rptNam $rptNamFrMT -proxyserverip $proxyserver -proxyUsr $proxyUsr -proxyPass $proxyPass -appDetails $appDetails
        $arr=$dmnshash[$rptNamFrMT].split('~')
        $dhash.Add('SupersetName',$arr[1])
        $dhash.Add($arr[0],$rptNamFrMT)
    	foreach($h in $dhash.Keys){
	        if($dhash[$h] -match $rptNamFrMT){
                if($h.IndexOf(',') -ne -1){
                    $dmarr=$h.split(',')
                    foreach($ele in $dmarr){
                        $alldomainnames+=$ele
                    }
                }
                else{
                    $alldomainnames+=$h
                }		                
	        }
	    }
    }else{
        $alldomainnames=Eg-GetDomain -userName $username -Password $Password -proxyUsr $proxyUsr -proxyPass $proxyPass -proxyserver $proxyserver -appDetails $appDetails
    }
	$remvedmails=New-Object System.Collections.ArrayList
    if($toHideAdminTrfic -eq $true){           
        [void]$remvedmails.Add($username)   
    }
    try{
        if($ExcludeMails.Contains(',')){        
            $ExcludeMails=$ExcludeMails.Split(',')      
        }
    }catch{  $ExcludeMails=" "}

    foreach( $ExcludeMail in  $ExcludeMails){        
       [void] $remvedmails.Add($ExcludeMail)
    }
    #each domain process
    foreach($domainname in $alldomainnames){  
        $tmpdomainname = "@"+$domainname 
        if($MessageTracetemp.SenderAddress -match $tmpdomainname -or $MessageTracetemp.RecipientAddress -match $tmpdomainname){
            $domainname=$domainname.ToString().ToLower() 
            Write-host 'gettingmeasuresofSpecificDomains#' $domainname
            $unqSendersHT = New-Object System.Collections.Hashtable
            $unqRecepientsHT = New-Object System.Collections.Hashtable
            $FmIPHT = New-Object System.Collections.Hashtable       
            $Pending=0
            $None=0
            $Failed=0
            $Delivered=0
            $Expanded=0
            $Resolved=0
            $GettingStatus=0
            $Quarantined=0
            $Unknown=0
            $FilteredAsSpam=0
            $interMailSent=0
            $sizeinterMailSent=0
            $exterMailSent=0
            $sizeexterMailSent=0
            $interMailRevd=0
            $sizeinterMailRevd=0
            $exterMailRevd=0
            $sizeexterMailRevd=0
            $InboundMailitemsNsize = @{} 
            $OutboundMailitemsNsize = @{} 
            $MailExternalSent=@{}
            $MailExternalReceived=@{}
            $MailInternalSent=@{}
            $MailInternalReceived=@{}
            $UniqueInboundDomains=@{}
            $UniqueOutboundDomains=@{}
            $delstatuscnt=0

            #for each domain the data will be processed in this loop
            foreach($Message in $MessageTracetemp){ 
                if($Message.SenderAddress -match $remvedmails -and $Message.RecipientAddress -match $remvedmails -and $remvedmails -match " " -and $remvedmails -match $null){}
                else{        
                    $sendersDomain = "" 
                    $RecipientDomain=""
                    try{$sendersDomain=(($Message.SenderAddress).split('@')[1]).ToString().ToLower()}catch{$sendersDomain=""}
                    try{$RecipientDomain=(($Message.RecipientAddress).split('@')[1]).ToString().ToLower()}catch{$RecipientDomain=""}                
                    if(($sendersDomain-ne "" -and $domainname -eq $sendersDomain) -or ($RecipientDomain -ne "" -and $domainname -eq $RecipientDomain)) {
                        try{$unqSendersHT.Add($Message.SenderAddress,$Message.SenderAddress)}catch{} 
                        try{$unqRecepientsHT.Add($Message.RecipientAddress,$Message.RecipientAddress)}catch{}
                        try{$FmIPHT.Add($Message.FromIP,$Message.FromIP)}catch{}
                               
                        ## message delivery status
                        $Status = $Message.Status
                        if($Status -eq 'Delivered' -and $Status -ne $null){$Delivered++} 
                        elseif($Status -eq 'Expanded' -and $Status -ne $null){$Expanded++}
                        elseif($Status -eq 'Resolved' -and $Status -ne $null){$Resolved++}
                        elseif($Status -eq 'Pending' -and $Status -ne $null){$Pending++}   
                        elseif($Status -eq 'Failed' -and $Status -ne $null){$Failed++}
                        elseif($Status -eq 'GettingStatus' -and $Status -ne $null){$GettingStatus++}
                        elseif($Status -eq 'Quarantined' -and $Status -ne $null){$Quarantined++}
                        elseif($Status -eq 'Unknown' -and $Status -ne $null){$Unknown++}
                        elseif($Status -eq 'None' -and $Status -ne $null){$None++} 
                        elseif($Status -eq 'FilteredAsSpam' -and $Status -ne $null){$FilteredAsSpam++}

                        #Read each message tracking entry and add it to a hash table
                        $MessageSenderAddress=$Message.SenderAddress+'#'+$Message.FromIP
                        $MessageRecipientAddress=$Message.RecipientAddress+'#'+$Message.ToIP

                           ## Mails sent to external and other internal tenant domains 
	                    if ($Message.RecipientAddress -ne $null -and $RecipientDomain -ne $domainname) {

		                    if ($OutboundMailitemsNsize.ContainsKey($MessageSenderAddress)) { 
		                        $OutboundMailitemsNsize[$MessageSenderAddress]['Outbound']++ 
		                        $OutboundMailitemsNsize[$MessageSenderAddress]['OutboundSize'] += [int]$Message.Size
    	                    }
                            else{
                                $OutboundMailitemsNsize[$MessageSenderAddress] = @{}
	                            $OutboundMailitemsNsize[$MessageSenderAddress]['Outbound']= 1
	                            $OutboundMailitemsNsize[$MessageSenderAddress]['Inbound']=0
	                            $OutboundMailitemsNsize[$MessageSenderAddress]['InboundSize']=0
	                            $OutboundMailitemsNsize[$MessageSenderAddress]['OutboundSize']=[int]$Message.Size
                            }
	                    }
                        
                            ## Mails received from the external and other internal tenant domains
                        if ($Message.SenderAddress -ne $null -and $sendersDomain -ne $domainname) {
		                    if ($InboundMailitemsNsize.ContainsKey($MessageRecipientAddress)){ 
			                    $InboundMailitemsNsize[$MessageRecipientAddress]['Inbound']++ 
			                    $InboundMailitemsNsize[$MessageRecipientAddress]['InboundSize'] += [int]$Message.Size
		                    }
                            else{
                                $InboundMailitemsNsize[$MessageRecipientAddress] = @{}
	                            $InboundMailitemsNsize[$MessageRecipientAddress]['Outbound']= 0
	                            $InboundMailitemsNsize[$MessageRecipientAddress]['Inbound']=1
	                            $InboundMailitemsNsize[$MessageRecipientAddress]['InboundSize']= [int]$Message.Size
	                            $InboundMailitemsNsize[$MessageRecipientAddress]['OutboundSize']= 0
                            }     
	                    }
  
		                if( $sendersDomain -eq $domainname -and $RecipientDomain -eq $domainname){
                                ## Mails sent within the current domain
			                $interMailSent++
			                $sizeinterMailSent=$sizeinterMailSent+$Message.Size

		                    if($MailInternalSent.ContainsKey($MessageSenderAddress)){
			                    $MailInternalSent[$MessageSenderAddress]['Outbound']++
			                    $MailInternalSent[$MessageSenderAddress]['OutboundSize'] +=[int]$Message.Size
		                    }
		                    else{
			                    $MailInternalSent[$MessageSenderAddress]=@{}
			                    $MailInternalSent[$MessageSenderAddress]['Inbound']=0
			                    $MailInternalSent[$MessageSenderAddress]['InboundSize']=0
			                    $MailInternalSent[$MessageSenderAddress]['Outbound']=1
			                    $MailInternalSent[$MessageSenderAddress]['OutboundSize']=[int]$Message.Size
		                    }   
		    
		                        ## Mails received within the current domain
		                    if($Message.Status -eq 'Delivered' -or $Message.Status -eq 'Expanded' -or $Message.Status -eq 'Resolved' -or $Message.Status -eq 'Quarantined' -or $Message.Status -eq 'FilteredAsSpam'){         
			                    $interMailRevd++
			                    $sizeinterMailRevd=$sizeinterMailRevd+$Message.Size
		                        if($MailInternalReceived.ContainsKey($Message.RecipientAddress)){
			                        $MailInternalReceived[$Message.RecipientAddress]['Inbound']++
			                        $MailInternalReceived[$Message.RecipientAddress]['InboundSize'] +=[int]$Message.Size
		                        }
		                        else{
			                        $MailInternalReceived[$Message.RecipientAddress]=@{}
			                        $MailInternalReceived[$Message.RecipientAddress]['Inbound']=1
			                        $MailInternalReceived[$Message.RecipientAddress]['InboundSize']=[int]$Message.Size
			                        $MailInternalReceived[$Message.RecipientAddress]['Outbound']=0
			                        $MailInternalReceived[$Message.RecipientAddress]['OutboundSize']=0
		                        }
		                    }           
		                }

                            #Mails sent outside the tenant domain and sender should be in the current domain
                        elseif( $sendersDomain -eq $domainname -and !($alldomainnames -match $RecipientDomain)){
                            $exterMailSent++           
                            $sizeexterMailSent=$sizeexterMailSent+$Message.Size
                            if($MailExternalSent.ContainsKey($Message.RecipientAddress)){
                                $MailExternalSent[$Message.RecipientAddress]['Outbound']++
                                $MailExternalSent[$Message.RecipientAddress]['OutboundSize'] +=[int]$Message.Size
                            }
                            else{
                                $MailExternalSent[$Message.RecipientAddress]=@{}
                                $MailExternalSent[$Message.RecipientAddress]['Inbound']=0
                                $MailExternalSent[$Message.RecipientAddress]['InboundSize']=0
                                $MailExternalSent[$Message.RecipientAddress]['Outbound']=1
                                $MailExternalSent[$Message.RecipientAddress]['OutboundSize']=[int]$Message.Size
                            }
                        }
                            #Mails received from outside the tenant domain and receiver should be in the current domain
		                elseif( $RecipientDomain -eq $domainname -and !($alldomainnames -match $sendersDomain)){
			                $exterMailRevd++
			                $sizeexterMailRevd=$sizeexterMailRevd+$Message.Size

		                    if($MailExternalReceived.ContainsKey($Message.SenderAddress)){
			                    $MailExternalReceived[$Message.SenderAddress]['Inbound']++
			                    $MailExternalReceived[$Message.SenderAddress]['InboundSize'] +=[int]$Message.Size
		                    }
		                    else{
			                    $MailExternalReceived[$Message.SenderAddress]=@{}
			                    $MailExternalReceived[$Message.SenderAddress]['Inbound']=1
			                    $MailExternalReceived[$Message.SenderAddress]['InboundSize']=[int]$Message.Size
			                    $MailExternalReceived[$Message.SenderAddress]['Outbound']=0
			                    $MailExternalReceived[$Message.SenderAddress]['OutboundSize']=0
		                    }
		                }

		                ###Message Status DD
                        $msgSub=[String]$Message.Subject
                        if($msgSub.Length -gt 1999){
                            $msgSub=$msgSub.Substring(0,1995+'...')
                        }
                        if($delstatuscnt -lt $rptTopNDD -and ($Message.Status -eq 'None' -or $Message.Status -eq 'Failed' -or $Message.Status -eq 'Pending' -or $Message.Status -eq 'Unknown' -or $Message.Status -eq 'Quarantined') ){
		                    $size=(($Message.Size)/1024).tostring("#.##").replace(',','.')
	                        Write-Host '#delstatusdd'$Message.Status $Message.Received '~!~'$Message.SenderAddress '~!~' $Message.RecipientAddress '~!~' $msgSub '~!~' $size '~!~' $Message.FromIP                    		    
                            $delstatuscnt++;
                        }elseif($FilteredAsSpam -lt $rptTopNDD -and $Message.Status -eq 'FilteredAsSpam'){                    
		                    $size=(($Message.Size)/1024).tostring("#.##").replace(',','.')
                            Write-Host "#delstatusdd Spam" $Message.Received'~!~'$Message.SenderAddress'~!~'$Message.RecipientAddress'~!~'$msgSub'~!~'$size '~!~'$Message.FromIP           
                        }

                           ## Mails sent to other internal and external domains
                        if($RecipientDomain -ne $null -and $RecipientDomain -ne "" -and $RecipientDomain -ne $domainname ){
                            if($UniqueOutboundDomains.ContainsKey($RecipientDomain)){
			                    $UniqueOutboundDomains[$RecipientDomain]['Outbound']++
			                    $UniqueOutboundDomains[$RecipientDomain]['OutboundSize']+=[int]$Message.Size                   
                            }
                            else{
				                $UniqueOutboundDomains[$RecipientDomain]=@{}
			                    $UniqueOutboundDomains[$RecipientDomain]['Inbound']=0
			                    $UniqueOutboundDomains[$RecipientDomain]['InboundSize']=0
			                    $UniqueOutboundDomains[$RecipientDomain]['Outbound']=1
			                    $UniqueOutboundDomains[$RecipientDomain]['OutboundSize']=[int]$Message.Size
                            }
                        }
                          ##  Mails received from other internal and external domains
                        if($sendersDomain -ne $null -and $sendersDomain -ne "" -and $sendersDomain -ne $domainname){
                            if($UniqueInboundDomains.ContainsKey($sendersDomain)){
			                    $UniqueInboundDomains[$sendersDomain]['Inbound']++
			                    $UniqueInboundDomains[$sendersDomain]['InboundSize']+=[int]$Message.Size                   
                            }
                            else{
				                $UniqueInboundDomains[$sendersDomain]=@{}
			                    $UniqueInboundDomains[$sendersDomain]['Inbound']=1
			                    $UniqueInboundDomains[$sendersDomain]['InboundSize']=[int]$Message.Size
			                    $UniqueInboundDomains[$sendersDomain]['Outbound']=0
			                    $UniqueInboundDomains[$sendersDomain]['OutboundSize']=0
                            }
                        }                           
                    }            
                }        
            }

            write-host 'SenderAddress' $unqSendersHT.Keys.Count"#@!"
            write-host 'RecipientAddress' $unqRecepientsHT.Keys.Count"#@!"
            write-host 'FromIP' $FmIPHT.Keys.Count"#@!"

            ## message delivery status measures
	        Write-Host '#statusMeasure' $None' ~' $Failed' ~' $Pending' ~'  $Delivered '~' $Expanded '~' $Resolved  '~' $FilteredAsSpam '~' $GettingStatus '~' $Quarantined '~' $Unknown 	          

	        #Build a table to format the results 
	        $table = New-Object system.Data.DataTable "DetailedMessageStats" 
	        $col2 = New-Object system.Data.DataColumn Recipient,([string]) 
	        $table.columns.add($col2) 
	        $col3 = New-Object system.Data.DataColumn Inbound,([long]) 
	        $table.columns.add($col3) 
	        $col4 = New-Object system.Data.DataColumn Outbound,([long]) 
	        $table.columns.add($col4)
	        $col5 = New-Object system.Data.DataColumn InboundSize,([long]) 
	        $table.columns.add($col5) 
	        $col6 = New-Object system.Data.DataColumn OutboundSize,([long]) 
	        $table.columns.add($col6) 

	        $intable=New-Object system.Data.DataTable "DetailedMessageStats" #table for out emails
	        $incol2 = New-Object system.Data.DataColumn Recipient,([string]) 
	        $intable.columns.add($incol2) 
	        $incol3 = New-Object system.Data.DataColumn Inbound,([long]) 
	        $intable.columns.add($incol3) 
	        $incol4 = New-Object system.Data.DataColumn Outbound,([long]) 
	        $intable.columns.add($incol4) 
	        $incol5 = New-Object system.Data.DataColumn InboundSize,([long]) 
	        $intable.columns.add($incol5) 
	        $incol6 = New-Object system.Data.DataColumn OutboundSize,([long]) 
	        $intable.columns.add($incol6) 

	        $outtable=New-Object system.Data.DataTable "DetailedMessageStats" #table for out emails
	        $tcol2 = New-Object system.Data.DataColumn Recipient,([string]) 
	        $outtable.columns.add($tcol2) 
	        $tcol3 = New-Object system.Data.DataColumn Inbound,([long]) 
	        $outtable.columns.add($tcol3) 
	        $tcol4 = New-Object system.Data.DataColumn Outbound,([long]) 
	        $outtable.columns.add($tcol4) 
	        $tcol5 = New-Object system.Data.DataColumn InboundSize,([long]) 
	        $outtable.columns.add($tcol5) 
	        $tcol6 = New-Object system.Data.DataColumn OutboundSize,([long]) 
	        $outtable.columns.add($tcol6) 

	        $Inbunddomainstab=New-Object system.Data.DataTable "Detailed Sender Domains Stats" #table for out emails
	        $tcol1 = New-Object system.Data.DataColumn Recipient,([string]) 
	        $Inbunddomainstab.columns.add($tcol1) 
	        $tcol2 = New-Object system.Data.DataColumn Inbound,([long]) 
	        $Inbunddomainstab.columns.add($tcol2)  
	        $tcol3 = New-Object system.Data.DataColumn InboundSize,([long]) 
	        $Inbunddomainstab.columns.add($tcol3) 

	        $Outbunddomainstab=New-Object system.Data.DataTable "Detailed Recipents Domains Stats" #table for out emails
	        $tcol1 = New-Object system.Data.DataColumn Recipient,([string]) 
	        $Outbunddomainstab.columns.add($tcol1) 
	        $tcol2 = New-Object system.Data.DataColumn Outbound,([long]) 
	        $Outbunddomainstab.columns.add($tcol2) 
	        $tcol3 = New-Object system.Data.DataColumn OutboundSize,([long]) 
	        $Outbunddomainstab.columns.add($tcol3) 
 
	        #Transpose hashtable to datatable 
	        $TotalInboundSize=0 
	        $TotalOutboundSize=0
	        $TotalInboundItems=0
	        $TotalOutboundItems=0
    
  	        ForEach ($Recipient in $InboundMailitemsNsize.keys){ 
	            $RecipientName = $Recipient 
	            $row = $table.NewRow() 
		        $row.Recipient = $RecipientName 
		        $row.Inbound = $InboundMailitemsNsize[$RecipientName].Inbound 
		        $row.Outbound = $InboundMailitemsNsize[$RecipientName].Outbound 
		        $row.InboundSize = ($InboundMailitemsNsize[$RecipientName].InboundSize)/1024
		        $row.OutboundSize = ($InboundMailitemsNsize[$RecipientName].OutboundSize)/1024
		        $table.Rows.Add($row)     
		        $TotalInboundSize = $TotalInboundSize + $InboundMailitemsNsize[$RecipientName].InboundSize
		        $TotalInboundItems = $TotalInboundItems + $InboundMailitemsNsize[$RecipientName].Inbound

	        } 
	        #Export data to CSV and Screen 
              
	        #"*******Top 10 Recipients by Inbound size*******" 
	        $InSize=$table  | sort InboundSize -Descending | select -first $rptTopNDD #| ConvertTo-Csv -NoTypeInformation -Delimiter "," | % {$_ -replace '"',''}
	
   	        foreach($s in $InSize){
                $inbundsize=if($s.Item(3) -gt 0){ ($s.Item(3)).tostring("#.##").replace(',','.') } else { 0 }
                $outboundsize=if($s.Item(4) -gt 0){ ($s.Item(4)).tostring("#.##").replace(',','.') } else { 0 }
                $mailIPadress=($s.Item(0)).ToString().split('#')
	            Write-Host  'InboundSize ' $mailIPadress[0] ','$s.Item(2)','$s.Item(1)','$outboundsize','$inbundsize',' $mailIPadress[1]
	        }
            #"*******Top 10 Recipients by Inbound items*******" 
	        $InItems=$table | sort Inbound -Descending | select -first $rptTopNDD #| ConvertTo-Csv -NoTypeInformation -Delimiter "," | % {$_ -replace '"',''}
    
   	        foreach($s in $InItems){
                $inbundsize=if($s.Item(3) -gt 0){ ($s.Item(3)).tostring("#.##").replace(',','.') } else { 0 }
                $outboundsize=if($s.Item(4) -gt 0){ ($s.Item(4)).tostring("#.##").replace(',','.') } else { 0 }
                $mailIPadress=($s.Item(0)).ToString().split('#')
                Write-Host  'InboundItems ' $mailIPadress[0] ','$s.Item(2)','$s.Item(1)','$outboundsize','$inbundsize',' $mailIPadress[1]
	        }
   	        $table.Rows.Clear()  # clearing all rows of the outable 
    
   	        ForEach ($Recipient in $OutboundMailitemsNsize.keys){ 
	            $RecipientName = $Recipient 
	            $row = $table.NewRow() 
		        $row.Recipient = $RecipientName 
		        $row.Inbound = $OutboundMailitemsNsize[$RecipientName].Inbound 
		        $row.Outbound = $OutboundMailitemsNsize[$RecipientName].Outbound 
		        $row.InboundSize = ($OutboundMailitemsNsize[$RecipientName].InboundSize)/1024
		        $row.OutboundSize = ($OutboundMailitemsNsize[$RecipientName].OutboundSize)/1024
		        $table.Rows.Add($row)   
		        $TotalOutboundSize = $TotalOutboundSize + $OutboundMailitemsNsize[$RecipientName].OutboundSize
		        $TotalOutboundItems = $TotalOutboundItems + $OutboundMailitemsNsize[$RecipientName].Outbound
	        }
   	        #"*******Top 10 Senders by Outbound size*******" 
	        $outSize=$table | sort OutboundSize -Descending | select -first $rptTopNDD #| ConvertTo-Csv -NoTypeInformation -Delimiter "," | % {$_ -replace '"',''}
    
  	        foreach($s in $outSize){
                $inbundsize=if($s.Item(3) -gt 0){ ($s.Item(3)).tostring("#.##").replace(',','.') } else { 0 }
                $outboundsize=if($s.Item(4) -gt 0){ ($s.Item(4)).tostring("#.##").replace(',','.') } else { 0 }
                $mailIPadress=($s.Item(0)).ToString().split('#')
	            Write-Host  'OutboundSize ' $mailIPadress[0] ','$s.Item(1)','$s.Item(2)','$inbundsize','$outboundsize',' $mailIPadress[1]
	        } 
   	            #"*******Top 10 Senders by Outbound items*******" 
	            $outitems = $table | sort Outbound -Descending | select -first $rptTopNDD #| ConvertTo-Csv -NoTypeInformation -Delimiter "," | % {$_ -replace '"',''} 
    
	        foreach($s in $outitems){
                $inbundsize=if($s.Item(3) -gt 0){ ($s.Item(3)).tostring("#.##").replace(',','.') } else { 0 }
                $outboundsize=if($s.Item(4) -gt 0){ ($s.Item(4)).tostring("#.##").replace(',','.') } else { 0 }
                $mailIPadress=($s.Item(0)).ToString().split('#')
	            Write-Host  'OutboundItems ' $mailIPadress[0] ','$s.Item(1)','$s.Item(2)','$inbundsize','$outboundsize',' $mailIPadress[1]
	        }
   
	        #"*******Totals*******"
	        $TotalItems=$TotalInboundItems+$TotalOutboundItems
	        $TotalSize=$TotalInboundSize+$TotalOutboundSize 
            $TotalInboundSize=if([math]::round($TotalInboundSize /1Gb, 4) -gt 0){ ([math]::round($TotalInboundSize /1Gb, 4)).tostring("#.####").replace(',','.') } else { 0 }
            $TotalOutboundSize=if([math]::round($TotalOutboundSize /1Gb, 4) -gt 0){ ([math]::round($TotalOutboundSize /1Gb, 4)).tostring("#.####").replace(',','.') } else { 0 }
            $TotalSize=if([math]::round($TotalSize /1Gb, 4) -gt 0){ ([math]::round($TotalSize /1Gb, 4)).tostring("#.####").replace(',','.') } else { 0 }
	        write-host "Totals "$TotalInboundSize ~ $TotalOutboundSize ~ $TotalInboundItems ~ $TotalOutboundItems ~ $TotalItems ~ $TotalSize"#@!" 

	        #$table | sort Date,Recipient,Inbound,Outbound, InboundSize, OutboundSize -desc | Out-GridView -Title "Messages Sent By User"
	        $sizeinterMailSent=if([math]::round($sizeinterMailSent /1Gb, 4) -gt 0){ ([math]::round($sizeinterMailSent /1Gb, 4)).tostring("#.####").replace(',','.') } else { 0 }
	        $sizeinterMailRevd=if([math]::round($sizeinterMailRevd /1Gb, 4) -gt 0){ ([math]::round($sizeinterMailRevd /1Gb, 4)).tostring("#.####").replace(',','.') } else { 0 }
	        $sizeexterMailSent=if([math]::round($sizeexterMailSent /1Gb, 4) -gt 0){ ([math]::round($sizeexterMailSent /1Gb, 4)).tostring("#.####").replace(',','.') } else { 0 }
	        $sizeexterMailRevd=if([math]::round($sizeexterMailRevd /1Gb, 4) -gt 0){ ([math]::round($sizeexterMailRevd /1Gb, 4)).tostring("#.####").replace(',','.') } else { 0 }    
	        Write-Host  'emailsCountAndSize##' $interMailSent ~ $sizeinterMailSent  ~ $interMailRevd ~ $sizeinterMailRevd ~ $exterMailSent ~ $sizeexterMailSent ~ $exterMailRevd ~ $sizeexterMailRevd
   
            ForEach ($Recipient in $MailExternalSent.keys) { 
	            $RecipientName = $Recipient 	     
		        $row = $outtable.NewRow() 
		        #$row.Date = $Date 
		        $row.Recipient = $RecipientName 
		        $row.Inbound = $MailExternalSent[$RecipientName].Inbound 
		        $row.Outbound = $MailExternalSent[$RecipientName].Outbound 
		        $row.InboundSize = ($MailExternalSent[$RecipientName].InboundSize)/1024
		        $row.OutboundSize = ($MailExternalSent[$RecipientName].OutboundSize)/1024
		        $outtable.Rows.Add($row)     
	        }
   	        # $exterMailRevd++           #external mail recived an mail from our domain inbound
	        # $exterMailSent++           #External mail sent an mail to our domain  outbound
	        #"*******Top 10 External Recipients by Outbound items*******" 
	        $Externalemailsent = $outtable | sort Outbound -Descending | select -first $rptTopNDD #| ConvertTo-Csv -NoTypeInformation -Delimiter "," | % {$_ -replace '"',''} 
    
   	        foreach($s in $Externalemailsent){
                $inbundsize=if($s.Item(3) -gt 0){ ($s.Item(3)).tostring("#.##").replace(',','.') } else { 0 }
                $outboundsize=if($s.Item(4) -gt 0){ ($s.Item(4)).tostring("#.##").replace(',','.') } else { 0 }
                $mailIPadress=($s.Item(0)).ToString().split('#')
	           Write-Host  'Externalemailsent ' $mailIPadress[0] ','$s.Item(1)','$s.Item(2)','$inbundsize','$outboundsize',' $mailIPadress[1]
	        }

            $outtable.Rows.Clear()  # clearing all rows of the outable 

   	        ForEach ($Recipient in $MailExternalReceived.keys) { 
	            $RecipientName = $Recipient 	     
		        $row = $outtable.NewRow() 
		        #$row.Date = $Date 
		        $row.Recipient = $RecipientName 
		        $row.Inbound = $MailExternalReceived[$RecipientName].Inbound 
		        $row.Outbound = $MailExternalReceived[$RecipientName].Outbound
		        $row.InboundSize = ($MailExternalReceived[$RecipientName].InboundSize)/1024
		        $row.OutboundSize = ($MailExternalReceived[$RecipientName].OutboundSize)/1024
		        $outtable.Rows.Add($row)     
	        }
   	        #"*******Top 10 External Recipients by Inbound items*******" 
	        $Externalemailrecived = $outtable | sort Inbound -Descending | select -first $rptTopNDD #| ConvertTo-Csv -NoTypeInformation -Delimiter "," | % {$_ -replace '"',''} 
    
  	        foreach($s in $Externalemailrecived){
                $inbundsize=if($s.Item(3) -gt 0){ ($s.Item(3)).tostring("#.##").replace(',','.') } else { 0 }
                $outboundsize=if($s.Item(4) -gt 0){ ($s.Item(4)).tostring("#.##").replace(',','.') } else { 0 }
                $mailIPadress=($s.Item(0)).ToString().split('#')      
	          Write-Host  'Externalemailrecived' $mailIPadress[0] ',' $s.Item(2) ',' $s.Item(1) ',' $outboundsize ',' $inbundsize  ',' $mailIPadress[1]
	        }
         
 	        ForEach ($Recipient in $MailInternalSent.keys){ 
	            $RecipientName = $Recipient 	     
		        $row = $intable.NewRow() 
		        $row.Recipient = $RecipientName 
		        $row.Inbound = $MailInternalSent[$RecipientName].Inbound 
		        $row.Outbound = $MailInternalSent[$RecipientName].Outbound 
		        $row.InboundSize = ($MailInternalSent[$RecipientName].InboundSize)/1024 
		        $row.OutboundSize = ($MailInternalSent[$RecipientName].OutboundSize)/1024
		        $intable.Rows.Add($row)     
	        }
  
	        #"*******Top 10 Internal Recipients by Outbound items*******" 
	        $Internalemailsent = $intable | sort Outbound -Descending | select -first $rptTopNDD #| ConvertTo-Csv -NoTypeInformation -Delimiter "," | % {$_ -replace '"',''}
    
 	        foreach($s in $Internalemailsent){
                $inbundsize=if($s.Item(3) -gt 0){ ($s.Item(3)).tostring("#.##").replace(',','.') } else { 0 }
                $outboundsize=if($s.Item(4) -gt 0){ ($s.Item(4)).tostring("#.##").replace(',','.') } else { 0 }
                $mailIPadress=($s.Item(0)).ToString().split('#')
	          Write-Host  'Internalemailsent ' $mailIPadress[0] ','$s.Item(1)','$s.Item(2)','$inbundsize','$outboundsize',' $mailIPadress[1]
	        }

            $intable.Rows.Clear()  # clearing all rows of the intable 

 	        ForEach ($Recipient in $MailInternalReceived.keys){ 
	            $RecipientName = $Recipient 	     
		        $row = $intable.NewRow() 
		        $row.Recipient = $RecipientName 
		        $row.Inbound = $MailInternalReceived[$RecipientName].Inbound 
		        $row.Outbound = $MailInternalReceived[$RecipientName].Outbound 
		        $row.InboundSize = ($MailInternalReceived[$RecipientName].InboundSize)/1024
		        $row.OutboundSize = ($MailInternalReceived[$RecipientName].OutboundSize)/1024
		        $intable.Rows.Add($row)     
	        }
	        #"*******Top 10 Internal Recipients by Inbound items*******" 
	        $Internalemailreceving = $intable | sort Inbound -Descending | select -first $rptTopNDD #| ConvertTo-Csv -NoTypeInformation -Delimiter "," | % {$_ -replace '"',''} 
    
 	        foreach($s in $Internalemailreceving){
                $inbundsize=if($s.Item(3) -gt 0){ ($s.Item(3)).tostring("#.##").replace(',','.') } else { 0 }
                $outboundsize=if($s.Item(4) -gt 0){ ($s.Item(4)).tostring("#.##").replace(',','.') } else { 0 }
                $mailIPadress=($s.Item(0)).ToString().split('#')
	          Write-Host  'Internalemailreceving ' $mailIPadress[0] ','$s.Item(1)','$s.Item(2)','$inbundsize','$outboundsize',' $mailIPadress[1]
	        }
              ## ADDING ROWS TO TABLE
            $sendercount=0
    
            ForEach ($Recipient in $UniqueInboundDomains.keys){ 
	            $RecipientName = $Recipient 
	            $sendercount++
		        $row = $Inbunddomainstab.NewRow() 
		        $row.Recipient = $RecipientName 
		        $row.Inbound = $UniqueInboundDomains[$RecipientName].Inbound 
		        $row.InboundSize = ($UniqueInboundDomains[$RecipientName].InboundSize)/1024
		        $Inbunddomainstab.Rows.Add($row)     
	        }
 	        #"*******Top 10 Sender Domains by Outbound items*******" 
	        $unquesendrdoms = $Inbunddomainstab | sort Inbound -Descending #| select -first 10 | ConvertTo-Csv -NoTypeInformation -Delimiter "," | % {$_ -replace '"',''}
            $uniqueRecipentDomainsCnt = 0
            foreach($s in $unquesendrdoms){
               $inbundsize=if($s.Item(2) -gt 0){ ($s.Item(2)).tostring("#.##").replace(',','.') } else { 0 }
               if($uniqueRecipentDomainsCnt -lt $rptTopNDD){
	                Write-Host  'uniqueRecipentDomains ' $s.Item(0)','$s.Item(1)','$inbundsize #for Inbound domains measure here sender is others and reciver ours domain
                    $uniqueRecipentDomainsCnt++
                }
	        }
  
            ## ADDING ROWS TO TABLE
            $recipncount=0
            ForEach ($Recipient in $UniqueOutboundDomains.keys){ 
	            $RecipientName = $Recipient 
                $recipncount++
		        $row = $Outbunddomainstab.NewRow() 
		        $row.Recipient = $RecipientName 
		        $row.Outbound = $UniqueOutboundDomains[$RecipientName].Outbound
		        $row.OutboundSize = ($UniqueOutboundDomains[$RecipientName].OutboundSize)/1024
		        $Outbunddomainstab.Rows.Add($row)     
	        }
   
	        #"*******Top 10 Recipents Domains by Outbound items*******" 
	        $unqueOutdoms = $Outbunddomainstab | sort Outbound -Descending # | select -first 10  | ConvertTo-Csv -NoTypeInformation -Delimiter "," | % {$_ -replace '"',''}
            $uniqueSenderDomainsCnt = 0
            foreach($s in $unqueOutdoms){
                $outboundsize=if($s.Item(2) -gt 0){ ($s.Item(2)).tostring("#.##").replace(',','.') } else { 0 }
	            if($uniqueSenderDomainsCnt -lt $rptTopNDD){
                    Write-Host  'uniqueSenderDomains' $s.Item(0)','$s.Item(1)',' $outboundsize   ## for outbound domains measure dd and here we are getting domains where sender is ours and recevers in other
                    $uniqueSenderDomainsCnt++
                }
	        }
            Write-Host 'uniquesdominascount'  $UniqueOutboundDomains.Count '~'  $UniqueInboundDomains.count   
            Write-Host 'donewithMeasuresofdomain#'$domainname    
        }            
    }            
}
[System.GC]::GetTotalMemory($true) | out-null