﻿[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
$cqdModule=$scriptPath+"\MTMCallQlityReport.psm1"
Import-Module $egEncryPath,$egDatnKy,$cqdModule
clear

#<#
$TestInputs=$args
$userName=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$rptNMea=$TestInputs[2].ToString().Split('#')
$mPeriodInMin=[int]$rptNMea[0].Trim()
$rptNam=$rptNMea[1].Trim()
$lastRptConfId=$TestInputs[3]
$prxyDtls=$TestInputs[4].ToString().Split('#')
$proxyUsr=$prxyDtls[0].Trim()
$proxyPass=Eg-O365Dcr -EncStr $prxyDtls[1]
$proxyserverip=$prxyDtls[2].Trim()
$debuglog=$TestInputs[5].Trim()
#>


##### LOG-Start ###########
$logDir=$egurkhaPath+'\agent\MTM\'+$rptNam+'\logs'
if(!(Test-Path -Path $logDir)){
    $null=New-Item -ItemType directory -Path $logDir
}
$LogFile = $logDir+"\MTMStreamBase.log"
$LogFile1 = $logDir+"\MTMStreamBase1.log"
$strmBasDebug=$false

Function Write-Log {
	Param ([string]$string)
		if($strmBasDebug){
		[string]$date = Get-Date -Format G
		( "[" + $date + "] -  [O365]  -  " + $string ) | Out-File -FilePath $LogFile -Append
		if ([System.IO.File]::Exists($LogFile) -and (Get-Item $LogFile).length -gt 2mb) {  #if the size of file is greater than 1MB 
			if([System.IO.File]::Exists($LogFile1)){  #if logfile1 already exists, delete logfile1 
				Remove-Item $LogFile1 
			} 
			Rename-Item $LogFile $LogFile1   
		}
	}
}
##### LOG - End ##########

##### MTMCallQlityReport Deletion - start ##########
if($debuglog -eq 'true'){
    $logDelDir=$egurkhaPath+'\agent\MTM\logs'
    $logDelFiles=Get-ChildItem -Path $logDelDir
    if($logDelFiles.Count -gt 0){
        foreach($logDelFile in $logDelFiles){
            $logDel=$logDelDir+'\'+$logDelFile
            Remove-Item -Path $logDel
        }
    }
}
##### MTMCallQlityReport Deletion - End ##########

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

if($lastRptConfId -ne 'none'){
    $confDatArr=($lastRptConfId -Split '~!~')
    $chklastRptConfId=($confDatArr[0]).ToString()
    $lstDat=[DateTime]($confDatArr[1]).ToString()
}
if($lstDat -ne $null -and $lstDat -ne ''){
    $currDat=(Get-Date)
    Write-Log("confId and curr date -->> $lstDat -- $currDat")
    if($lstDat.Date -eq $currDat.Date){
        $dat1=(Get-Date).AddMinutes(-($mPeriodInMin)).ToUniversalTime()
    }
    else{
        $dat1=(Get-Date).AddMinutes(-($mPeriodInMin+1440)).ToUniversalTime()
    }
}else{
    $dat1=(Get-Date).AddMinutes(-($mPeriodInMin)).ToUniversalTime()
}
#$dat1=(Get-Date).AddMinutes(-($mPeriodInMin)).ToUniversalTime()
$dat2=(Get-Date).AddDays(1).ToUniversalTime()
$startDat='{0:yyyy-MM-dd}' -f $dat1
$endDat='{0:yyyy-MM-dd}' -f $dat2
Write-Log("start and end date -->> $startDat -- $endDat")

if(!$proxyserverip.ToString().ToLower().Contains('none')){
    $proxyserver='http://'+$proxyserverip
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred   #[System.Net.CredentialCache]::DefaultNetworkCredentials
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
 }

$dir=$egurkhaPath +'\agent\MTM\'+$rptNam
if(!(Test-Path -Path $dir )){
    $null=New-Item -ItemType directory -Path $dir
}
$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$allStmsPath=$dir+'\AllStrmsBase'+ $timenow +".csv"

$measures='Measures.Audio Stream Count','Measures.Audio Good Stream Count','Measures.Audio Poor Stream Count','Measures.Audio Unclassified Stream Count','Measures.Audio Poor Due To Jitter Count','Measures.Audio Poor Due To PacketLoss Count','Measures.Audio Poor Due To Degradation Count','Measures.Audio Poor Due To RoundTrip Count','Measures.Audio Poor Due To ConcealedRatio Count','Measures.Video Stream Count','Measures.Video Poor Due To VideoPostFecplr Count','Measures.Video Poor Due To VideoLocalFrameLossPercentageAvg Count','Measures.Video Poor Due To VideoFrameRateAvg Count','Measures.Video Poor Stream Count','Measures.Video Good Stream Count','Measures.Video Unclassified Stream Count','Measures.Avg Video Post FECPLR','Measures.Avg Video Local Frame Loss Percentage','Measures.Avg Video Recv Frame Rate Average','Measures.Avg Video Low Frame Rate Call Percent','Measures.Avg Video Packet Loss Rate','Measures.Avg Video Frame Rate','Measures.Avg Video Dynamic Capability Percent','Measures.VBSS Stream Count','Measures.VBSS Good Stream Count','Measures.VBSS Poor Stream Count','Measures.VBSS Unclassified Stream Count','Measures.VBSS Poor Due To VideoPostFecplr Count','Measures.VBSS Poor Due To VideoLocalFrameLossPercentageAvg Count','Measures.VBSS Poor Due To VideoFrameRateAvg Count','Measures.Total Stream Count','Measures.Total CDR Available Stream Count','Measures.Total Media Failed Stream Count','Measures.Total Call Setup Failed Stream Count','Measures.Total Call Dropped Stream Count','Measures.Total Media Succeeded Stream Count','Measures.Total Call Setup Succeeded Stream Count','Measures.Total Call Setup Failure Percentage','Measures.Total Call Dropped Failure Percentage','Measures.Total Answer Seizure Ratio','Measures.Total Short Call Percentage','Measures.Total Media Failure Percentage','Measures.Avg Call Duration','Measures.Media Failed Due To Firewall DPI Stream Count','Measures.Firewall DPI Media Failure Percentage','Measures.Media Failed Due To Firewall IP Blocked Stream Count','Measures.Firewall IP Blocked Media Failure Percentage','Measures.Media Failed Due To Other Stream Count','Measures.Other Media Failure Percentage','Measures.First Feedback Rating Avg','Measures.Second Feedback Rating Avg','Measures.First Feedback Rating Count','Measures.Second Feedback Rating Count','Measures.First Feedback Rating Poor Count','Measures.Second Feedback Rating Poor Count','Measures.First Feedback Rating Poor Percentage','Measures.Second Feedback Rating Poor Percentage','Measures.First Feedback Token Audio Issue Count','Measures.Second Feedback Token Audio Issue Count','Measures.First Feedback Token Video Issue Count','Measures.Second Feedback Token Video Issue Count','Measures.Avg Audio Degradation','Measures.Avg Jitter','Measures.Avg Jitter Max','Measures.Avg Packet Loss Rate','Measures.Avg Packet Loss Rate Max','Measures.Avg Send Listen MOS','Measures.Avg Overall Avg Network MOS','Measures.Avg Ratio Concealed Samples','Measures.Avg Ratio Stretched Samples','Measures.Avg Round Trip','Measures.Avg Round Trip Max'
$Dimentions='AllStreams.Is Teams','AllStreams.Poor','AllStreams.Unclassified','AllStreams.Date','AllStreams.Hour','AllStreams.Start Time','AllStreams.End Time','AllStreams.First UPN','AllStreams.Second UPN','AllStreams.Organizer UPN','AllStreams.Duration (Minutes)','AllStreams.Media Type','AllStreams.Poor Reason','AllStreams.Conference Id','AllStreams.First Inside Corp','AllStreams.Second Inside Corp','AllStreams.First Network Connection Detail','AllStreams.Second Network Connection Detail','AllStreams.First VPN','AllStreams.Second VPN','AllStreams.Transport','AllStreams.First IP Address','AllStreams.Second IP Address','AllStreams.First Reflexive Local IP','AllStreams.Second Reflexive Local IP','AllStreams.First Feedback Rating','AllStreams.Second Feedback Rating','AllStreams.First Capture Dev Name','AllStreams.Second Capture Dev Name','AllStreams.First Render Dev Name','AllStreams.Second Render Dev Name','AllStreams.First User Agent','AllStreams.Second User Agent','AllStreams.First CPU Name','AllStreams.Second CPU Name','AllStreams.First OS','AllStreams.Second OS','AllStreams.First Virtualization Flag','AllStreams.Second Virtualization Flag','AllStreams.First Capture Dev','AllStreams.Second Capture Dev','AllStreams.First Capture Dev Driver','AllStreams.Second Capture Dev Driver','AllStreams.First Render Dev','AllStreams.Second Render Dev','AllStreams.First Render Dev Driver','AllStreams.Second Render Dev Driver','AllStreams.First MAC Address','AllStreams.Second MAC Address','AllStreams.First Client Endpoint Name','AllStreams.Second Client Endpoint Name','AllStreams.First ASN Country','AllStreams.Second ASN Country','AllStreams.First ASN City','AllStreams.Second ASN City','AllStreams.First ASN State','AllStreams.Second ASN State','AllStreams.Region','AllStreams.First Connectivity Ice','AllStreams.Second Connectivity Ice','AllStreams.First Link Speed','AllStreams.Second Link Speed','AllStreams.Bandwidth Est','AllStreams.Inside Corp Pair','AllStreams.First Tenant Id','AllStreams.Second Tenant Id','AllStreams.Is Federated','AllStreams.First Is Caller','AllStreams.Stream Direction','AllStreams.Audio and Video Call','AllStreams.First Domain','AllStreams.Second Domain','AllStreams.Conference Type','AllStreams.First Client App Version','AllStreams.Second Client App Version','AllStreams.Meeting Id','AllStreams.Error Report Sender','AllStreams.Is Media Error','AllStreams.Media Failure Type','AllStreams.Call Setup Failure Reason','AllStreams.Session Type','AllStreams.CDR Response Reason','AllStreams.First Video Duration Seconds','AllStreams.Second Video Duration Seconds','AllStreams.Audio Degradation Avg','AllStreams.Jitter','AllStreams.Packet Loss Rate','AllStreams.Send Listen MOS','AllStreams.Overall Avg Network MOS','AllStreams.Ratio Concealed Samples Avg','AllStreams.Ratio Stretched Samples Avg','AllStreams.Round Trip','AllStreams.Packet Utilization','AllStreams.Jitter Buffer Size Avg','AllStreams.Relative OneWay Gap Duration','AllStreams.Audio Post FECPLR','AllStreams.Network Jitter Avg','AllStreams.Video Post FECPLR','AllStreams.Video Local Frame Loss Percentage Avg','AllStreams.Recv Frame Rate Average','AllStreams.Low Frame Rate Call Percent','AllStreams.Video Packet Loss Rate','AllStreams.Video Frame Rate Avg','AllStreams.Dynamic Capability Percent','AllStreams.Spoiled Tile Percent Total','AllStreams.First Network Bandwidth Low Event Ratio','AllStreams.Second Network Bandwidth Low Event Ratio','AllStreams.Video Poor Due to Freeze','AllStreams.Video Poor Due To VideoPostFecplr','AllStreams.Video Poor Due To VideoLocalFrameLossPercentageAvg','AllStreams.Video Poor Due To VideoFrameRateAvg','AllStreams.VBSS Poor Due To VideoPostFecplr','AllStreams.VBSS Poor Due To VideoLocalFrameLossPercentageAvg','AllStreams.VBSS Poor Due To VideoFrameRateAvg','AllStreams.AppSharing Poor Due To SpoiledTilePercentTotal','AllStreams.AppSharing Poor Due To RelativeOneWayAverage','AllStreams.AppSharing Poor Due To RDPTileProcessingLatencyAverage','AllStreams.Audio Poor Due To Jitter','AllStreams.Audio Poor Due To RoundTrip','AllStreams.Audio Poor Due To PacketLoss','AllStreams.Audio Poor Due To Degradation','AllStreams.Audio Poor Due To ConcealedRatio','AllStreams.First Feedback Tokens','AllStreams.Second Feedback Tokens','AllStreams.First Feedback Has Audio Issue','AllStreams.Second Feedback Has Audio Issue','AllStreams.First Feedback Has Video Issue','AllStreams.Second Feedback Has Video Issue','AllStreams.First Feedback Has AppSharing Issue','AllStreams.Second Feedback Has AppSharing Issue','AllStreams.First Feedback Text','AllStreams.Second Feedback Text'
Try{
    Get-CQDData -Measures $measures -Dimensions $Dimentions -StartDate $startDat -EndDate $endDat -OutPutType DataTable -username $username -password $password -CQDVer V3 -debugLog $debuglog | Export-Csv $allStmsPath -Encoding $encTyp #-Descending -debugLog $debuglog
}
Catch{
    $ExcepMsg='['+(Split-Path ($_.InvocationInfo.ScriptName) -leaf)+'] Exception Occured in "getting Records" -- [Line Number] '+$_.InvocationInfo.ScriptLineNumber+' -- '+$_.Exception
    Write-Host $ExcepMsg
    Write-Log($ExcepMsg)
    [System.GC]::GetTotalMemory($true) | out-null
    Start-Sleep -Seconds 20

    Try{
        Write-Host 'Second try....'
        Write-Log('Second try....')
        Get-CQDData -Measures $measures -Dimensions $Dimentions -StartDate $startDat -EndDate $endDat -OutPutType DataTable -username $username -password $password -CQDVer V3 -debugLog $debuglog | Export-Csv $allStmsPath -Encoding $encTyp #-Descending -debugLog $debuglog
    }Catch{
        $ExcepMsg='['+(Split-Path ($_.InvocationInfo.ScriptName) -leaf)+'] Exception Occured in "getting Records" -- [Line Number] '+$_.InvocationInfo.ScriptLineNumber+' -- '+$_.Exception
        Write-Host 'After catching exception -->> '$ExcepMsg
        Write-Log ("After catching exception -->> $ExcepMsg")
    }
}
[System.GC]::GetTotalMemory($true) | out-null

if($allStmsPath -ne $null -and [System.IO.File]::Exists($allStmsPath) -eq 'True'){
	$allStrms= import-csv $allStmsPath -Encoding $encTyp
    $csvCnt='allStrms Count -- '+($allStrms.Count).ToString()
    Write-Log($csvCnt)
    if(Test-Path -Path $allStmsPath -PathType Leaf){
        Remove-Item $allStmsPath -Force
    }
}else{
    Write-Log($allStmsPath+" -- file is empty or null")
}
$timenow = [int][double]::Parse((Get-Date -UFormat %s))
$mdifyStmsPath=$dir+'\MdifyStrmsBase'+ $timenow +".csv"
foreach($strms in $allStrms){
    $strmsHash =[ordered] @{}
    $isOccur=$false;$isFirst=$true
    foreach( $property in $strms.psobject.properties.name)
    {
        if($property -eq 'First CPU Name'){$isOccur=$true}
        #if($property -eq 'Audio Poor Stream Count'){$isOccur=$false}
        if($property -eq 'Audio Stream Count'){$isOccur=$false}
        if($isOccur -and $isFirst){
            $isFirst=$false
            $sysDtls=$strms.'First CPU Name'+'~#~'+$strms.'Second CPU Name'+'~#~'+$strms.'First OS'+'~#~'+$strms.'Second OS'+'~#~'+$strms.'First Virtualization Flag'+'~#~'+$strms.'Second Virtualization Flag'+'~#~'+$strms.'First Capture Dev'+'~#~'+$strms.'Second Capture Dev'+'~#~'+$strms.'First Capture Dev Driver'+'~#~'+$strms.'Second Capture Dev Driver'+'~#~'+$strms.'First Render Dev'+'~#~'+$strms.'Second Render Dev'+'~#~'+$strms.'First Render Dev Driver'+'~#~'+$strms.'Second Render Dev Driver'+'~#~'+$strms.'First MAC Address'+'~#~'+$strms.'Second MAC Address'+'~#~'+$strms.'First Client Endpoint Name'+'~#~'+$strms.'Second Client Endpoint Name'
            $netWrkDtls=$strms.'First ASN Country'+'~#~'+$strms.'Second ASN Country'+'~#~'+$strms.'First ASN City'+'~#~'+$strms.'Second ASN City'+'~#~'+$strms.'First ASN State'+'~#~'+$strms.'Second ASN State'+'~#~'+$strms.'Region'+'~#~'+$strms.'First Connectivity Ice'+'~#~'+$strms.'Second Connectivity Ice'+'~#~'+$strms.'First Link Speed'+'~#~'+$strms.'Second Link Speed'+'~#~'+$strms.'Bandwidth Est'+'~#~'+$strms.'Inside Corp Pair'
            $callDtls=$strms.'First Tenant Id'+'~#~'+$strms.'Second Tenant Id'+'~#~'+$strms.'Is Federated'+'~#~'+$strms.'First Is Caller'+'~#~'+$strms.'Stream Direction'+'~#~'+$strms.'Audio and Video Call'+'~#~'+$strms.'First Domain'+'~#~'+$strms.'Second Domain'+'~#~'+$strms.'Conference Type'+'~#~'+$strms.'First Client App Version'+'~#~'+$strms.'Second Client App Version'+'~#~'+$strms.'Meeting Id'+'~#~'+$strms.'Error Report Sender'+'~#~'+$strms.'Is Media Error'+'~#~'+$strms.'Media Failure Type'+'~#~'+$strms.'Call Setup Failure Reason'+'~#~'+$strms.'Session Type'+'~#~'+$strms.'CDR Response Reason'+'~#~'+$strms.'First Video Duration Seconds'+'~#~'+$strms.'Second Video Duration Seconds'
            $metricsDtls=$strms.'Audio Degradation Avg'+'~#~'+$strms.'Jitter'+'~#~'+$strms.'Packet Loss Rate'+'~#~'+$strms.'Send Listen MOS'+'~#~'+$strms.'Overall Avg Network MOS'+'~#~'+$strms.'Ratio Concealed Samples Avg'+'~#~'+$strms.'Ratio Stretched Samples Avg'+'~#~'+$strms.'Round Trip'+'~#~'+$strms.'Packet Utilization'+'~#~'+$strms.'Jitter Buffer Size Avg'+'~#~'+$strms.'Relative OneWay Gap Duration'+'~#~'+$strms.'Audio Post FECPLR'+'~#~'+$strms.'Network Jitter Avg'+'~#~'+$strms.'Video Post FECPLR'+'~#~'+$strms.'Video Local Frame Loss Percentage Avg'+'~#~'+$strms.'Recv Frame Rate Average'+'~#~'+$strms.'Low Frame Rate Call Percent'+'~#~'+$strms.'Video Packet Loss Rate'+'~#~'+$strms.'Video Frame Rate Avg'+'~#~'+$strms.'Dynamic Capability Percent'+'~#~'+$strms.'Spoiled Tile Percent Total'+'~#~'+$strms.'First Network Bandwidth Low Event Ratio'+'~#~'+$strms.'Second Network Bandwidth Low Event Ratio'+'~#~'+$strms.'Video Poor Due to Freeze'+'~#~'+$strms.'Video Poor Due To VideoPostFecplr'+'~#~'+$strms.'Video Poor Due To VideoLocalFrameLossPercentageAvg'+'~#~'+$strms.'Video Poor Due To VideoFrameRateAvg'+'~#~'+$strms.'VBSS Poor Due To VideoPostFecplr'+'~#~'+$strms.'VBSS Poor Due To VideoLocalFrameLossPercentageAvg'+'~#~'+$strms.'VBSS Poor Due To VideoFrameRateAvg'+'~#~'+$strms.'AppSharing Poor Due To SpoiledTilePercentTotal'+'~#~'+$strms.'AppSharing Poor Due To RelativeOneWayAverage'+'~#~'+$strms.'AppSharing Poor Due To RDPTileProcessingLatencyAverage'+'~#~'+$strms.'Audio Poor Due To Jitter'+'~#~'+$strms.'Audio Poor Due To RoundTrip'+'~#~'+$strms.'Audio Poor Due To PacketLoss'+'~#~'+$strms.'Audio Poor Due To Degradation'+'~#~'+$strms.'Audio Poor Due To ConcealedRatio'
            $feedBackDtls=$strms.'First Feedback Tokens'+'~#~'+$strms.'Second Feedback Tokens'+'~#~'+$strms.'First Feedback Has Audio Issue'+'~#~'+$strms.'Second Feedback Has Audio Issue'+'~#~'+$strms.'First Feedback Has Video Issue'+'~#~'+$strms.'Second Feedback Has Video Issue'+'~#~'+$strms.'First Feedback Has AppSharing Issue'+'~#~'+$strms.'Second Feedback Has AppSharing Issue'+'~#~'+$strms.'First Feedback Text'+'~#~'+$strms.'Second Feedback Text'
            
            $strmsHash.Add('Video Frame Rate Avg',$strms.'Video Frame Rate Avg')
            $strmsHash.Add('First Transport Protocol',$strms.'First Transport Protocol')
            $strmsHash.Add('Second Transport Protocol',$strms.'Second Transport Protocol')
            $strmsHash.Add('Session Type',$strms.'Session Type')
            $strmsHash.Add('Stream Direction',$strms.'Stream Direction')
            $strmsHash.Add('Jitter',$strms.'Jitter')
            $strmsHash.Add('Packet Loss Rate',$strms.'Packet Loss Rate')
            $strmsHash.Add('Round Trip',$strms.'Round Trip')

            $strmsHash.Add('System Details',$sysDtls)
            $strmsHash.Add('Network Details',$netWrkDtls)
            $strmsHash.Add('Call Details',$callDtls)
            $strmsHash.Add('Metrics Details',$metricsDtls)
            $strmsHash.Add('Feedback Details',$feedBackDtls)

        }
        if(!$isOccur){
            $strmsHash.Add($property,$strms.$property)
        } 
    }
    [pscustomobject]$strmsHash | Export-Csv $mdifyStmsPath -Encoding $encTyp -Append 
}

if($mdifyStmsPath -ne $null -and [System.IO.File]::Exists($mdifyStmsPath) -eq 'True'){
	$allStrmsCSV= import-csv $mdifyStmsPath -Encoding $encTyp | Sort-Object -Property 'End Time'
    if(Test-Path -Path $mdifyStmsPath -PathType Leaf){
        Remove-Item $mdifyStmsPath -Force
    }
}
if($allStrmsCSV.Count -gt 0){
    $writPath=$dir+'\MTMStrmsBase'+ $timenow +".csv"
    $iswrite=$false
    $obj=$allStrmsCSV| select -Last 1
    #$rptEdTimNUPN=([String]$obj.'End Time').Trim()+'#'+([String]$obj.'First UPN').Trim()+'#'+([String]$obj.'Second UPN').Trim()
    $rptLastConfID=([String]$obj.'Conference Id').Trim()+"~!~"+([String]$obj.'Date').Trim()

    if($lastRptConfId -ne 'none'){
        $isChkTim=$true
        foreach($strms in $allStrmsCSV){
            $chkConfIdNam=([String]$strms.'Conference Id').Trim()
            if($iswrite){ 
                if($chklastRptConfId -ne $chkConfIdNam){
                    $strms| Export-Csv $writPath -Encoding $encTyp -Append
                }
            }
            if($isChkTim){
                if($chklastRptConfId -eq $chkConfIdNam){
                    Write-Log("initial - entering conf id -->> $chklastRptConfId")
                    $iswrite=$true;$isChkTim=$false;
                }
            }
        }
    }
    if(!$iswrite){
        foreach($strms in $allStrmsCSV){
            $cmprTime=[DateTime][String]$strms.'End Time'
            $cmprTime=$cmprTime.ToUniversalTime()
            Write-Log("compare time -->> $cmprTime")
            Write-Log("dat1 time -->> $dat1")
            if($cmprTime -ne ''){
                if($dat1 -lt $cmprTime){
                    $strms| Export-Csv $writPath -Encoding $encTyp -Append  
                }
            }
        }
    }

    $confIdStr='LastConferenceID#'+$rptLastConfID
    Write-Log("last - entering conf id -->> $rptLastConfID")
    Write-Host $confIdStr
    Write-Host 'LastReporting WritePath#'$writPath

    #<#
    $azureVal=Eg-GetAzureEnv -UserName $userName
    $azureEnvArr=$azureVal.Split(',')
    $credential = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $userName, $(convertto-securestring $password -asplaintext -force)
    $azureAD=Connect-AzureAD  -AzureEnvironmentName $azureEnvArr[0] -Credential $credential |select *
    $iniDomainDtls=Get-AzureADDomain | select *
    Write-Host 'TenantDomains#'$iniDomainDtls.Name
    Disconnect-AzureAD
    #>

}

[System.GC]::GetTotalMemory($true) | out-null




