﻿[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath =split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy -WarningAction SilentlyContinue
clear

Function O365-WriteLog{
	Param(
    [String]$writString,
    [String]$LogPath,
    [String]$ReportingName
    )
    $LogPath1=$LogPath.Replace(".log","1.log")
	[string]$date = Get-Date -Format G 
    ( "[" + $date + "] - [" + $ReportingName+"]"+" - " + $writString ) | Out-File -FilePath $LogPath -Append
    if ([System.IO.File]::Exists($LogPath) -and (Get-Item $LogPath).length -gt 2mb) {  #if the size of file is greater than 1MB 
        if([System.IO.File]::Exists($LogPath1)){  #if logfile1 already exists, delete logfile1 
            Remove-Item $LogPath1 
        } 
        Rename-Item $LogPath $LogPath1 
    }
}

function O365-Enc(){
    [CmdletBinding()]
    Param(
        [Parameter(Mandatory=$true, Position=1)]
        [String]$str
    )
    Process
    {
        $j=124;
        $eStr=[System.Text.Encoding]::UTF8
        $byt=$eStr.GetBytes($str)
        $bytArr=@()
        for($i=0;$i -lt $byt.count ;$i++){  
            $k=$j-$byt[$i]+$i*3
            $bt=[System.BitConverter]::GetBytes($k)
            $bytArr+=$bt[0]
        }
        $encStr=''
        for($i=$bytArr.count;$i -ge 0 ;$i--){
            $encStr+=$bytArr[$i]
            if($bytArr[$i] -ne 0){
                $encStr+=':'
            }
        }
        $encStr=$encStr.Substring(1,$encStr.Length-2)
        return $encStr
    }
}

$certDir=$egurkhaPath+'\agent\O365\AppInfo'
if(!(Test-Path -Path $certDir)){
    $null=New-Item -ItemType directory -Path $certDir
}
$logFile=$certDir+'\O365_AppPrerequisites.log'

######***GUI  form ****#######
Add-Type -AssemblyName  Microsoft.VisualBasic,PresentationCore,PresentationFramework,System.Drawing,System.Windows.Forms,WindowsBase,WindowsFormsIntegration
[System.Windows.Forms.Application]::EnableVisualStyles()
$form = New-Object System.Windows.Forms.Form
$flowlayoutpanel = New-Object System.Windows.Forms.FlowLayoutPanel
$buttonOK = New-Object System.Windows.Forms.Button

$pfxDtlsLbl=New-Object System.Windows.Forms.Label
$pfxPassLbl=New-Object System.Windows.Forms.Label
$pfxPassTxtBx=New-Object System.Windows.Forms.TextBox

$formsize = 120

$form.Controls.Add($pfxPassLbl)
$form.Controls.Add($pfxPassTxtBx)

$form.Controls.Add($buttonOK)

$form.AcceptButton = $buttonOK
$form.AutoScaleDimensions = '8, 17'
$form.AutoScaleMode = 'Font'
$form.ClientSize = "390 , $formsize"
$form.FormBorderStyle = 'FixedDialog'
$form.Margin = '5, 5, 5, 5'
$form.MaximizeBox = $False
$form.MinimizeBox = $False
$form.Name = 'form1'
$form.StartPosition = 'CenterScreen'
$form.Text = 'O365 Certificate Generation'
$form.FormBorderStyle = [System.Windows.Forms.FormBorderStyle]::Fixed3D

$pfxPassLbl.Location="38,15"
$pfxPassLbl.Anchor="Bottom, Left"
$pfxPassLbl.Text="&PFX File Password"
$pfxPassLbl.Size="115,20"
$pfxPassTxtBx.Location="150,15"
$pfxPassTxtBx.Name="O365Pass"
$pfxPassTxtBx.Size="200,20"
$pfxPassTxtBx.Text=""
$pfxPassTxtBx.PasswordChar='*'

$buttonOK.Anchor = 'Bottom, Right'
$buttonOK.DialogResult = 'OK'
$buttonOK.Location = "150, 55"
$buttonOK.Margin = '4, 4, 4, 4'
$buttonOK.Name = 'buttonOK'
$buttonOK.Size = '100, 30'
$buttonOK.TabIndex = 0
$buttonOK.Text = '&OK'
$frmDialog=$form.ShowDialog()

if($frmDialog -eq 'OK' ){
    $pfxPass=$pfxPassTxtBx.Text
    if($pfxPass -eq ""){
        Write-Host "PFX password is mandatory." -ForegroundColor Red 
        O365-WriteLog -writString  "PFX password is mandatory." -LogPath $logFile -ReportingName 'ERROR'
        exit
    }
}

Write-host "Certificate generation started"
O365-WriteLog -writString  "[O365GenerateCertificate] Certificate generation started" -LogPath $logFile -ReportingName 'INFO'

$cerFile=$certDir+'\eGCBACert.cer'
if(Test-Path -Path $cerFile -PathType Leaf){
    Remove-Item -Path $cerFile -Force
}
$cerPfxFile=$certDir+'\eGCBApfxCert.pfx'
if($pfxPass -ne $null -and $pfxPass -ne ''){
    $encPfxPass=O365-Enc -str $pfxPass
    O365-WriteLog -writString  "[O365GenerateCertificate] $encPfxPass" -LogPath $logFile -ReportingName 'INFO'
}
if(Test-Path -Path $cerPfxFile -PathType Leaf){
    Remove-Item -Path $cerPfxFile -Force
}
Try{
    $cert = New-SelfSignedCertificate -Subject "CN={eGCBACert}" -CertStoreLocation "Cert:\CurrentUser\My" -KeyExportPolicy Exportable -KeySpec Signature -KeyLength 2048 -KeyAlgorithm RSA -HashAlgorithm SHA256 -NotBefore (Get-Date).AddDays(-1) -NotAfter (Get-Date).AddYears(2)
    Export-Certificate -Cert $cert -FilePath $cerFile
    $cert | Export-PfxCertificate -FilePath $cerPfxFile -Password $(ConvertTo-SecureString -String $pfxPass -AsPlainText -Force)
    Write-Host ''
    Write-host "Certificates are available under <egurkha\agent\O365\AppInfo>."
    O365-WriteLog -writString "Certificates are available under <egurkha\agent\O365\AppInfo>." -LogPath $logFile -ReportingName 'INFO'
}
Catch{
    $message= $_.Exception.Message + $_.ScriptStackTrace 
    Write-host "Exception Occurred - $message."
    O365-WriteLog -writString  "[O365GenerateCertificate] Exception Occurred - $message." -LogPath $logFile -ReportingName 'ERROR'
}
if(!$form.IsDisposed){
    $form.Close()
    $form.Dispose()
}

