﻿#Requires -Version 3.0
#This File is in Unicode format.  Do not edit in an ASCII editor.
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

#region help text

<#
.SYNOPSIS
	Creates an inventory of a Citrix PVS Farm details.
.DESCRIPTION
	Creates an inventory of a Citrix PVS Farm details using Microsoft PowerShell.
	
	The PVS Console must be installed and the snap-in registered on the computer running 
	the script.
	
	For Windows 8.x, Server 2012 and later, run:
	
	For 32-bit:
	%systemroot%\Microsoft.NET\Framework\v4.0.30319\installutil.exe "%ProgramFiles%\Citrix\Provisioning Services Console\Citrix.PVS.SnapIn.dll"
	
	For 64-bit:
	%systemroot%\Microsoft.NET\Framework64\v4.0.30319\installutil.exe "%ProgramFiles%\Citrix\Provisioning Services Console\Citrix.PVS.SnapIn.dll"
	
	
.INPUTS
	None.  You cannot pipe objects to this script.
.OUTPUTS
	No objects are output from this script.  
.NOTES
    Test	: PVSFarmTest_cf
	
	Measures:
        1.Farm description
	    2.Groups with Farm Administrtor access
	    3.Security groups with access rights
	    4.License server name
	    5.License server port
	    6.Auto-add enabled
	    7.Sitename
	    8.Auditing enabled
	    9.Offline database support enabled
	    10.Maximum number of versions from base image
	    11.Auto merge enabled
	    12.Default access mode for new merge versions
#>

#endregion

#region initialize variables
$SaveEAPreference = $ErrorActionPreference
$ErrorActionPreference = 'SilentlyContinue'
$global:isErrorOccured = $False  

$global:CONST_SCRIPT_START = "***Start_Citrix_PVS_server_config_data_***";
$global:CONST_SCRIPT_END = "***End_Citrix_PVS_server_config_data_***";
$global:CONST_DELIMITER = "~#~";

Add-PSSnapin Citrix.PVS.SnapIn

Function getPvsFarmDetails
{
    try
    {
		$rqrdFields = @('farmName','Description','AutoAddEnabled','AuditingEnabled','DefaultSiteName','OfflineDatabaseSupportEnabled','LicenseServer','LicenseServerPort','AutomaticMergeEnabled','MaxVersions','MergeMode')
  
        $farm = Get-PVSFarm -fields $rqrdFields
        If($? -and $farm -ne $Null)
        {
            Write-Host $($CONST_SCRIPT_START)        
            If($? -and $farm -ne $Null)
            {
                $securitys = Get-PVSAuthGroup -Farm -fields AuthGroupName
                $authgroups = Get-PVSAuthGroup -fields AuthGroupName
                $securityFarmAdministrator = $securitys.AuthGroupName -join ",";
                $groupsAssigned =  $authgroups.AuthGroupName -join ",";
				
                $farmName = $farm.farmName;
                $description = $farm.Description;
                $autoAddEnabled = $farm.AutoAddEnabled;
                $auditingEnabled = $farm.AuditingEnabled;
                $defaultSiteName = $farm.DefaultSiteName;
                $offlineDataBase = $farm.OfflineDatabaseSupportEnabled;
                $licenseServer = $farm.LicenseServer;
                $licenseServerPort = $farm.LicenseServerPort;
                $automaticMergeEnabled = $farm.AutomaticMergeEnabled;
                $maxVersions = $farm.MaxVersions;
                $mergeMode = $farm.MergeMode;
                                
                Write-Host "FarmName: $($farmName) $($CONST_DELIMITER) Description: $($description) $($CONST_DELIMITER) GroupsAssigned: $($groupsAssigned) $($CONST_DELIMITER) SecurityFarmAdministrator: $($securityFarmAdministrator) $($CONST_DELIMITER) AutoAddEnabled: $($autoAddEnabled) $($CONST_DELIMITER)  AuditingEnabled: $($auditingEnabled) $($CONST_DELIMITER) DefaultSiteName: $($defaultSiteName) $($CONST_DELIMITER) OfflineDatabaseSupportEnabled: $($offlineDataBase) $($CONST_DELIMITER) LicenseServer: $($licenseServer) $($CONST_DELIMITER) LicenseServerPort: $($licenseServerPort) $($CONST_DELIMITER)  AutomaticMergeEnabled: $($automaticMergeEnabled) $($CONST_DELIMITER)  MaxVersions: $($MaxVersions) $($CONST_DELIMITER) MergeMode: $($mergeMode)";  
            }
        }
    }
    catch
    {
	    $global:isErrorOccured = $True
	    Write-Host " PVSFarmTest_cf powershell script Exception ";
        Write-Host $_
    }

    If(-Not $isErrorOccured)
    {
	    Write-Host $CONST_SCRIPT_END
    }
}

getPvsFarmDetails
Remove-PSSnapin Citrix.PVS.SnapIn