﻿#Requires -Version 3.0
#This File is in Unicode format.  Do not edit in an ASCII editor.
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

#region help text

<#
.SYNOPSIS
	Creates an inventory of a Citrix PVS UpdateTask details.
.DESCRIPTION
	Creates an inventory of a Citrix PVS UpdateTask details using Microsoft PowerShell.
	
	The PVS Console must be installed and the snap-in registered on the computer running 
	the script.
	
	For Windows 8.x, Server 2012 and later, run:
	
	For 32-bit:
	%systemroot%\Microsoft.NET\Framework\v4.0.30319\installutil.exe "%ProgramFiles%\Citrix\Provisioning Services Console\Citrix.PVS.SnapIn.dll"
	
	For 64-bit:
	%systemroot%\Microsoft.NET\Framework64\v4.0.30319\installutil.exe "%ProgramFiles%\Citrix\Provisioning Services Console\Citrix.PVS.SnapIn.dll"
	
	
.INPUTS
	None.  You cannot pipe objects to this script.
.OUTPUTS
	No objects are output from this script.  
.NOTES
    Test	: PVSUpdateTaskTest_cf
	
	Measures:
       	1.Description
		2.Task enabled
		3.Hour
		4.Minute
		5.Recurrence
		6.Day mask
		7.Date
		8.Monthly offset
		9.Esd type
		10.Pre update script
		11.Pre Vm script
		12.Post update script
		13.Post Vm script
		14.Post update approve
#>

#endregion

#region initialize variables
$SaveEAPreference = $ErrorActionPreference
$ErrorActionPreference = 'SilentlyContinue'
$global:isErrorOccured = $False  

$global:CONST_SCRIPT_START = "***Start_Citrix_PVS_server_config_data_***";
$global:CONST_SCRIPT_END = "***End_Citrix_PVS_server_config_data_***";
$global:CONST_DELIMITER = "~#~";

Add-PSSnapin Citrix.PVS.SnapIn
#endregion

Function getPvsUpdateTaskDetails
{
    try
    {
        $pvsFarm =  Get-PvsFarm
        
        If($? -and $pvsFarm -ne $Null)
        {
            Write-Host $($CONST_SCRIPT_START)


            $PVSSites = Get-PVSSite -fields SiteName
        
            If($? -and $PVSSites -ne $Null)
            {
                $SiteNames =$PVSSites.SiteName
	   
	   		    $pvsFarmFields = @('UpdateTaskName','SiteName','Description','Enabled','Hour','Minute','Recurrence','DayMask','Date','MonthlyOffset','EsdType','PreUpdateScript','PreVmScript','PostUpdateScript','PostVmScript','PostUpdateApprove')

                ForEach($SiteName in $SiteNames)
	            {
                    $Tasks = Get-PvsUpdateTask -siteName $SiteName -fields $pvsFarmFields
               
                    If($? -and $Tasks -ne $Null)
				    {
                        ForEach($Task in $Tasks)
				        {
                            $updateTaskName = $Task.UpdateTaskName
                            $siteName = $Task.SiteName
                            $description = $Task.Description
                            $enabled = $Task.Enabled
                            $hour = $Task.Hour
                            $minute = $Task.Minute
                            $recurrence = $Task.Recurrence
                            $dayMask = $Task.DayMask
                            $date = $Task.Date
                            $monthlyOffset = $Task.MonthlyOffset
                            $esdType = $Task.EsdType
                            $preUpdateScript = $Task.PreUpdateScript
                            $preVmScript = $Task.PreVmScript
                            $postUpdateScript = $Task.PostUpdateScript
                            $postVmScript = $Task.PostVmScript
                            $postUpdateApprove = $Task.PostUpdateApprove
                        
	                        Write-Host "UpdateTaskName: $($updateTaskName) $($CONST_DELIMITER) SiteName: $($siteName) $($CONST_DELIMITER) Description: $($description) $($CONST_DELIMITER) Enabled: $($enabled) $($CONST_DELIMITER) Hour: $($hour) $($CONST_DELIMITER) Minute: $($minute) $($CONST_DELIMITER) Recurrence: $($recurrence) $($CONST_DELIMITER) DayMask: $($dayMask) $($CONST_DELIMITER) Date: $($date) $($CONST_DELIMITER) MonthlyOffset: $($monthlyOffset) $($CONST_DELIMITER) EsdType: $($esdType) $($CONST_DELIMITER) PreUpdateScript: $($preUpdateScript) $($CONST_DELIMITER) PreVmScript: $($preVmScript) $($CONST_DELIMITER) PostUpdateScript: $($postUpdateScript) $($CONST_DELIMITER) PostVmScript: $($postVmScript) $($CONST_DELIMITER) PostUpdateApprove: $($postUpdateApprove)"
                         }
                    }
                }
            }
        }
    }
    catch
    {
	    $global:isErrorOccured = $True
	    Write-Host " PVSUpdateTaskTest_cf powershell script Exception ";
        Write-Host $_
    }

    If(-Not $isErrorOccured)
    {
	    Write-Host $CONST_SCRIPT_END
    }
}

getPvsUpdateTaskDetails
Remove-PSSnapin Citrix.PVS.SnapIn
