$corePath = Get-ItemProperty -Path "HKLM:\Software\Veeam\Veeam Backup and Replication\" -Name "CorePath"
$depDLLPath = Join-Path -Path $corePath.CorePath -ChildPath "Packages\VeeamDeploymentDLL.dll" -Resolve -EA SilentlyContinue
if($depDLLPath)
{
	$file = Get-Item -Path $depDLLPath
	$MajorVersion = $file.VersionInfo.ProductMajorPart
	if($MajorVersion -ge 10)
	{
		import-Module Veeam.Backup.Powershell
	}
	else
	{
		Add-PSSnapin VeeamPSSnapin -ErrorAction SilentlyContinue

		If ((Get-PSSnapin "*Veeam*" -ErrorAction SilentlyContinue) -eq $null)
		{
			Write-Host "Unable to load Veeam snapin, you must run this on your Veeam backup server, and the Powershell snapin must be installed."
			Return
		}
	}
}
else
{
	Write-Host "Unable to load Veeam snapin, you must run this on your Veeam backup server, and the Powershell snapin must be installed."
	Return
}
$Global:ErrorActionPreference="SilentlyContinue"
foreach($Job in (Get-VBRJob))
{
	$Session = $Job.FindLastSession()
	if(!$Session){continue;}
	$Info = $Session.GetTaskSessions()
	foreach ($VM in $info)
	{
		# Get Array Data
		$JobName = $job.Name
		$Name = $VM.Name
		$Type = $job.jobtype
		$Status = $VM.status
		#$Progress = $VM.Progress.DisplayName
		$Size = [Math]::Round([Decimal]$VM.Progress.ProcessedSize/1GB,2)
		$Start = $VM.progress.starttimelocal 
		$Finish = $VM.progress.stoptimelocal
		$Creationtime = $session.Creationtime
		$EndTime = $session.Endtime
		$d = $EndTime - $Creationtime
		$Duration = '{0:00}:{1:00}:{2:00}' -f ($d | % {$_.Hours, $_.Minutes, $_.Seconds})
		$schedule = $job.GetScheduleOptions()
		$NextRun = $schedule.NextRun
		$Age = "-"
		if($Finish -ne $null)
		{
			$Age = ((Get-Date) - $Finish).Hours
		}
		else
		{
			$Finish = -5
			$Age = -5
		}
		$Message = $VM.GetDetails()
	
		Write-Host "START"$JobName_$Name=$Type,$Status,$Size,$Start,$Finish,$Duration,$Age,$NextRun,$Message,"END" -separator "#~#"
	}
}


Remove-PSSnapin VeeamPSSnapin