$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

<# 
.SYNOPSIS
    Changes the XenApp Logon Mode for the selected server
.PARAMETER LogonMode
   Logon behavior of the server - manually entered by user
#>

$ErrorActionPreference = "Stop"
$computer = $env:COMPUTERNAME
$mode = $args[0]

Try
{
    Add-PsSnapin Citrix.XenApp.Commands
}
Catch
{
    Write-Error "Not able to load the SnapIn"
    Exit 1
}

Try
{
    Set-XAServerLogOnMode -LogOnMode $mode -ServerName $computer
}
Catch
{
    Write-Error "Error in Set-XAServerLogonMode cmdlet execution" 
    Exit 1
}

Write-Host "The operation completed successfully." 
