$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$ErrorActionPreference = "Stop"
$DGs = @()
Try
{
    Add-PSSnapin Citrix.Broker.Admin.* | Out-Null } Catch { Write-Host "Unable to load Citrix Snapin.
               Exit 1
}
$DGs = Get-BrokerDesktopGroup -InMaintenanceMode $true 
If ($DGs) 
{ 
    Write-Host "Delivery Groups in Maintenance Mode are:"
    ForEach ($DG in $DGs)
    {
           $DG.Name
    }
}
Else
{
Write-Host "There are no delivery groups in maintenance mode!"
}
