'use strict'

const semver = require('semver');

const channel = require('./channel');
const shimmer = require('../../shimmer');
const logger = require('../../../logger');

let isWrapped = false;
const appendMsg = `RabbitMQ-amqplib-connect:`;

exports.start = function (amqplib, agent, version, enabled) {
  if (!enabled) return amqplib;
  if (!semver.satisfies(version, '>=0.5')) {
    logger.info(appendMsg, `version ${version} is not supported`);
    return amqplib;
  }

  try {
    logger.debug(appendMsg, 'wrapping amqplib.connect');
    shimmer.wrap(amqplib.Channel.prototype, 'get', channel.wrapGet, agent);
    logger.info(appendMsg, 'Wrapped successfully..!, Version', version);
  } catch (e) {
    logger.error(appendMsg, 'wrapChannel', e);
  }

  isWrapped = true;
  return amqplib;
}

exports.stop = function (amqplib, version) {
  if (!isWrapped) return;
  try {
    shimmer.unwrap(amqplib.Channel.prototype, 'get');
  } catch (e) {
    logger.error(appendMsg, 'stop', e);
  }
  isWrapped = false;
  logger.info(appendMsg, 'unwrapped successfully..!, Version', version);
}