﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy
clear 

$TestInputs=$args

$reportingname='EXO\'+$TestInputs[0]

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'
try{
    $readfiles=Eg-ReadFile -ComntRptPath $reportingname -FileName "mailbox" -keyFileName "kmailbox" -EgPath $egurkhaPath
    if($readfiles -ne $null -and [System.IO.File]::Exists($readfiles[1]) -eq 'True'){
        $datafile=$readfiles[1] -replace (".csv",".dat") 
        $csvfile=Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]	
        $MailboxesDetails= import-csv $csvfile -Encoding $encTyp
        Remove-Item $csvfile
        Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'mailbox' -InputFile $readfiles[3]
        Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'kmailbox' -InputFile $readfiles[4]
        Write-Host 'ReadFile:'$readfiles[3]
    }
}
catch{
    $errmsg=$_.Exception.Message
    Write-Error -Message $errmsg
}
    [System.GC]::GetTotalMemory($true) | out-null
Try{
    $readArr =Eg-ReadFile -ComntRptPath $reportingname -FileName "O365msolUsr" -keyFileName "kO365msolUsr" -EgPath $egurkhaPath
    if($readArr -ne $null -and [System.IO.File]::Exists($readArr[1]) -eq 'True'){
        $unProtctMUsr =$readArr[1] -replace (".csv",".dat") 
        $musrPath =Unprotect-File $unProtctMUsr -Algorithm AES -KeyAsPlainText $readArr[0]	
        $msoluserS = import-csv $musrPath -Encoding $encTyp
        Remove-Item $musrPath
        Write-Host 'ReadFile:'$readArr[3]
        Eg-DeleteFiles -FilePath $readArr[2] -Pattern 'O365msolUsr' -InputFile $readArr[3]
        Eg-DeleteFiles -FilePath $readArr[2] -Pattern 'kO365msolUsr' -InputFile $readArr[4]
    }
}Catch{}
    
    
    [System.GC]::GetTotalMemory($true) | out-null
    <#
	$Datacenter = @{}
	$Datacenter["AF"]=@("","Afghanistan")
    $Datacenter["AL"]=@("","Albania")
    $Datacenter["DZ"]=@("","Algeria")
    $Datacenter["AS"]=@("","American Samoa")
    $Datacenter["AD"]=@("","Andorra")
    $Datacenter["AO"]=@("","Angola")
    $Datacenter["AI"]=@("","Anguilla")
    $Datacenter["AQ"]=@("","Antarctica")
    $Datacenter["AG"]=@("","Antigua and Barbuda")
    $Datacenter["AR"]=@("","Argentina")
    $Datacenter["AM"]=@("","Amsterdam, Netherlands")
    $Datacenter["AW"]=@("","Aruba")
    $Datacenter["AU"]=@("","Australia")
    $Datacenter["AT"]=@("","Austria")
    $Datacenter["AZ"]=@("","Azerbaijan")
    $Datacenter["BS"]=@("","Bahamas")
    $Datacenter["BH"]=@("","Bahrain")
    $Datacenter["BD"]=@("","Bangladesh")
    $Datacenter["BB"]=@("","Barbados")
    $Datacenter["BY"]=@("","Belarus")
    $Datacenter["BE"]=@("","Belgium")
    $Datacenter["BZ"]=@("","Belize")
    $Datacenter["BJ"]=@("","Benin")
    $Datacenter["BM"]=@("","Bermuda")
    $Datacenter["BT"]=@("","Bhutan")
    $Datacenter["BO"]=@("","Bolivia")
    $Datacenter["BQ"]=@("","Bonaire")
    $Datacenter["BA"]=@("","Bosnia and Herzegovina")
    $Datacenter["BW"]=@("","Botswana")
    $Datacenter["BV"]=@("","Bouvet Island")
    $Datacenter["BR"]=@("","Brazil")
    $Datacenter["IO"]=@("","British Indian Ocean Territory")
    $Datacenter["BN"]=@("","Brunei Darussalam")
    $Datacenter["BG"]=@("","Bulgaria")
    $Datacenter["BF"]=@("","Burkina Faso")
    $Datacenter["BI"]=@("","Burundi")
    $Datacenter["KH"]=@("","Cambodia")
    $Datacenter["CM"]=@("","Cameroon")
    $Datacenter["CA"]=@("","Canada")
    $Datacenter["CV"]=@("","Cape Verde")
    $Datacenter["KY"]=@("","Cayman Islands")
    $Datacenter["CF"]=@("","Central African Republic")
    $Datacenter["TD"]=@("","Chad")
    $Datacenter["CL"]=@("","Chile")
    $Datacenter["CN"]=@("","China")
    $Datacenter["CX"]=@("","Christmas Island")
    $Datacenter["CC"]=@("","Cocos (Keeling) Islands")
    $Datacenter["CO"]=@("","Colombia")
    $Datacenter["KM"]=@("","Comoros")
    $Datacenter["CG"]=@("","Congo")
    $Datacenter["CD"]=@("","Democratic Republic of the Congo")
    $Datacenter["CK"]=@("","Cook Islands")
    $Datacenter["CR"]=@("","Costa Rica")
    $Datacenter["HR"]=@("","Croatia")
    $Datacenter["CU"]=@("","Cuba")
    $Datacenter["CW"]=@("","Curacao")
    $Datacenter["CY"]=@("","Cyprus")
    $Datacenter["CZ"]=@("","Czech Republic")
    $Datacenter["CI"]=@("","Cote d'Ivoire")
    $Datacenter["DK"]=@("","Denmark")
    $Datacenter["DJ"]=@("","Djibouti")
    $Datacenter["DM"]=@("","Dominica")
    $Datacenter["DO"]=@("","Dominican Republic")
    $Datacenter["EC"]=@("","Ecuador")
    $Datacenter["EG"]=@("","Egypt")
    $Datacenter["SV"]=@("","El Salvador")
    $Datacenter["GQ"]=@("","Equatorial Guinea")
    $Datacenter["ER"]=@("","Eritrea")
    $Datacenter["EE"]=@("","Estonia")
    $Datacenter["ET"]=@("","Ethiopia")
    $Datacenter["FK"]=@("","Falkland Islands (Malvinas)")
    $Datacenter["FO"]=@("","Faroe Islands")
    $Datacenter["FJ"]=@("","Fiji")
    $Datacenter["FI"]=@("","Finland")
    $Datacenter["FR"]=@("","France")
    $Datacenter["GF"]=@("","French Guiana")
    $Datacenter["PF"]=@("","French Polynesia")
    $Datacenter["TF"]=@("","French Southern Territories")
    $Datacenter["GA"]=@("","Gabon")
    $Datacenter["GM"]=@("","Gambia")
    $Datacenter["GE"]=@("","Georgia")
    $Datacenter["DE"]=@("","Germany")
    $Datacenter["GH"]=@("","Ghana")
    $Datacenter["GI"]=@("","Gibraltar")
    $Datacenter["GR"]=@("","Greece")
    $Datacenter["GL"]=@("","Greenland")
    $Datacenter["GD"]=@("","Grenada")
    $Datacenter["GP"]=@("","Guadeloupe")
    $Datacenter["GU"]=@("","Guam")
    $Datacenter["GT"]=@("","Guatemala")
    $Datacenter["GG"]=@("","Guernsey")
    $Datacenter["GN"]=@("","Guinea")
    $Datacenter["GW"]=@("","Guinea-Bissau")
    $Datacenter["GY"]=@("","Guyana")
    $Datacenter["HT"]=@("","Haiti")
    $Datacenter["HM"]=@("","Heard Island and McDonald Islands")
    $Datacenter["VA"]=@("","Holy See (Vatican City State)")
    $Datacenter["HN"]=@("","Honduras")
    $Datacenter["HK"]=@("","Hong Kong")
    $Datacenter["HU"]=@("","Hungary")
    $Datacenter["IS"]=@("","Iceland")
    $Datacenter["IN"]=@("","India")
    $Datacenter["ID"]=@("","Indonesia")
    $Datacenter["IR"]=@("","Islamic Republic of Iran")
    $Datacenter["IQ"]=@("","Iraq")
    $Datacenter["IE"]=@("","Ireland")
    $Datacenter["IM"]=@("","Isle of Man")
    $Datacenter["IL"]=@("","Israel")
    $Datacenter["IT"]=@("","Italy")
    $Datacenter["JM"]=@("","Jamaica")
    $Datacenter["JP"]=@("","Japan")
    $Datacenter["JE"]=@("","Jersey")
    $Datacenter["JO"]=@("","Jordan")
    $Datacenter["KZ"]=@("","Kazakhstan")
    $Datacenter["KE"]=@("","Kenya")
    $Datacenter["KI"]=@("","Kiribati")
    $Datacenter["KP"]=@("","Democratic People's Republic of Korea")
    $Datacenter["KR"]=@("","Republic of Korea")
    $Datacenter["KW"]=@("","Kuwait")
    $Datacenter["KG"]=@("","Kyrgyzstan")
    $Datacenter["LA"]=@("","Lao People's Democratic Republic")
    $Datacenter["LV"]=@("","Latvia")
    $Datacenter["LB"]=@("","Lebanon")
    $Datacenter["LS"]=@("","Lesotho")
    $Datacenter["LR"]=@("","Liberia")
    $Datacenter["LY"]=@("","Libya")
    $Datacenter["LI"]=@("","Liechtenstein")
    $Datacenter["LT"]=@("","Lithuania")
    $Datacenter["LU"]=@("","Luxembourg")
    $Datacenter["MO"]=@("","Macao")
    $Datacenter["MK"]=@("","The Former Yugoslav Republic of Macedonia")
    $Datacenter["MG"]=@("","Madagascar")
    $Datacenter["MW"]=@("","Malawi")
    $Datacenter["MY"]=@("","Malaysia")
    $Datacenter["MV"]=@("","Maldives")
    $Datacenter["ML"]=@("","Mali")
    $Datacenter["MT"]=@("","Malta")
    $Datacenter["MH"]=@("","Marshall Islands")
    $Datacenter["MQ"]=@("","Martinique")
    $Datacenter["MR"]=@("","Mauritania")
    $Datacenter["MU"]=@("","Mauritius")
    $Datacenter["YT"]=@("","Mayotte")
    $Datacenter["MX"]=@("","Mexico")
    $Datacenter["FM"]=@("","Federated States of Micronesia")
    $Datacenter["MD"]=@("","Republic of Moldova")
    $Datacenter["MC"]=@("","Monaco")
    $Datacenter["MN"]=@("","Mongolia")
    $Datacenter["ME"]=@("","Montenegro")
    $Datacenter["MS"]=@("","Montserrat")
    $Datacenter["MA"]=@("","Morocco")
    $Datacenter["MZ"]=@("","Mozambique")
    $Datacenter["MM"]=@("","Myanmar")
    $Datacenter["NA"]=@("","Namibia")
    $Datacenter["NR"]=@("","Nauru")
    $Datacenter["NP"]=@("","Nepal")
    $Datacenter["NL"]=@("","Netherlands")
    $Datacenter["NC"]=@("","New Caledonia")
    $Datacenter["NZ"]=@("","New Zealand")
    $Datacenter["NI"]=@("","Nicaragua")
    $Datacenter["NE"]=@("","Niger")
    $Datacenter["NG"]=@("","Nigeria")
    $Datacenter["NU"]=@("","Niue")
    $Datacenter["NF"]=@("","Norfolk Island")
    $Datacenter["MP"]=@("","Northern Mariana Islands")
    $Datacenter["NO"]=@("","Norway")
    $Datacenter["OM"]=@("","Oman")
    $Datacenter["PK"]=@("","Pakistan")
    $Datacenter["PW"]=@("","Palau")
    $Datacenter["PS"]=@("","State of Palestine")
    $Datacenter["PA"]=@("","Panama")
    $Datacenter["PG"]=@("","Papua New Guinea")
    $Datacenter["PY"]=@("","Paraguay")
    $Datacenter["PE"]=@("","Peru")
    $Datacenter["PH"]=@("","Philippines")
    $Datacenter["PN"]=@("","Pitcairn")
    $Datacenter["PL"]=@("","Poland")
    $Datacenter["PT"]=@("","Portugal")
    $Datacenter["PR"]=@("","Puerto Rico")
    $Datacenter["QA"]=@("","Qatar")
    $Datacenter["RO"]=@("","Romania")
    $Datacenter["RU"]=@("","Russian Federation")
    $Datacenter["RW"]=@("","Rwanda")
    $Datacenter["RE"]=@("","Reunion")
    $Datacenter["BL"]=@("","Saint Barthelemy")
    $Datacenter["SH"]=@("","Saint Helena")
    $Datacenter["KN"]=@("","Saint Kitts and Nevis")
    $Datacenter["LC"]=@("","Saint Lucia")
    $Datacenter["MF"]=@("","Saint Martin (French part)")
    $Datacenter["PM"]=@("","Saint Pierre and Miquelon")
    $Datacenter["VC"]=@("","Saint Vincent and the Grenadines")
    $Datacenter["WS"]=@("","Samoa")
    $Datacenter["SM"]=@("","San Marino")
    $Datacenter["ST"]=@("","Sao Tome and Principe")
    $Datacenter["SA"]=@("","Saudi Arabia")
    $Datacenter["SN"]=@("","Senegal")
    $Datacenter["RS"]=@("","Serbia")
    $Datacenter["SC"]=@("","Seychelles")
    $Datacenter["SL"]=@("","Sierra Leone")
    $Datacenter["SG"]=@("","Singapore")
    $Datacenter["SX"]=@("","Sint Maarten (Dutch part)")
    $Datacenter["SK"]=@("","Slovakia")
    $Datacenter["SI"]=@("","Slovenia")
    $Datacenter["SB"]=@("","Solomon Islands")
    $Datacenter["SO"]=@("","Somalia")
    $Datacenter["ZA"]=@("","South Africa")
    $Datacenter["GS"]=@("","South Georgia and the South Sandwich Islands")
    $Datacenter["SS"]=@("","South Sudan")
    $Datacenter["ES"]=@("","Spain")
    $Datacenter["LK"]=@("","Sri Lanka")
    $Datacenter["SD"]=@("","Sudan")
    $Datacenter["SR"]=@("","Suriname")
    $Datacenter["SJ"]=@("","Svalbard and Jan Mayen")
    $Datacenter["SZ"]=@("","Swaziland")
    $Datacenter["SE"]=@("","Sweden")
    $Datacenter["CH"]=@("","Switzerland")
    $Datacenter["SY"]=@("","Syrian Arab Republic")
    $Datacenter["TW"]=@("","Taiwan")
    $Datacenter["TJ"]=@("","Tajikistan")
    $Datacenter["TZ"]=@("","United Republic of Tanzania")
    $Datacenter["TH"]=@("","Thailand")
    $Datacenter["TL"]=@("","Timor-Leste")
    $Datacenter["TG"]=@("","Togo")
    $Datacenter["TK"]=@("","Tokelau")
    $Datacenter["TO"]=@("","Tonga")
    $Datacenter["TT"]=@("","Trinidad and Tobago")
    $Datacenter["TN"]=@("","Tunisia")
    $Datacenter["TR"]=@("","Turkey")
    $Datacenter["TM"]=@("","Turkmenistan")
    $Datacenter["TC"]=@("","Turks and Caicos Islands")
    $Datacenter["TV"]=@("","Tuvalu")
    $Datacenter["UG"]=@("","Uganda")
    $Datacenter["UA"]=@("","Ukraine")
    $Datacenter["AE"]=@("","United Arab Emirates")
    $Datacenter["GB"]=@("","United Kingdom")
    $Datacenter["US"]=@("","United States")
    $Datacenter["UM"]=@("","United States Minor Outlying Islands")
    $Datacenter["UY"]=@("","Uruguay")
    $Datacenter["UZ"]=@("","Uzbekistan")
    $Datacenter["VU"]=@("","Vanuatu")
    $Datacenter["VE"]=@("","Venezuela")
    $Datacenter["VN"]=@("","Viet Nam")
    $Datacenter["VG"]=@("","British Virgin Islands")
    $Datacenter["VI"]=@("","Vienna, Austria")
    $Datacenter["WF"]=@("","Wallis and Futuna")
    $Datacenter["EH"]=@("","Western Sahara")
    $Datacenter["YE"]=@("","Yemen")
    $Datacenter["ZM"]=@("","Zambia")
    $Datacenter["ZW"]=@("","Zimbabwe")
    $Datacenter["CP"]=@("","Brazil")
    $Datacenter["KA"]=@("","Japan")
    $Datacenter["OS"]=@("","Japan")
    $Datacenter["TY"]=@("","Japan")
    $Datacenter["DB"]=@("","Dublin, Ireland")
    $Datacenter["HE"]=@("","Finland")
    $Datacenter["KL"]=@("","Kuala Lumpur, Malaysia")
    $Datacenter["YQ"]=@("","Quebec City, Canada")
    $Datacenter["LO"]=@("","London, England")
    #>
    #<#
    $Datacenter = @{}
    $Datacenter["CP"]=@("LAM","Brazil")
    $Datacenter["GR"]=@("LAM","Brazil")
    $Datacenter["HK"]=@("APC","Hong Kong")
    $Datacenter["SI"]=@("APC","Singapore")
    $Datacenter["SG"]=@("APC","Singapore")
    $Datacenter["KA"]=@("JPN","Japan")
    $Datacenter["OS"]=@("JPN","Japan")
    $Datacenter["TY"]=@("JPN","Japan")
    $Datacenter["AM"]=@("EUR","Amsterdam, Netherlands")
    $Datacenter["DB"]=@("EUR","Dublin, Ireland")
    $Datacenter["HE"]=@("EUR","Finland")
    $Datacenter["VI"]=@("EUR","Austria")
    $Datacenter["BL"]=@("NAM","Virginia, USA")
    $Datacenter["SN"]=@("NAM","San Antonio, Texas, USA")
    $Datacenter["BN"]=@("NAM","Virginia, USA")
    $Datacenter["DM"]=@("NAM","Des Moines, Iowa, USA")
    $Datacenter["BY"]=@("NAM","San Francisco, California, USA")
    $Datacenter["CY"]=@("NAM","Cheyenne, Wyoming, USA")
    $Datacenter["CO"]=@("NAM","Quincy, Washington, USA")
    $Datacenter["CH"]=@("NAM","Chicago, Illinois, USA")
    $Datacenter["ME"]=@("APC","Melbourne, Victoria, Australia")
    $Datacenter["SY"]=@("APC","Sydney, New South Wales, Australia")
    #>

	$Mailboxes = $MailboxesDetails | Where-Object {$_.RecipientTypeDetails -ne "DiscoveryMailbox"}
	#$ServerCount = ($Mailboxes | Group-Object {$_.ServerName}).count
	#$DatabaseCount = ($Mailboxes | Group-Object {$_.Database}).count
	$Mailboxes = $Mailboxes | Group-Object {$_.ServerName.SubString(0,2)} | Select @{Name="Datacenter";Expression={$_.Name}}, Count

	$Locations=@()
    $MailLocationsCount=0
	$LocationsConsolCount=0
	$usersLocationsCount=0
	
	# Not pretty error handling but allows counts to add properly when a datacenter location could not be identified from the table
	$E = $ErrorActionPreference
	$ErrorActionPreference = "SilentlyContinue"
	if($Mailboxes -ne $null -and $Mailboxes -ne ''){
        
		ForEach ($Mailbox in $Mailboxes) {
		  $Object = New-Object -TypeName PSObject
		  if($Datacenter[$Mailbox.Datacenter] -eq $null){
			$Datacenter[$Mailbox.Datacenter]=@("Unknown","Unknown")
		  }
		  $Object | Add-Member -Name 'Datacenter' -MemberType NoteProperty -Value $Mailbox.Datacenter
		  $Object | Add-Member -Name 'Region' -MemberType NoteProperty -Value $Datacenter[$Mailbox.Datacenter][0]
		  $Object | Add-Member -Name 'Location' -MemberType NoteProperty -Value $Datacenter[$Mailbox.Datacenter][1]
		  $Object | Add-Member -Name 'Count' -MemberType NoteProperty -Value $Mailbox.Count
		  $Locations += $Object
		}

		$ErrorActionPreference = $E

		$TotalMailboxes = ($Locations | Measure-Object Count -Sum).sum

		if($TotalMailboxes -eq $null ){
		  $TotalMailboxes=0
		}

		$LocationsConsolidated = $Locations | Group-Object Location | ForEach {
		      New-Object PSObject -Property @{
		      Location = $_.Name
		      Mailboxes = ("{0,9}" -f ($_.Group | Measure-Object Count -Sum).Sum)
		      }
		} | Sort-Object Count -Descending


		$ddpairs=$LocationsConsolidated | Select Location, Mailboxes
		foreach($ddline in $ddpairs){
			$LocationsConsolCount++    
			Write-Host '#DD' $ddline.Location '~!~'$ddline.Mailboxes.Trim()
		}
        $MailLocationsCount=$Locations.Count
	}
	else{
		$LocationsConsolCount = '-5'
		$MailLocationsCount= '-5'
	}
    $msoluserLocations = @()
    $msoluserS=$msoluserS | Where {$_.Userprincipalname -notlike '*#EXT#*'}

    ForEach ($msoluser in $msoluserS) {
     if($msoluser.UsageLocation -eq '' -or $Datacenter[$msoluser.UsageLocation] -eq $null){
        $Datacenter[$msoluser.UsageLocation]=@("Unknown","Unknown")
     }
	  $MsolObject = New-Object -TypeName PSObject
	  $MsolObject | Add-Member -Name 'UsageLocation' -MemberType NoteProperty -Value $Datacenter[$msoluser.UsageLocation][1]
	  $MsolObject | Add-Member -Name 'Count' -MemberType NoteProperty -Value 1
	  $msoluserLocations += $MsolObject
	}

	$usersLocationsConsolidated = $msoluserLocations | Group-Object UsageLocation | ForEach {
	      New-Object PSObject -Property @{
	      Location = $_.Name
	      Unique_Count = ("{0,9}" -f ($_.Group | Measure-Object Count -Sum).Sum)
	      }
	} | Sort-Object Unique_Count -Descending

	foreach($ddline in $usersLocationsConsolidated){
		$usersLocationsCount++    
		Write-Host '#UserLocationDD' $ddline.Location '~!~'$ddline.Unique_Count.Trim()
	}

    Write-Host '#Measure ' $MailLocationsCount '~' $LocationsConsolCount '~' $usersLocationsCount
    [System.GC]::GetTotalMemory($true) | out-null

# SIG # Begin signature block
# MIIlUgYJKoZIhvcNAQcCoIIlQzCCJT8CAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQU8fxq2+aifeAkCES0RlrrcCC5
# 8ISggh54MIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFjTCC
# BHWgAwIBAgIQDpsYjvnQLefv21DiCEAYWjANBgkqhkiG9w0BAQwFADBlMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJvb3QgQ0Ew
# HhcNMjIwODAxMDAwMDAwWhcNMzExMTA5MjM1OTU5WjBiMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MSEwHwYDVQQDExhEaWdpQ2VydCBUcnVzdGVkIFJvb3QgRzQwggIiMA0GCSqGSIb3
# DQEBAQUAA4ICDwAwggIKAoICAQC/5pBzaN675F1KPDAiMGkz7MKnJS7JIT3yithZ
# wuEppz1Yq3aaza57G4QNxDAf8xukOBbrVsaXbR2rsnnyyhHS5F/WBTxSD1Ifxp4V
# pX6+n6lXFllVcq9ok3DCsrp1mWpzMpTREEQQLt+C8weE5nQ7bXHiLQwb7iDVySAd
# YyktzuxeTsiT+CFhmzTrBcZe7FsavOvJz82sNEBfsXpm7nfISKhmV1efVFiODCu3
# T6cw2Vbuyntd463JT17lNecxy9qTXtyOj4DatpGYQJB5w3jHtrHEtWoYOAMQjdjU
# N6QuBX2I9YI+EJFwq1WCQTLX2wRzKm6RAXwhTNS8rhsDdV14Ztk6MUSaM0C/CNda
# SaTC5qmgZ92kJ7yhTzm1EVgX9yRcRo9k98FpiHaYdj1ZXUJ2h4mXaXpI8OCiEhtm
# mnTK3kse5w5jrubU75KSOp493ADkRSWJtppEGSt+wJS00mFt6zPZxd9LBADMfRyV
# w4/3IbKyEbe7f/LVjHAsQWCqsWMYRJUadmJ+9oCw++hkpjPRiQfhvbfmQ6QYuKZ3
# AeEPlAwhHbJUKSWJbOUOUlFHdL4mrLZBdd56rF+NP8m800ERElvlEFDrMcXKchYi
# Cd98THU/Y+whX8QgUWtvsauGi0/C1kVfnSD8oR7FwI+isX4KJpn15GkvmB0t9dmp
# sh3lGwIDAQABo4IBOjCCATYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQU7Nfj
# gtJxXWRM3y5nP+e6mK4cD08wHwYDVR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNt
# yA8wDgYDVR0PAQH/BAQDAgGGMHkGCCsGAQUFBwEBBG0wazAkBggrBgEFBQcwAYYY
# aHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRwOi8vY2Fj
# ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3J0MEUG
# A1UdHwQ+MDwwOqA4oDaGNGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2Vy
# dEFzc3VyZWRJRFJvb3RDQS5jcmwwEQYDVR0gBAowCDAGBgRVHSAAMA0GCSqGSIb3
# DQEBDAUAA4IBAQBwoL9DXFXnOF+go3QbPbYW1/e/Vwe9mqyhhyzshV6pGrsi+Ica
# aVQi7aSId229GhT0E0p6Ly23OO/0/4C5+KH38nLeJLxSA8hO0Cre+i1Wz/n096ww
# epqLsl7Uz9FDRJtDIeuWcqFItJnLnU+nBgMTdydE1Od/6Fmo8L8vC6bp8jQ87PcD
# x4eo0kxAGTVGamlUsLihVo7spNU96LHc/RzY9HdaXFSMb++hUD38dglohJ9vytsg
# jTVgHAIDyyCwrFigDkBjxZgiwbJZ9VVrzyerbHbObyMt9H5xaiNrIv8SuFQtJ37Y
# OtnwtoeW/VvRXKwYw02fc7cBqZ9Xql4o4rmUMIIGMzCCBRugAwIBAgIQCJp0nrgt
# w+wn6mXq2/g1MTANBgkqhkiG9w0BAQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UE
# ChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYD
# VQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5nIENBMB4X
# DTIxMDUyNTAwMDAwMFoXDTI0MDUyOTIzNTk1OVowcTELMAkGA1UEBhMCVVMxEzAR
# BgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxpbjEdMBsGA1UEChMUZUcg
# SW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElubm92YXRpb25zLCBJbmMu
# MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAxGUJ0prjbfxcmgZGjd7J
# DxOs7sySHvaQ3wGR2KbD3aZageSE+kG0tKkEsQ4na8bnNViY/zF4Pbo0ZkYtMzJI
# k0AZXDTMvXr/mEvmKxCbiJFTCpKkmZ4sa5BZfO7igIvcNSa0zII2a5jiQJFy85j+
# f9I4EgTo9OcdVeINXhgQ2xZ6TjEK+pbhqmVXvr8DB26JclOaed0L5Vs7+CbGzZuK
# ifgxL2i8d5FDzkhZSZfdCtGtEvE5pLesXSWfpzUddvCNRisIPGB7mg+Rln2XvUZy
# yaRURtlx11pYfJ/KNYAkUCL23rnh38/maxtSvdeioYBj4xLyt7poQBG+b0uzCjgR
# ADe3/k0NtiVwJIo0ZEsUyDANp7JIIjMePzsOMYzfMPyi8clAwfBYc2XhSuUcX3yK
# f4kpRFmClYfK5LstGQRNbONjpsCBTEgZuwEfkdOU0rmaMywZFVLHEpmpYZePz7M3
# VhN+aV56kR/efo8eD81E5VDQqmJiGWKq/s9jhbkYH7g2uhL2MXb/uRshVDSOkFRv
# IID/l+yDJogDBpae3x2ov5YvjY8Zo8RF0tXvyS0rfsDvANZw7mptzHn0Blmw5lug
# 3F2CVJpNbzb1HmAH6k0yFHmWYCoUANbBB0YR/k4JvgY2byttF7cQPJyl7UI9Cu4K
# TAg7ROmGkwdLhmXoPCBco0ECAwEAAaOCAcQwggHAMB8GA1UdIwQYMBaAFFrEuXsq
# CqOl6nEDwGD5LfZldQ5YMB0GA1UdDgQWBBT5yESaz9gTSS8aBNa1r34MMA42SjAO
# BgNVHQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMwdwYDVR0fBHAwbjA1
# oDOgMYYvaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1n
# MS5jcmwwNaAzoDGGL2h0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFzc3Vy
# ZWQtY3MtZzEuY3JsMEsGA1UdIAREMEIwNgYJYIZIAYb9bAMBMCkwJwYIKwYBBQUH
# AgEWG2h0dHA6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAlAjncFPvLKywT/4DECG7bHbtiVl+uumfRj2YrFuC
# hsgkv1PmQpgfypxC3g+ErV9yRV8+XXSCwOaKJ3v6RLnfphLhEwYc2+0Qs/Nlib5N
# AxDGuIczAIeXOc5kRRpvFsQ2XSNtM7XL1tLDm6p/VG7BoUAyqRXsMPdWbTkN/9nd
# CmGSsqcxjG2ud8O6Vhte9J5LaHBVk3lIZAMtH6ACdo5QTrM49nbIU8QGuRYNXZKR
# LAUu6IgD6WJKMVfZXWlyfD8dZ2r3ej6Q1uAO/Nbtd397T+BVQrDWMOG8+GeRiJwo
# evxbIWh0SenZOUrAq9vTJaSvFMSvctkJm/oxLUcUdEGS3zCCBq4wggSWoAMCAQIC
# EAc2N7ckVHzYR6z9KGYqXlswDQYJKoZIhvcNAQELBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgVHJ1c3RlZCBSb290IEc0MB4XDTIyMDMyMzAw
# MDAwMFoXDTM3MDMyMjIzNTk1OVowYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRp
# Z2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQw
# OTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQTCCAiIwDQYJKoZIhvcNAQEBBQADggIP
# ADCCAgoCggIBAMaGNQZJs8E9cklRVcclA8TykTepl1Gh1tKD0Z5Mom2gsMyD+Vr2
# EaFEFUJfpIjzaPp985yJC3+dH54PMx9QEwsmc5Zt+FeoAn39Q7SE2hHxc7Gz7iuA
# hIoiGN/r2j3EF3+rGSs+QtxnjupRPfDWVtTnKC3r07G1decfBmWNlCnT2exp39mQ
# h0YAe9tEQYncfGpXevA3eZ9drMvohGS0UvJ2R/dhgxndX7RUCyFobjchu0CsX7Le
# Sn3O9TkSZ+8OpWNs5KbFHc02DVzV5huowWR0QKfAcsW6Th+xtVhNef7Xj3OTrCw5
# 4qVI1vCwMROpVymWJy71h6aPTnYVVSZwmCZ/oBpHIEPjQ2OAe3VuJyWQmDo4EbP2
# 9p7mO1vsgd4iFNmCKseSv6De4z6ic/rnH1pslPJSlRErWHRAKKtzQ87fSqEcazjF
# KfPKqpZzQmiftkaznTqj1QPgv/CiPMpC3BhIfxQ0z9JMq++bPf4OuGQq+nUoJEHt
# Qr8FnGZJUlD0UfM2SU2LINIsVzV5K6jzRWC8I41Y99xh3pP+OcD5sjClTNfpmEpY
# PtMDiP6zj9NeS3YSUZPJjAw7W4oiqMEmCPkUEBIDfV8ju2TjY+Cm4T72wnSyPx4J
# duyrXUZ14mCjWAkBKAAOhFTuzuldyF4wEr1GnrXTdrnSDmuZDNIztM2xAgMBAAGj
# ggFdMIIBWTASBgNVHRMBAf8ECDAGAQH/AgEAMB0GA1UdDgQWBBS6FtltTYUvcyl2
# mi91jGogj57IbzAfBgNVHSMEGDAWgBTs1+OC0nFdZEzfLmc/57qYrhwPTzAOBgNV
# HQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwgwdwYIKwYBBQUHAQEEazBp
# MCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYBBQUH
# MAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRS
# b290RzQuY3J0MEMGA1UdHwQ8MDowOKA2oDSGMmh0dHA6Ly9jcmwzLmRpZ2ljZXJ0
# LmNvbS9EaWdpQ2VydFRydXN0ZWRSb290RzQuY3JsMCAGA1UdIAQZMBcwCAYGZ4EM
# AQQCMAsGCWCGSAGG/WwHATANBgkqhkiG9w0BAQsFAAOCAgEAfVmOwJO2b5ipRCIB
# fmbW2CFC4bAYLhBNE88wU86/GPvHUF3iSyn7cIoNqilp/GnBzx0H6T5gyNgL5Vxb
# 122H+oQgJTQxZ822EpZvxFBMYh0MCIKoFr2pVs8Vc40BIiXOlWk/R3f7cnQU1/+r
# T4osequFzUNf7WC2qk+RZp4snuCKrOX9jLxkJodskr2dfNBwCnzvqLx1T7pa96kQ
# sl3p/yhUifDVinF2ZdrM8HKjI/rAJ4JErpknG6skHibBt94q6/aesXmZgaNWhqsK
# RcnfxI2g55j7+6adcq/Ex8HBanHZxhOACcS2n82HhyS7T6NJuXdmkfFynOlLAlKn
# N36TU6w7HQhJD5TNOXrd/yVjmScsPT9rp/Fmw0HNT7ZAmyEhQNC3EyTN3B14OuSe
# reU0cZLXJmvkOHOrpgFPvT87eK1MrfvElXvtCl8zOYdBeHo46Zzh3SP9HSjTx/no
# 8Zhf+yvYfvJGnXUsHicsJttvFXseGYs2uJPU5vIXmVnKcPA3v5gA3yAWTyf7YGcW
# oWa63VXAOimGsJigK+2VQbc61RWYMbRiCQ8KvYHZE/6/pNHzV9m8BPqC3jLfBInw
# AM1dwvnQI38AC+R2AibZ8GV2QqYphwlHK+Z/GqSFD/yYlvZVVCsfgPrA8g4r5db7
# qS9EFUrnEw4d2zc4GqEr9u3WfPwwggbGMIIErqADAgECAhAKekqInsmZQpAGYzhN
# hpedMA0GCSqGSIb3DQEBCwUAMGMxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdp
# Q2VydCwgSW5jLjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2
# IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0EwHhcNMjIwMzI5MDAwMDAwWhcNMzMwMzE0
# MjM1OTU5WjBMMQswCQYDVQQGEwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4x
# JDAiBgNVBAMTG0RpZ2lDZXJ0IFRpbWVzdGFtcCAyMDIyIC0gMjCCAiIwDQYJKoZI
# hvcNAQEBBQADggIPADCCAgoCggIBALkqliOmXLxf1knwFYIY9DPuzFxs4+AlLtIx
# 5DxArvurxON4XX5cNur1JY1Do4HrOGP5PIhp3jzSMFENMQe6Rm7po0tI6IlBfw2y
# 1vmE8Zg+C78KhBJxbKFiJgHTzsNs/aw7ftwqHKm9MMYW2Nq867Lxg9GfzQnFuUFq
# RUIjQVr4YNNlLD5+Xr2Wp/D8sfT0KM9CeR87x5MHaGjlRDRSXw9Q3tRZLER0wDJH
# GVvimC6P0Mo//8ZnzzyTlU6E6XYYmJkRFMUrDKAz200kheiClOEvA+5/hQLJhuHV
# GBS3BEXz4Di9or16cZjsFef9LuzSmwCKrB2NO4Bo/tBZmCbO4O2ufyguwp7gC0vI
# CNEyu4P6IzzZ/9KMu/dDI9/nw1oFYn5wLOUrsj1j6siugSBrQ4nIfl+wGt0ZvZ90
# QQqvuY4J03ShL7BUdsGQT5TshmH/2xEvkgMwzjC3iw9dRLNDHSNQzZHXL537/M2x
# wafEDsTvQD4ZOgLUMalpoEn5deGb6GjkagyP6+SxIXuGZ1h+fx/oK+QUshbWgaHK
# 2jCQa+5vdcCwNiayCDv/vb5/bBMY38ZtpHlJrYt/YYcFaPfUcONCleieu5tLsuK2
# QT3nr6caKMmtYbCgQRgZTu1Hm2GV7T4LYVrqPnqYklHNP8lE54CLKUJy93my3YTq
# J+7+fXprAgMBAAGjggGLMIIBhzAOBgNVHQ8BAf8EBAMCB4AwDAYDVR0TAQH/BAIw
# ADAWBgNVHSUBAf8EDDAKBggrBgEFBQcDCDAgBgNVHSAEGTAXMAgGBmeBDAEEAjAL
# BglghkgBhv1sBwEwHwYDVR0jBBgwFoAUuhbZbU2FL3MpdpovdYxqII+eyG8wHQYD
# VR0OBBYEFI1kt4kh/lZYRIRhp+pvHDaP3a8NMFoGA1UdHwRTMFEwT6BNoEuGSWh0
# dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZT
# SEEyNTZUaW1lU3RhbXBpbmdDQS5jcmwwgZAGCCsGAQUFBwEBBIGDMIGAMCQGCCsG
# AQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wWAYIKwYBBQUHMAKGTGh0
# dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQw
# OTZTSEEyNTZUaW1lU3RhbXBpbmdDQS5jcnQwDQYJKoZIhvcNAQELBQADggIBAA0t
# I3Sm0fX46kuZPwHk9gzkrxad2bOMl4IpnENvAS2rOLVwEb+EGYs/XeWGT76TOt4q
# OVo5TtiEWaW8G5iq6Gzv0UhpGThbz4k5HXBw2U7fIyJs1d/2WcuhwupMdsqh3KEr
# lribVakaa33R9QIJT4LWpXOIxJiA3+5JlbezzMWn7g7h7x44ip/vEckxSli23zh8
# y/pc9+RTv24KfH7X3pjVKWWJD6KcwGX0ASJlx+pedKZbNZJQfPQXpodkTz5GiRZj
# IGvL8nvQNeNKcEiptucdYL0EIhUlcAZyqUQ7aUcR0+7px6A+TxC5MDbk86ppCaiL
# fmSiZZQR+24y8fW7OK3NwJMR1TJ4Sks3KkzzXNy2hcC7cDBVeNaY/lRtf3GpSBp4
# 3UZ3Lht6wDOK+EoojBKoc88t+dMj8p4Z4A2UKKDr2xpRoJWCjihrpM6ddt6pc6pI
# allDrl/q+A8GQp3fBmiW/iqgdFtjZt5rLLh4qk1wbfAs8QcVfjW05rUMopml1xVr
# NQ6F1uAszOAMJLh8UgsemXzvyMjFjFhpr6s94c/MfRWuFL+Kcd/Kl7HYR+ocheBF
# ThIcFClYzG/Tf8u+wQ5KbyCcrtlzMlkI5y2SoRoR/jKYpl0rl+CL05zMbbUNrkdj
# OEcXW28T2moQbh9Jt0RbtAgKh1pZBHYRoad3AhMcMYIGRDCCBkACAQEwgYYwcjEL
# MAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3
# LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElE
# IENvZGUgU2lnbmluZyBDQQIQCJp0nrgtw+wn6mXq2/g1MTAJBgUrDgMCGgUAoHAw
# EAYKKwYBBAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYK
# KwYBBAGCNwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFB5zy9fS
# O1m/VQHXehM7CRfQmCmGMA0GCSqGSIb3DQEBAQUABIICAGj/ZsNexSbg/Yre8oBU
# UMZQG/G1DX2lezHk71aZ7YtuYSHinhdA14HM4Zxdq8Jne7dWWDW3VaZMXvPV+HH8
# Wabc3UdfrqJq3njkM2XdhDKiMAOKQOqKWPLuomtYRf/aIqanyLIMdhU7dDkAgkj9
# 2Ek4+c2LZ26cCjejkrhJYpZz4H5vWLlpS5e64Ylr1dws+7bOK0ro01BFrEJ66g1Q
# 7THoiS2tNZr1aKVBBnXa6wYhgjX7kpkafVTBJxiv0GS8QMaXGkblhZeKN77Wp5AJ
# 9wo2jozmvuXOvekSMVjKwnOXaeTONJuCAf4DfZ0ZAXN7QmCQIS1CfnV+Q8/diXQB
# AQcwFnYN7hFE8DO9FO35mIpjgSKHdTMtSmWJ7vpBKAKmJ5ryULxNey2WB/neuYBf
# No06C1AL0+U+4FhbOiLI/h02dykZ/tyKMJmt7g2QadIXOW/lRKGq2g1/tHrRwg3i
# bvO1hTh/MbruxMTueXFsOebmtxV70kL1kX3DX65pu97+bYwJlrpne6bd5hIgN+wS
# +HC2a9U3Ho+vN+2wedjJi5cjLfv4v0pxZ6i9UBOe9qJQ73WcCExsBm1rzLWHobQa
# YtSpQXGi7Pr7vDfMz5JEnn+aOcaLt0UBdEtLBMi2oz5qR6X/liBXRopxOejW7bap
# u7ZleWsPDdTd+IbbemUzZLJToYIDIDCCAxwGCSqGSIb3DQEJBjGCAw0wggMJAgEB
# MHcwYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYD
# VQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRpbWVTdGFt
# cGluZyBDQQIQCnpKiJ7JmUKQBmM4TYaXnTANBglghkgBZQMEAgEFAKBpMBgGCSqG
# SIb3DQEJAzELBgkqhkiG9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTIyMDkxMjA0MDk0
# NlowLwYJKoZIhvcNAQkEMSIEIBr9iFIvqxZKs/nU9OUw+jAKkT2hEJ6nj0gqOS23
# FFeTMA0GCSqGSIb3DQEBAQUABIICAGyIaXbXiG1UNq1zSXc/TTMyBBUxQfxyiIVd
# isMYY2BySmCrF1LsvKrtFxlgbqXFqaR56bEWT6qMSnNVUDjhZfXB+hZgTXeAKtX8
# oarlKmSaOq8fcTytPp7Ru8c1LHwGZLuN+C2q04TWGxiJSuNFyxy2upgCjgwA/6b4
# hy/BGH+eZgmWpAb5zRulaHXZgUuOmzol4WVfTlvOnhwswBlev0IvABP36xicsxkm
# oYMy9y1x5p3HZ4JHol3ICHxFq5smqVKTosiJ/aI8+D1ejrH0K0yhLm5yvDr1IK53
# +tyqXPHS1UksOmvGX07Oumax7Mp25DKEqiV4rZs/PNc59cZl8OlfsmkOGvXK3SvZ
# hL8arLvFB18W+hSTNAMXR0Z5RVq5kvzbfGBHl0aCNiuxlFjuOEbeIIq0fQt2hJJg
# JuPhBUo1OB4WfeIHMKUFUJQDsNlr0ScE2hqxGKrGy2PPSKtz54PHSK2ss3xfsrfi
# tLyEwI/YEHcdPcX4QxviC7lrOJHxzr6u7ZhxRZx9HodpyUS1sMzRrsm9UwtHlpse
# l1ioVIs0IaD4upNE4G5uWQhZIXutb8BUBGhZg81haFmRxxtRWfmLYDL+GeXmptki
# 5t+zZelbiyzj1597wVThzd0+x6PBJ9jhPGqhOrSTXtUW1I3tYXd2f569LAN0+E1s
# ROkaMYpc
# SIG # End signature block
