﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath =split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egDatnKy,$egEncryPath -WarningAction SilentlyContinue

#<#
$TestInputs=$args
$o365User=$TestInputs[0]
$password=Eg-O365Dcr -EncStr $TestInputs[1]
$proxyUsr=$TestInputs[2]
$proxyPass=Eg-O365Dcr -EncStr $TestInputs[3]
$proxyserver=$TestInputs[4]
$oneDrivUrl=$TestInputs[5]
$fileLoc=$TestInputs[6]
$appDtls=$TestInputs[7]
#>


if(!$proxyserver.ToString().ToLower().Contains('none')){
    [system.net.webrequest]::defaultwebproxy = new-object system.net.webproxy($proxyserver)
    if($proxyUsr.ToString().ToLower() -ne 'none' -and $proxyPass.ToString().ToLower() -ne 'none'){
        $proxyCred = New-Object -TypeName System.Management.Automation.PSCredential -argumentlist $proxyUsr, $(convertto-securestring $proxyPass -asplaintext -force)
        [system.net.webrequest]::defaultwebproxy.credentials =$proxyCred
        [system.net.webrequest]::defaultwebproxy.BypassProxyOnLocal = $true
    }
}

if(!(Test-Path -Path $fileLoc )){
    $null=New-Item -ItemType 'directory' -Path $fileLoc
}
$docPath=$egurkhaPath+'\agent\config\eg_tests.ini'
$docStr=Eg-GetINIContent -Path $docPath -Subject 'ODB_File_Fields' -Key 'path' -Type 'UTF8'
if($docStr -eq $null -or $docStr -eq ''){
    $docStr='Documents'
}

$dirStr=Eg-GetINIContent -Path $docPath -Subject 'ODB_File_Fields' -Key 'dir' -Type 'UTF8'
if($dirStr -eq $null -or $dirStr -eq ''){
    $dirStr='personal'
}

if($appDtls -and $appDtls -ne 'none'){
    $appDetailsArr=($appDtls).ToString() -Split ("~!~")
    $clientId=$appDetailsArr[0]
    $tenantName=$appDetailsArr[1]
    $thumbPrint=$appDetailsArr[2]

    $uploadTime=-5;$dwnloadTime=-5;$delTime=-5
    if($oneDrivUrl.Contains($dirStr)){
        
        Connect-PnPOnline -Thumbprint $thumbPrint -url $oneDrivUrl -clientId $clientId -Tenant $tenantName
        $getURL=Get-PnPSite -Includes ServerRelativeUrl |select *
        $getConnURL=$getURL.Url
        Disconnect-PnPOnline

        Connect-PnPOnline -Thumbprint $thumbPrint -url $getConnURL -clientId $clientId -Tenant $tenantName
        ##File Creation
        $dat=Get-Date -Format "dd-MM-yyyy-HH-mm-ss-fff"
        $fileNam='eGTestFile'+$dat+'.csv'

        $odbFile=$fileLoc+'\'+$fileNam
        Add-Content -Path $odbFile -Value 'eG Uploading the document for testing the time taken to upload'

        $pnpSiturl=Get-PnPSite -Includes RootWeb,ServerRelativeUrl |select *
        $serverRelativeUrl=$pnpSiturl.ServerRelativeUrl
        $serverRelativeUrl=$serverRelativeUrl+'/'+$docStr+'/'+$fileNam
        Try{
            ## Upload the file
            $uploadStart=[datetime](Get-Date)
            $null=Add-PnPFile -Path $odbFile -Folder $docStr
            $uploadEnd=[datetime](Get-Date)
            $uploaddiff=New-TimeSpan -Start $uploadStart -End $uploadEnd
            $uploadTime=[Math]::Round(((($uploaddiff.Minutes*60000)+($uploaddiff.Seconds*1000)+$uploaddiff.Milliseconds)/1000),2)
        
            if([System.IO.File]::Exists($odbFile) -eq 'True'){
                Remove-Item -Path $odbFile -Force
            }
            $odbReltivUrl='/'+$docStr+"/"+$fileNam

            ##Download the file
            $dwnloadStart=[datetime](Get-Date)
            Get-PnPFile -Url $odbReltivUrl -Path $fileLoc -FileName $fileNam -AsFile -Force
            $dwnloadEnd=[datetime](Get-Date)
            $dwnloaddiff=New-TimeSpan -Start $dwnloadStart -End $dwnloadEnd
            $dwnloadTime=[Math]::Round(((($dwnloaddiff.Minutes*60000)+($dwnloaddiff.Seconds*1000)+$dwnloaddiff.Milliseconds)/1000),2)

            ##Delete the file
            $delStart=[datetime](Get-Date)
            Remove-PnPFile -ServerRelativeUrl $serverRelativeUrl -Force
            $delEnd=[datetime](Get-Date)
            $deldiff=New-TimeSpan -Start $delStart -End $delEnd
            $delTime=[Math]::Round(((($deldiff.Minutes*60000)+($deldiff.Seconds*1000)+$deldiff.Milliseconds)/1000),2)

            Disconnect-PnPOnline

            if([System.IO.File]::Exists($odbFile) -eq 'True'){
                Remove-Item -Path $odbFile -Force
            }  
        }
        Catch{
            $odbExcepMsg='[ODBFileOperations] Exception Occured -- [Line Number] '+$_.InvocationInfo.ScriptLineNumber+' -- '+$_.Exception+'!>'
            Write-Host $odbExcepMsg
        }
    }else{
        Write-Error '[ODBFileOperations] Provide valid url for upload/download operations'
    }

    $measures='measures~'+$uploadTime+'~'+$dwnloadTime+'~'+$delTime
    Write-Host $measures

}
else{
    $location=([xml]((Get-Package -Name Microsoft.Online.SharePoint.PowerShell -ErrorAction SilentlyContinue | select SwidTagText).SwidTagText)).SoftwareIdentity.Meta.InstalledLocation
    if($location -eq $null -or $location -eq ''){
        $baseDrive=''
        $varArr=@('PATH','PSModulePath')
        foreach($nam in $varArr){
            $pathVar=[Environment]::GetEnvironmentVariable($nam).split(';')
            foreach($var in $pathVar){
                if($var -match 'Program Files'){
                    $baseDrive=$var.Substring(0,$var.IndexOf('Program Files'))
                    break
                }
            }
            if($baseDrive -ne $null -and $baseDrive -ne ''){
                break
            }
        }
        $path1=[String]$baseDrive+'Program Files\SharePoint Online Management Shell\'
        $path2=[String]$baseDrive+'Program Files\WindowsPowerShell\'
        $paths=@($path1,$path2)
        foreach($path in $paths){
            $dirs=Get-Childitem $path -Recurse |select Directory 
            foreach($dir in $dirs){
                if($dir.Directory -ne $null -and $dir.Directory -ne '' -and [String]$dir.Directory -match 'Microsoft.Online.SharePoint.PowerShell' ){
                    $location=$dir.Directory
                    break
                }
            }
            if($location -ne $null -and $location -ne ''){
                break
            }
        }
    }

    $dllOne=[String]$location+'\Microsoft.SharePoint.Client.dll'
    $dllTwo=[String]$location+'\Microsoft.SharePoint.Client.Runtime.dll'
    $dllThree=[String]$location+'\Microsoft.Online.SharePoint.Client.Tenant.dll'

    [System.Reflection.Assembly]::LoadFile($dllOne) | Out-Null
    [System.Reflection.Assembly]::LoadFile($dllTwo) | Out-Null
    [System.Reflection.Assembly]::LoadFile($dllThree) | Out-Null


    function FileOpertn-OneDrive {
        param (
		    [Parameter(Mandatory=$true)]
		    [String]$Url,
            [Parameter(Mandatory=$true)]
		    [String]$LocalFile,
            [Parameter(Mandatory=$true)]
		    [String]$TargetFile,
            [Parameter(Mandatory=$true)]
		    [String]$DocStr
	    )
    
             process{  
             try{ 
            
                $srcFileName = Split-path $LocalFile -leaf

                $Ctx = New-Object Microsoft.SharePoint.Client.ClientContext($Url)
                $Ctx.RequestTimeout=16384000
                $Ctx.Credentials = $spolCred

                $web = $Ctx.Web
                $Ctx.Load($web)
                $Ctx.ExecuteQuery()

                $datStr1=[datetime](Get-Date)
                $oneDriveList = $web.Lists.GetByTitle($DocStr)
                $Ctx.Load($oneDriveList.RootFolder)
                $Ctx.ExecuteQuery()
                $folderRelativeUrl = $oneDriveList.RootFolder.ServerRelativeUrl
                $fileURL = $folderRelativeUrl + "/" +$srcFileName
            
                $FileStream = ([System.IO.FileInfo] (Get-Item $LocalFile)).OpenRead()
                $SourceFileName = Split-path $LocalFile -leaf
                $FileCreationInfo = New-Object Microsoft.SharePoint.Client.FileCreationInformation
                $FileCreationInfo.Overwrite = $true
                $FileCreationInfo.ContentStream = $FileStream
                $FileCreationInfo.URL = $SourceFileName
                $FileUploaded = $oneDriveList.RootFolder.Files.Add($FileCreationInfo)
                $Ctx.Load($FileUploaded)
                $Ctx.ExecuteQuery()
                $FileStream.Close()
                $datStr2=[datetime](Get-Date)
                $diff1=New-TimeSpan -Start $datStr1 -End $datStr2
                $uploadTime=[Math]::Round(((($diff1.Minutes*60000)+($diff1.Seconds*1000)+$diff1.Milliseconds)/1000),2)

                $datStr3=[datetime](Get-Date)
                $FileInfo = [Microsoft.SharePoint.Client.File]::OpenBinaryDirect($Ctx,$fileURL)
                $WriteStream = [System.IO.File]::Open($TargetFile,[System.IO.FileMode]::Create)
                $FileInfo.Stream.CopyTo($WriteStream)
                $WriteStream.Close()
                $datStr4=[datetime](Get-Date)
                $diff2=New-TimeSpan -Start $datStr3 -End $datStr4
                $downloadTime=[Math]::Round(((($diff2.Minutes*60000)+($diff2.Seconds*1000)+$diff2.Milliseconds)/1000),2)
               
                $datStr5=[datetime](Get-Date)
                $File = $Ctx.Web.GetFileByServerRelativeUrl($fileURL)
                $Ctx.Load($File)
                $Ctx.ExecuteQuery()
                $File.DeleteObject()
                $Ctx.ExecuteQuery()
                $datStr6=[datetime](Get-Date)
                $diff3=New-TimeSpan -Start $datStr5 -End $datStr6
                $deletionTime=[Math]::Round(((($diff3.Minutes*60000)+($diff3.Seconds*1000)+$diff3.Milliseconds)/1000),2)

                $ctx.Dispose()

                $measure='measures~'+$uploadTime+'~'+$downloadTime+'~'+$deletionTime
                return $measure
            }
            catch{  
                $ExcepMsg='['+(Split-Path ($_.InvocationInfo.ScriptName) -leaf)+'] Exception Occured in "ODBFileOperations" -- [Line Number] '+$_.InvocationInfo.ScriptLineNumber+' -- '+$_.Exception
                Write-Host $ExcepMsg
                $measure='-5~-5~-5'
                return
            }     
        }
    }

    [System.Security.SecureString] $o365Pass = ConvertTo-SecureString -String $password -AsPlainText -Force
    $spolCred = New-Object Microsoft.SharePoint.Client.SharePointOnlineCredentials($o365User, $o365Pass)
    $fileNam='eGtest'+$(get-date -f yyyyMMddHHmmss)+'.txt'
    $null=New-Item -Name $fileNam -Path $fileLoc -ItemType "file"
    $cntFile=$fileLoc+'\'+$fileNam
    Add-Content $cntFile "eGTest"
    $localFile=$fileLoc+'\'+$fileNam
    $targetFile=$fileLoc+'\S'+$fileNam
    Try{
        $measure=FileOpertn-OneDrive -Url $oneDrivUrl -LocalFile $localFile -TargetFile $targetFile -DocStr $docStr
        Write-Host $measure

        if(Test-Path -Path $localFile -PathType Leaf){
            Remove-Item $localFile -Force
        }
        if(Test-Path -Path $targetFile -PathType Leaf){
            Remove-Item $targetFile -Force
        }   
    }Catch{
        $ExcepMsg1='['+(Split-Path ($_.InvocationInfo.ScriptName) -leaf)+'] Exception Occured in "FileOpertn-OneDrive" -- [Line Number] '+$_.InvocationInfo.ScriptLineNumber+' -- '+$_.Exception
        Write-Host $ExcepMsg1
    }
}

[System.GC]::GetTotalMemory($true) | out-null


# SIG # Begin signature block
# MIIlTAYJKoZIhvcNAQcCoIIlPTCCJTkCAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUJu91Y/ue6LlIy+y5iqIqdEwJ
# 6EGggh5yMIIFMDCCBBigAwIBAgIQBAkYG1/Vu2Z1U0O1b5VQCDANBgkqhkiG9w0B
# AQsFADBlMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVk
# IElEIFJvb3QgQ0EwHhcNMTMxMDIyMTIwMDAwWhcNMjgxMDIyMTIwMDAwWjByMQsw
# CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cu
# ZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQg
# Q29kZSBTaWduaW5nIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
# +NOzHH8OEa9ndwfTCzFJGc/Q+0WZsTrbRPV/5aid2zLXcep2nQUut4/6kkPApfmJ
# 1DcZ17aq8JyGpdglrA55KDp+6dFn08b7KSfH03sjlOSRI5aQd4L5oYQjZhJUM1B0
# sSgmuyRpwsJS8hRniolF1C2ho+mILCCVrhxKhwjfDPXiTWAYvqrEsq5wMWYzcT6s
# cKKrzn/pfMuSoeU7MRzP6vIK5Fe7SrXpdOYr/mzLfnQ5Ng2Q7+S1TqSp6moKq4Tz
# rGdOtcT3jNEgJSPrCGQ+UpbB8g8S9MWOD8Gi6CxR93O8vYWxYoNzQYIH5DiLanMg
# 0A9kczyen6Yzqf0Z3yWT0QIDAQABo4IBzTCCAckwEgYDVR0TAQH/BAgwBgEB/wIB
# ADAOBgNVHQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwMweQYIKwYBBQUH
# AQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYI
# KwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFz
# c3VyZWRJRFJvb3RDQS5jcnQwgYEGA1UdHwR6MHgwOqA4oDaGNGh0dHA6Ly9jcmw0
# LmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcmwwOqA4oDaG
# NGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RD
# QS5jcmwwTwYDVR0gBEgwRjA4BgpghkgBhv1sAAIEMCowKAYIKwYBBQUHAgEWHGh0
# dHBzOi8vd3d3LmRpZ2ljZXJ0LmNvbS9DUFMwCgYIYIZIAYb9bAMwHQYDVR0OBBYE
# FFrEuXsqCqOl6nEDwGD5LfZldQ5YMB8GA1UdIwQYMBaAFEXroq/0ksuCMS1Ri6en
# IZ3zbcgPMA0GCSqGSIb3DQEBCwUAA4IBAQA+7A1aJLPzItEVyCx8JSl2qB1dHC06
# GsTvMGHXfgtg/cM9D8Svi/3vKt8gVTew4fbRknUPUbRupY5a4l4kgU4QpO4/cY5j
# DhNLrddfRHnzNhQGivecRk5c/5CxGwcOkRX7uq+1UcKNJK4kxscnKqEpKBo6cSgC
# PC6Ro8AlEeKcFEehemhor5unXCBc2XGxDI+7qPjFEmifz0DLQESlE/DmZAwlCEIy
# sjaKJAL+L3J+HNdJRZboWR3p+nRka7LrZkPas7CM1ekN3fYBIM6ZMWM9CBoYs4Gb
# T8aTEAb8B4H6i9r5gkn3Ym6hU/oSlBiFLpKR6mhsRDKyZqHnGKSaZFHvMIIFjTCC
# BHWgAwIBAgIQDpsYjvnQLefv21DiCEAYWjANBgkqhkiG9w0BAQwFADBlMQswCQYD
# VQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGln
# aWNlcnQuY29tMSQwIgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJvb3QgQ0Ew
# HhcNMjIwODAxMDAwMDAwWhcNMzExMTA5MjM1OTU5WjBiMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MSEwHwYDVQQDExhEaWdpQ2VydCBUcnVzdGVkIFJvb3QgRzQwggIiMA0GCSqGSIb3
# DQEBAQUAA4ICDwAwggIKAoICAQC/5pBzaN675F1KPDAiMGkz7MKnJS7JIT3yithZ
# wuEppz1Yq3aaza57G4QNxDAf8xukOBbrVsaXbR2rsnnyyhHS5F/WBTxSD1Ifxp4V
# pX6+n6lXFllVcq9ok3DCsrp1mWpzMpTREEQQLt+C8weE5nQ7bXHiLQwb7iDVySAd
# YyktzuxeTsiT+CFhmzTrBcZe7FsavOvJz82sNEBfsXpm7nfISKhmV1efVFiODCu3
# T6cw2Vbuyntd463JT17lNecxy9qTXtyOj4DatpGYQJB5w3jHtrHEtWoYOAMQjdjU
# N6QuBX2I9YI+EJFwq1WCQTLX2wRzKm6RAXwhTNS8rhsDdV14Ztk6MUSaM0C/CNda
# SaTC5qmgZ92kJ7yhTzm1EVgX9yRcRo9k98FpiHaYdj1ZXUJ2h4mXaXpI8OCiEhtm
# mnTK3kse5w5jrubU75KSOp493ADkRSWJtppEGSt+wJS00mFt6zPZxd9LBADMfRyV
# w4/3IbKyEbe7f/LVjHAsQWCqsWMYRJUadmJ+9oCw++hkpjPRiQfhvbfmQ6QYuKZ3
# AeEPlAwhHbJUKSWJbOUOUlFHdL4mrLZBdd56rF+NP8m800ERElvlEFDrMcXKchYi
# Cd98THU/Y+whX8QgUWtvsauGi0/C1kVfnSD8oR7FwI+isX4KJpn15GkvmB0t9dmp
# sh3lGwIDAQABo4IBOjCCATYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQU7Nfj
# gtJxXWRM3y5nP+e6mK4cD08wHwYDVR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNt
# yA8wDgYDVR0PAQH/BAQDAgGGMHkGCCsGAQUFBwEBBG0wazAkBggrBgEFBQcwAYYY
# aHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRwOi8vY2Fj
# ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3J0MEUG
# A1UdHwQ+MDwwOqA4oDaGNGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2Vy
# dEFzc3VyZWRJRFJvb3RDQS5jcmwwEQYDVR0gBAowCDAGBgRVHSAAMA0GCSqGSIb3
# DQEBDAUAA4IBAQBwoL9DXFXnOF+go3QbPbYW1/e/Vwe9mqyhhyzshV6pGrsi+Ica
# aVQi7aSId229GhT0E0p6Ly23OO/0/4C5+KH38nLeJLxSA8hO0Cre+i1Wz/n096ww
# epqLsl7Uz9FDRJtDIeuWcqFItJnLnU+nBgMTdydE1Od/6Fmo8L8vC6bp8jQ87PcD
# x4eo0kxAGTVGamlUsLihVo7spNU96LHc/RzY9HdaXFSMb++hUD38dglohJ9vytsg
# jTVgHAIDyyCwrFigDkBjxZgiwbJZ9VVrzyerbHbObyMt9H5xaiNrIv8SuFQtJ37Y
# OtnwtoeW/VvRXKwYw02fc7cBqZ9Xql4o4rmUMIIGMzCCBRugAwIBAgIQCJp0nrgt
# w+wn6mXq2/g1MTANBgkqhkiG9w0BAQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UE
# ChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYD
# VQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgQ29kZSBTaWduaW5nIENBMB4X
# DTIxMDUyNTAwMDAwMFoXDTI0MDUyOTIzNTk1OVowcTELMAkGA1UEBhMCVVMxEzAR
# BgNVBAgTCk5ldyBKZXJzZXkxDzANBgNVBAcTBklzZWxpbjEdMBsGA1UEChMUZUcg
# SW5ub3ZhdGlvbnMsIEluYy4xHTAbBgNVBAMTFGVHIElubm92YXRpb25zLCBJbmMu
# MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAxGUJ0prjbfxcmgZGjd7J
# DxOs7sySHvaQ3wGR2KbD3aZageSE+kG0tKkEsQ4na8bnNViY/zF4Pbo0ZkYtMzJI
# k0AZXDTMvXr/mEvmKxCbiJFTCpKkmZ4sa5BZfO7igIvcNSa0zII2a5jiQJFy85j+
# f9I4EgTo9OcdVeINXhgQ2xZ6TjEK+pbhqmVXvr8DB26JclOaed0L5Vs7+CbGzZuK
# ifgxL2i8d5FDzkhZSZfdCtGtEvE5pLesXSWfpzUddvCNRisIPGB7mg+Rln2XvUZy
# yaRURtlx11pYfJ/KNYAkUCL23rnh38/maxtSvdeioYBj4xLyt7poQBG+b0uzCjgR
# ADe3/k0NtiVwJIo0ZEsUyDANp7JIIjMePzsOMYzfMPyi8clAwfBYc2XhSuUcX3yK
# f4kpRFmClYfK5LstGQRNbONjpsCBTEgZuwEfkdOU0rmaMywZFVLHEpmpYZePz7M3
# VhN+aV56kR/efo8eD81E5VDQqmJiGWKq/s9jhbkYH7g2uhL2MXb/uRshVDSOkFRv
# IID/l+yDJogDBpae3x2ov5YvjY8Zo8RF0tXvyS0rfsDvANZw7mptzHn0Blmw5lug
# 3F2CVJpNbzb1HmAH6k0yFHmWYCoUANbBB0YR/k4JvgY2byttF7cQPJyl7UI9Cu4K
# TAg7ROmGkwdLhmXoPCBco0ECAwEAAaOCAcQwggHAMB8GA1UdIwQYMBaAFFrEuXsq
# CqOl6nEDwGD5LfZldQ5YMB0GA1UdDgQWBBT5yESaz9gTSS8aBNa1r34MMA42SjAO
# BgNVHQ8BAf8EBAMCB4AwEwYDVR0lBAwwCgYIKwYBBQUHAwMwdwYDVR0fBHAwbjA1
# oDOgMYYvaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1n
# MS5jcmwwNaAzoDGGL2h0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFzc3Vy
# ZWQtY3MtZzEuY3JsMEsGA1UdIAREMEIwNgYJYIZIAYb9bAMBMCkwJwYIKwYBBQUH
# AgEWG2h0dHA6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAIBgZngQwBBAEwgYQGCCsG
# AQUFBwEBBHgwdjAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# ME4GCCsGAQUFBzAChkJodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRTSEEyQXNzdXJlZElEQ29kZVNpZ25pbmdDQS5jcnQwDAYDVR0TAQH/BAIwADAN
# BgkqhkiG9w0BAQsFAAOCAQEAlAjncFPvLKywT/4DECG7bHbtiVl+uumfRj2YrFuC
# hsgkv1PmQpgfypxC3g+ErV9yRV8+XXSCwOaKJ3v6RLnfphLhEwYc2+0Qs/Nlib5N
# AxDGuIczAIeXOc5kRRpvFsQ2XSNtM7XL1tLDm6p/VG7BoUAyqRXsMPdWbTkN/9nd
# CmGSsqcxjG2ud8O6Vhte9J5LaHBVk3lIZAMtH6ACdo5QTrM49nbIU8QGuRYNXZKR
# LAUu6IgD6WJKMVfZXWlyfD8dZ2r3ej6Q1uAO/Nbtd397T+BVQrDWMOG8+GeRiJwo
# evxbIWh0SenZOUrAq9vTJaSvFMSvctkJm/oxLUcUdEGS3zCCBq4wggSWoAMCAQIC
# EAc2N7ckVHzYR6z9KGYqXlswDQYJKoZIhvcNAQELBQAwYjELMAkGA1UEBhMCVVMx
# FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNv
# bTEhMB8GA1UEAxMYRGlnaUNlcnQgVHJ1c3RlZCBSb290IEc0MB4XDTIyMDMyMzAw
# MDAwMFoXDTM3MDMyMjIzNTk1OVowYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRp
# Z2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQw
# OTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQTCCAiIwDQYJKoZIhvcNAQEBBQADggIP
# ADCCAgoCggIBAMaGNQZJs8E9cklRVcclA8TykTepl1Gh1tKD0Z5Mom2gsMyD+Vr2
# EaFEFUJfpIjzaPp985yJC3+dH54PMx9QEwsmc5Zt+FeoAn39Q7SE2hHxc7Gz7iuA
# hIoiGN/r2j3EF3+rGSs+QtxnjupRPfDWVtTnKC3r07G1decfBmWNlCnT2exp39mQ
# h0YAe9tEQYncfGpXevA3eZ9drMvohGS0UvJ2R/dhgxndX7RUCyFobjchu0CsX7Le
# Sn3O9TkSZ+8OpWNs5KbFHc02DVzV5huowWR0QKfAcsW6Th+xtVhNef7Xj3OTrCw5
# 4qVI1vCwMROpVymWJy71h6aPTnYVVSZwmCZ/oBpHIEPjQ2OAe3VuJyWQmDo4EbP2
# 9p7mO1vsgd4iFNmCKseSv6De4z6ic/rnH1pslPJSlRErWHRAKKtzQ87fSqEcazjF
# KfPKqpZzQmiftkaznTqj1QPgv/CiPMpC3BhIfxQ0z9JMq++bPf4OuGQq+nUoJEHt
# Qr8FnGZJUlD0UfM2SU2LINIsVzV5K6jzRWC8I41Y99xh3pP+OcD5sjClTNfpmEpY
# PtMDiP6zj9NeS3YSUZPJjAw7W4oiqMEmCPkUEBIDfV8ju2TjY+Cm4T72wnSyPx4J
# duyrXUZ14mCjWAkBKAAOhFTuzuldyF4wEr1GnrXTdrnSDmuZDNIztM2xAgMBAAGj
# ggFdMIIBWTASBgNVHRMBAf8ECDAGAQH/AgEAMB0GA1UdDgQWBBS6FtltTYUvcyl2
# mi91jGogj57IbzAfBgNVHSMEGDAWgBTs1+OC0nFdZEzfLmc/57qYrhwPTzAOBgNV
# HQ8BAf8EBAMCAYYwEwYDVR0lBAwwCgYIKwYBBQUHAwgwdwYIKwYBBQUHAQEEazBp
# MCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYBBQUH
# MAKGNWh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRS
# b290RzQuY3J0MEMGA1UdHwQ8MDowOKA2oDSGMmh0dHA6Ly9jcmwzLmRpZ2ljZXJ0
# LmNvbS9EaWdpQ2VydFRydXN0ZWRSb290RzQuY3JsMCAGA1UdIAQZMBcwCAYGZ4EM
# AQQCMAsGCWCGSAGG/WwHATANBgkqhkiG9w0BAQsFAAOCAgEAfVmOwJO2b5ipRCIB
# fmbW2CFC4bAYLhBNE88wU86/GPvHUF3iSyn7cIoNqilp/GnBzx0H6T5gyNgL5Vxb
# 122H+oQgJTQxZ822EpZvxFBMYh0MCIKoFr2pVs8Vc40BIiXOlWk/R3f7cnQU1/+r
# T4osequFzUNf7WC2qk+RZp4snuCKrOX9jLxkJodskr2dfNBwCnzvqLx1T7pa96kQ
# sl3p/yhUifDVinF2ZdrM8HKjI/rAJ4JErpknG6skHibBt94q6/aesXmZgaNWhqsK
# RcnfxI2g55j7+6adcq/Ex8HBanHZxhOACcS2n82HhyS7T6NJuXdmkfFynOlLAlKn
# N36TU6w7HQhJD5TNOXrd/yVjmScsPT9rp/Fmw0HNT7ZAmyEhQNC3EyTN3B14OuSe
# reU0cZLXJmvkOHOrpgFPvT87eK1MrfvElXvtCl8zOYdBeHo46Zzh3SP9HSjTx/no
# 8Zhf+yvYfvJGnXUsHicsJttvFXseGYs2uJPU5vIXmVnKcPA3v5gA3yAWTyf7YGcW
# oWa63VXAOimGsJigK+2VQbc61RWYMbRiCQ8KvYHZE/6/pNHzV9m8BPqC3jLfBInw
# AM1dwvnQI38AC+R2AibZ8GV2QqYphwlHK+Z/GqSFD/yYlvZVVCsfgPrA8g4r5db7
# qS9EFUrnEw4d2zc4GqEr9u3WfPwwggbAMIIEqKADAgECAhAMTWlyS5T6PCpKPSkH
# gD1aMA0GCSqGSIb3DQEBCwUAMGMxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdp
# Q2VydCwgSW5jLjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2
# IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0EwHhcNMjIwOTIxMDAwMDAwWhcNMzMxMTIx
# MjM1OTU5WjBGMQswCQYDVQQGEwJVUzERMA8GA1UEChMIRGlnaUNlcnQxJDAiBgNV
# BAMTG0RpZ2lDZXJ0IFRpbWVzdGFtcCAyMDIyIC0gMjCCAiIwDQYJKoZIhvcNAQEB
# BQADggIPADCCAgoCggIBAM/spSY6xqnya7uNwQ2a26HoFIV0MxomrNAcVR4eNm28
# klUMYfSdCXc9FZYIL2tkpP0GgxbXkZI4HDEClvtysZc6Va8z7GGK6aYo25BjXL2J
# U+A6LYyHQq4mpOS7eHi5ehbhVsbAumRTuyoW51BIu4hpDIjG8b7gL307scpTjUCD
# HufLckkoHkyAHoVW54Xt8mG8qjoHffarbuVm3eJc9S/tjdRNlYRo44DLannR0hCR
# RinrPibytIzNTLlmyLuqUDgN5YyUXRlav/V7QG5vFqianJVHhoV5PgxeZowaCiS+
# nKrSnLb3T254xCg/oxwPUAY3ugjZNaa1Htp4WB056PhMkRCWfk3h3cKtpX74LRsf
# 7CtGGKMZ9jn39cFPcS6JAxGiS7uYv/pP5Hs27wZE5FX/NurlfDHn88JSxOYWe1p+
# pSVz28BqmSEtY+VZ9U0vkB8nt9KrFOU4ZodRCGv7U0M50GT6Vs/g9ArmFG1keLuY
# /ZTDcyHzL8IuINeBrNPxB9ThvdldS24xlCmL5kGkZZTAWOXlLimQprdhZPrZIGwY
# UWC6poEPCSVT8b876asHDmoHOWIZydaFfxPZjXnPYsXs4Xu5zGcTB5rBeO3GiMiw
# bjJ5xwtZg43G7vUsfHuOy2SJ8bHEuOdTXl9V0n0ZKVkDTvpd6kVzHIR+187i1Dp3
# AgMBAAGjggGLMIIBhzAOBgNVHQ8BAf8EBAMCB4AwDAYDVR0TAQH/BAIwADAWBgNV
# HSUBAf8EDDAKBggrBgEFBQcDCDAgBgNVHSAEGTAXMAgGBmeBDAEEAjALBglghkgB
# hv1sBwEwHwYDVR0jBBgwFoAUuhbZbU2FL3MpdpovdYxqII+eyG8wHQYDVR0OBBYE
# FGKK3tBh/I8xFO2XC809KpQU31KcMFoGA1UdHwRTMFEwT6BNoEuGSWh0dHA6Ly9j
# cmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEyNTZU
# aW1lU3RhbXBpbmdDQS5jcmwwgZAGCCsGAQUFBwEBBIGDMIGAMCQGCCsGAQUFBzAB
# hhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wWAYIKwYBBQUHMAKGTGh0dHA6Ly9j
# YWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEy
# NTZUaW1lU3RhbXBpbmdDQS5jcnQwDQYJKoZIhvcNAQELBQADggIBAFWqKhrzRvN4
# Vzcw/HXjT9aFI/H8+ZU5myXm93KKmMN31GT8Ffs2wklRLHiIY1UJRjkA/GnUypsp
# +6M/wMkAmxMdsJiJ3HjyzXyFzVOdr2LiYWajFCpFh0qYQitQ/Bu1nggwCfrkLdcJ
# iXn5CeaIzn0buGqim8FTYAnoo7id160fHLjsmEHw9g6A++T/350Qp+sAul9Kjxo6
# UrTqvwlJFTU2WZoPVNKyG39+XgmtdlSKdG3K0gVnK3br/5iyJpU4GYhEFOUKWaJr
# 5yI+RCHSPxzAm+18SLLYkgyRTzxmlK9dAlPrnuKe5NMfhgFknADC6Vp0dQ094XmI
# vxwBl8kZI4DXNlpflhaxYwzGRkA7zl011Fk+Q5oYrsPJy8P7mxNfarXH4PMFw1nf
# J2Ir3kHJU7n/NBBn9iYymHv+XEKUgZSCnawKi8ZLFUrTmJBFYDOA4CPe+AOk9kVH
# 5c64A0JH6EE2cXet/aLol3ROLtoeHYxayB6a1cLwxiKoT5u92ByaUcQvmvZfpyeX
# upYuhVfAYOd4Vn9q78KVmksRAsiCnMkaBXy6cbVOepls9Oie1FqYyJ+/jbsYXEP1
# 0Cro4mLueATbvdH7WwqocH7wl4R44wgDXUcsY6glOJcB0j862uXl9uab3H4szP8X
# TE0AotjWAQ64i+7m4HJViSwnGWH2dwGMMYIGRDCCBkACAQEwgYYwcjELMAkGA1UE
# BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
# ZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUg
# U2lnbmluZyBDQQIQCJp0nrgtw+wn6mXq2/g1MTAJBgUrDgMCGgUAoHAwEAYKKwYB
# BAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
# NwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFIZ6H5+/93sqq1Wk
# L7V0R4lUDZPeMA0GCSqGSIb3DQEBAQUABIICAMFOO82FVBXysoR6lH0ouCWjJPBa
# 0KITxOk8HNnyaLrkQcphKo9RonJnG9dZ2M+yf15JO35z48/RahjxWoUWV2Zp7/tZ
# ab+WvMYlqBbt2WcNoibH83rdjgh1k3ph5kjpndFEn7ICtit5nsyzm+Hh6c6x7raY
# Qr7TXMY8E690N60hA+FDQyfGgY3V2ywTPr0HIxuXSnKmCF19S8M3sd8eMYbSrc3F
# 3A4muJ8Vmb+rT+1bDwlHC+I333C82v1gxxItMR61gGqXLLgkZRku8FueGqrubIi8
# iPPqAQSBUoIs5NqLyiHJnbPv++0DEalVP6pN6+rcvvd3aPlaX6Q/jD3ZTpi9KHP6
# VTsuIxLIaCvpy50eZQ/p4dNjaypHHXA4jWLjT23mBs/CoREzdw9/8O+eYQUOv4tP
# CAefh64ojg8AE1ZJvl9I3++Tnjf22r0q/R4EPrrleH7XlflQswiDbD/u/P/OEa++
# WlrE5sixWJYxAl+CwbmVTdPKRehWab7JMJ7YOgFPZVf2vdjFyxUod6XAm7VSdCxl
# uWhNNoIrkVZbtB48voz3Gwb/dWWr5UiwiFq8Zv2gzJ3orW/k3bqcfOkybdx7ihqk
# w+5HaFqovbLFYI1HcMmDTz85IsMIDCSF4Fswz9W4N1uW39guxkiSBN9hx3msrWn8
# 2S7dGRWe28IFypwJoYIDIDCCAxwGCSqGSIb3DQEJBjGCAw0wggMJAgEBMHcwYzEL
# MAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJE
# aWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRpbWVTdGFtcGluZyBD
# QQIQDE1pckuU+jwqSj0pB4A9WjANBglghkgBZQMEAgEFAKBpMBgGCSqGSIb3DQEJ
# AzELBgkqhkiG9w0BBwEwHAYJKoZIhvcNAQkFMQ8XDTIyMTAyMTE0MDI1MFowLwYJ
# KoZIhvcNAQkEMSIEIBYgY9aDQrjQV1ulX6DV1E9mK9jo6Np6Go6HfLT2Q6CAMA0G
# CSqGSIb3DQEBAQUABIICAJ3Et5z+inMTI4XZUcyVTtdd5VWBWiVw1aKq7B2aMXVD
# /6jI+VWjoLmkJ7C0mCgJE5lLq4l04YZOiGhpbVqrAgD3O268G5+c4Iqj9dzfaNM/
# D+RJqcsaeAfdH8SxsyM6fdI6fsFu5hRZHHHvaiX6CyUFJfJxCU4IHq4daBeGqCFm
# B1AKu9LWXfptCBxFkwqinRrB/0L6ia0tdjh21scvVJukWrl9GzoY0awTfw6XU7hY
# D0WhktYu0u+GyX65MDPkUvX7pbceQboVlECT4CFluwTLDN9hpaseOduCCYzlnD5z
# 2zsfh6yQ8rtgew1TU0JVQUjIU3Hve7/0Kkx+hvajOKvqU9vBpEMwMs9eYqmAiHu5
# s0XCw8GKabtySh4E7DCmlNDm4EXdWNBX3xFuSyXD5DhTLc1Rd488pTPmZG9fgaDC
# fWgO1uaEHjYcCGO6z+iQL+4oqP9G3zqwep0ONe6cAvhRY6jJ11JYz9FYB3nARxtX
# RvTQRW7AC8/PPhHewLPRgvdAPtNE8d7JKXbESuWg5/9w3CMIp+hkV2Tn4G4Xtp0M
# 6/cH0W1oDq0SRNry6ugngpKSULp2AcT7mMjqqN7E6X2ry0ixHn+eyhz1psOssj+1
# 7wN15wH9NHpvvnWxWqlf884SSl9inExv5PKn2iNrqqAAz8PSpfG9dOzxq4gVhlyO
# SIG # End signature block
