﻿##/*********************************************************************************************
##Author                :  Guravareddy.T
##Purpose               :  Display the Im(Instant message) and file transfer in skype
##Created               :  11/08/2018
##Modified By		    :

$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$egInstallpath=Get-ChildItem Env:EGURKHA_INSTALL_DIR |Select Value
$egurkhaPath=$egInstallpath.Value.ToString()
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy

$testargs=$args
$reportingname='SBO\'+$testargs[0]
$egInstallpath=Get-ChildItem Env:EGURKHA_INSTALL_DIR |Select Value

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'
$am_Format=Eg-GetINIContent -Path $langPath -Subject 'TimeFormats' -Key 'AM' -Type $encTyp
$pm_Format=Eg-GetINIContent -Path $langPath -Subject 'TimeFormats' -Key 'PM' -Type $encTyp

    $readfiles=Eg-ReadFile -ComntRptPath $reportingname -FileName "Syallsessions" -keyFileName "kSyallsessions" -EgPath $egurkhaPath
    $datafile=$readfiles[1] -replace (".csv",".dat") 
    $csvfile=Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]
    [array]$userSession= import-csv $csvfile -Encoding $encTyp | Select-Object FromUri,ToUri,MediaTypesDescription,ConfInstance,conferenceurl,StartTime,EndTime,DialogId | Sort -property DialogId -Unique
    Remove-Item $csvfile
    Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'Syallsessions' -InputFile $readfiles[3]
    Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'kSyallsessions' -InputFile $readfiles[4]
    Write-Host "ReadFile:"$readfiles[3]
    [System.GC]::GetTotalMemory($true) | out-null
$totalImsesions=0
$cmpltedImsessions=0
$totalsesduration=0
$filetransfersessions=0
$CurrentSessions=0
$totalcnferncecals=0
$CnfOrganisersCnt=0
$CnfParticpatedUsersCnt=0
$cnfurlStrtNendtime=@{} #map having conference url as key and start end times as values
$CnfrurlNusers=@{}  # conferenceurl and users hashtable
$Cnfrurlusrcnt=@{}  # conferenceurl and users count hashtable
$CnfrncurlNinstancid=@{} # confrence url as key and ConfInstance is value
$filetransfermap=@{} # key as from and to uri and  value as count 
$cnfpartisipant=New-Object System.Collections.ArrayList #total conference paraticipated users list
$CnfOrgslist=New-Object System.Collections.ArrayList #unique conference organised users list

#Date Format 
$CultureDateTimeFormat = (Get-Culture).DateTimeFormat
$DateFormat = $CultureDateTimeFormat.ShortDatePattern
$TimeFormat = $CultureDateTimeFormat.LongTimePattern
$DateTimeFormat = "$DateFormat $TimeFormat"


if($userSession){
    [array]$imusersessions=$userSession | Select-Object * |  Where-Object { $_.MediaTypesDescription -Like "*IM*"} 
    if($imusersessions)
    { 
        $totalImsesions=$imusersessions.count
        ## getting the only conference sessions from all im sessions
        [array]$cnfrncecals=$imusersessions | Select-Object * | Where-Object { $_.MediaTypesDescription -Like "*Conference*"} 
        ## geeting current running sessions (endtime of session is null)
        [array]$currentcals=$imusersessions | Select-Object FromUri,ToUri,MediaTypesDescription,StartTime,EndTime | Where-Object { $_.EndTime -eq "" }  | sort -Property FromUri,ToUri,MediaTypesDescription,StartTime -Unique | Sort-Object { $_.StartTime -as [datetime] } -Descending
        [array]$output=$imusersessions | Select-Object * | Where-Object { $_.EndTime -ne "" }
        $cmpltedImsessions=$output.Count
    }

    [array]$filetransfers=$userSession | Select-Object * | Where-Object { $_.MediaTypesDescription -eq ""}
}

foreach($ot in $output)
{  
    $otStrtTim=$ot.StartTime
    $otEdTim=$ot.EndTime
    if($TimeFormat -match 'tt' -and ($otStrtTim -notmatch $am_Format -and $otStrtTim -notmatch $pm_Format)){
        $otStrtTim=$otStrtTim.Trim()+' '+$am_Format
    }
    if($TimeFormat -match 'tt' -and ($otEdTim -notmatch $am_Format -and $otEdTim -notmatch $pm_Format)){
        $otEdTim=$otEdTim.Trim()+' '+$am_Format
    }
    $cultInfo=(Get-Culture).Name
    $mediastrttime = [DateTime]::ParseExact($otStrtTim,$DateTimeFormat,[cultureinfo]::GetCultureInfo($cultInfo),[System.Globalization.DateTimeStyles]::None)
    $mediaendtime = [DateTime]::ParseExact($otEdTim,$DateTimeFormat,[cultureinfo]::GetCultureInfo($cultInfo),[System.Globalization.DateTimeStyles]::None)
    #$mediastrttime = [DateTime]::ParseExact($ot.StartTime,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
    #$mediaendtime = [DateTime]::ParseExact($ot.EndTime,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)

    $MediaDurationInMinutes = ( $mediaendtime - $mediastrttime).TotalMinutes
    $totalsesduration=$totalsesduration+$MediaDurationInMinutes               
}

foreach($crtcal in $currentcals  | select -First 10)
{
    $CurrentSessions=$currentcals.Count
    $curentmediatype=$crtcal.MediaTypesDescription.Replace("]["," ").Replace("]","").Replace("[","")
    $crtStrtTim=$crtcal.StartTime
    if($TimeFormat -match 'tt' -and ($crtStrtTim -notmatch $am_Format -and $crtStrtTim -notmatch $pm_Format)){
        $crtStrtTim=$crtStrtTim.Trim()+' '+$am_Format
    }
    $cultInfo=(Get-Culture).Name
    $crtcalStartTime = [DateTime]::ParseExact($crtStrtTim,$DateTimeFormat,[cultureinfo]::GetCultureInfo($cultInfo),[System.Globalization.DateTimeStyles]::None)
    #$crtcalStartTime = [DateTime]::ParseExact($crtcal.StartTime,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
    $curntstrttime=Eg-ConvertTime -Time ($crtcalStartTime)
    $dd=''+$crtcal.FromURI +'~!~'+$crtcal.ToURI+'~!~'+'-'+'~!~'+$curntstrttime+'~!~'+'-'+'~!~'+$curentmediatype
    write-host 'currentcals##' $dd
    $dd=$null
}

if($filetransfers){$filetransfersessions=$filetransfers.Count}
foreach($filetranses in $filetransfers)
{
    $frmuri=$filetranses.FromURI
    $touri=$filetranses.ToURI

    $tempstr=$filetranses.FromURI+'#'+$filetranses.ToURI

    if($filetransfermap.Contains($tempstr))
    {
        $filetransfermap[$tempstr]++
    }
    else{

        $filetransfermap[$tempstr]=1
    }

}

foreach($filetranses in $filetransfermap.GetEnumerator() | Sort -property  Value -Descending | select -First 10)
{
    $key=(($filetranses.key).ToString()).split('#')
    $dd=''+$key[0]+'~!~'+$key[1]+'~!~'+$filetranses.value
    write-host 'filetransfer##' $dd
    $dd=$null
}

if($cnfrncecals)
{
    $totalcnferncecals=$cnfrncecals.count
    $cnfrncecals=$cnfrncecals | Select-Object * | Where-Object { $_.EndTime -ne ""}
    foreach($cfrccal in $cnfrncecals)
    {
        $cnfurl=$cfrccal.conferenceurl
        $instanceid=$cfrccal.ConfInstance
        $frmuri=$cfrccal.FromURI
        $touri= $cfrccal.ToURI

        $cfrStrtTim=$cfrccal.StartTime
        $cfrEdTim=$cfrccal.EndTime
        if($TimeFormat -match 'tt' -and ($cfrStrtTim -notmatch $am_Format -and $cfrStrtTim -notmatch $pm_Format)){
            $cfrStrtTim=$cfrStrtTim.Trim()+' '+$am_Format
        }
        if($TimeFormat -match 'tt' -and ($cfrEdTim -notmatch $am_Format -and $cfrEdTim -notmatch $pm_Format)){
            $cfrEdTim=$cfrEdTim.Trim()+' '+$am_Format
        }
        $cultInfo=(Get-Culture).Name
        $cfrccalStartTime = [DateTime]::ParseExact($cfrStrtTim,$DateTimeFormat,[cultureinfo]::GetCultureInfo($cultInfo),[System.Globalization.DateTimeStyles]::None)
        $cfrccalEndTime = [DateTime]::ParseExact($cfrEdTim,$DateTimeFormat,[cultureinfo]::GetCultureInfo($cultInfo),[System.Globalization.DateTimeStyles]::None)
        #$cfrccalStartTime = [DateTime]::ParseExact($cfrccal.StartTime,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
        #$cfrccalEndTime = [DateTime]::ParseExact($cfrccal.EndTime,$DateTimeFormat,[System.Globalization.DateTimeFormatInfo]::InvariantInfo,[System.Globalization.DateTimeStyles]::None)
        $strtime=Eg-ConvertTime -Time  $cfrccalStartTime
        $endtme=Eg-ConvertTime -Time $cfrccalEndTime
        
        if($CnfrurlNusers.Contains($cnfurl))
        {
            $list=$CnfrurlNusers[$cnfurl]
            if(!$list.Contains($frmuri)) { $null=$list.Add($frmuri) }

            if(!$list.Contains($touri)) { $null=$list.Add($touri) }

            if(!$cnfpartisipant.Contains($frmuri)) { $null=$cnfpartisipant.Add($frmuri)}
            if(!$cnfpartisipant.Contains($touri)) { $null=$cnfpartisipant.Add($touri)}

        }
        else
        {
            $list=New-Object System.Collections.ArrayList
            $null=$list.Add($frmuri)
            if(!$list.Contains($touri))
            {
              $null=$list.Add($touri)  
            }
            $null=$CnfrurlNusers.Add($cnfurl,$list)
            $CnfrncurlNinstancid.Add($cnfurl,$instanceid)   #adding cnfurl and instnce id to map
        }
        
        
        if(!$cnfpartisipant.Contains($frmuri)) { $null=$cnfpartisipant.Add($frmuri)}
        if(!$cnfpartisipant.Contains($touri)) { $null=$cnfpartisipant.Add($touri)}


        ### getting the start time and end time of the each conference

        if($cnfurlStrtNendtime.Contains($cnfurl))
        {
            $strttime1=$cnfurlStrtNendtime[$cnfurl]['starttime']
            if(([datetime]$strtime) -lt ([datetime]$strttime1)){$cnfurlStrtNendtime[$cnfurl]['starttime']=$strtime}
            $endtime1=$cnfurlStrtNendtime[$cnfurl]['endtime']
            if(([datetime]$endtme) -gt ([datetime]$endtime1)){$cnfurlStrtNendtime[$cnfurl]['endtime']=$endtme}
        }
        else
        {
            $temp=@{}
            $temp.Add('starttime',$strtime)
            $temp.Add('endtime',$endtme)
            $cnfurlStrtNendtime.Add($cnfurl,$temp)
        }

    }
}

if($CnfrurlNusers)
{
   $totalcnferncecals=$CnfrurlNusers.count

    foreach($parcon in $CnfrurlNusers.GetEnumerator())
    {
        $cnfurl=($parcon.key).ToString()
        $CnfOrgUser=$cnfurl.Substring(4,$cnfurl.IndexOf(";"))
        $CnfOrgUser=$CnfOrgUser.Substring(0,$CnfOrgUser.IndexOf(";"))
        if(!$CnfOrgslist.Contains($CnfOrgUser)) { $null=$CnfOrgslist.Add($CnfOrgUser)}
        $cnt=$parcon.value.count
        $null=$Cnfrurlusrcnt.Add($parcon.key,$cnt)
	}

    foreach($entry in $Cnfrurlusrcnt.GetEnumerator() | sort -Property value -Descending | select -First 10)
    {
        $cnfurl=($entry.key).ToString()
        $CnfOrgUser=$cnfurl.Substring(4,$cnfurl.IndexOf(";"))
        $CnfOrgUser=$CnfOrgUser.Substring(0,$CnfOrgUser.IndexOf(";"))
        if($CnfrurlNusers[$cnfurl].Count -gt 5){$CnfrurlNusers[$cnfurl].Remove($CnfOrgUser)}
        $CnfPartUsrs=([String]($CnfrurlNusers[$cnfurl] | select -First 5)).Replace(" ",",")
        Write-Host  'conferencedd##' $CnfrncurlNinstancid[$entry.key]  '~!~' $CnfOrgUser '~!~' $entry.value '~!~'$CnfPartUsrs '~!~'($cnfurlStrtNendtime[$cnfurl]['starttime']).ToString() '~!~' ($cnfurlStrtNendtime[$cnfurl]['endtime']).ToString()
	}
}


if($CnfOrgslist) { $CnfOrganisersCnt=$CnfOrgslist.count }
if($cnfpartisipant) { $CnfParticpatedUsersCnt=$cnfpartisipant.count }

$totalsesduration=$totalsesduration.ToString('#.##')
Write-Host 'measures#' $cmpltedImsessions ~ $CurrentSessions ~ $totalsesduration ~ $totalcnferncecals ~ $CnfOrganisersCnt  ~ $CnfParticpatedUsersCnt ~ $filetransfersessions
[System.GC]::GetTotalMemory($true) | out-null
# SIG # Begin signature block
# MIIbjAYJKoZIhvcNAQcCoIIbfTCCG3kCAQExCzAJBgUrDgMCGgUAMGkGCisGAQQB
# gjcCAQSgWzBZMDQGCisGAQQBgjcCAR4wJgIDAQAABBAfzDtgWUsITrck0sYpfvNR
# AgEAAgEAAgEAAgEAAgEAMCEwCQYFKw4DAhoFAAQUHIPJE7R+goWNTVvC8m0/2xGX
# 2D6gghWiMIIE/jCCA+agAwIBAgIQDUJK4L46iP9gQCHOFADw3TANBgkqhkiG9w0B
# AQsFADByMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYD
# VQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYDVQQDEyhEaWdpQ2VydCBTSEEyIEFz
# c3VyZWQgSUQgVGltZXN0YW1waW5nIENBMB4XDTIxMDEwMTAwMDAwMFoXDTMxMDEw
# NjAwMDAwMFowSDELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMu
# MSAwHgYDVQQDExdEaWdpQ2VydCBUaW1lc3RhbXAgMjAyMTCCASIwDQYJKoZIhvcN
# AQEBBQADggEPADCCAQoCggEBAMLmYYRnxYr1DQikRcpja1HXOhFCvQp1dU2UtAxQ
# tSYQ/h3Ib5FrDJbnGlxI70Tlv5thzRWRYlq4/2cLnGP9NmqB+in43Stwhd4CGPN4
# bbx9+cdtCT2+anaH6Yq9+IRdHnbJ5MZ2djpT0dHTWjaPxqPhLxs6t2HWc+xObTOK
# fF1FLUuxUOZBOjdWhtyTI433UCXoZObd048vV7WHIOsOjizVI9r0TXhG4wODMSlK
# XAwxikqMiMX3MFr5FK8VX2xDSQn9JiNT9o1j6BqrW7EdMMKbaYK02/xWVLwfoYer
# vnpbCiAvSwnJlaeNsvrWY4tOpXIc7p96AXP4Gdb+DUmEvQECAwEAAaOCAbgwggG0
# MA4GA1UdDwEB/wQEAwIHgDAMBgNVHRMBAf8EAjAAMBYGA1UdJQEB/wQMMAoGCCsG
# AQUFBwMIMEEGA1UdIAQ6MDgwNgYJYIZIAYb9bAcBMCkwJwYIKwYBBQUHAgEWG2h0
# dHA6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAfBgNVHSMEGDAWgBT0tuEgHf4prtLk
# YaWyoiWyyBc1bjAdBgNVHQ4EFgQUNkSGjqS6sGa+vCgtHUQ23eNqerwwcQYDVR0f
# BGowaDAyoDCgLoYsaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJl
# ZC10cy5jcmwwMqAwoC6GLGh0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9zaGEyLWFz
# c3VyZWQtdHMuY3JsMIGFBggrBgEFBQcBAQR5MHcwJAYIKwYBBQUHMAGGGGh0dHA6
# Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBPBggrBgEFBQcwAoZDaHR0cDovL2NhY2VydHMu
# ZGlnaWNlcnQuY29tL0RpZ2lDZXJ0U0hBMkFzc3VyZWRJRFRpbWVzdGFtcGluZ0NB
# LmNydDANBgkqhkiG9w0BAQsFAAOCAQEASBzctemaI7znGucgDo5nRv1CclF0CiNH
# o6uS0iXEcFm+FKDlJ4GlTRQVGQd58NEEw4bZO73+RAJmTe1ppA/2uHDPYuj1UUp4
# eTZ6J7fz51Kfk6ftQ55757TdQSKJ+4eiRgNO/PT+t2R3Y18jUmmDgvoaU+2QzI2h
# F3MN9PNlOXBL85zWenvaDLw9MtAby/Vh/HUIAHa8gQ74wOFcz8QRcucbZEnYIpp1
# FUL1LTI4gdr0YKK6tFL7XOBhJCVPst/JKahzQ1HavWPWH1ub9y4bTxMd90oNcX6X
# t/Q/hOvB46NJofrOp79Wz7pZdmGJX36ntI5nePk2mOHLKNpbh6aKLzCCBTAwggQY
# oAMCAQICEAQJGBtf1btmdVNDtW+VUAgwDQYJKoZIhvcNAQELBQAwZTELMAkGA1UE
# BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
# ZXJ0LmNvbTEkMCIGA1UEAxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENBMB4X
# DTEzMTAyMjEyMDAwMFoXDTI4MTAyMjEyMDAwMFowcjELMAkGA1UEBhMCVVMxFTAT
# BgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEx
# MC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUgU2lnbmluZyBD
# QTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAPjTsxx/DhGvZ3cH0wsx
# SRnP0PtFmbE620T1f+Wondsy13Hqdp0FLreP+pJDwKX5idQ3Gde2qvCchqXYJawO
# eSg6funRZ9PG+yknx9N7I5TkkSOWkHeC+aGEI2YSVDNQdLEoJrskacLCUvIUZ4qJ
# RdQtoaPpiCwgla4cSocI3wz14k1gGL6qxLKucDFmM3E+rHCiq85/6XzLkqHlOzEc
# z+ryCuRXu0q16XTmK/5sy350OTYNkO/ktU6kqepqCquE86xnTrXE94zRICUj6whk
# PlKWwfIPEvTFjg/BougsUfdzvL2FsWKDc0GCB+Q4i2pzINAPZHM8np+mM6n9Gd8l
# k9ECAwEAAaOCAc0wggHJMBIGA1UdEwEB/wQIMAYBAf8CAQAwDgYDVR0PAQH/BAQD
# AgGGMBMGA1UdJQQMMAoGCCsGAQUFBwMDMHkGCCsGAQUFBwEBBG0wazAkBggrBgEF
# BQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRw
# Oi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0Eu
# Y3J0MIGBBgNVHR8EejB4MDqgOKA2hjRodHRwOi8vY3JsNC5kaWdpY2VydC5jb20v
# RGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3JsMDqgOKA2hjRodHRwOi8vY3JsMy5k
# aWdpY2VydC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3JsME8GA1UdIARI
# MEYwOAYKYIZIAYb9bAACBDAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdp
# Y2VydC5jb20vQ1BTMAoGCGCGSAGG/WwDMB0GA1UdDgQWBBRaxLl7KgqjpepxA8Bg
# +S32ZXUOWDAfBgNVHSMEGDAWgBRF66Kv9JLLgjEtUYunpyGd823IDzANBgkqhkiG
# 9w0BAQsFAAOCAQEAPuwNWiSz8yLRFcgsfCUpdqgdXRwtOhrE7zBh134LYP3DPQ/E
# r4v97yrfIFU3sOH20ZJ1D1G0bqWOWuJeJIFOEKTuP3GOYw4TS63XX0R58zYUBor3
# nEZOXP+QsRsHDpEV+7qvtVHCjSSuJMbHJyqhKSgaOnEoAjwukaPAJRHinBRHoXpo
# aK+bp1wgXNlxsQyPu6j4xRJon89Ay0BEpRPw5mQMJQhCMrI2iiQC/i9yfhzXSUWW
# 6Fkd6fp0ZGuy62ZD2rOwjNXpDd32ASDOmTFjPQgaGLOBm0/GkxAG/AeB+ova+YJJ
# 92JuoVP6EpQYhS6SkepobEQysmah5xikmmRR7zCCBTEwggQZoAMCAQICEAqhJdbW
# Mht+QeQF2jaXwhUwDQYJKoZIhvcNAQELBQAwZTELMAkGA1UEBhMCVVMxFTATBgNV
# BAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEkMCIG
# A1UEAxMbRGlnaUNlcnQgQXNzdXJlZCBJRCBSb290IENBMB4XDTE2MDEwNzEyMDAw
# MFoXDTMxMDEwNzEyMDAwMFowcjELMAkGA1UEBhMCVVMxFTATBgNVBAoTDERpZ2lD
# ZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGln
# aUNlcnQgU0hBMiBBc3N1cmVkIElEIFRpbWVzdGFtcGluZyBDQTCCASIwDQYJKoZI
# hvcNAQEBBQADggEPADCCAQoCggEBAL3QMu5LzY9/3am6gpnFOVQoV7YjSsQOB0Uz
# URB90Pl9TWh+57ag9I2ziOSXv2MhkJi/E7xX08PhfgjWahQAOPcuHjvuzKb2Mln+
# X2U/4Jvr40ZHBhpVfgsnfsCi9aDg3iI/Dv9+lfvzo7oiPhisEeTwmQNtO4V8CdPu
# XciaC1TjqAlxa+DPIhAPdc9xck4Krd9AOly3UeGheRTGTSQjMF287DxgaqwvB8z9
# 8OpH2YhQXv1mblZhJymJhFHmgudGUP2UKiyn5HU+upgPhH+fMRTWrdXyZMt7HgXQ
# hBlyF/EXBu89zdZN7wZC/aJTKk+FHcQdPK/P2qwQ9d2srOlW/5MCAwEAAaOCAc4w
# ggHKMB0GA1UdDgQWBBT0tuEgHf4prtLkYaWyoiWyyBc1bjAfBgNVHSMEGDAWgBRF
# 66Kv9JLLgjEtUYunpyGd823IDzASBgNVHRMBAf8ECDAGAQH/AgEAMA4GA1UdDwEB
# /wQEAwIBhjATBgNVHSUEDDAKBggrBgEFBQcDCDB5BggrBgEFBQcBAQRtMGswJAYI
# KwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBDBggrBgEFBQcwAoY3
# aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9v
# dENBLmNydDCBgQYDVR0fBHoweDA6oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQu
# Y29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDA6oDigNoY0aHR0cDovL2Ny
# bDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDBQBgNV
# HSAESTBHMDgGCmCGSAGG/WwAAgQwKjAoBggrBgEFBQcCARYcaHR0cHM6Ly93d3cu
# ZGlnaWNlcnQuY29tL0NQUzALBglghkgBhv1sBwEwDQYJKoZIhvcNAQELBQADggEB
# AHGVEulRh1Zpze/d2nyqY3qzeM8GN0CE70uEv8rPAwL9xafDDiBCLK938ysfDCFa
# KrcFNB1qrpn4J6JmvwmqYN92pDqTD/iy0dh8GWLoXoIlHsS6HHssIeLWWywUNUME
# aLLbdQLgcseY1jxk5R9IEBhfiThhTWJGJIdjjJFSLK8pieV4H9YLFKWA1xJHcLN1
# 1ZOFk362kmf7U2GJqPVrlsD0WGkNfMgBsbkodbeZY4UijGHKeZR+WfyMD+NvtQEm
# tmyl7odRIeRYYJu6DC0rbaLEfrvEJStHAgh8Sa4TtuF8QkIoxhhWz0E0tmZdtnR7
# 9VYzIi8iNrJLokqV2PWmjlIwggYzMIIFG6ADAgECAhAImnSeuC3D7CfqZerb+DUx
# MA0GCSqGSIb3DQEBCwUAMHIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2Vy
# dCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xMTAvBgNVBAMTKERpZ2lD
# ZXJ0IFNIQTIgQXNzdXJlZCBJRCBDb2RlIFNpZ25pbmcgQ0EwHhcNMjEwNTI1MDAw
# MDAwWhcNMjQwNTI5MjM1OTU5WjBxMQswCQYDVQQGEwJVUzETMBEGA1UECBMKTmV3
# IEplcnNleTEPMA0GA1UEBxMGSXNlbGluMR0wGwYDVQQKExRlRyBJbm5vdmF0aW9u
# cywgSW5jLjEdMBsGA1UEAxMUZUcgSW5ub3ZhdGlvbnMsIEluYy4wggIiMA0GCSqG
# SIb3DQEBAQUAA4ICDwAwggIKAoICAQDEZQnSmuNt/FyaBkaN3skPE6zuzJIe9pDf
# AZHYpsPdplqB5IT6QbS0qQSxDidrxuc1WJj/MXg9ujRmRi0zMkiTQBlcNMy9ev+Y
# S+YrEJuIkVMKkqSZnixrkFl87uKAi9w1JrTMgjZrmOJAkXLzmP5/0jgSBOj05x1V
# 4g1eGBDbFnpOMQr6luGqZVe+vwMHbolyU5p53QvlWzv4JsbNm4qJ+DEvaLx3kUPO
# SFlJl90K0a0S8Tmkt6xdJZ+nNR128I1GKwg8YHuaD5GWfZe9RnLJpFRG2XHXWlh8
# n8o1gCRQIvbeueHfz+ZrG1K916KhgGPjEvK3umhAEb5vS7MKOBEAN7f+TQ22JXAk
# ijRkSxTIMA2nskgiMx4/Ow4xjN8w/KLxyUDB8FhzZeFK5RxffIp/iSlEWYKVh8rk
# uy0ZBE1s42OmwIFMSBm7AR+R05TSuZozLBkVUscSmalhl4/PszdWE35pXnqRH95+
# jx4PzUTlUNCqYmIZYqr+z2OFuRgfuDa6EvYxdv+5GyFUNI6QVG8ggP+X7IMmiAMG
# lp7fHai/li+NjxmjxEXS1e/JLSt+wO8A1nDuam3MefQGWbDmW6DcXYJUmk1vNvUe
# YAfqTTIUeZZgKhQA1sEHRhH+Tgm+BjZvK20XtxA8nKXtQj0K7gpMCDtE6YaTB0uG
# Zeg8IFyjQQIDAQABo4IBxDCCAcAwHwYDVR0jBBgwFoAUWsS5eyoKo6XqcQPAYPkt
# 9mV1DlgwHQYDVR0OBBYEFPnIRJrP2BNJLxoE1rWvfgwwDjZKMA4GA1UdDwEB/wQE
# AwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzB3BgNVHR8EcDBuMDWgM6Axhi9odHRw
# Oi8vY3JsMy5kaWdpY2VydC5jb20vc2hhMi1hc3N1cmVkLWNzLWcxLmNybDA1oDOg
# MYYvaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC1jcy1nMS5j
# cmwwSwYDVR0gBEQwQjA2BglghkgBhv1sAwEwKTAnBggrBgEFBQcCARYbaHR0cDov
# L3d3dy5kaWdpY2VydC5jb20vQ1BTMAgGBmeBDAEEATCBhAYIKwYBBQUHAQEEeDB2
# MCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wTgYIKwYBBQUH
# MAKGQmh0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFNIQTJBc3N1
# cmVkSURDb2RlU2lnbmluZ0NBLmNydDAMBgNVHRMBAf8EAjAAMA0GCSqGSIb3DQEB
# CwUAA4IBAQCUCOdwU+8srLBP/gMQIbtsdu2JWX666Z9GPZisW4KGyCS/U+ZCmB/K
# nELeD4StX3JFXz5ddILA5oone/pEud+mEuETBhzb7RCz82WJvk0DEMa4hzMAh5c5
# zmRFGm8WxDZdI20ztcvW0sObqn9UbsGhQDKpFeww91ZtOQ3/2d0KYZKypzGMba53
# w7pWG170nktocFWTeUhkAy0foAJ2jlBOszj2dshTxAa5Fg1dkpEsBS7oiAPpYkox
# V9ldaXJ8Px1navd6PpDW4A781u13f3tP4FVCsNYw4bz4Z5GInCh6/FshaHRJ6dk5
# SsCr29MlpK8UxK9y2Qmb+jEtRxR0QZLfMYIFVDCCBVACAQEwgYYwcjELMAkGA1UE
# BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2lj
# ZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNlcnQgU0hBMiBBc3N1cmVkIElEIENvZGUg
# U2lnbmluZyBDQQIQCJp0nrgtw+wn6mXq2/g1MTAJBgUrDgMCGgUAoHAwEAYKKwYB
# BAGCNwIBDDECMAAwGQYJKoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
# NwIBCzEOMAwGCisGAQQBgjcCARUwIwYJKoZIhvcNAQkEMRYEFEYzaeqSozkTP5jN
# qYNwBYMaOZS5MA0GCSqGSIb3DQEBAQUABIICAIzUp30x1W2PmpbhIeo/oe0Jz+yG
# u3h3S8B6Cfgj/I/1UKurkDo50SeugBOUVZYZHGKBZR+3gcDQHD5Cnvf1bWafiaLQ
# fMo4+udY58Sae7y6XpGmia6eEdW7UDU+CK0BQLU8GGrQgWvDC+triAinyV6p5Evy
# MjrtY3Z3PPV0R6fX5PEUOnuAfjn3wNAYppug32xtfmoSZu6/hzQoqZ8j/63KLfpU
# ZEBQjM4rLAo3jCMMDVfheWYFTxc7VQfTtnAKyuE0hPtHM/BoRzzRoT9iyG9BId0k
# MAtb7IiLABtFMAR8NwruLZElHMsyoqliFzhO4WS5bkR3yi4GHrtNZmMO21QumIwX
# RXpRGxG/8AO5IjYc31haViw1HF3i2htTxQn6Rf3MF7LkQIyYBUT1rEbLUe/UQPeb
# E/Dwi4fJufzWG9SAkdPmt4J1287j4PLm1dMdV+vxUVrmWM2UbdbYXwL63IjKMTQC
# t3O1QQwU8r3YIfaR2WS8ppbp2nWzu7ygkAP7ZTJwEs0/A+QYI1nMBgd+yBZKWKr5
# Z5BBVgv58Z9Fj2cnsxXpcAEZju3dMhXK8IWT4eb6Fq5y3JSclvQc/V4l1ofCr69G
# blLHxYhPsi5PV26IimlNKDGfYXOcBVBdYfCmvrN5ckLN1Jitx6oT/U/8Tm9b9h+H
# OfvxpLiDbHsn5qZuoYICMDCCAiwGCSqGSIb3DQEJBjGCAh0wggIZAgEBMIGGMHIx
# CzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3
# dy5kaWdpY2VydC5jb20xMTAvBgNVBAMTKERpZ2lDZXJ0IFNIQTIgQXNzdXJlZCBJ
# RCBUaW1lc3RhbXBpbmcgQ0ECEA1CSuC+Ooj/YEAhzhQA8N0wDQYJYIZIAWUDBAIB
# BQCgaTAYBgkqhkiG9w0BCQMxCwYJKoZIhvcNAQcBMBwGCSqGSIb3DQEJBTEPFw0y
# MTA5MDExMjM2NDhaMC8GCSqGSIb3DQEJBDEiBCDzx/wVp6WR54Q58ATmVst0K6uQ
# TpTxaFZO4R0IuvMo4jANBgkqhkiG9w0BAQEFAASCAQAzGKnmzA9f8cp5pp7krtlI
# U46x/FBgZDgiw4c3mQHDgv/INT/kn5CFZK9UZxaBh7eUCbShUfanHttyoyzGqW0R
# ka37SoxRbU/05j0eF7fGB378I9pLv49mKyZz+thovchsuv4fo6aHoWIqJRGeJjzZ
# 0Tv8NR/HSOM8w+3D5bHQ9PItcZDfOS7zQGW8/82lVIEv3mzKtJmsrhPwYeQpScLi
# DbPUMj0VWOEnEkTDS6SfCWXCduDFq8fnZJ5b0Ljg4oVoIdj5HjrQGf9L/8peSgjT
# njrWOgUO2vLsvSlYp6XlUHJXoCpzv7NzWW9uUms+gk7FOUDVqX0mcP4f94j1RqqM
# SIG # End signature block
