
#This File is in Unicode format.  Do not edit in an ASCII editor.
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

#region help text

<#
.SYNOPSIS
			
			To get collect the Partition details of Active Directory
.DESCRIPTION

			This Script is used to collect the Partition details of Active Directory
			Measure : 1.Server name

.INPUTS
			CONST_TEST_HDR and delimiter
.OUTPUTS
			Collect the Group Measures of  Partition in following format
			<part.nCName><Delimiter><DNSServersList>
#>

$ErrorActionPreference = 'SilentlyContinue'
$global:isErrorOccured = $False

$global:CONST_TEST_HDR = $args[0]
$global:CONST_TEST_END = $args[1]
$global:delimiter = $args[2]


import-module ActiveDirectory

Clear-Host

# To get the Partition details of Active Directory

Function getADConfigPartitionInfo
{
	
	$Forest = Get-ADForest -Current LocalComputer
	$rootDomain = $Forest.RootDomain
	$partitions = Get-ADObject -Server $rootDomain -Filter * -SearchBase $Forest.PartitionsContainer -SearchScope OneLevel -Properties name,nCName,msDS-NC-Replica-Locations | Select name,nCName,msDS-NC-Replica-Locations | Sort-Object name
	foreach ($part in $partitions)
	{
		$DNSServers = $part."msDS-NC-Replica-Locations" | Sort-Object
		$DNSServersList = ""
		foreach ($DNSServer in $DNSServers)
		{
			$DNSServersList += ($DNSServer -Split ",")[1] -Replace "CN=",""
		}
		if ($DNSServersList -eq $null -or  $DNSServersList.length -eq 0)
		{
			$DNSServersList = "-"
		}
		Write-Host ($part.nCName,$DNSServersList) -Separator $global:delimiter
	}

}

#Main Region Starts
try
{

   	Write-Host $global:CONST_TEST_HDR
	Write-Host "-------------------------"
       
    getADConfigPartitionInfo
}
catch [Exception]
{
	$global:isErrorOccured = $True
	Write-Verbose "Catch block executed and following Exception is occured : " $_.Exception.GetType().FullName, $_.Exception.Message
}

If($global:isErrorOccured -eq $False)
{
	Write-Host $global:CONST_TEST_END
}
#Main Region Ends

