$Global:ErrorActionPreference="SilentlyContinue"
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}
Add-PSSnapin Citrix.Authentication.FederatedAuthenticationService.V1

$FQDN = [System.Net.Dns]::GetHostEntry([System.Net.Dns]::GetHostName()).HostName
Write-Host("FQDN=" + $FQDN);

$FasServers = Get-FasServer
Write-Host "FAS Servers"
Write-Host "==========="
if ($FasServers -ne $null)
{
    foreach ($FasServer in $FasServers)
    {
        Write-Host ($FasServer.Address,$FasServer.Index,$FasServer.Version,$FasServer.MaintenanceMode) -Separator "#~#"
    }
}

Write-Host "FAS Authorization Certificates"
Write-Host "=============================="
$FasAuthorizationCertificates = Get-FasAuthorizationCertificate -Address $FQDN -FullCertInfo
if ($FasAuthorizationCertificates -ne $null)
{
	# Status - Pending,Ok,MaintenanceRequired and Expired
	foreach ($FasAuthorizationCertificate in $FasAuthorizationCertificates)
    {
        $ExpiryDate = $FasAuthorizationCertificate.ExpiryDate
        $RemainingExpiryDays = $ExpiryDate.subtract([DateTime]::Now).days
        Write-Host ($FasAuthorizationCertificate.Id,$FasAuthorizationCertificate.Address,$FasAuthorizationCertificate.Status,$FasAuthorizationCertificate.TrustArea,
                    $RemainingExpiryDays,$ExpiryDate,$FasAuthorizationCertificate.CertificateRequest) -Separator "#~#"
    }
}

Write-Host "FAS Authorization Definitions"
Write-Host "============================="
$FasCertificateDefinitions = Get-FasCertificateDefinition -Address $FQDN
if ($FasCertificateDefinitions -ne $null)
{
	foreach ($FasCertificateDefinition in $FasCertificateDefinitions)
    {
		$count = 0
        $CertAuthorities = ""
		$CertificateAuthorities = $FasCertificateDefinition.CertificateAuthorities
        if ($CertificateAuthorities -ne $null)
        {
		    foreach ($CertAuth in $CertificateAuthorities)
		    {
			    if ($count -eq 0)
			    {
				    $CertAuthorities = $CertAuth
			    }
			    else
			    {
				    $CertAuthorities = $CertAuthorities + "," + $CertAuth
			    }
			    $count = $count + 1
		    }
        }
        Write-Host ($FasCertificateDefinition.Name,$FasCertificateDefinition.InSession,$FasCertificateDefinition.MsTemplate,$CertAuthorities) -Separator "#~#"
    }
}


Write-Host "FAS User Certificates"
Write-Host "====================="
$FasUserCertificates = Get-FasUserCertificate -Address $FQDN
if ($FasUserCertificates -ne $null)
{
	foreach ($FasUserCertificate in $FasUserCertificates)
   	{
       	Write-Host ($FasUserCertificate.UserPrincipalName,$FasUserCertificate.Role,$FasUserCertificate.CertificateDefinition,$FasUserCertificate.ExpiryDate,$FasUserCertificate.ThumbPrint) -Separator "#~#"
   	}
}

#Write-Host "FAS MS Certificate Authority"
#Write-Host "============================"
#$FasMsCertificateAuthorities = Get-FasMsCertificateAuthority -Default
#if ($FasMsCertificateAuthorities -ne $null)
#{
#	foreach ($FasMsCertificateAuthority in $FasMsCertificateAuthorities)
#   	{	
#		$count = 0
#        $PublishedTemplates = ""
#		$PubTemplates = $FasMsCertificateAuthority.PublishedTemplates
#        if ($PubTemplates -ne $null)
#        {
#		    foreach ($PubTemplate in $PubTemplates)
#		    {
#			    if ($count -eq 0)
#			    {
#				    $PublishedTemplates = $PubTemplate
#			    }
#			    else
#			    {
#				    $PublishedTemplates = $PublishedTemplates + "," + $PubTemplate
#			    }
#			    $count = $count + 1
#		    }
#        }
#       	Write-Host ($FasMsCertificateAuthority.Address,$FasMsCertificateAuthority.IsAccessible,$FasMsCertificateAuthority.IsDefault,$PublishedTemplates) -Separator "#~#"
#   	}
#}

Write-Host "FAS Policy Oid"
Write-Host "=============="
$FasPolicyOids = Get-FasPolicyOid
if ($FasPolicyOids -ne $null)
{
	foreach ($FasPolicyOid in $FasPolicyOids)
   	{
       	Write-Host ($FasPolicyOid.Name,$FasPolicyOid.Oid,$FasPolicyOid.Path,$FasPolicyOid.LdapSecurityGroup) -Separator "#~#"
   	}
}

 
