$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

#only retrieve quota entries that are limited
$query="Select * from win32_diskquota"
$Computer=$env:computername.ToUpper()
$quotas=get-wmiobject -query $query -ea Stop

#get quota entries and filter off local user accounts, administrator and domain admins
$entries = $quotas

Write-Host "LogonName;Status;VolumeName;DiskSpaceUsed(MB);QuotaUsed(%);QuotaLimit(GB),LimitRemaining(GB);WarningLevel(GB);OverWarning;OverLimit"
if ($entries)
{
	foreach ($entry in $entries)
	{
		 #remove quotes from user property and split the user entry at the comma
	         #assuming no commas in the domain or username	
		 $replaced=($entry.user).Replace('"',"")
		 
		 $userdata=$replaced.split(",")
		 
		 #item 0 will be the domain and item 1 will be the user. Each item needs
		 #to be further split.  The domain and username values should be the same as any
		 #values passed as paramters.  I'll override the default domain parameter value. 
		 #Otherwise, if it isn't specified and the admin running the script isn't in the domain
		 #you'll get the wrong domain listed.
		 
		 $domain=$userdata[0].Split("=")[1]
		 $username=$userdata[1].Split("=")[1]
		 
		 #parse QuotaVolume and strip off quotes
		 $Volume=($entry.quotavolume.split("=")[1]).Replace('"',"") 
		 $Volume=$Volume.ToUpper()
		 
		 #calculate % of quota used
		 if([double]$entry.Limit -gt 0.0)
		 {
		 	$percentUsed = ([double]$entry.DiskSpaceUsed/[double]$entry.Limit)
			if ($percentUsed -lt 0)
			{
				$percentUsed = -5.0
			}
		 }
		 else
		 {
		 	$percentUsed = -6.0
		 }
		
		 
		 #calculate limit remaining space
		 if([double]$entry.Limit -gt 0.0)
		 {
		 	[double]$limitRemaining = (([double]$entry.Limit - [double]$entry.DiskSpaceUsed)/1GB)
			if($limitRemaining -lt 0)
			{
				$limitRemaining = -5.0
			}
		 }
		 else
		 {
		 	$limitRemaining = -6.0
		 }
		 
		 #is user over the warning limit?
		 if ($entry.diskspaceused -gt $entry.WarningLimit)
		 {
         		$Warning=$True
         	 }
         	 else
		 {
         		$Warning=$False
         	 }
		 
		#is user over the hard limit?
		if (($entry.Limit -gt 0.0) -and ($entry.DiskSpaceUsed -gt $entry.Limit))
		{
         		$OverLimit=$True
		}
		 else
		{
         		$OverLimit=$False
		}
		$d = $domain + "\" + $username
		$status  =  $entry.Status

		[double]$DiskUsed = ([double]($entry.DiskSpaceUsed/1GB))
		[double]$Limit = ([double]($entry.Limit/1GB))
		[double]$WarningLimit = ([double]($entry.WarningLimit/1GB))

		Write-Host $d,$status,$Volume,$DiskUsed, $percentUsed, $Limit, $limitRemaining,$WarningLimit,$Warning,$OverLimit  -Separator  ";" 

	}
}

 

