﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$egEncryPath=$scriptPath+"\EGFileEncryption.psm1"
$egDatnKy=$scriptPath+"\GetDatnKeyFiles.psm1"
Import-Module $egEncryPath,$egDatnKy
clear

$testargs=$args
$excldMailbox= ($testargs[0]).trim()
$toHideAdminAct=$testargs[1]
$reportingname='EXO\'+$testargs[2]
if($testargs[3] -eq $null){
    $topNDD=10
}
$topNDD=$testargs[3]
$shwTopNDD=0
if($topNDD -ne $null -and $topNDD -ne '' -and $topNDD.ToString().ToLower() -ne 'all'){
    $shwTopNDD=[int]$topNDD
}

$langPath=$egurkhaPath+'\agent\config\O365_lang.ini'
$encTyp=Eg-GetINIContent -Path $langPath -Subject 'File_Type' -Key 'encoding'

try{
    $readfiles=Eg-ReadFile -ComntRptPath $reportingname -FileName "owneractvts" -keyFileName "kowneractvts" -EgPath $egurkhaPath
    if($readfiles -ne $null -and [System.IO.File]::Exists($readfiles[1]) -eq 'True'){
        $datafile=$readfiles[1] -replace (".csv",".dat")
        $csvfile=Unprotect-File $datafile -Algorithm AES -KeyAsPlainText $readfiles[0]
        $totaactivites= import-csv $csvfile -Encoding $encTyp
        Remove-Item $csvfile
        Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'owneractvts' -InputFile $readfiles[3]
        Eg-DeleteFiles -FilePath $readfiles[2] -Pattern 'kowneractvts' -InputFile $readfiles[4]
        Write-Host 'ReadFile:'$readfiles[3]
    }
}
catch{
    $errmsg=$_.Exception.Message
    Write-Error -Message $errmsg
}
    
[System.GC]::GetTotalMemory($true) | out-null
if($totaactivites -ne $null){ 
	$activitys=@{}
    $Operationddlist=New-Object System.Collections.ArrayList

    $ddCnt=0
	foreach($entry in $totaactivites)
	{
       $clientipadd=$entry.ClientIPAddress
       if($clientipadd -and $clientipadd.contains('[') -and $clientipadd.Contains(']') )
       {
        $entry.ClientIPAddress=$clientipadd.ToString().Substring($clientipadd.IndexOf("[")+1,$clientipadd.IndexOf("]")-1)
       }
            $usermailbox=$entry.MailboxOwnerUPN
            if($toHideAdminAct -eq $true)
            {
                if($usermailbox -eq $excldMailbox)
                {
                    continue
                }
            }

	    $oper=$entry.Operation
        if(($entry.FolderId).Length -gt 255){ $entry.FolderId= $entry.FolderId.Substring(0,254) }
        if(($entry.SourceFolders).Length -gt 255){ $entry.SourceFolders= $entry.SourceFolders.Substring(0,254) }
        if(($entry.SourceItems).Length -gt 255){ $entry.SourceItems= $entry.SourceItems.Substring(0,254) }
        if(($entry.SourceItemIdsList).Length -gt 255){ $entry.SourceItemIdsList= $entry.SourceItemIdsList.Substring(0,254) }
        if(($entry.SourceItemSubjectsList).Length -gt 255){ $entry.SourceItemSubjectsList= $entry.SourceItemSubjectsList.Substring(0,254) }
        if(($entry.SourceItemAttachmentsList).Length -gt 255){ $entry.SourceItemAttachmentsList= $entry.SourceItemAttachmentsList.Substring(0,254) }
        if(($entry.SourceItemFolderPathNamesList).Length -gt 255){ $entry.SourceItemFolderPathNamesList= $entry.SourceItemFolderPathNamesList.Substring(0,254) }
        if(($entry.SourceFolderPathNamesList).Length -gt 255){ $entry.SourceFolderPathNamesList= $entry.SourceFolderPathNamesList.Substring(0,254) }
        if($shwTopNDD -ne 0){
            if($ddCnt -lt $shwTopNDD){
                $ddCnt++
                $ddoperation=$oper +'total' +$entry.LastAccessed  +'~!~'+  $entry.OperationResult +'~!~'+  $entry.LogonUserDisplayName   +'~!~'+  $entry.MailboxOwnerUPN  +'~!~'+  $entry.ExternalAccess  +'~!~'+  $entry.DestFolderId  +'~!~'+  $entry.DestFolderPathName  +'~!~'+  $entry.FolderId  +'~!~'+  $entry.FolderPathName  +'~!~'+  $entry.ClientIPAddress  +'~!~'+  $entry.ClientMachineName  +'~!~'+  $entry.ClientProcessName  +'~!~'+  $entry.ClientInfoString  +'~!~'+  $entry.ClientVersion  +'~!~'+  $entry.DestMailboxOwnerUPN  +'~!~'+  $entry.CrossMailboxOperation    +'~!~'+  $entry.SourceItems  +'~!~'+  $entry.SourceFolders  +'~!~'+  $entry.SourceItemIdsList  +'~!~'+  $entry.SourceItemSubjectsList  +'~!~'+  $entry.SourceItemAttachmentsList  +'~!~'+  $entry.SourceItemFolderPathNamesList  +'~!~'+  $entry.SourceFolderPathNamesList  +'~!~'+  $entry.ItemSubject  +'~!~'+  $entry.ItemAttachments  +'~!~'+  $entry.DirtyProperties  +'~!~'+  $entry.OriginatingServer 
                if($Operationddlist.Contains($ddoperation)){
                    Continue
                }else{
                    $Operationddlist.Add($ddoperation)
                }
	            Write-Host $ddoperation
            }
        }else{
            $ddoperation=$oper +'total' +$entry.LastAccessed  +'~!~'+  $entry.OperationResult +'~!~'+  $entry.LogonUserDisplayName   +'~!~'+  $entry.MailboxOwnerUPN  +'~!~'+  $entry.ExternalAccess  +'~!~'+  $entry.DestFolderId  +'~!~'+  $entry.DestFolderPathName  +'~!~'+  $entry.FolderId  +'~!~'+  $entry.FolderPathName  +'~!~'+  $entry.ClientIPAddress  +'~!~'+  $entry.ClientMachineName  +'~!~'+  $entry.ClientProcessName  +'~!~'+  $entry.ClientInfoString  +'~!~'+  $entry.ClientVersion  +'~!~'+  $entry.DestMailboxOwnerUPN  +'~!~'+  $entry.CrossMailboxOperation    +'~!~'+  $entry.SourceItems  +'~!~'+  $entry.SourceFolders  +'~!~'+  $entry.SourceItemIdsList  +'~!~'+  $entry.SourceItemSubjectsList  +'~!~'+  $entry.SourceItemAttachmentsList  +'~!~'+  $entry.SourceItemFolderPathNamesList  +'~!~'+  $entry.SourceFolderPathNamesList  +'~!~'+  $entry.ItemSubject  +'~!~'+  $entry.ItemAttachments  +'~!~'+  $entry.DirtyProperties  +'~!~'+  $entry.OriginatingServer 
            if($Operationddlist.Contains($ddoperation)){
                Continue
            }else{
                $Operationddlist.Add($ddoperation)
            }
	        Write-Host $ddoperation
        }

	    $uniqueuser=$entry.LogonUserDisplayName+'('+$entry.MailboxOwnerUPN+')'
	    if($activitys.Contains($oper))
	    {
		    $activitys[$oper]['count']++
		    if($activitys[$oper]['uniqueips'].Contains($entry.ClientIPAddress))
		    {
		    }
		    else
		    {
		        $null=$activitys[$oper]['uniqueips'].Add($entry.ClientIPAddress)
		    }
		    
		    

		    if($activitys[$oper]['uniqueusers'].Contains($uniqueuser))
		    {
		    }
		    else
		    {
		        $null=$activitys[$oper]['uniqueusers'].Add($uniqueuser)
		    }               
	    }
	    else
	    {
		$activitys[$oper]=@{}
		$activitys[$oper]['count']=1
		$activitys[$oper]['uniqueips'] = New-Object System.Collections.ArrayList
		$null=$activitys[$oper]['uniqueips'].Add($entry.ClientIPAddress)
		$activitys[$oper]['uniqueusers'] = New-Object System.Collections.ArrayList
		$null=$activitys[$oper]['uniqueusers'].Add($uniqueuser)
	    }       

	    }
	    
	    foreach($act in $activitys.Keys)
	    {
	    if($act -ne 'none'){
		Write-Host 'opertype##' $act 'count' $activitys[$act]['count']  

		$totalusers=""
		foreach($user in $activitys[$act]['uniqueusers'])
		{
		    $totalusers=$totalusers+', '+$user
		}
		Write-Host $act 'uniqueusercount'  $activitys[$act]['uniqueusers'].Count 'dd#' $totalusers 

		$totalips=""
		foreach($ip in $activitys[$act]['uniqueips'])
		{
		    $totalips=$totalips+', '+$ip
		}
		Write-Host  $act 'unquieipscount'  $activitys[$act]['uniqueips'].Count 'dd#' $totalips

		}
	    }
}
[System.GC]::GetTotalMemory($true) | out-null