﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

clear
[Net.ServicePointManager]::SecurityProtocol = [Net.SecurityProtocolType]::Tls12
$scriptPath = split-path -parent $MyInvocation.MyCommand.Definition
$egurkhaPath=($scriptPath.Substring(0,$scriptPath.ToLower().IndexOf('egurkha')+7)).Trim()
$mtmDir=$egurkhaPath+'\agent\MTM'
if(!(Test-Path -Path $mtmDir )){
    $null=New-Item -ItemType directory -Path $mtmDir
}

$WriteLog=$true
$isFrstTimLog=$true
$LogFile = $mtmDir+"\MTMCallQuality.log"
$LogFile1 = $mtmDir+"\MTMCallQuality1.log"
Function Write-Log {
	Param ([string]$string)
	[string]$date = Get-Date -Format G
    if ($WriteLog) {
       ( "[" + $date + "] - "+ $string ) | Out-File -FilePath $LogFile -Append } 
    if($isFrstTimLog){     
        if ($WriteLog -eq $true){ #if flag is true 
            if ([System.IO.File]::Exists($LogFile) -and (Get-Item $LogFile).length -gt 1mb) {  #if the size of file is greater than 1MB 
                if([System.IO.File]::Exists($LogFile1)){  #if logfile1 already exists, delete logfile1 
                    Remove-Item $LogFile1 
                }
                Rename-Item $LogFile $LogFile1 
            }
        }
        $isFrstTimLog=$false
    }
}
Write-Log("[INFO] ------------------------- MTMCALL CONNECTIVITY - START --------------------------------- ")
$metriInput=''
$nwAsses=Get-Childitem "C:\*\Microsoft Teams Network Assessment Tool" -Recurse
$nwrkAssessDir=$nwAsses.Directory[0].ToString()
Write-Log("[INFO] - Network Assesment Directory path is -->> "+$nwrkAssessDir)
$stdOutServiceConnCheck=$mtmDir+'\MTMServiceConnCheckDtlsStdOut.txt'
$stdOutQualityCheck=$mtmDir+'\MTMQualityCheckStdOut.txt'
$stdOutInfraConnCheck=$mtmDir+'\MTMInfraConnCheckStdOut.txt'
[System.GC]::GetTotalMemory($true) | out-null
#----------Call Details-------------
push-location $nwrkAssessDir
$exe=$nwrkAssessDir+'\NetworkAssessmentTool.exe'
#<#
Write-Log("[INFO] -  NetworkAssessmentTool path is -->> "+$exe)
Write-Log("[INFO] SERVICE_CONNECTIVITY_CHECK-START ------------------------------------------------------------------ ")
Write-Host '[SERVICE_CONNECTIVITY_CHECK-START]'
try {
    Start-Process -FilePath $exe -Wait -WindowStyle Hidden -RedirectStandardOutput $stdOutServiceConnCheck
    $cntnt=Get-Content -Path $stdOutServiceConnCheck

    for($sc=0;$sc -lt $cntnt.Length;$sc++) {
        Write-Log("[NetworkAssessmentTool] - content -->> "+$cntnt[$sc])
        #if($cntnt[$sc].StartsWith('Relay :')) {
            Write-Host $cntnt[$sc]
        #}
    }
} catch {
    Write-Error $_
}
Write-Host '[SERVICE_CONNECTIVITY_CHECK-END]'
Write-Log("[INFO] SERVICE_CONNECTIVITY_CHECK-END ------------------------------------------------------------------ ")
#>

#<#
$arg='/qualitycheck'
Write-Log("[qualitycheck] - exe -->> "+$exe+$arg)
Write-Log("[INFO] QUALITY_CHECK-START ------------------------------------------------------------------ ")
Write-Host '[QUALITY_CHECK-START]'
try {
    Start-Process -FilePath $exe -ArgumentList $arg -Wait -WindowStyle Hidden -RedirectStandardOutput $stdOutQualityCheck
    $cntnt=Get-Content -Path $stdOutQualityCheck

    for($qc=0;$qc -lt $cntnt.Length;$qc++) {
        Write-Log("[NetworkAssessmentTool] - content -->> "+$cntnt[$qc])
        Write-Host $cntnt[$qc]
    }
} catch {
    Write-Error $_
}
Write-Host '[QUALITY_CHECK-END]'
Write-Log("[INFO] QUALITY_CHECK-END ------------------------------------------------------------------ ")
#>

#<#
$arg='/infraconnectivitytest'
Write-Log("[infraconnectivitytest] - exe -->> "+$exe+$arg)
Write-Log("[INFO] INFRA_CONN_CHECK-START ------------------------------------------------------------------ ")
Write-Host '[INFRA_CONN_CHECK-START]'
try {
    Start-Process -FilePath $exe -ArgumentList $arg -Wait -WindowStyle Hidden -RedirectStandardOutput $stdOutInfraConnCheck
    $currYear = (Get-Date -Format yyyy) + '-'
    $cntnt=Get-Content -Path $stdOutInfraConnCheck

    for($ic=0;$ic -lt $cntnt.Length;$ic++) {
        Write-Log("[NetworkAssessmentTool] - content -->> "+$cntnt[$ic])
        if($cntnt[$ic].StartsWith($currYear)) {
            if($cntnt[$ic].Contains('[ERROR]')) {
                Write-Host $cntnt[$ic]
            }
        continue
        }
        Write-Host $cntnt[$ic].Trim()
    }
} catch {
    Write-Error $_
}
Write-Host '[INFRA_CONN_CHECK-END]'
Write-Log("[INFO] INFRA_CONN_CHECK-END ------------------------------------------------------------------ ")
#>
