﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue 

$spfarms            = get-spfarm

    foreach($spfarm in $spfarms) 
    {

        $spservers         = $spfarm.Servers

        $farmName          = $spfarm.Name            # Farm Name   
        $farmNeedsUpgrade  = $spfarm.NeedsUpgrade    # Farm requires upgrade?
        $farmStatus        = $spfarm.Status          # Status of the farm 
        #$farmServersCnt   = $spfarm.Count           # Number of farm Count
        $ServersCnt        = $spservers.Count        # Number of servers in the farm

        write-host "FARM_DETAILS=$farmName~$farmStatus~$farmNeedsUpgrade~$ServersCnt"


        foreach($spserver in $spservers) 
        {
            $spserver = get-spserver -Identity $spserver

            $spserverstatus = $spserver.Status

            if($spserverstatus -eq "Disabled")
            {
                $spserverstatus = "Offline"
            }

            $serverName = $spserver.Name
            $serverDispName = $spserver.DisplayName
            $serverRole = $spserver.Role
            $spserverCanUpgrade = $spserver.CanUpgrade
            $spserverNeedsUpgrade = $spserver.NeedsUpgrade

            write-host "SERVERS_STATUS=$farmName~$serverName~$serverDispName~$serverRole~$spserverstatus~$spserverCanUpgrade~$spserverNeedsUpgrade"
    


    
            #validation in case the server is Web Front end server

                $srv = Get-SPServiceInstance –Server $serverName | where-object {$_.TypeName –eq “Microsoft SharePoint Foundation Web Application” -and $_.Status –eq “Online”}
     
                foreach($cntWFEServers in  $srv) 
                {
                    write-host "WFESERVERS=$farmName~$serverName~$serverDispName~$serverRole~$spserverCanUpgrade~$spserverNeedsUpgrade"
                }

    
     
            #validation in case the server is Application server

                $APPSrv = Get-SPServiceInstance –Server $serverName | where-object { (($_.TypeName -ne "Microsoft SharePoint Foundation Incoming E-Mail" -and  $_.TypeName -ne " Microsoft SharePoint Foundation Workflow Timer Service" -and $_.TypeName –ne “Microsoft SharePoint Foundation Web Application” -and $_.Status –eq “online”)) -and ($_.TypeName –ne “Microsoft SharePoint Foundation Database”)}
                
                if($APPSrv.count -gt 0)
                {
                    write-host "APPSERVERS=$farmName~$serverName~$serverDispName~$serverRole~$spserverCanUpgrade~$spserverNeedsUpgrade"
                }

                $serviceinstances = $spserver.ServiceInstances
                foreach($serviceinstance in $serviceinstances)
                {
                    $serviceInsTypeName=$serviceinstance.TypeName
                    $serviceInsStatus=$serviceinstance.Status
                    
                    Write-Host "SERVICE_INSTANCE_STATUS=$farmName~$serverDispName~$serviceInsTypeName~$serviceInsStatus"
                }
           }
            #validation in case the server is Data Base server

            $DataBase=Get-SPDatabase | Select NormalizedDataSource | Get-Unique


             if($DataBase.NormalizedDataSource.Contains("\") )
             {
                $DATA=$DataBase.NormalizedDataSource.Split("\")

                write-host "DBSERVERS=$farmName~"$DATA[0]
             }
    
     }



Remove-PSSnapin Microsoft.Sharepoint.PowerShell


