﻿$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue

$TestInputs=$args

$TestFrequency=$TestInputs[0]


$TestFrequency=-1 * $TestFrequency/60

$StartTime = (Get-date).AddMinutes($TestFrequency)
$EndTime = (Get-Date)

 
$StartTime = $StartTime.ToUniversalTime()
$EndTime = $EndTime.ToUniversalTime()



 $output=Get-SPWebApplication | foreach {
    $p=$_.JobHistoryEntries |
        where{  ($StartTime -le $_.StartTime -and $_.StartTime -le $EndTime) -or
            ($StartTime -le $_.EndTime -and $_.EndTime -le $EndTime) } |
        sort StartTime |
        select  JobDefinitionTitle,
            WebApplicationName,
            ServerName,
            Status,
            StartTime,
            EndTime
           
            foreach($k in $p)
            {

            $Status=$k.Status
            $WebApplicationName=$k.WebApplicationName
            $JobDefinitionTitle=$k.JobDefinitionTitle
            $ServerName=$k.ServerName
            $StartTime=$k.StartTime
            $EndTime=$k.EndTime

            Write-host  $Status'~!~'$WebApplicationName'~!~'$JobDefinitionTitle'~!~'$ServerName'~!~'$StartTime'~!~'$EndTime
                       
            }
} 



Remove-PSSnapin Microsoft.SharePoint.PowerShell