$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Global:ErrorActionPreference="SilentlyContinue"
Add-PSSnapin Microsoft.Exchange.Management.PowerShell.SnapIn
$dbcopystatus = Get-MailboxDatabaseCopyStatus -Server $env:computername
if($dbcopystatus -ne $null)
{
	foreach($status in $dbcopystatus)
	{
		$dbName = $status.DatabaseName
		$state = $status.Status
		$MailboxServer = $status.MailboxServer
		$ActiveDatabaseCopy = $status.ActiveDatabaseCopy
		$ContentIndexState = $status.ContentIndexState
		$WorkerProcessId = $status.WorkerProcessId
		$DiskFreeSpacePercent = $status.DiskFreeSpacePercent
		$DiskFreeSpace = $status.DiskFreeSpace.ToMB()
		$DiskTotalSpace = $status.DiskTotalSpace.ToMB()
		$DatabaseVolumeMountPoint = $status.DatabaseVolumeMountPoint
		
		write-host($dbName,$state,$MailboxServer,$ActiveDatabaseCopy,$ContentIndexState,$WorkerProcessId,$DiskFreeSpacePercent,$DiskFreeSpace,$DiskTotalSpace,$DatabaseVolumeMountPoint) -Separator ";"
	}
}
Remove-PSSnapin Microsoft.Exchange.Management.PowerShell.SnapIn
