$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$argsCount = $args.length
if ($argsCount -eq 0)
{
	Write-Host "Please supply Server name"
	break
}

$ServerName = $args[0]
$Global:ErrorActionPreference="SilentlyContinue"
$svr = Get-ExchangeServer $ServerName 
$version = $svr.AdminDisplayVersion

$allmbs = Get-Mailbox -Server $ServerName -ResultSize unlimited

foreach ($amb in $allmbs)
{
	$stats = Get-MailboxStatistics -Identity $amb.DisplayName
	if ($amb.UseDatabaseQuotaDefaults -eq $true) #The quota is defined at Database level. 
	{
		if($version.Major -le 14) #Now look for lower version. 
		{
			$Limit1 = (Get-MailboxDatabase -Identity $amb.Database).ProhibitSendQuota
		}
		else #This is Exchange 2013 and higher
		{
			$Limit1 = $stats.DatabaseProhibitSendQuota
		}
	}		
	else #The quota is defined at Mailbox level
	{
		$Limit1 = $amb.ProhibitSendQuota
	}
	
	if($Limit1.IsUnlimited)
	{
		$quota = -2048 #This quota is unlimited
	}
	else
	{
		$quota = $Limit1.Value.ToKB()
	}
		
	$percent = 0
	
	$size = $stats.TotalItemSize.Value.ToKB()
	if($quota -gt 0)
	{
		$percent = ($size / $quota * 100)
	}
	else
	{
		$percent = -5
	}
	$logonTime = "N/A"
	$logoffTime = "N/A"
	$disconnectDate = "N/A"

	$disconnect = ($stats.DisconnectDate.ToString())
	if ($disconnect.length -gt 0)
	{
		$disconnectDate = $stats.DisconnectDate.ToString()
	}

	$logon = ($stats.Lastlogontime.ToString())
	if ($logon.length -gt 0)
	{
		$logonTime = $stats.Lastlogontime.ToString()
	}

	$logoff = ($stats.Lastlogofftime.ToString())
	if ($logoff.length -gt 0)
	{
		$logoffTime = $stats.Lastlogofftime.ToString()
	}

	Write-Host ($amb.ServerName,$amb.Database,$amb.Name,$amb.PrimarySmtpAddress,$stats.DeletedItemCount,$stats.TotalDeletedItemSize.Value.ToMB(),$stats.ItemCount,$size,$quota,$percent,$logonTime,$logoffTime,$disconnectDate) -Separator ";"
}
