$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$Global:ErrorActionPreference="SilentlyContinue"
$argsCount = $args.length
$Timeout = $args[0]
Add-PSSnapin Microsoft.Exchange.Management.PowerShell.SnapIn
 
$dbs = Get-MailboxDatabase -Server $env:computername
foreach($db in $dbs)
{
    $name = $db.Identity
    $result = Test-Mailflow -TargetDatabase $name -ExecutionTimeout:$Timeout
    Write-Host($name,$result.TestMailflowResult,$result.MessageLatencyTime) -separator ";"
}
 
Remove-PSSnapin Microsoft.Exchange.Management.PowerShell.SnapIn