$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}


Add-pssnapin "Citrix.Common.Commands"
Add-pssnapin "Citrix.Common.GroupPolicy"
Add-pssnapin "Citrix.Host.Admin.V1"
Add-pssnapin "Citrix.Broker.Admin.V1"
Add-pssnapin "Citrix.ADIdentity.Admin.V1"
Add-pssnapin "Citrix.Configuration.Admin.V1"
Add-pssnapin "Citrix.MachineCreation.Admin.V1"
Add-pssnapin "Citrix.MachineIdentity.Admin.V1"
Add-pssnapin "Citrix.LicensingConfig.Admin.V1"

Write-Host
Write-Host "Configuration - Site Wide Settings"
Write-Host "-------------------------------------"
Write-Host
$site = get-BrokerSite -EA 0
if($? -and $site)
{
	if($site.BaseOU -eq $null)
	{
		$ADOU = "-"
	}
	else
	{
		$ADOU = $site.BaseOU
	}
	
	Write-Host "Name : " $site.Name
	Write-Host "AD Organization Unit : " $ADOU
	Write-Host "DNS Resolution : " $site.DnsResolutionEnabled
	write-Host "Trust XML Service : " $site.TrustRequestsSentToTheXmlServicePort
	
}
$sitedb  = Get-BrokerDBConnection
if($sitedb)
{
	Write-Host "Datebase Connection String : " $sitedb
}
Write-Host 
Write-Host "Configuration\Administrators"
Write-Host "-------------------------------------"
Write-Host
$brokerAdmins = Get-BrokerAdministrator
if($? -and $brokerAdmins)
{
	foreach($brokerAdmin in $brokerAdmins)
	{
		if($brokerAdmin.CatalogNames)
		{
			$catalogNames = $brokerAdmin.CatalogNames
		}
		else
		{
			$catalogNames = "All Catalogs"
		}
		
		if($brokerAdmin.DesktopGroupNames)
		{
			$DesktopGroupNames = $brokerAdmin.DesktopGroupNames
		}
		else
		{
			$DesktopGroupNames = "All Desktop Groups"
		}
		
		$Roles = ""
		if($brokerAdmin.ProvisioningAdmin -eq "True")
		{
			$Roles = $Roles + " Machine"
		}		

		if($brokerAdmin.ReadOnly -eq "True")
		{
			$Roles = $Roles + " Readonly"
		}
		
		if($brokerAdmin.FullAdmin -eq "True")
		{
			$Roles = "Full"
		}
		
		Write-Host "Name : " $brokerAdmin.Name
		Write-Host "Enable this Administrator/Group : " $brokerAdmin.Enabled
		Write-Host "Catalogs : " $catalogNames
		Write-Host "Desktop Groups : " $DesktopGroupNames
		Write-Host "Roles : " $Roles
	}
}
Write-Host 
Write-Host "Configuration\Controllers"
Write-Host "-------------------------------------"
Write-Host
$controllers = Get-brokercontroller
if($? -and $controllers)
{
	foreach($controller in $controllers)
	{
		Write-Host "Name : " $controller.DNSName
		Write-Host "Controller Version : " $controller.ControllerVersion
		Write-Host "Registered desktops:" $controller.DesktopsRegistered
	}
}
Write-Host
Write-Host "Configuration\Hosts"
Write-Host "-------------------------------------"
Write-Host
$hyphosts = get-BrokerHypervisorConnection
if($? -and $hyphosts)
{
	foreach($hyphost in $hyphosts)
	{
		$a = "XDHyp:\Connections\"
		$b = $a + $hyphost.Name
		if((get-hypxenserveraddress -LiteralPath $b).length -gt 0)
		{
			$ipAddress = get-hypxenserveraddress -LiteralPath $b
		}
		else
		{
			$ipAddress = "-"
		}
		Write-Host "Name : " $hyphost.Name
		Write-Host "Addresses : " $ipAddress
		Write-Host "Perferred Controller : " $hyphost.PreferredController
		Write-Host "State : " $hyphost.State
		 
	}

}

Write-Host
Write-Host "Configuaration\Licensing"
Write-Host "-------------------------------------"
Write-Host
Write-Host "License Server Name : " $site.LicenseServerName
Write-Host "License Server Port : " $site.LicenseServerPort
Write-Host "Edition : " $site.DesktopLicenseEdition
Write-Host "Model : " $site.DesktopLicenseModel

Write-Host
Write-Host "XenDesktop Licenses"
Write-Host
$licenses = get-licinventory -adminaddress $site.LicenseServerName
if($licenses)
{
	foreach($license in $licenses)
	{
		Write-Host "Product Name : " $license.LocalizedLicenseProductName
		Write-Host "Model : " $license.LocalizedLicenseModel
		Write-Host "Expiration Date : " $license.LicenseExpirationDate
		Write-Host "Subscription Advantage Date : " $license.LicenseSubscriptionAdvantageDate
		Write-Host "License Type : " $license.LicenseType
		Write-Host "Total : " $license.LicensesAvailable 
	}

}
Write-Host
Write-Host "Catalogs configuration"
Write-Host "-------------------------------------"
Write-Host
$catalogs = get-brokercatalog -EA 0 -MaxRecordCount 2147483647
if($? -and $catalogs)
{
	foreach($catalog in $catalogs)
	{
		$catalogAdmins = $catalog.AdministratorNames
		Write-Host "Name : " $catalog.Name
		Write-Host "Allocation Type : " $catalog.AllocationType
		if($catalogAdmins)
		{
			Write-Host "Administrators assigned to catalog : " $catalogAdmins
		}
		else
		{
			$brokerAdmins = Get-BrokerAdministrator
			if($? -and $brokerAdmins)
			{
				$admins = ""
				Write-Host "Administrators assigned to catalog : " -nonewline
				foreach($brokerAdmin in $brokerAdmins)
				{
					 $admins = $admins + " " + $brokerAdmin.Name
				}
				Write-Host $admins
			}
		}
		Write-Host "Catalog Kind : " $catalog.CatalogKind
		Write-Host "Provisioning Server Address : " $catalog.PvsAddress
		Write-Host "Provisioning server Domain : " $catalog.PvsDomain
	}


}
Write-Host
Write-Host "Desktop groups configuration"
Write-Host "-------------------------------------"
Write-Host
$desktopGroups = get-brokerdesktopgroup -EA 0 -MaxRecordCount 2147483647
if($? -and $desktopGroups)
{
	foreach($group in $desktopGroups)
	{
		$gadmins = $group.AdministratorNames
		Write-Host "Name : " $group.Name
		if($gadmins)
		{
			Write-Host "Administrators assigned to desktop group: " $gadmins
		}
		else
		{
			$brokerAdmins = Get-BrokerAdministrator
			if($? -and $brokerAdmins)
			{
				$admins = ""
				Write-Host "Administrators assigned to desktop group : " -nonewline
				foreach($brokerAdmin in $brokerAdmins)
				{
					 $admins = $admins + " " + $brokerAdmin.Name
				}
				Write-Host $admins
			}
		}		
		Write-Host "Desktop Kind : " $group.DesktopKind
		Write-Host "Maintenance Mode : " $group.InMaintenanceMode
		Write-Host "Automatic poweredon for assigned users : " $group.AutomaticPowerOnForAssigned
		Write-Host "Shutdown desktops after use : " $group.ShutdownDesktopsAfterUse
		Write-Host "Display Names : " $group.PublishedName
		Write-Host "Enabled : " $group.Enabled
		Write-Host "Color depth : " $group.ColorDepth
		Write-Host "Time Zone : " $group.TimeZone
		Write-Host "Enable Secure ICA : " $group.SecureIcaRequired
		Write-Host "OffPeak BufferSize Percent : " $group.OffPeakBufferSizePercent
		Write-Host "OffPeak Disconnect Action : " $group.OffPeakDisconnectAction
		Write-Host "OffPeak Disconnect Timeout : " $group.OffPeakDisconnectTimeout
		Write-Host "OffPeak Extended Disconnect Action  : " $group.OffPeakExtendedDisconnectAction
		Write-Host "OffPeak Extended Disconnect Timeout : " $group.OffPeakExtendedDisconnectTimeout
		Write-Host "OffPeak Logoff Action : " $group.OffPeakLogOffAction
		Write-Host "OffPeak Logoff Timeout : " $group.OffPeakLogOffTimeout
		Write-Host "Peak BufferSize Percent : " $group.PeakBufferSizePercent
		Write-Host "Peak Disconnect Action : " $group.PeakDisconnectAction
		Write-Host "Peak Disconnect Timeout : " $group.PeakDisconnectTimeout			
		Write-Host "Peak Extended Disconnect Action : " $group.PeakExtendedDisconnectAction
		Write-Host "Peak Extended Disconnect Timeout : " $group.PeakExtendedDisconnectTimeout
		Write-Host "Peak Logoff Action : " $group.PeakLogOffAction          
		Write-Host "Peal Logoff Timeout : " $group.PeakLogOffTimeout
		$userpolicy = get-brokerassignmentpolicyrule -DesktopGroupUid $group.Uid
		$tusers  = ""
		if($? -and $userpolicy)
		{
			Write-Host "Users selected to this group : "  -nonewline
			$users = $userpolicy.IncludedUsers
			foreach($user in $users)
			{
				$tusers  = $tusers + " " + $user.Name		
			}
			Write-host $tusers
			Write-Host "Desktops per user : " $userpolicy.MaxDesktops
		}

		
		
	}

}

Write-Host
Write-Host "VDI machines"
Write-Host "------------------"
Write-Host
$catalogs = get-brokercatalog -EA 0 -MaxRecordCount 2147483647
if($? -and $catalogs)
{
	foreach($catalog in $catalogs)
	{
		$brokerMachines = get-brokermachine -catalogname $catalog.Name -EA 0 -MaxRecordCount 5000
		if($? -and $brokerMachines)
		{
			foreach ($brokermachine in $brokerMachines)
			{
			    $desktopgroup = get-brokerdesktopgroup -uid $brokermachine.desktopuid
				if($desktopgroup)
				{
					Write-Host "Desktop group name : " $desktopgroup.Name
				}
				else
				{
					Write-Host "Desktop group name : - "
				}	
				Write-Host "Catalog name : " $brokermachine.CatalogName
				Write-Host "Catalog Kind : " $brokermachine.CatalogKind
				Write-Host "DNS Name : " $brokermachine.DNSName
				Write-Host "Registration State : " $brokermachine.RegistrationState
				Write-Host "Hosted Machine name : " $brokermachine.HostedMachineName
				Write-Host "Machine name : " $brokermachine.MachineName
				Write-Host "Hypervisor Connection Name : " $brokermachine.Hypervisorconnectionname
				Write-Host "Is assigned to user : " $brokermachine.IsAssigned
				if($brokermachine.IsAssigned)
				{
					Write-Host "Assigned to users : " $brokermachine.AssociatedUserNames
				}
				else
				{
					Write-Host "Assigned to users : - "
				}
				Write-Host "Power Action Pending : " $brokermachine.PowerActionPending
				Write-Host "Power State : " $brokermachine.PowerState
				Write-Host "PVD Stage : " $brokermachine.pvdstage
				Write-Host "Will Shutdown after use : " $brokermachine.WillShutdownAfterUse
		
			}
		}	
	}
}	

Write-Host
Write-Host "HDX Policy\Machine policies"
Write-Host "-----------------------------"
Write-Host 
Set-Location LocalGpo:\Computer\Unfiltered\Settings
$a = get-itemproperty ICA\IcaListenerPortNumber
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\ICA Listener Port Number : " $a.Value
}
$a = get-itemproperty ICA\IcaListenerTimeout
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\ICA Listener connection timeout : " $a.Value
}
$a = get-itemproperty Licensing\LicenseServerHostName
if($a.state -ne "NotConfigured")
{
	Write-host "Licensing\License Server Host Name : " $a.Value
}
$a = get-itemproperty Licensing\LicenseServerPort
if($a.state -ne "NotConfigured")
{
	Write-host "Licensing\License Server Port : " $a.Value
}
$a = get-itemproperty PowerAndCapacityManagement\FarmName
if($a.state -ne "NotConfigured")
{
	Write-host "PowerAndCapacityManagement\Farm Name : " $a.Value
}
$a = get-itemproperty PowerAndCapacityManagement\WorkLoadName
if($a.state -ne "NotConfigured")
{
	Write-host "PowerAndCapacityManagement\Work Load Name : " $a.Value
}


$a = get-itemproperty ServerSettings\ConnectionAccessControl
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\Connection Access Control : " $a.Value
}

$a = get-itemproperty ServerSettings\DNSAddressResolution
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\DNS Address Resolution: " $a.Value
}

$a = get-itemproperty ServerSettings\FullIconCaching
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\Full Icon Caching : " $a.Value
}

$a = get-itemproperty ServerSettings\InitialZone
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\Initial Zone : " $a.Value
}

$a = get-itemproperty ServerSettings\LoadEvaluator
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\Load Evaluator : " $a.Value
}

$a = get-itemproperty ServerSettings\ProductEdition
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\Product Edition : " $a.Value
}

$a = get-itemproperty ServerSettings\ProductModel
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\Product Model: " $a.Value
}

$a = get-itemproperty ServerSettings\Connectionlimits\UserSessionLimit
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\Connectionlimits\User Session Limit : " $a.Value
}

$a = get-itemproperty ServerSettings\Connectionlimits\UserSessionLimitAffectsAdministrators
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\Connectionlimits\User Session Limit Affects Administrators : " $a.Value
}
$a = get-itemproperty ServerSettings\Connectionlimits\UserSessionLimitLogging
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\Connectionlimits\User Session Limit Logging : " $a.Value
}

$a = get-itemproperty ServerSettings\DatabaseSettings\InitialDatabaseName
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\DatabaseSettings\Initial Database Name : " $a.Value
}

$a = get-itemproperty ServerSettings\DatabaseSettings\InitialDatabaseServerName
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\DatabaseSettings\Initial Database Server Name : " $a.Value
}

$a = get-itemproperty ServerSettings\DatabaseSettings\InitialFailoverPartner
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\DatabaseSettings\Initial Failover Partner : " $a.Value
}

$a = get-itemproperty ServerSettings\HealthMonitoringAndRecovery\HealthMonitoring
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\HealthMonitoriongAndRecovery\Health Monitoring : " $a.Value
}

$a = get-itemproperty ServerSettings\HealthMonitoringAndRecovery\HealthMonitoringTests
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\HealthMonitoriongAndRecovery\Health Monitoring Tests: " $a.Value
}

$a = get-itemproperty ServerSettings\HealthMonitoringAndRecovery\MaximumServersOfflinePercent
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\HealthMonitoriongAndRecovery\Maximum Servers Offline Percent : " $a.Value
}

$a = get-itemproperty ServerSettings\MemoryCPU\CpuManagementServerLevel
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\MemoryCPU\Cpu Management Server Level : " $a.Value
}

$a = get-itemproperty ServerSettings\MemoryCPU\MemoryOptimization
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\MemoryCPU\Memory Optimization : " $a.Value
}

$a = get-itemproperty ServerSettings\MemoryCPU\MemoryOptimizationDayOfMonth
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\MemoryCPU\Memory Optimization Day of month : " $a.Value
}

$a = get-itemproperty ServerSettings\MemoryCPU\MemoryOptimizationDayOfWeek
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\MemoryCPU\Memory Optimization Day of week : " $a.Value
}

$a = get-itemproperty ServerSettings\MemoryCPU\MemoryOptimizationExcludedPrograms
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\MemoryCPU\Memory Optimization Excluded Programs : " $a.Value
}

$a = get-itemproperty ServerSettings\MemoryCPU\MemoryOptimizationIntervalType
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\MemoryCPU\Memory Optimization Interval Type : " $a.Value
}

$a = get-itemproperty ServerSettings\MemoryCPU\MemoryOptimizationTime
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\MemoryCPU\Memory Optimization Time : " $a.Value
}

$a = get-itemproperty ServerSettings\OfflineApplications\OfflineClientTrust
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\OfflineApplications\Offline Client Trust : " $a.Value
}

$a = get-itemproperty ServerSettings\OfflineApplications\OfflineEventLogging
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\OfflineApplications\Offline Event Logging : " $a.Value
}

$a = get-itemproperty ServerSettings\OfflineApplications\OfflineLicensePeriod
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\OfflineApplications\Offline License Period : " $a.Value
}

$a = get-itemproperty ServerSettings\OfflineApplications\OfflineUsers
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\OfflineApplications\Offline Users : " $a.Value
}


$a = get-itemproperty ServerSettings\RebootBehavior\RebootCustomMessage
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\RebootBehavior\Reboot Custom Message : " $a.Value
}

$a = get-itemproperty ServerSettings\RebootBehavior\RebootCustomMessageText
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\RebootBehavior\Reboot Custom Message Text: " $a.Value
}

$a = get-itemproperty ServerSettings\RebootBehavior\RebootDisableLogonTime
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\RebootBehavior\Reboot Disable Logon Time : " $a.Value
}

$a = get-itemproperty ServerSettings\RebootBehavior\RebootScheduleFrequency
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\RebootBehavior\Reboot Schedule Frequency : " $a.Value
}

$a = get-itemproperty ServerSettings\RebootBehavior\RebootScheduleRandomizationInterval
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\RebootBehavior\Reboot Schedule Randomization Interval : " $a.Value
}

$a = get-itemproperty ServerSettings\RebootBehavior\RebootScheduleStartDate
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\RebootBehavior\Reboot Schedule Start Date : " $a.Value
}

$a = get-itemproperty ServerSettings\RebootBehavior\RebootScheduleTime
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\RebootBehavior\Reboot Schedule Time : " $a.Value
}

$a = get-itemproperty ServerSettings\RebootBehavior\RebootWarningInterval
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\RebootBehavior\Reboot Warning Interval : " $a.Value
}

$a = get-itemproperty ServerSettings\RebootBehavior\RebootWarningMessage
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\RebootBehavior\Reboot Warning Message : " $a.Value
}

$a = get-itemproperty ServerSettings\RebootBehavior\RebootWarningStartTime
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\RebootBehavior\Reboot Warning Start Time : " $a.Value
}

$a = get-itemproperty ServerSettings\RebootBehavior\ScheduledReboots
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSettings\RebootBehavior\Scheduled Reboots : " $a.Value
}

$a = get-itemproperty VirtualDesktopAgent\ControllerRegistrationPort
if($a.state -ne "NotConfigured")
{
	Write-host "VirtualDesktopAgent\Controller Registration Port : " $a.Value
}

$a = get-itemproperty VirtualDesktopAgent\Controllers
if($a.state -ne "NotConfigured")
{
	Write-host "VirtualDesktopAgent\Controllers : " $a.Value
}

$a = get-itemproperty VirtualDesktopAgent\ControllerSIDs
if($a.state -ne "NotConfigured")
{
	Write-host "VirtualDesktopAgent\Controller SIDs : " $a.Value
}

$a = get-itemproperty VirtualDesktopAgent\SiteGUID
if($a.state -ne "NotConfigured")
{
	Write-host "VirtualDesktopAgent\Site GUID : " $a.Value
}

$a = get-itemproperty VirtualDesktopAgent\CpuUsageMonitoring\CPUUsageMonitoring_Enable
if($a.state -ne "NotConfigured")
{
	Write-host "VirtualDesktopAgent\CpuUsageMonitoring\CPU Usage Monitoring Enable : " $a.Value
}

$a = get-itemproperty VirtualDesktopAgent\CpuUsageMonitoring\CPUUsageMonitoring_Period
if($a.state -ne "NotConfigured")
{
	Write-host "VirtualDesktopAgent\CpuUsageMonitoring\CPU Usage Monitoring Period : " $a.Value
}

$a = get-itemproperty VirtualDesktopAgent\CpuUsageMonitoring\CPUUsageMonitoring_Threshold
if($a.state -ne "NotConfigured")
{
	Write-host "VirtualDesktopAgent\CpuUsageMonitoring\CPU Usage Monitoring Threshold : " $a.Value
}

$a = get-itemproperty VirtualIP\EnhancedCompatibility
if($a.state -ne "NotConfigured")
{
	Write-host "VirtualIP\Enhanced Compatibility : " $a.Value
}

$a = get-itemproperty VirtualIP\EnhancedCompatibilityPrograms
if($a.state -ne "NotConfigured")
{
	Write-host "VirtualIP\Enhanced Compatibility Programs: " $a.Value
}

$a = get-itemproperty VirtualIP\FilterAdapterAddresses
if($a.state -ne "NotConfigured")
{
	Write-host "VirtualIP\Filter Adapter Addresses : " $a.Value
}

$a = get-itemproperty VirtualIP\FilterAdapterAddressesPrograms
if($a.state -ne "NotConfigured")
{
	Write-host "VirtualIP\Filter Adapter Addresses Programs : " $a.Value
}

$a = get-itemproperty VirtualIP\VirtualLoopbackPrograms
if($a.state -ne "NotConfigured")
{
	Write-host "VirtualIP\Virtual Loop back programs : " $a.Value
}

$a = get-itemproperty VirtualIP\VirtualLoopbackSupport
if($a.state -ne "NotConfigured")
{
	Write-host "VirtualIP\Virtual Loop back Support : " $a.Value
}

$a = get-itemproperty XMLService\TrustXMLRequests
if($a.state -ne "NotConfigured")
{
	Write-host "XMLService\Trust XML Requests : " $a.Value
}

$a = get-itemproperty XMLService\XMLServicePort
if($a.state -ne "NotConfigured")
{
	Write-host "XMLService\XML Service Port : " $a.Value
}

Write-Host
Write-Host "HDX Policy\User policies"
Write-Host "-----------------------------"
Write-Host 
Set-Location LocalGpo:\User\Unfiltered\Settings
$a = get-itemproperty ICA\ClipboardRedirection
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Clipboard Redirection : " $a.Value
}

$a = get-itemproperty ICA\DesktopLaunchForNonAdmins
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Desktop Launch For Non Admins : " $a.Value
}

$a = get-itemproperty ICA\NonPublishedProgramLaunching
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Non Published Program Launching: " $a.Value
}

$a = get-itemproperty ICA\AdobeFlashDelivery\HDXMediaStreamForFlash\FlashAcceleration
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\AdobeFlashDelivery\HDXMediaStreamForFlash\Flash Acceleration: " $a.Value
}

$a = get-itemproperty ICA\AdobeFlashDelivery\HDXMediaStreamForFlash\FlashBackwardsCompatibility
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\AdobeFlashDelivery\HDXMediaStreamForFlash\Flash backwards compatibility: " $a.Value
}

$a = get-itemproperty ICA\AdobeFlashDelivery\HDXMediaStreamForFlash\FlashDefaultBehavior
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\AdobeFlashDelivery\HDXMediaStreamForFlash\Flash Default Behavior: " $a.Value
}

$a = get-itemproperty ICA\AdobeFlashDelivery\HDXMediaStreamForFlash\FlashEventLogging
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\AdobeFlashDelivery\HDXMediaStreamForFlash\Flash Event Logging: " $a.Value
}
$a = get-itemproperty ICA\AdobeFlashDelivery\HDXMediaStreamForFlash\FlashIntelligentFallback
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\AdobeFlashDelivery\HDXMediaStreamForFlash\Flash Intelligent Fallback : " $a.Value
}

$a = get-itemproperty ICA\AdobeFlashDelivery\HDXMediaStreamForFlash\FlashLatencyThreshold
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\AdobeFlashDelivery\HDXMediaStreamForFlash\Flash Latency Threshold : " $a.Value
}

$a = get-itemproperty ICA\AdobeFlashDelivery\HDXMediaStreamForFlash\FlashServerSideContentFetchingWhitelist
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\AdobeFlashDelivery\HDXMediaStreamForFlash\Flash Server Side Content Fetching Whitelist : " $a.Value
}

$a = get-itemproperty ICA\AdobeFlashDelivery\HDXMediaStreamForFlash\FlashUrlColorList
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\AdobeFlashDelivery\HDXMediaStreamForFlash\Flash Url Color List : " $a.Value
}

$a = get-itemproperty ICA\AdobeFlashDelivery\HDXMediaStreamForFlash\FlashUrlCompatibilityList
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\AdobeFlashDelivery\HDXMediaStreamForFlash\Flash Url Compatibility List : " $a.Value
}

$a = get-itemproperty ICA\AdobeFlashDelivery\HDXMultimediaForFlash\AllowSpeedFlash
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\AdobeFlashDelivery\HDXMultimediaForFlash\Allow Speed Flash : " $a.Value
}

$a = get-itemproperty ICA\Audio\AllowRtpAudio
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Audio\Allow RPt Audio : " $a.Value
}

$a = get-itemproperty ICA\Audio\AudioPlugNPlay
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Audio\Audio Plug N Play : " $a.Value
}

$a = get-itemproperty ICA\Audio\AudioQuality
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Audio\Audio Quality : " $a.Value
}

$a = get-itemproperty ICA\Audio\ClientAudioRedirection
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Audio\Client Audio Redirection : " $a.Value
}

$a = get-itemproperty ICA\Audio\MicrophoneRedirection
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Audio\Microphone Redirection : " $a.Value
}

$a = get-itemproperty ICA\Bandwidth\AudioBandwidthLimit
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Bandwidth\Audio Bandwidth Limit : " $a.Value
}

$a = get-itemproperty ICA\Bandwidth\AudioBandwidthPercent
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Bandwidth\Audio Bandwidth Percent : " $a.Value
}

$a = get-itemproperty ICA\Bandwidth\ClipboardBandwidthlimit
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Bandwidth\Clipboard Bandwidth Limit : " $a.Value
}

$a = get-itemproperty ICA\Bandwidth\ClipboardBandwidthPercent
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Bandwidth\Clipboard Bandwidth Percent : " $a.Value
}

$a = get-itemproperty ICA\Bandwidth\ComPortBandwidthLimit
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Bandwidth\Com Port Bandwidth Limit : " $a.Value
}

$a = get-itemproperty ICA\Bandwidth\ComPortBandwidthPercent
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Bandwidth\Com Port Bandwidth Percent : " $a.Value
}

$a = get-itemproperty ICA\Bandwidth\FileRedirectionBandwidthLimit
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Bandwidth\File Redirection Bandwidth Limit : " $a.Value
}

$a = get-itemproperty ICA\Bandwidth\FileRedirectionBandwidthPercent
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Bandwidth\File Redirection Bandwidth Percent : " $a.Value
}

$a = get-itemproperty ICA\Bandwidth\HDXMultimediaBandwidthLimit
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Bandwidth\HDX Multimedia Bandwidth Limit : " $a.Value
}

$a = get-itemproperty ICA\Bandwidth\HDXMultimediaBandwidthPercent
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Bandwidth\HDX Multimedia Bandwidth Percent : " $a.Value
}

$a = get-itemproperty ICA\Bandwidth\LptBandwidthLimit
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Bandwidth\LPT Bandwidth Limit : " $a.Value
}

$a = get-itemproperty ICA\Bandwidth\LptBandwidthLimitPercent
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Bandwidth\LPT Bandwidth Limit Percent : " $a.Value
}

$a = get-itemproperty ICA\Bandwidth\OverallBandwidthLimit
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Bandwidth\Overall Bandwidth Limit : " $a.Value
}

$a = get-itemproperty ICA\Bandwidth\PrinterBandwidthLimit
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Bandwidth\Printer Bandwidth Limit : " $a.Value
}

$a = get-itemproperty ICA\Bandwidth\PrinterBandwidthPercent
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Bandwidth\Printer Bandwidth Percent : " $a.Value
}

$a = get-itemproperty ICA\Bandwidth\TwainBandwidthLimit
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Bandwidth\Twain Bandwidth Limit : " $a.Value
}

$a = get-itemproperty ICA\Bandwidth\TwainBandwidthPercent
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Bandwidth\Twain Bandwidth Percent : " $a.Value
}

$a = get-itemproperty ICA\Bandwidth\USBBandwidthLimit
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Bandwidth\USB Bandwidth Limit : " $a.Value
}

$a = get-itemproperty ICA\Bandwidth\USBBandwidthPercent
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Bandwidth\USB Bandwidth Percent : " $a.Value
}

$a = get-itemproperty ICA\DesktopUI\AeroRedirection
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\DesktopUI\Aero Redirection : " $a.Value
}

$a = get-itemproperty ICA\DesktopUI\DesktopWallpaper
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\DesktopUI\Desktop Wallpaper : " $a.Value
}

$a = get-itemproperty ICA\DesktopUI\GraphicsQuality
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\DesktopUI\Graphics Quality : " $a.Value
}

$a = get-itemproperty ICA\DesktopUI\MenuAnimation
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\DesktopUI\Menu Animation: " $a.Value
}

$a = get-itemproperty ICA\DesktopUI\WindowContentsVisibleWhileDragging
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\DesktopUI\Window Contents Visible While Dragging : " $a.Value
}

$a = get-itemproperty ICA\FileRedirection\AsynchronousWrites
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\FileRedirection\Asynchronous Writes : " $a.Value
}

$a = get-itemproperty ICA\FileRedirection\AutoConnectDrives
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\FileRedirection\Auto Connect Drives : " $a.Value
}

$a = get-itemproperty ICA\FileRedirection\ClientDriveLetterPreservation
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\FileRedirection\ClientDriveLetterPreservation : " $a.Value
}

$a = get-itemproperty ICA\FileRedirection\ClientDriveRedirection
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\FileRedirection\ClinetDriveRedirection : " $a.Value
}

$a = get-itemproperty ICA\FileRedirection\ClientFixedDrives
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\FileRedirection\Client Fixed Drives : " $a.Value
}

$a = get-itemproperty ICA\FileRedirection\ClientFloppyDrives
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\FileRedirection\Client Floopy Drives : " $a.Value
}

$a = get-itemproperty ICA\FileRedirection\ClientNetworkDrives
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\FileRedirection\Client Network Drives : " $a.Value
}

$a = get-itemproperty ICA\FileRedirection\ClientOpticalDrives
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\FileRedirection\Client Optical Drives : " $a.Value
}

$a = get-itemproperty ICA\FileRedirection\ClientRemoveableDrives
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\FileRedirection\Client Removeable Drives : " $a.Value
}

$a = get-itemproperty ICA\FileRedirection\HostToClientRedirection
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\FileRedirection\Host To Client Redirection : " $a.Value
}

$a = get-itemproperty ICA\FileRedirection\ReadOnlyMappedDrive
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\FileRedirection\ReadOnly Mapped Drive : " $a.Value
}

$a = get-itemproperty ICA\FileRedirection\SpecialFolderRedirection
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\FileRedirection\Special Folder Redirection : " $a.Value
}

$a = get-itemproperty ICA\MSI\MultiStream
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\MSI\Multi Stream : " $a.Value
}

$a = get-ItemProperty ICA\Ports\ClientComPortRedirection
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Ports\Client ComPort Redirection : " $a.Value
}

$a = get-ItemProperty ICA\Ports\ClientComPortsAutoConnection
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Ports\Client ComPorts Auto Connection : " $a.Value
}

$a = get-ItemProperty ICA\Ports\ClientLptPortRedirection
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Ports\Client LptPort Redirection : " $a.Value
}

$a = get-ItemProperty ICA\Ports\ClientLptPortsAutoConnection
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Ports\Client LptPorts Auto Connection : " $a.Value
}

$a = get-ItemProperty ICA\Printing\AutoCreationEventLogPreference
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Printing\Auto Creation Event Log Preference : " $a.Value
}

$a = get-ItemProperty ICA\Printing\ClientPrinterRedirection
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Printing\Client Printer Redirection : " $a.Value
}

$a = get-ItemProperty ICA\Printing\DefaultClientPrinter
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Printing\Default Client Printer : " $a.Value
}

$a = get-ItemProperty ICA\Printing\SessionPrinters
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Printing\Session Printers : " $a.Value
}

$a = get-ItemProperty ICA\Printing\WaitForPrintersToBeCreated
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Printing\Wait For Printers To Be Created : " $a.Value
}

$a = get-ItemProperty ICA\Printing\ClientPrinters\ClientPrinterAutoCreation
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Printing\ClientPrinters\Client Printer Auto Creation : " $a.Value
}

$a = get-ItemProperty ICA\Printing\ClientPrinters\ClientPrinterNames
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Printing\ClientPrinters\Client Printer Names : " $a.Value
}

$a = get-ItemProperty ICA\Printing\ClientPrinters\DirectConnectionsToPrintServers
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Printing\ClientPrinters\Direct Connections To Print Servers : " $a.Value
}

$a = get-ItemProperty ICA\Printing\ClientPrinters\GenericUniversalPrinterAutoCreation
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Printing\ClientPrinters\Generic Universal Printer Auto Creation : " $a.Value
}

$a = get-ItemProperty ICA\Printing\ClientPrinters\PrinterDriverMappings
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Printing\ClientPrinters\Printer Driver Mappings : " $a.Value
}

$a = get-ItemProperty ICA\Printing\ClientPrinters\PrinterPropertiesRetention
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Printing\ClientPrinters\Printer Properties Retention : " $a.Value
}

$a = get-ItemProperty ICA\Printing\ClientPrinters\RetainedAndRestoredClientPrinters
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Printing\ClientPrinters\Retained And Restored Client Printers : " $a.Value
}

$a = get-ItemProperty ICA\Printing\Drivers\InboxDriverAutoInstallation
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Printing\Drivers\Inbox Driver Auto Installation : " $a.Value
}

$a = get-ItemProperty ICA\Printing\Drivers\UniversalDriverPriority
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Printing\Drivers\Universal Driver Priority : " $a.Value
}

$a = get-ItemProperty ICA\Printing\Drivers\UniversalPrintDriverUsage
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Printing\Drivers\Universal Print Driver Usage : " $a.Value
}

$a = get-ItemProperty ICA\Printing\UniversalPrinting\DPILimit
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Printing\UniversalPrinting\DPI Limit : " $a.Value
}

$a = get-ItemProperty ICA\Printing\UniversalPrinting\EMFProcessingMode
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Printing\UniversalPrinting\EMF Processing Mode : " $a.Value
}

$a = get-ItemProperty ICA\Printing\UniversalPrinting\ImageCompressionLimit
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Printing\UniversalPrinting\Image Compression Limit : " $a.Value
}

$a = get-ItemProperty ICA\Printing\UniversalPrinting\UniversalPrintingPreviewPreference
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Printing\UniversalPrinting\Universal Printing Preview Preference : " $a.Value
}

$a = get-ItemProperty ICA\Printing\UniversalPrinting\UPDCompressionDefaults
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Printing\UniversalPrinting\UPD Compression Defaults: " $a.Value
}

$a = get-ItemProperty ICA\Security\MinimumEncryptionLevel
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Security\Minimum Encryption Level: " $a.Value
}

$a = get-ItemProperty ICA\SessionLimits\ConCurrentLogonLimit
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\SessionLimits\Concurrent Logon Limit: " $a.Value
}

$a = get-ItemProperty ICA\SessionLimits\LingerDisconnectTimerInterval
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\SessionLimits\Linger Disconnect Timer Interval: " $a.Value
}

$a = get-ItemProperty ICA\SessionLimits\LingerTerminateTimerInterval
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\SessionLimits\Linger Terminate Timer Interval: " $a.Value
}

$a = get-ItemProperty ICA\SessionLimits\PrelaunchDisconnectTimerInterval
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\SessionLimits\Prelaunch Disconnect Timer Interval: " $a.Value
}

$a = get-ItemProperty ICA\SessionLimits\PrelaunchTerminateTimerInterval
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\SessionLimits\Prelaunch Terminate Timer Interval: " $a.Value
}

$a = get-ItemProperty ICA\SessionLimits\SessionConnectionTimer
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\SessionLimits\Session Connection Timer: " $a.Value
}

$a = get-ItemProperty ICA\SessionLimits\SessionConnectionTimerInterval
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\SessionLimits\Session Connection Timer Interval: " $a.Value
}

$a = get-ItemProperty ICA\SessionLimits\SessionDisconnectTimer
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\SessionLimits\Session Disconnect Timer: " $a.Value
}

$a = get-ItemProperty ICA\SessionLimits\SessionDisconnectTimerInterval
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\SessionLimits\Session Disconnect Timer Interval: " $a.Value
}

$a = get-ItemProperty ICA\SessionLimits\SessionIdleTimer
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\SessionLimits\Session Idle Timer: " $a.Value
}

$a = get-ItemProperty ICA\SessionLimits\SessionIdleTimerInterval
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\SessionLimits\Session Idle Timer Interval: " $a.Value
}

$a = get-ItemProperty ICA\Shadowing\ShadowAllowList
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Shadowing\Shadow Allow Limit: " $a.Value
}

$a = get-ItemProperty ICA\Shadowing\ShadowDenyList
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Shadowing\Shadow Deny Limit: " $a.Value
}

$a = get-ItemProperty ICA\Shadowing\ShadowInput
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Shadowing\Shadow Input: " $a.Value
}

$a = get-ItemProperty ICA\Shadowing\ShadowLogging
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Shadowing\Shadow Logging: " $a.Value
}

$a = get-ItemProperty ICA\Shadowing\ShadowUserNotification
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\Shadowing\Shadow User Notification: " $a.Value
}

$a = get-ItemProperty ICA\TimeZoneControl\LocalTimeEstimation
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\TimeZoneControl\Local Time Estimation: " $a.Value
}

$a = get-ItemProperty ICA\TimeZoneControl\SessionTimeZone
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\TimeZoneControl\Session TimeZone: " $a.Value
}

$a = get-ItemProperty ICA\TwainDevices\TwainCompressionLevel
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\TwainDevices\Twain Compression Level : " $a.Value
}

$a = get-ItemProperty ICA\TwainDevices\TwainRedirection
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\TwainDevices\Twain Redirection :  " $a.Value
}

$a = get-ItemProperty ICA\USBDevices\UsbDeviceRedirection
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\USBDevices\Usb Device Redirection :  " $a.Value
}

$a = get-ItemProperty ICA\USBDevices\UsbDeviceRedirectionRules
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\USBDevices\Usb Device Redirection Rules :  " $a.Value
}

$a = get-ItemProperty ICA\USBDevices\UsbPlugAndPlayRedirection
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\USBDevices\Usb PlugAndPlay Redirection :  " $a.Value
}

$a = get-ItemProperty ICA\VisualDisplay\FramesPerSecond
if($a.state -ne "NotConfigured")
{
	Write-host "ICA\VisualDisplay\Frames Per Second :  " $a.Value
}

$a = get-ItemProperty ServerSessionSettings\SessionImportance
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSessionSettings\Session Importance :  " $a.Value
}

$a = get-ItemProperty ServerSessionSettings\Singlesignon
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSessionSettings\Single signon:  " $a.Value
}

$a = get-ItemProperty ServerSessionSettings\Singlesignoncentralstore
if($a.state -ne "NotConfigured")
{
	Write-host "ServerSessionSettings\Single Signon Central Store :  " $a.Value
}

$a = get-ItemProperty VirtualDesktopAgent\HDX3DPro\EnableLossLess
if($a.state -ne "NotConfigured")
{
	Write-host "VirtualDesktopAgent\HDX3DPro\EnableLossLess :  " $a.Value
}

$a = get-ItemProperty VirtualDesktopAgent\HDX3DPro\ProGraphicsObj
if($a.state -ne "NotConfigured")
{
	Write-host "VirtualDesktopAgent\HDX3DPro\ProGraphicsObj :  " $a.Value
}

$a = get-ItemProperty VirtualDesktopAgent\ICALatencyMonitoring\ICALatencyMonitoring_Enable
if($a.state -ne "NotConfigured")
{
	Write-host "VirtualDesktopAgent\ICALatencyMonitoring\ICALatencyMonitoring_Enable :  " $a.Value
}

$a = get-ItemProperty VirtualDesktopAgent\ICALatencyMonitoring\ICALatencyMonitoring_Period
if($a.state -ne "NotConfigured")
{
	Write-host "VirtualDesktopAgent\ICALatencyMonitoring\ICALatencyMonitoring_Period :  " $a.Value
}

$a = get-ItemProperty VirtualDesktopAgent\ICALatencyMonitoring\ICALatencyMonitoring_Threshold
if($a.state -ne "NotConfigured")
{
	Write-host "VirtualDesktopAgent\ICALatencyMonitoring\ICALatencyMonitoring_Threshold :  " $a.Value
}

$a = get-ItemProperty VirtualDesktopAgent\ProfileLoadtimeMonitoring\ProfileLoadTimeMonitoring_Enable
if($a.state -ne "NotConfigured")
{
	Write-host "VirtualDesktopAgent\ProfileLoadtimeMonitoring\ProfileLoadTimeMonitoring_Enable :  " $a.Value
}

$a = get-ItemProperty VirtualDesktopAgent\ProfileLoadtimeMonitoring\ProfileLoadTimeMonitoring_Threshold
if($a.state -ne "NotConfigured")
{
	Write-host "VirtualDesktopAgent\ProfileLoadtimeMonitoring\ProfileLoadTimeMonitoring_Threshold :  " $a.Value
}

Write-Host
Write-Host "Registry keys"
Write-Host "------------------"
Write-Host
$a = get-ItemProperty -Path "HKLM:\SOFTWARE\Citrix\DesktopServer" -Name "MaxRegistrationCompletionTimeSecs" -EA 0
if($? -and $a)
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\MaxRegistrationCompletionTimeSecs : " $a.MaxRegistrationCompletionTimeSecs
}
else
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\MaxRegistrationCompletionTimeSecs : 600" 
}

$a = get-ItemProperty -Path "HKLM:\SOFTWARE\Citrix\DesktopServer" -Name "MaxLaunchRegistrationDelaySec" -EA 0
if($? -and $a)
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\MaxLaunchRegistrationDelaySec : " $a.MaxLaunchRegistrationDelaySec
}
else
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\MaxLaunchRegistrationDelaySec : 180" 
}

$a = get-ItemProperty -Path "HKLM:\SOFTWARE\Citrix\DesktopServer" -Name "MaxRegistrationDelayMin" -EA 0
if($? -and $a)
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\MaxRegistrationDelayMin : " $a.MaxRegistrationDelayMin
}
else
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\MaxRegistrationDelayMin : 20" 
}

$a = get-ItemProperty -Path "HKLM:\SOFTWARE\Citrix\DesktopServer" -Name "HeartbeatPeriodMs" -EA 0
if($? -and $a)
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\HeartbeatPeriodMs : " $a.HeartbeatPeriodMs
}
else
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\HeartbeatPeriodMs : 600000" 
}

$a = get-ItemProperty -Path "HKLM:\SOFTWARE\Citrix\DesktopServer" -Name "MaxHeartbeatIntervalMs" -EA 0
if($? -and $a)
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\MaxHeartbeatIntervalMs : " $a.MaxHeartbeatIntervalMs
}
else
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\MaxHeartbeatIntervalMs : -" 
}

$a = get-ItemProperty -Path "HKLM:\SOFTWARE\Citrix\DesktopServer" -Name "SupportMultipleForest" -EA 0
if($? -and $a)
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\SupportMultipleForest : " $a.SupportMultipleForest
}
else
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\SupportMultipleForest : 0" 
}

$a = get-ItemProperty -Path "HKLM:\SOFTWARE\Citrix\DesktopServer" -Name "MaxWorkers" -EA 0
if($? -and $a)
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\MaxWorkers : " $a.MaxWorkers
}
else
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\MaxWorkers : 10000" 
}

$a = get-ItemProperty -Path "HKLM:\SOFTWARE\Citrix\DesktopServer" -Name "PrepareSessionConnectionTimeoutSec" -EA 0
if($? -and $a)
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\PrepareSessionConnectionTimeoutSec : " $a.PrepareSessionConnectionTimeoutSec
}
else
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\PrepareSessionConnectionTimeoutSec : -" 
}

$a = get-ItemProperty -Path "HKLM:\SOFTWARE\Citrix\DesktopServer" -Name "MaxSessionEstablishmentTimeSecs" -EA 0
if($? -and $a)
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\MaxSessionEstablishmentTimeSecs : " $a.MaxSessionEstablishmentTimeSecs
}
else
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\MaxSessionEstablishmentTimeSecs : 60" 
}

$a = get-ItemProperty -Path "HKLM:\SOFTWARE\Citrix\DesktopServer" -Name "ExtraSpinUpTimeSecs" -EA 0
if($? -and $a)
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\ExtraSpinUpTimeSecs : " $a.ExtraSpinUpTimeSecs
}
else
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\ExtraSpinUpTimeSecs : 120" 
}

$a = get-ItemProperty -Path "HKLM:\SOFTWARE\Citrix\DesktopServer" -Name "DisableActiveSessionReconnect" -EA 0
if($? -and $a)
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\DisableActiveSessionReconnect : " $a.DisableActiveSessionReconnect
}
else
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\DisableActiveSessionReconnect : 0" 
}

$a = get-ItemProperty -Path "HKLM:\SOFTWARE\Citrix\DesktopServer" -Name "MaxDisconnectWaitTimeSecs" -EA 0
if($? -and $a)
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\MaxDisconnectWaitTimeSecs : " $a.MaxDisconnectWaitTimeSecs
}
else
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\MaxDisconnectWaitTimeSecs : 10" 
}


$a = get-ItemProperty -Path "HKLM:\SOFTWARE\Citrix\DesktopServer" -Name "MaxFailedRegistrationsAllowed" -EA 0
if($? -and $a)
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\MaxFailedRegistrationsAllowed : " $a.MaxFailedRegistrationsAllowed
}
else
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\MaxFailedRegistrationsAllowed : 2" 
}

$a = get-ItemProperty -Path "HKLM:\SOFTWARE\Citrix\DesktopServer" -Name "XmlServicesEnableNonSsl" -EA 0
if($? -and $a)
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\XmlServicesEnableNonSsl : " $a.XmlServicesEnableNonSsl
}
else
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\XmlServicesEnableNonSsl : 1" 
}

$a = get-ItemProperty -Path "HKLM:\SOFTWARE\Citrix\DesktopServer" -Name "XmlServicesEnableSsl" -EA 0
if($? -and $a)
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\XmlServicesEnableSsl : " $a.XmlServicesEnableSsl
}
else
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\XmlServicesEnableSsl : 1" 
}

$a = get-ItemProperty -Path "HKLM:\SOFTWARE\Citrix\DesktopServer\DataStore\Connections\Controller" -Name "MaxConnectivityLossSecs" -EA 0
if($? -and $a)
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\DataStore\Connections\Controller\MaxConnectivityLossSecs : " $a.MaxConnectivityLossSecs
}
else
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\DataStore\Connections\Controller\MaxConnectivityLossSecs : 300" 
}

$a = get-ItemProperty -Path "HKLM:\SOFTWARE\Citrix\DesktopServer\NameCache" -Name "NameRefreshPeriodMins" -EA 0
if($? -and $a)
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\NameCache\NameRefreshPeriodMins : " $a.NameRefreshPeriodMins
}
else
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\NameCache\NameRefreshPeriodMins : 1440" 
}

$a = get-ItemProperty -Path "HKLM:\SOFTWARE\Citrix\DesktopServer\NameCache" -Name "NameRefreshPeriodAfterErrorMins" -EA 0
if($? -and $a)
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\NameCache\NameRefreshPeriodAfterErrorMins : " $a.NameRefreshPeriodAfterErrorMins
}
else
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\NameCache\NameRefreshPeriodAfterErrorMins : 1440" 
}

$a = get-ItemProperty -Path "HKLM:\SOFTWARE\Citrix\DesktopServer" -Name "CompletedActionRetentionPeriodSec" -EA 0
if($? -and $a)
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\CompletedActionRetentionPeriodSec : " $a.CompletedActionRetentionPeriodSec
}
else
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\CompletedActionRetentionPeriodSec : 3660" 
}

$a = get-ItemProperty -Path "HKLM:\SOFTWARE\Citrix\DesktopServer\Logging" -Name "ConnectionLogLifetimeHours" -EA 0
if($? -and $a)
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\Logging\ConnectionLogLifetimeHours : " $a.ConnectionLogLifetimeHours
}
else
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\Logging\ConnectionLogLifetimeHours : 48" 
}

$a = get-ItemProperty -Path "HKLM:\SOFTWARE\Citrix\DesktopServer\Logging" -Name "HypervisorAlertLifetimeHours" -EA 0
if($? -and $a)
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\Logging\HypervisorAlertLifetimeHours : " $a.HypervisorAlertLifetimeHours
}
else
{
	Write-Host "HKLM\SOFTWARE\Citrix\DesktopServer\Logging\HypervisorAlertLifetimeHours : 168" 
}

$a = get-ItemProperty -Path "HKLM:\SOFTWARE\Citrix\ADConfig" -Name "ControllersGroupGuid" -EA 0
if($? -and $a)
{
	Write-Host "HKLM\SOFTWARE\Citrix\ADConfig\ControllersGroupGuid : " $a.ControllersGroupGuid
}
else
{
	Write-Host "HKLM\SOFTWARE\Citrix\ADConfig\ControllersGroupGuid : -" 
}

Remove-pssnapin "Citrix.Common.Commands"
Remove-pssnapin "Citrix.Common.GroupPolicy"
Remove-pssnapin "Citrix.Host.Admin.V1"
Remove-pssnapin "Citrix.Broker.Admin.V1"
Remove-pssnapin "Citrix.ADIdentity.Admin.V1"
Remove-pssnapin "Citrix.Configuration.Admin.V1"
Remove-pssnapin "Citrix.MachineCreation.Admin.V1"
Remove-pssnapin "Citrix.MachineIdentity.Admin.V1"
