$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$var1 = 'localhost'
asnp citrix.machine*
asnp citrix.Broker*
asnp citrix.adidentity*
$tasks = Get-ProvTask -AdminAddress $var1 -MaxRecordCount 2147483647 -Active $true
foreach ($task in $tasks)
{
	if ($task -eq $null)
	{
		continue
	}
	$wfs = $task.WorkflowStatus
	$taskid = $task.TaskId	
	$ds = $task.DateStarted
	$active = $task.Active
	$type = $task.Type
	$tp = $task.TaskProgress
	$mi = $task.MasterImage
	$psn = $task.ProvisioningSchemeName
	$ts = $task.TaskState
	if ($wfs -eq $null -or $wfs.length -eq 0)
	{
		$wfs = "-"
	}
	if ($taskid -eq $null -or $taskid.length -eq 0)
	{
		$taskid = "-"
	}
	if ($ds -eq $null)
	{
		$ds = "-"
	}
	if ($active -eq $null -or $active.length -eq 0)
	{
		$active = "-"
	}
	if ($type -eq $null -or $type.length -eq 0)
	{
		$type = "-"
	}
	if ($tp -eq $null -or $tp.length -eq 0)
	{
		$tp = "-"
	}
	if ($mi -eq $null -or $mi.length -eq 0)
	{
		$mi = "-"
	}
	if ($psn -eq $null -or $psn.length -eq 0)
	{
		$psn = "-"
	}
	if ($ts -eq $null -or $ts.length -eq 0)
	{
		$ts = "-"
	}

	Write-Host ($wfs,$taskid,$ds,$active,$type,$tp,$mi,$psn,$ts) -Separator "^^"
}

remove-pssnapin citrix.machine*
remove-pssnapin citrix.Broker*
remove-pssnapin citrix.adidentity*

