$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$ErrorActionPreference = 'SilentlyContinue'
$global:isErrorOccured = $False

$global:CONST_TEST_HDR = $args[0]
$global:CONST_TEST_END = $args[1]
$global:delimiter = $args[2]
$global:HTMLPath = $args[3]

Import-Module GroupPolicy

Function writeGPOsIntoFolder
{
	$Server = $env:computername
	Remove-Item -path $global:HTMLPath -recurse
	New-Item -Path $global:HTMLPath -ItemType directory
	$gpos = Get-GPO -All 
	If ($Null -ne $gpos -AND $gpos.count -gt 0)
	{
		foreach ($gpo in $gpos)
		{
			$HTMLFileNmWithPath = $global:HTMLPath + "$($gpo.DisplayName) [$($gpo.Id)]"
			[XML](Get-GPOReport -GUID $gpo.Id -Server $Server -ReportType HTML -Path $HTMLFileNmWithPath )
		}
	}
}


Clear-Host

#Main Region Starts
try
{

   	Write-Host $global:CONST_TEST_HDR
	Write-Host "-------"
   
    writeGPOsIntoFolder
}
catch [Exception]
{
	$global:isErrorOccured = $True
	Write-Verbose "Catch block executed and following Exception is occured : " $_.Exception.GetType().FullName, $_.Exception.Message
}

If($global:isErrorOccured -eq $False)
{
	Write-Host $global:CONST_TEST_END
}
#Main Region Ends

