$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$drives = Get-WmiObject -Class Win32_MappedLogicalDisk
if($drives)
{
              Write-host Name,Location,DeviceId -separator ^^
              foreach($drive in $drives)
              {
                             write-host $drive.Name, $drive.ProviderName, $drive.DeviceId -separator "^^"
              }
}
else
{
              write-host "No mapped drives present in this user's session."
}
