[CmdletBinding()]
param
(
    [string] $deliveryGroupName
)
Add-PSSnapin Citrix.Broker.*
$OutputEncoding = [console]::InputEncoding = [console]::OutputEncoding = New-Object System.Text.UTF8Encoding
$PSDefaultParameterValues = @{'*:Encoding' = 'utf8'}

$MaxRecordCount = 250
$allVMs = @()
do
{
    if($deliveryGroupName -like "*none*")
    {
        $VMs = @(Get-BrokerMachine  -MaxRecordCount $MaxRecordCount  |  select-object DesktopGroupName,DnsName, AgentVersion | sort-object  AgentVersion)
    }
    else
    {
        $VMs = @(Get-BrokerMachine -DesktopGroupName $deliveryGroupName -MaxRecordCount $MaxRecordCount  |  select-object DesktopGroupName, DnsName, AgentVersion | sort-object AgentVersion)
    }
    if($VMs.count -gt 0)
    {
        $allVMs += $VMs
    }
} while ($VMs.count -ge $MaxRecordCount)
if($allVMs)
{
	Write-Host "Desktop_Group_Name;DNS_Name;Agent_Version"
    foreach($item in $allVMs)
    {
        Write-Host "$($item.DesktopGroupName);$($item.DnsName);$($item.AgentVersion)"
    }
}
else {

    "Check the input parameters"   
}           
Remove-pssnapin Citrix.Broker.*