/*
 * Decompiled with CFR 0.152.
 */
package eGTTIntegration;

import eGTTIntegration.TTIntegrationWrapper;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.soap.SOAPFaultException;
import services.saas.ArrayOfArrayOfWebServiceBusinessObject;
import services.saas.ArrayOfFieldClass;
import services.saas.ArrayOfLinkEntry;
import services.saas.ArrayOfObjectCommandDataFieldValue;
import services.saas.ArrayOfRuleClass;
import services.saas.ArrayOfWebServiceBusinessObject;
import services.saas.ArrayOfWebServiceFieldValue;
import services.saas.FRSHEATIntegration;
import services.saas.FRSHEATIntegrationConnectionResponse;
import services.saas.FRSHEATIntegrationSearchResponse;
import services.saas.FRSHEATIntegrationSoap;
import services.saas.FRSHEATIntegrationUpdateBOResponse;
import services.saas.FieldClass;
import services.saas.FromClass;
import services.saas.LinkEntry;
import services.saas.ObjectCommandData;
import services.saas.ObjectCommandDataFieldValue;
import services.saas.ObjectQueryDefinition;
import services.saas.RuleClass;
import services.saas.SelectClass;
import services.saas.WebServiceBusinessObject;
import services.saas.WebServiceFieldValue;

public class IvantiIntegrator
extends TTIntegrationWrapper {
    private static QName ivantiQName = null;
    private static String ENDPOINT_URL = "";
    private static String WSDL_URL = "";
    private String userName;
    private String password;
    private String role;
    private String tenantId;
    private String serviceFieldValue;
    private String customer;
    private String category;
    private String team;
    private String workGroup;
    private String departmentName;
    private String summaryFormat;
    private String descriptionFormat;
    private String strAuthKey;
    private String DefaultDescFormat;
    private int MAX_TITLE_SIZE;
    private int MAX_DESC_SIZE;
    private String owner;
    private String source;
    private String incidentTableName;
    private String customerTableName;
    private String targetNamespace;
    private String WS_ServiceName;
    private String resolution;
    private String causeCode;
    private String impactValueForCritical;
    private String impactValueForMajor;
    private String impactValueForMinor;
    private String urgencyValueForCritical;
    private String urgencyValueForMajor;
    private String urgencyValueForMinor;
    private String statusForNormal;
    private String statusForAbnormal;
    FRSHEATIntegrationSoap port;

    public IvantiIntegrator(Hashtable hashtable) {
        block2: {
            this.userName = "";
            this.password = "";
            this.role = "";
            this.tenantId = "";
            this.serviceFieldValue = "";
            this.customer = "";
            this.category = "";
            this.team = "";
            this.workGroup = "";
            this.departmentName = "";
            this.summaryFormat = "$prior - $ctype / $cname  - $pdesc";
            this.descriptionFormat = "";
            this.strAuthKey = "";
            this.DefaultDescFormat = " Priority :$prior  Component : $cname  Component  Type : $ctype  Layer : $layer  Problem  Description : $pdesc";
            this.MAX_TITLE_SIZE = 255;
            this.MAX_DESC_SIZE = 1024;
            this.owner = "";
            this.source = "";
            this.incidentTableName = "";
            this.customerTableName = "";
            this.targetNamespace = "";
            this.WS_ServiceName = "";
            this.resolution = "";
            this.causeCode = "";
            this.impactValueForCritical = "";
            this.impactValueForMajor = "";
            this.impactValueForMinor = "";
            this.urgencyValueForCritical = "";
            this.urgencyValueForMajor = "";
            this.urgencyValueForMinor = "";
            this.statusForNormal = "Resolved";
            this.statusForAbnormal = "Active";
            this.port = null;
            try {
                this.setGlobalValues(hashtable);
            }
            catch (Throwable throwable) {
                if (!this.logEnabled) break block2;
                this.sop("ERROR: Got an exception, while setting Global Values in Ivanti Integrator" + throwable.getMessage());
            }
        }
    }

    public void updateInitParams(Hashtable hashtable) {
        this.setGlobalValues(hashtable);
    }

    public void setGlobalValues(Hashtable hashtable) {
        WSDL_URL = (String)hashtable.get("wsdl_url");
        this.userName = (String)hashtable.get("user");
        this.password = (String)hashtable.get("password");
        this.role = (String)hashtable.get("role");
        this.tenantId = (String)hashtable.get("tenantId");
        this.customer = (String)hashtable.get("customer");
        this.category = (String)hashtable.get("category");
        this.team = (String)hashtable.get("team");
        this.serviceFieldValue = (String)hashtable.get("service");
        this.owner = (String)hashtable.get("owner");
        this.source = (String)hashtable.get("source");
        this.incidentTableName = (String)hashtable.get("WS_IncidentTableName");
        this.customerTableName = (String)hashtable.get("WS_CustomerTableName");
        this.summaryFormat = (String)hashtable.get("TitleFormat");
        this.descriptionFormat = (String)hashtable.get("DescriptionFormat");
        this.targetNamespace = (String)hashtable.get("WSDL_targetNamespace");
        this.WS_ServiceName = (String)hashtable.get("WSDL_ServiceName");
        this.resolution = (String)hashtable.get("resolution");
        this.causeCode = (String)hashtable.get("causeCode");
        String string = (String)hashtable.get("titleLength");
        String string2 = (String)hashtable.get("descriptionLength");
        if (string == null || string.length() == 0) {
            string = "255";
        }
        if (string2 == null || string2.length() == 0) {
            string2 = "4000";
        }
        try {
            this.MAX_TITLE_SIZE = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.MAX_TITLE_SIZE = 255;
        }
        try {
            this.MAX_DESC_SIZE = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.MAX_DESC_SIZE = 4000;
        }
        this.setGlobalValuesForImpactAndUrgency(hashtable);
        this.setGlobalValuesForStatus(hashtable);
        if (this.targetNamespace == null) {
            this.targetNamespace = "SaaS.Services";
        }
        if (this.WS_ServiceName == null) {
            this.WS_ServiceName = "FRSHEATIntegration";
        }
        if (WSDL_URL != null && WSDL_URL.indexOf("?") > -1) {
            ENDPOINT_URL = WSDL_URL.substring(0, WSDL_URL.indexOf("?"));
        } else if (this.logEnabled) {
            this.sop("ERROR: Invalid WSDL URL: " + WSDL_URL);
        }
        ivantiQName = new QName(this.targetNamespace, this.WS_ServiceName);
    }

    public void setGlobalValuesForImpactAndUrgency(Hashtable hashtable) {
        if (hashtable != null) {
            this.impactValueForCritical = (String)hashtable.get("impactValueForCritical");
            this.impactValueForMajor = (String)hashtable.get("impactValueForMajor");
            this.impactValueForMinor = (String)hashtable.get("impactValueForMinor");
            this.urgencyValueForCritical = (String)hashtable.get("urgencyValueForCritical");
            this.urgencyValueForMajor = (String)hashtable.get("urgencyValueForMajor");
            this.urgencyValueForMinor = (String)hashtable.get("urgencyValueForMinor");
        }
        this.impactValueForCritical = this.impactValueForCritical != null && this.impactValueForCritical.trim().length() > 0 ? this.impactValueForCritical : "High";
        this.impactValueForMajor = this.impactValueForMajor != null && this.impactValueForMajor.trim().length() > 0 ? this.impactValueForMajor : "Medium";
        this.impactValueForMinor = this.impactValueForMinor != null && this.impactValueForMinor.trim().length() > 0 ? this.impactValueForMinor : "Low";
        this.urgencyValueForCritical = this.urgencyValueForCritical != null && this.urgencyValueForCritical.trim().length() > 0 ? this.urgencyValueForCritical : "High";
        this.urgencyValueForMajor = this.urgencyValueForMajor != null && this.urgencyValueForMajor.trim().length() > 0 ? this.urgencyValueForMajor : "Medium";
        this.urgencyValueForMinor = this.urgencyValueForMinor != null && this.urgencyValueForMinor.trim().length() > 0 ? this.urgencyValueForMinor : "Low";
    }

    public void setGlobalValuesForStatus(Hashtable hashtable) {
        if (hashtable != null) {
            this.statusForAbnormal = (String)hashtable.get("statusForAbnormal");
            this.statusForNormal = (String)hashtable.get("statusForNormal");
        }
        this.statusForAbnormal = this.statusForAbnormal != null && this.statusForAbnormal.trim().length() > 0 ? this.statusForAbnormal : "Active";
        this.statusForNormal = this.statusForNormal != null && this.statusForNormal.trim().length() > 0 ? this.statusForNormal : "Resolved";
    }

    public String createTicket(Object[] objectArray) throws IOException {
        String string = "";
        String string2 = "";
        String string3 = "";
        try {
            LinkEntry linkEntry;
            List list;
            ArrayOfLinkEntry arrayOfLinkEntry;
            String string4;
            String string5 = "";
            String string6 = "";
            Hashtable hashtable = null;
            String string7 = "";
            String string8 = (String)objectArray[0];
            String string9 = (String)objectArray[2];
            String string10 = (String)objectArray[3];
            String string11 = (String)objectArray[4];
            String string12 = (String)objectArray[5];
            String string13 = (String)objectArray[6];
            String string14 = (String)objectArray[7];
            String string15 = (String)objectArray[8];
            String string16 = (String)objectArray[9];
            if (string11 != null && string11.indexOf(":") > -1) {
                string7 = string11.substring(0, string11.indexOf(":"));
            } else if (string11 != null) {
                string7 = string11;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" Priority: ");
            stringBuffer.append(string8);
            stringBuffer.append(" Component Type: ");
            stringBuffer.append(string10);
            stringBuffer.append(" Component Name: ");
            stringBuffer.append(string11);
            stringBuffer.append(" Layer: ");
            stringBuffer.append(string12);
            stringBuffer.append(" Problem Description: ");
            stringBuffer.append(string13);
            string2 = stringBuffer.toString();
            hashtable = this.getFormattedData(objectArray);
            if (hashtable != null && !hashtable.isEmpty()) {
                string6 = (String)hashtable.get("summary");
                string5 = (String)hashtable.get("description");
            }
            String string17 = this.getMappedUrgency(string8);
            String string18 = this.getMappedImpact(string8);
            String string19 = this.getMappedStatus(string8);
            FRSHEATIntegrationConnectionResponse fRSHEATIntegrationConnectionResponse = null;
            FRSHEATIntegration fRSHEATIntegration = new FRSHEATIntegration(new URL(WSDL_URL), ivantiQName);
            this.port = fRSHEATIntegration.getFRSHEATIntegrationSoap();
            ((BindingProvider)this.port).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
            try {
                fRSHEATIntegrationConnectionResponse = this.port.connect(this.userName, this.password, this.tenantId, this.role);
            }
            catch (SOAPFaultException sOAPFaultException) {
                SOAPFault sOAPFault = sOAPFaultException.getFault();
                if (sOAPFault != null) {
                    if (sOAPFault.getFaultCode().equalsIgnoreCase("AccessDenied")) {
                        if (this.logEnabled) {
                            this.sop("ERROR: [AccessDenied] Ticket creation got failed with following error message: AccessDenied-Ensure that the credentials are specified properly(Either the specified user name does not exist in the tenant, or the password provided is invalid for the user name). Ticket Details: " + string2);
                        }
                    } else if (sOAPFault.getFaultCode().equalsIgnoreCase("TenantNotFound")) {
                        if (this.logEnabled) {
                            this.sop("ERROR: [TenantNotFound] Ticket creation got failed with following error message: AccessDenied- Ensure that the tenant URL is correct for accessing the tenant. If it is, contact Ivanti regarding the status of the given tenant. Ticket Details: " + string2);
                        }
                    } else if (sOAPFault.getFaultCode().equalsIgnoreCase("InvalidRole")) {
                        if (this.logEnabled) {
                            this.sop("ERROR: [InvalidRole] Ticket creation got failed with following error message: InvalidRole- Confirm that the role exists in the tenant and that the user belongs to the given role. Ticket Details: " + string2);
                        }
                    } else if (this.logEnabled) {
                        this.sop("ERROR: [" + sOAPFault.getFaultCode() + "] Ticket creation got failed(either during the authentication or authorization phases). Ticket Details: " + string2);
                    }
                } else if (this.logEnabled) {
                    this.sop("ERROR: Ticket creation got failed(either during the authentication or authorization phases). Ticket Details: " + string2);
                }
                string = "";
                return string;
            }
            catch (Throwable throwable) {
                if (this.logEnabled) {
                    this.sop("ERROR: Ticket creation got failed(either during the authentication or authorization phases).Given details(UserName/Password/TenantId/Role) are invalid. Ticket Details-> " + string2);
                }
                string = "";
                return string;
            }
            if (fRSHEATIntegrationConnectionResponse == null || !fRSHEATIntegrationConnectionResponse.getConnectionStatus().equalsIgnoreCase("Success")) {
                if (fRSHEATIntegrationConnectionResponse != null && fRSHEATIntegrationConnectionResponse.getExceptionReason() != null) {
                    if (this.logEnabled) {
                        this.sop("ERROR: Failed to create Ticket. Unable to connect Ivanti(Given details are invalid). ExceptionReason: " + fRSHEATIntegrationConnectionResponse.getExceptionReason() + "Ticket Details-> " + string2);
                    }
                } else if (this.logEnabled) {
                    this.sop("ERROR: Failed to create Ticket. Unable to connect Ivanti(Given details are invalid). Ticket Details-> " + string2);
                }
                string = "";
                return string;
            }
            string3 = fRSHEATIntegrationConnectionResponse.getSessionKey();
            if (this.incidentTableName == null || this.incidentTableName.trim().length() == 0) {
                this.incidentTableName = "Incident#";
            }
            if (this.customerTableName == null || this.customerTableName.trim().length() == 0) {
                this.customerTableName = "Frs_CompositeContract_Contact#";
            }
            ObjectCommandData objectCommandData = new ObjectCommandData();
            objectCommandData.setObjectType(this.incidentTableName);
            ArrayOfObjectCommandDataFieldValue arrayOfObjectCommandDataFieldValue = new ArrayOfObjectCommandDataFieldValue();
            List list2 = arrayOfObjectCommandDataFieldValue.getObjectCommandDataFieldValue();
            ObjectCommandDataFieldValue objectCommandDataFieldValue = new ObjectCommandDataFieldValue();
            objectCommandDataFieldValue.setName("Subject");
            objectCommandDataFieldValue.setValue(string6);
            list2.add(objectCommandDataFieldValue);
            objectCommandDataFieldValue = new ObjectCommandDataFieldValue();
            objectCommandDataFieldValue.setName("Symptom");
            objectCommandDataFieldValue.setValue(string5);
            list2.add(objectCommandDataFieldValue);
            objectCommandDataFieldValue = new ObjectCommandDataFieldValue();
            objectCommandDataFieldValue.setName("Impact");
            objectCommandDataFieldValue.setValue(string18);
            list2.add(objectCommandDataFieldValue);
            objectCommandDataFieldValue = new ObjectCommandDataFieldValue();
            objectCommandDataFieldValue.setName("Urgency");
            objectCommandDataFieldValue.setValue(string17);
            list2.add(objectCommandDataFieldValue);
            objectCommandDataFieldValue = new ObjectCommandDataFieldValue();
            objectCommandDataFieldValue.setName("Service");
            objectCommandDataFieldValue.setValue(this.serviceFieldValue);
            list2.add(objectCommandDataFieldValue);
            objectCommandDataFieldValue = new ObjectCommandDataFieldValue();
            objectCommandDataFieldValue.setName("Category");
            objectCommandDataFieldValue.setValue(this.category);
            list2.add(objectCommandDataFieldValue);
            objectCommandDataFieldValue = new ObjectCommandDataFieldValue();
            objectCommandDataFieldValue.setName("Owner");
            objectCommandDataFieldValue.setValue(this.owner);
            list2.add(objectCommandDataFieldValue);
            objectCommandDataFieldValue = new ObjectCommandDataFieldValue();
            objectCommandDataFieldValue.setName("Status");
            objectCommandDataFieldValue.setValue(string19);
            list2.add(objectCommandDataFieldValue);
            objectCommandDataFieldValue = new ObjectCommandDataFieldValue();
            objectCommandDataFieldValue.setName("OwnerTeam");
            objectCommandDataFieldValue.setValue(this.team);
            list2.add(objectCommandDataFieldValue);
            objectCommandDataFieldValue = new ObjectCommandDataFieldValue();
            objectCommandDataFieldValue.setName("Source");
            objectCommandDataFieldValue.setValue(this.source);
            list2.add(objectCommandDataFieldValue);
            String string20 = this.getReclIDForField(this.customerTableName, "=", "DisplayName", this.customer, string3);
            if (string20 != null && string20.trim().equals("") && this.logEnabled) {
                this.sop("Error: Customer name (" + this.customer + ") Configured in eG console not matched with customer names list in Ivanti. ");
            }
            if ((string4 = this.getReclIDForField("CI#", "=", "Name", string7, string3)) != null && string4.trim().length() > 0) {
                arrayOfLinkEntry = new ArrayOfLinkEntry();
                list = arrayOfLinkEntry.getLinkEntry();
                linkEntry = new LinkEntry();
                linkEntry.setAction("Link");
                linkEntry.setRelatedObjectId(string4);
                linkEntry.setRelatedObjectType("CI#");
                linkEntry.setRelation("");
                list.add(linkEntry);
                objectCommandData.setLinkToExistent(arrayOfLinkEntry);
            } else if (this.logEnabled) {
                this.sop("Warning: CI link Mapping is Skipped. The Server name (" + string7 + ")configured in eG not matched with CI name in Ivanti.");
            }
            objectCommandDataFieldValue = new ObjectCommandDataFieldValue();
            objectCommandDataFieldValue.setName("ProfileLink");
            objectCommandDataFieldValue.setValue(string20);
            list2.add(objectCommandDataFieldValue);
            objectCommandData.setFields(arrayOfObjectCommandDataFieldValue);
            arrayOfLinkEntry = this.port.createObject(string3, this.tenantId, objectCommandData);
            if (arrayOfLinkEntry != null && arrayOfLinkEntry.getStatus().equalsIgnoreCase("Success")) {
                list = arrayOfLinkEntry.getObj();
                linkEntry = list.getFieldValues();
                List list3 = linkEntry.getWebServiceFieldValue();
                Number number = 0;
                for (WebServiceFieldValue webServiceFieldValue : list3) {
                    if (webServiceFieldValue == null || !webServiceFieldValue.getName().equalsIgnoreCase("IncidentNumber")) continue;
                    number = (Number)webServiceFieldValue.getValue();
                }
                string = arrayOfLinkEntry.getRecId();
                System.out.println("Ticket is created successfully...TicketID(ReclId):  " + string);
                if (this.logEnabled) {
                    this.sop("INFO: Ticket has been created successfully...  Ticket Details-> Ticket Number: " + number + " " + string2);
                }
            } else if (arrayOfLinkEntry != null && arrayOfLinkEntry.getExceptionReason() != null) {
                if (this.logEnabled) {
                    this.sop("Error: Ticket creation got failed with following error message :: " + arrayOfLinkEntry.getExceptionReason() + " Ticket Details->  " + string2);
                }
            } else if (this.logEnabled) {
                this.sop("Error: Ticket creation got failed. Ticket Details->  " + string2);
            }
        }
        catch (Throwable throwable) {
            if (this.logEnabled) {
                this.sop("Error: Ticket creation got failed with following error message :: " + throwable.getMessage());
            }
            throwable.printStackTrace();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean updateTicket(String string, Object[] objectArray) throws IOException {
        boolean bl;
        block57: {
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            Hashtable hashtable = null;
            String string6 = (String)objectArray[0];
            String string7 = (String)objectArray[2];
            String string8 = (String)objectArray[3];
            String string9 = (String)objectArray[4];
            String string10 = (String)objectArray[5];
            String string11 = (String)objectArray[6];
            String string12 = (String)objectArray[7];
            String string13 = (String)objectArray[8];
            String string14 = (String)objectArray[9];
            bl = false;
            boolean bl2 = false;
            String string15 = "update";
            String string16 = this.getMappedUrgency(string6);
            String string17 = this.getMappedImpact(string6);
            String string18 = this.getMappedStatus(string6);
            if (string6 != null && string6.equalsIgnoreCase("Normal")) {
                bl2 = true;
                string15 = "resolve";
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" Priority: ");
            stringBuffer.append(string6);
            stringBuffer.append(" Component Type: ");
            stringBuffer.append(string8);
            stringBuffer.append(" Component Name: ");
            stringBuffer.append(string9);
            stringBuffer.append(" Layer: ");
            stringBuffer.append(string10);
            stringBuffer.append(" Problem Description: ");
            stringBuffer.append(string11);
            string3 = stringBuffer.toString();
            FRSHEATIntegrationConnectionResponse fRSHEATIntegrationConnectionResponse = null;
            try {
                FRSHEATIntegration fRSHEATIntegration = new FRSHEATIntegration(new URL(WSDL_URL), ivantiQName);
                FRSHEATIntegrationSoap fRSHEATIntegrationSoap = fRSHEATIntegration.getFRSHEATIntegrationSoap();
                ((BindingProvider)fRSHEATIntegrationSoap).getRequestContext().put("javax.xml.ws.service.endpoint.address", ENDPOINT_URL);
                try {
                    fRSHEATIntegrationConnectionResponse = fRSHEATIntegrationSoap.connect(this.userName, this.password, this.tenantId, this.role);
                }
                catch (SOAPFaultException sOAPFaultException) {
                    SOAPFault sOAPFault = sOAPFaultException.getFault();
                    if (sOAPFault != null) {
                        if (sOAPFault.getFaultCode().equalsIgnoreCase("AccessDenied")) {
                            if (this.logEnabled) {
                                this.sop("ERROR: [AccessDenied] Failed to " + string15 + " Ticket with following error message: AccessDenied-Ensure that the credentials are specified properly(Either the specified user name does not exist in the tenant, or the password provided is invalid for the user name). Ticket Details: " + string3);
                            }
                        } else if (sOAPFault.getFaultCode().equalsIgnoreCase("TenantNotFound")) {
                            if (this.logEnabled) {
                                this.sop("ERROR: [TenantNotFound] Failed to " + string15 + " Ticket with following error message: AccessDenied- Ensure that the tenant URL is correct for accessing the tenant. If it is, contact Ivanti regarding the status of the given tenant. Ticket Details: " + string3);
                            }
                        } else if (sOAPFault.getFaultCode().equalsIgnoreCase("InvalidRole")) {
                            if (this.logEnabled) {
                                this.sop("ERROR: [InvalidRole] Failed to " + string15 + " Ticket with following error message: InvalidRole- Confirm that the role exists in the tenant and that the user belongs to the given role. Ticket Details: " + string3);
                            }
                        } else if (this.logEnabled) {
                            this.sop("ERROR: [" + sOAPFault.getFaultCode() + "] Failed to " + string15 + " Ticket(either during the authentication or authorization phases). Ticket Details: " + string3);
                        }
                    } else if (this.logEnabled) {
                        this.sop("ERROR: [" + sOAPFault.getFaultCode() + "] Failed to " + string15 + " Ticket(either during the authentication or authorization phases). Ticket Details: " + string3);
                    }
                    boolean bl3 = bl = false;
                    try {
                        fRSHEATIntegrationConnectionResponse = null;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                    return bl3;
                }
                catch (Throwable throwable) {
                    if (this.logEnabled) {
                        this.sop("ERROR: Failed to " + string15 + " Ticket(either during the authentication or authorization phases).Given details(UserName/Password/TenantId/Role) are invalid. Ticket Details-> Ticket Number(ReclId): " + string + " " + string3);
                    }
                    throwable.printStackTrace();
                    boolean bl4 = bl = false;
                    try {
                        fRSHEATIntegrationConnectionResponse = null;
                    }
                    catch (Throwable throwable2) {
                        throwable2.printStackTrace();
                    }
                    return bl4;
                }
                if (fRSHEATIntegrationConnectionResponse == null || !fRSHEATIntegrationConnectionResponse.getConnectionStatus().equalsIgnoreCase("Success")) {
                    if (fRSHEATIntegrationConnectionResponse != null && fRSHEATIntegrationConnectionResponse.getExceptionReason() != null) {
                        if (this.logEnabled) {
                            this.sop("ERROR: Failed to " + string15 + " Ticket(either during the authentication or authorization phases).Given details(UserName/Password/TenantId/Role) are invalid. ExceptionReason: " + fRSHEATIntegrationConnectionResponse.getExceptionReason() + "Ticket Details-> Ticket Number(ReclId): " + string + " " + string3);
                        }
                    } else if (this.logEnabled) {
                        this.sop("ERROR: Failed to " + string15 + " Ticket. (either during the authentication or authorization phases).Given details(UserName/Password/TenantId/Role) are invalid.Ticket Details-> Ticket Number(ReclId): " + string + " " + string3);
                    }
                    boolean bl5 = bl = false;
                    return bl5;
                }
                string2 = fRSHEATIntegrationConnectionResponse.getSessionKey();
                hashtable = this.getFormattedData(objectArray);
                if (hashtable != null && !hashtable.isEmpty()) {
                    string5 = (String)hashtable.get("summary");
                    string4 = (String)hashtable.get("description");
                }
                ObjectCommandData objectCommandData = new ObjectCommandData();
                objectCommandData.setObjectType(this.incidentTableName);
                objectCommandData.setObjectId(string);
                ArrayOfObjectCommandDataFieldValue arrayOfObjectCommandDataFieldValue = new ArrayOfObjectCommandDataFieldValue();
                List list = arrayOfObjectCommandDataFieldValue.getObjectCommandDataFieldValue();
                ObjectCommandDataFieldValue objectCommandDataFieldValue = new ObjectCommandDataFieldValue();
                objectCommandDataFieldValue.setName("Subject");
                objectCommandDataFieldValue.setValue(string5);
                list.add(objectCommandDataFieldValue);
                objectCommandDataFieldValue = new ObjectCommandDataFieldValue();
                objectCommandDataFieldValue.setName("Symptom");
                objectCommandDataFieldValue.setValue(string4);
                list.add(objectCommandDataFieldValue);
                objectCommandDataFieldValue = new ObjectCommandDataFieldValue();
                objectCommandDataFieldValue.setName("Impact");
                objectCommandDataFieldValue.setValue(string17);
                list.add(objectCommandDataFieldValue);
                objectCommandDataFieldValue = new ObjectCommandDataFieldValue();
                objectCommandDataFieldValue.setName("Urgency");
                objectCommandDataFieldValue.setValue(string16);
                list.add(objectCommandDataFieldValue);
                objectCommandDataFieldValue = new ObjectCommandDataFieldValue();
                objectCommandDataFieldValue.setName("Status");
                objectCommandDataFieldValue.setValue(string18);
                list.add(objectCommandDataFieldValue);
                if (string6 != null && string6.equalsIgnoreCase("Normal")) {
                    bl2 = true;
                    objectCommandDataFieldValue = new ObjectCommandDataFieldValue();
                    objectCommandDataFieldValue.setName("Resolution");
                    objectCommandDataFieldValue.setValue(this.resolution);
                    list.add(objectCommandDataFieldValue);
                    objectCommandDataFieldValue = new ObjectCommandDataFieldValue();
                    objectCommandDataFieldValue.setName("CauseCode");
                    objectCommandDataFieldValue.setValue(this.causeCode);
                    list.add(objectCommandDataFieldValue);
                }
                objectCommandData.setFields(arrayOfObjectCommandDataFieldValue);
                FRSHEATIntegrationUpdateBOResponse fRSHEATIntegrationUpdateBOResponse = fRSHEATIntegrationSoap.updateObject(string2, this.tenantId, objectCommandData);
                if (fRSHEATIntegrationUpdateBOResponse != null && fRSHEATIntegrationUpdateBOResponse.getStatus().equalsIgnoreCase("Success")) {
                    WebServiceBusinessObject webServiceBusinessObject = fRSHEATIntegrationUpdateBOResponse.getObj();
                    ArrayOfWebServiceFieldValue arrayOfWebServiceFieldValue = webServiceBusinessObject.getFieldValues();
                    List list2 = arrayOfWebServiceFieldValue.getWebServiceFieldValue();
                    Number number = 0;
                    for (WebServiceFieldValue webServiceFieldValue : list2) {
                        if (!webServiceFieldValue.getName().equalsIgnoreCase("IncidentNumber")) continue;
                        number = (Number)webServiceFieldValue.getValue();
                    }
                    bl = true;
                    if (bl2) {
                        if (this.logEnabled) {
                            this.sop("INFO: Ticket has been resolved successfully... Ticket Details-> Ticket Number: " + number + " " + string3);
                        }
                    } else if (this.logEnabled) {
                        this.sop("INFO: Ticket has been updated successfully... Ticket Details-> Ticket Number: " + number + " " + string3);
                    }
                } else if (fRSHEATIntegrationUpdateBOResponse != null && fRSHEATIntegrationUpdateBOResponse.getExceptionReason() != null) {
                    if (this.logEnabled) {
                        this.sop("ERROR: Failed to " + string15 + " ticket with following error message :: " + fRSHEATIntegrationUpdateBOResponse.getExceptionReason() + " Ticket Details-> Ticket Number(ReclId): " + string + " " + string3);
                    }
                } else if (this.logEnabled) {
                    this.sop("ERROR: Failed to " + string15 + " ticket. Ticket Details-> Ticket Number(ReclId): " + string + " " + string3);
                }
                break block57;
                {
                    catch (Throwable throwable) {
                        if (this.logEnabled) {
                            this.sop("ERROR:Failed to " + string15 + " ticket. with following error message :: " + throwable.getMessage() + " Ticket Details->  Ticket Number(ReclId): " + string + " " + string3);
                        }
                        throwable.printStackTrace();
                        break block57;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                try {
                    fRSHEATIntegrationConnectionResponse = null;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
        return bl;
    }

    private String getMappedUrgency(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("Critical")) {
                string = this.urgencyValueForCritical;
            } else if (string.equalsIgnoreCase("Major")) {
                string = this.urgencyValueForMajor;
            } else if (string.equalsIgnoreCase("Minor")) {
                string = this.urgencyValueForMinor;
            } else if (string.equalsIgnoreCase("Normal")) {
                string = this.urgencyValueForMinor;
            }
        }
        return string;
    }

    private String getMappedImpact(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("Critical")) {
                string = this.impactValueForCritical;
            } else if (string.equalsIgnoreCase("Major")) {
                string = this.impactValueForMajor;
            } else if (string.equalsIgnoreCase("Minor")) {
                string = this.impactValueForMinor;
            } else if (string.equalsIgnoreCase("Normal")) {
                string = this.impactValueForMinor;
            }
        }
        return string;
    }

    private String getMappedStatus(String string) {
        String string2 = "";
        if (string != null) {
            if (string.equalsIgnoreCase("Critical")) {
                string2 = this.statusForAbnormal;
            } else if (string.equalsIgnoreCase("Major")) {
                string2 = this.statusForAbnormal;
            } else if (string.equalsIgnoreCase("Minor")) {
                string2 = this.statusForAbnormal;
            } else if (string.equalsIgnoreCase("Normal")) {
                string2 = this.statusForNormal;
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hashtable getFormattedData(Object[] objectArray) {
        String string = "";
        Hashtable<String, String> hashtable = null;
        String string2 = (String)objectArray[0];
        String string3 = (String)objectArray[2];
        String string4 = (String)objectArray[3];
        String string5 = (String)objectArray[4];
        String string6 = (String)objectArray[5];
        String string7 = (String)objectArray[6];
        String string8 = (String)objectArray[7];
        String string9 = (String)objectArray[8];
        try {
            hashtable = new Hashtable<String, String>();
            if (this.descriptionFormat != null && !this.descriptionFormat.equals("")) {
                hashtable.put("description", this.descriptionFormat);
            } else {
                hashtable.put("description", this.DefaultDescFormat);
            }
            if (this.descriptionFormat != null && !this.descriptionFormat.equals("")) {
                hashtable.put("summary", this.summaryFormat);
            } else {
                hashtable.put("summary", string7);
            }
            if (hashtable != null && !hashtable.isEmpty()) {
                Set set = hashtable.keySet();
                for (String string10 : set) {
                    string = (String)hashtable.get(string10);
                    if (string10 == null || string == null) continue;
                    if (string.indexOf("$cname") > -1) {
                        string = this.replace(string, "$cname", string5);
                    }
                    if (string.indexOf("$ctype") > -1) {
                        string = this.replace(string, "$ctype", string4);
                    }
                    if (string.indexOf("$prior") > -1) {
                        string = this.replace(string, "$prior", string2);
                    }
                    if (string.indexOf("$pdesc") > -1) {
                        string = this.replace(string, "$pdesc", string7);
                    }
                    if (string.indexOf("$layer") > -1) {
                        string = this.replace(string, "$layer", string6);
                    }
                    if (string.indexOf("$starttime") > -1) {
                        string = this.replace(string, "$starttime", string8);
                    }
                    if (string.indexOf("$Service") > -1) {
                        string = this.replace(string, "$Service", string3);
                    }
                    if (string.indexOf("$user") > -1) {
                        string = this.replace(string, "$user", string9);
                    }
                    if (string10.equalsIgnoreCase("summary")) {
                        if (string.length() > this.MAX_TITLE_SIZE) {
                            string = string.substring(0, this.MAX_TITLE_SIZE - 4);
                            string = string + "...";
                        }
                    } else if (string10.equalsIgnoreCase("description") && string.length() > this.MAX_DESC_SIZE) {
                        string = string.substring(0, this.MAX_DESC_SIZE - 4);
                        string = string + "...";
                    }
                    hashtable.put(string10, string);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                return hashtable;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return hashtable;
    }

    public String getReclIDForField(String string, String string2, String string3, String string4, String string5) {
        String string6 = "";
        try {
            ObjectQueryDefinition objectQueryDefinition = new ObjectQueryDefinition();
            ArrayOfFieldClass arrayOfFieldClass = new ArrayOfFieldClass();
            List list = arrayOfFieldClass.getField();
            FieldClass fieldClass = new FieldClass();
            fieldClass.setName("RecId");
            fieldClass.setType("Text");
            list.add(fieldClass);
            SelectClass selectClass = new SelectClass();
            selectClass.setFields(arrayOfFieldClass);
            objectQueryDefinition.setSelect(selectClass);
            FromClass fromClass = new FromClass();
            fromClass.setObject(string);
            objectQueryDefinition.setFrom(fromClass);
            ArrayOfRuleClass arrayOfRuleClass = new ArrayOfRuleClass();
            List list2 = arrayOfRuleClass.getRule();
            RuleClass ruleClass = new RuleClass();
            ruleClass.setCondition(string2);
            ruleClass.setField(string3);
            ruleClass.setValue(string4);
            list2.add(ruleClass);
            objectQueryDefinition.setWhere(arrayOfRuleClass);
            FRSHEATIntegrationSearchResponse fRSHEATIntegrationSearchResponse = this.port.search(string5, this.tenantId, objectQueryDefinition);
            if (fRSHEATIntegrationSearchResponse != null && fRSHEATIntegrationSearchResponse.getStatus().equalsIgnoreCase("Success")) {
                ArrayOfArrayOfWebServiceBusinessObject arrayOfArrayOfWebServiceBusinessObject = fRSHEATIntegrationSearchResponse.getObjList();
                List list3 = arrayOfArrayOfWebServiceBusinessObject.getArrayOfWebServiceBusinessObject();
                ArrayOfWebServiceBusinessObject arrayOfWebServiceBusinessObject = (ArrayOfWebServiceBusinessObject)list3.get(0);
                List list4 = arrayOfWebServiceBusinessObject.getWebServiceBusinessObject();
                WebServiceBusinessObject webServiceBusinessObject = (WebServiceBusinessObject)list4.get(0);
                string6 = webServiceBusinessObject.getRecID();
            } else if (fRSHEATIntegrationSearchResponse != null && fRSHEATIntegrationSearchResponse.getStatus().equalsIgnoreCase("Error")) {
                string6 = "";
            } else if (fRSHEATIntegrationSearchResponse != null && fRSHEATIntegrationSearchResponse.getStatus().equalsIgnoreCase("NotFound")) {
                string6 = "";
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return string6;
    }
}

