/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.Escape;
import com.sybase.jdbc2.jdbc.SybStatement;
import com.sybase.jdbc2.utils.Debug;
import java.sql.SQLException;

class EscapeTokenizer {
    static final int START = 1;
    static final int IN_SINGLE_QUOTES = 2;
    static final int IN_DOUBLE_QUOTES = 3;
    private StringBuffer _text;
    private char[] _textCharBuf;
    private int _nextIndex;
    private SybStatement _stmt;
    private int _mark;
    private boolean _openCursor = false;
    private static final String SQL_DELIMITERS = " %&'()*+,-./:;<=>?[|\t\n";

    EscapeTokenizer(SybStatement stmt, String text) {
        Debug.println(this, "EscapeTokenizer constructor called on text '" + text + "'");
        this.updateText(new StringBuffer(text));
        this._stmt = stmt;
        this._nextIndex = 0;
        this._stmt._type = 0;
        this._stmt._setEnd = 0;
    }

    private String completeTableName(String word) {
        Debug.println(this, "completeTableName(" + word + ")");
        String tableName = word;
        int j = 0;
        while (j < 2) {
            if (this._mark < this._text.length()) {
                if (this._text.charAt(this._mark - 1) != '.') break;
                if (this._text.charAt(this._mark) == '.') {
                    tableName = String.valueOf(tableName) + ".";
                    ++j;
                }
                tableName = String.valueOf(tableName) + "." + this.nextWord(-1);
            }
            ++j;
        }
        return tableName;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static int matchClosingChar(char toMatch, StringBuffer s, int startIndex) {
        int state = 1;
        int closeCharIndex = -1;
        int i = startIndex + 1;
        while (i < s.length()) {
            char nextChar = s.charAt(i);
            switch (nextChar) {
                case '\"': 
                case '\'': {
                    state = EscapeTokenizer.nextState(state, nextChar);
                    break;
                }
                case ')': 
                case '}': {
                    if (state != 1) break;
                    if (nextChar == '}') {
                        if (toMatch == '{') return i;
                    }
                    if (nextChar != ')' || toMatch != '(') break;
                    return i;
                }
                case '(': 
                case '{': {
                    if (state != 1 || nextChar != toMatch) break;
                    i = EscapeTokenizer.matchClosingChar(nextChar, s, i);
                }
            }
            ++i;
        }
        return closeCharIndex;
    }

    /*
     * Unable to fully structure code
     */
    protected Object next() throws SQLException {
        block42: {
            block43: {
                block41: {
                    state = 1;
                    Debug.println(this, "next called with _text = '" + this._text + "', _nextIndex = " + this._nextIndex);
                    if (this._nextIndex == 0) {
                        word = this.nextWord(0);
                        if ("exec".equalsIgnoreCase(word)) {
                            this._nextIndex = this._text.length();
                            this._stmt._type = 1;
                            return new Escape(this._text.toString(), 1);
                        }
                        if ("select".equalsIgnoreCase(word)) {
                            this._stmt._type = 2;
                        } else if ("delete".equalsIgnoreCase(word)) {
                            this._stmt._type = 4;
                            word = this.nextWord(-1);
                            if (word != null && word.equalsIgnoreCase("from")) {
                                word = this.nextWord(-1);
                            }
                            this._stmt._table = this.completeTableName(word);
                        } else if ("update".equalsIgnoreCase(word)) {
                            this._stmt._type = 8;
                            word = this.nextWord(-1);
                            if ((word = this.completeTableName(word)) != null) {
                                this._stmt._setStart = this._mark - 1;
                            }
                            this._stmt._table = word;
                        }
                    }
                    if (this._nextIndex < this._text.length()) break block41;
                    returnValue = null;
                    break block42;
                }
                if (this._text.charAt(this._nextIndex) != '{') break block43;
                closeCurlyIndex = -1;
                i = this._nextIndex + 1;
                block15: while (i < this._text.length()) {
                    nextChar = this._text.charAt(i);
                    switch (nextChar) {
                        case '\"': 
                        case '\'': {
                            state = EscapeTokenizer.nextState(state, nextChar);
                            ** GOTO lbl60
                        }
                        case '}': {
                            if (state == 1) {
                                closeCurlyIndex = i;
                                break block15;
                            }
                            ** GOTO lbl60
                        }
                        case '{': {
                            if (state == 1) {
                                end = EscapeTokenizer.matchClosingChar(nextChar, this._text, i) + 1;
                                if (end == 0) {
                                    ErrorMessage.raiseError("JZ0S8", this._text.toString());
                                }
                                s = this._stmt.processEscapes(new String(this._textCharBuf, i, end - i));
                                sLen = s.length();
                                cap = i + sLen + this._textCharBuf.length - end;
                                newText = new StringBuffer(cap);
                                newText.append(this._textCharBuf, 0, i);
                                newText.append(s);
                                newText.append(this._textCharBuf, end, this._textCharBuf.length - end);
                                i += sLen - 1;
                                this.updateText(newText);
                            }
                        }
lbl60:
                        // 6 sources

                        default: {
                            ++i;
                        }
                    }
                }
                if (closeCurlyIndex == -1) {
                    ErrorMessage.raiseError("JZ0S8", this._text.toString());
                }
                escText = new String(this._textCharBuf, this._nextIndex, closeCurlyIndex + 1 - this._nextIndex);
                esc = new Escape(escText);
                returnValue = esc;
                this._stmt._setEnd -= escText.length() - esc.getBody().length();
                switch (esc.getType()) {
                    case 4: {
                        this._stmt._setEnd += "1970-1-1 ".length();
                        break;
                    }
                    case 3: {
                        this._stmt._setEnd += "00:00:00 ".length();
                        break;
                    }
                }
                Debug.println(this, "setEnd changed to: " + this._stmt._setEnd);
                this._nextIndex = closeCurlyIndex + 1;
                break block42;
            }
            indexPastText = -1;
            i = this._nextIndex;
            block16: while (i < this._text.length()) {
                nextChar = this._text.charAt(i);
                switch (nextChar) {
                    case '\"': 
                    case '\'': {
                        state = EscapeTokenizer.nextState(state, nextChar);
                        ** GOTO lbl116
                    }
                    case '{': {
                        if (state == 1) {
                            indexPastText = i;
                            break block16;
                        }
                        ** GOTO lbl116
                    }
                    case 'F': 
                    case 'f': {
                        if (state == 1 && this._stmt._type == 2) {
                            word = this.nextWord(i);
                            if ("from".equalsIgnoreCase(word)) {
                                word = this.nextWord(-1);
                                this._stmt._table = this.completeTableName(word);
                                if (this._stmt._cursor != null) {
                                    this._stmt._cursor.setTable(this._stmt._table);
                                }
                                if (!this._stmt._context._conn._props.getBoolean(33) || this._stmt._cursor != null) {
                                    this._stmt._type |= 4096;
                                }
                            } else if (this._stmt._context._conn._props.getBoolean(33) && "for".equalsIgnoreCase(word)) {
                                word = this.nextWord(-1);
                                if ("update".equalsIgnoreCase(word)) {
                                    Debug.println(this, "SELECT statement contains FOR UPDATE, cursor will be opened automatically.");
                                    this._openCursor = true;
                                }
                                this._stmt._type |= 4096;
                            }
                        }
                        ** GOTO lbl116
                    }
                    case 'W': 
                    case 'w': {
                        if (state == 1 && (this._stmt._type & 12) != 0 && "where".equalsIgnoreCase(word = this.nextWord(i)) && "current".equalsIgnoreCase(word = this.nextWord(-1)) && "of".equalsIgnoreCase(word = this.nextWord(-1))) {
                            this._stmt._type |= 4096;
                            this._stmt._setEnd += i - 1;
                            Debug.println(this, "setEnd = " + this._stmt._setEnd);
                        }
                    }
lbl116:
                    // 8 sources

                    default: {
                        ++i;
                    }
                }
            }
            if (indexPastText == -1) {
                indexPastText = this._text.length();
            }
            Debug.println(this, ">>> Array Length: " + this._textCharBuf.length + ", " + this._nextIndex + ", " + indexPastText);
            returnValue = new String(this._textCharBuf, this._nextIndex, indexPastText - this._nextIndex);
            this._nextIndex = indexPastText;
        }
        if (this._openCursor) {
            Debug.assert(this, (this._stmt._type & 2) != 0, "Tried to open a cursor, but statement was not a SELECT");
            this._stmt.checkCursor(false);
            this._stmt._cursor.getName();
            this._openCursor = false;
        }
        return returnValue;
    }

    protected static int nextState(int oldState, char quoteChar) {
        int newState = oldState;
        switch (quoteChar) {
            case '\'': {
                if (oldState == 2) {
                    newState = 1;
                    break;
                }
                if (oldState != 1) break;
                newState = 2;
                break;
            }
            case '\"': {
                if (oldState == 3) {
                    newState = 1;
                    break;
                }
                if (oldState != 1) break;
                newState = 3;
                break;
            }
            default: {
                Debug.assert(null, false);
            }
        }
        return newState;
    }

    private String nextWord(int start) {
        if (start >= 0) {
            this._mark = start;
        }
        String ret = null;
        int end = this._text.length();
        while (this._mark < end && SQL_DELIMITERS.indexOf(this._text.charAt(this._mark)) != -1) {
            ++this._mark;
        }
        if (this._mark >= end) {
            ret = null;
        } else {
            if (this._mark > 0 && this._text.charAt(this._mark) == '\"') {
                Debug.println(this, "hit a double quote, searching for next double quote");
                end = this._text.toString().indexOf(34, this._mark + 1) + 1;
            } else {
                int i = this._mark;
                while (i < end) {
                    if (SQL_DELIMITERS.indexOf(this._text.charAt(i)) != -1) {
                        end = i;
                        break;
                    }
                    ++i;
                }
            }
            if (end > this._mark) {
                ret = String.copyValueOf(this._textCharBuf, this._mark, end - this._mark);
                this._mark = end + 1;
                end = this._text.length();
            }
        }
        Debug.println(this, "nextWord is " + ret);
        return ret;
    }

    private void updateText(StringBuffer text) {
        this._text = text;
        int tLen = text.length();
        this._textCharBuf = new char[tLen];
        if (tLen > 0) {
            this._text.getChars(0, tLen, this._textCharBuf, 0);
        }
    }
}

