/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.MetaDataAccessor;
import com.sybase.jdbc2.jdbc.ProtocolContext;
import com.sybase.jdbc2.jdbc.SybCallableStatement;
import com.sybase.jdbc2.jdbc.SybConnection;
import com.sybase.jdbc2.jdbc.SybLiteral;
import com.sybase.jdbc2.jdbc.SybPreparedStatement;
import com.sybase.jdbc2.jdbc.SybStatement;
import com.sybase.jdbc2.utils.Debug;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Hashtable;

public class MdaManager {
    protected int _prependDBName;
    public static final int MDA_VERSION_REQUEST = 0;
    public static final int MDA_JDBC_FULL_REQUEST = 1;
    public static final int MDA_JDBC_MINIMAL_REQUEST = 2;
    private static final String FUNCTIONCALL = "FUNCTIONCALL";
    public static final String CONNECTCONFIG = "CONNECTCONFIG";
    public static final String SET_CATALOG = "SET_CATALOG";
    public static final String GET_CATALOG = "GET_CATALOG";
    public static final String COLUMNTYPENAME = "COLUMNTYPENAME";
    public static final String GET_AUTOCOMMIT = "GET_AUTOCOMMIT";
    public static final String SET_AUTOCOMMIT_ON = "SET_AUTOCOMMIT_ON";
    public static final String SET_AUTOCOMMIT_OFF = "SET_AUTOCOMMIT_OFF";
    public static final String SET_ISOLATION = "SET_ISOLATION";
    public static final String GET_ISOLATION = "GET_ISOLATION";
    public static final String SET_ROWCOUNT = "SET_ROWCOUNT";
    public static final String GET_READONLY = "GET_READONLY";
    public static final String SET_READONLY_TRUE = "SET_READONLY_TRUE";
    public static final String SET_READONLY_FALSE = "SET_READONLY_FALSE";
    public static final String ISREADONLY = "ISREADONLY";
    public static final String MDAVERSION = "MDAVERSION";
    public static final String PREPEND_DB_NAME = "PREPEND_DB_NAME";
    public static final String MAXLONGVARCHARLENGTH = "MAXLONGVARCHARLENGTH";
    public static final String MAXLONGVARBINARYLENGTH = "MAXLONGVARBINARYLENGTH";
    public static final int BASELINE_VERSION = 0;
    public static final int MDA_VER_COMPLIANT = 4;
    public static final int HIGHEST_VERSION = 7;
    public static final int OUTERJOIN_VERSION = 1;
    public static final String DEFAULT_CHARSET = "DEFAULT_CHARSET";
    private SybConnection _conn;
    private Hashtable _functionMapTable;
    private Hashtable _metaDataAccess;
    protected int _version;
    protected int _requestedVersion;
    public static final int NOT_SET = -1;
    private int _maxLongvarcharLength;
    private int _maxLongvarbinaryLength;

    MdaManager(SybConnection conn, int mdaVersion, ProtocolContext pc) throws SQLException {
        block10: {
            this._functionMapTable = null;
            this._metaDataAccess = null;
            this._maxLongvarcharLength = -1;
            this._maxLongvarbinaryLength = -1;
            this._conn = conn;
            this._version = 0;
            this._requestedVersion = mdaVersion;
            this._conn._protocol.getSendLock(pc);
            try {
                try {
                    this.loadMetaData(pc);
                    PreparedStatement ps = null;
                    ResultSet rs = null;
                    try {
                        ps = this.getMetaDataAccessor(MDAVERSION, pc);
                        rs = ps.executeQuery();
                        rs.next();
                        this._version = rs.getInt(1);
                        rs.close();
                    }
                    catch (SQLException sQLException) {}
                    try {
                        ps = this.getMetaDataAccessor(PREPEND_DB_NAME, pc);
                        rs = ps.executeQuery();
                        rs.next();
                        this._prependDBName = rs.getInt(1);
                        ps.close();
                    }
                    catch (SQLException sQLException) {
                        this._prependDBName = 0;
                    }
                }
                catch (SQLException sqe) {
                    Debug.printStackTrace(this, sqe);
                    throw sqe;
                }
                Object var5_7 = null;
                this._conn._protocol.freeSendLock(pc);
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this._conn._protocol.freeSendLock(pc);
                throw throwable;
            }
            if (this._version != 0 && (this._requestedVersion < 4 || this._version >= this._requestedVersion)) break block10;
            try {
                ErrorMessage.raiseWarning("010SL");
            }
            catch (SQLWarning warning) {
                this._conn.handleSQLE(warning);
            }
        }
    }

    MdaManager(SybConnection conn, ProtocolContext pc) throws SQLException {
        this(conn, 7, pc);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized String getFunctionMap(String function, ProtocolContext pc) throws SQLException {
        String result;
        block10: {
            Debug.println(this, "getFunctionMap(" + function + ")");
            if (this._functionMapTable == null) {
                Debug.println(this, "allocating new _functionMapTable");
                this._functionMapTable = new Hashtable();
                PreparedStatement ps = null;
                try {
                    try {
                        Debug.println(this, "sending query...");
                        ps = this.getMetaDataAccessor(FUNCTIONCALL, pc);
                        ResultSet resultSet = ps.executeQuery();
                        Debug.println(this, "query sent");
                        while (true) {
                            if (!resultSet.next()) {
                                resultSet.close();
                                break;
                            }
                            String s1 = resultSet.getString(1).trim();
                            String s2 = resultSet.getString(2).trim();
                            Debug.println(this, "putting key = " + s1 + ", value = " + s2);
                            this._functionMapTable.put(s1, s2);
                        }
                    }
                    catch (SQLException e) {
                        Debug.println(this, "couldn't get function info, exception: " + e.toString());
                        ErrorMessage.raiseError("JZ0SH");
                    }
                    Object var5_8 = null;
                    if (ps == null) break block10;
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    if (ps != null) {
                        ps.close();
                    }
                    throw throwable;
                }
                ps.close();
            }
        }
        if ((result = (String)this._functionMapTable.get(function)) == null) {
            Debug.println(this, "couldn't find map string for " + function + "; hash table = " + this._functionMapTable.toString());
        }
        return result;
    }

    public int getMaxLongvarbinaryLength(ProtocolContext pc) throws SQLException {
        block3: {
            if (this._maxLongvarbinaryLength == -1) {
                this._maxLongvarbinaryLength = Integer.MAX_VALUE;
                try {
                    PreparedStatement ps = this.getMetaDataAccessor(MAXLONGVARBINARYLENGTH, pc);
                    ResultSet rs = null;
                    rs = ps.executeQuery();
                    rs.next();
                    this._maxLongvarbinaryLength = rs.getInt(1);
                    ps.close();
                }
                catch (SQLException sqe) {
                    if (sqe.getSQLState().equals("JZ0SJ")) break block3;
                    throw sqe;
                }
            }
        }
        return this._maxLongvarbinaryLength;
    }

    public int getMaxLongvarcharLength(ProtocolContext pc) throws SQLException {
        block3: {
            if (this._maxLongvarcharLength == -1) {
                this._maxLongvarcharLength = Integer.MAX_VALUE;
                try {
                    PreparedStatement ps = this.getMetaDataAccessor(MAXLONGVARCHARLENGTH, pc);
                    ResultSet rs = null;
                    rs = ps.executeQuery();
                    rs.next();
                    this._maxLongvarcharLength = rs.getInt(1);
                    ps.close();
                }
                catch (SQLException sqe) {
                    if (sqe.getSQLState().equals("JZ0SJ")) break block3;
                    throw sqe;
                }
            }
        }
        return this._maxLongvarcharLength;
    }

    public PreparedStatement getMetaDataAccessor(String mdInfo, ProtocolContext pc) throws SQLException {
        return this.getMetaDataAccessor(mdInfo, "", pc);
    }

    public PreparedStatement getMetaDataAccessor(String mdInfo, String pad, ProtocolContext pc) throws SQLException {
        return this.getMetaDataAccessor(mdInfo, pad, null, pc);
    }

    public PreparedStatement getMetaDataAccessor(String mdInfo, String pad, String catalog, ProtocolContext pc) throws SQLException {
        MetaDataAccessor mda;
        if (catalog != null) {
            Debug.println(this, "getMetaDataAccessor(" + mdInfo + pad + ", " + catalog + ")");
        } else {
            Debug.println(this, "getMetaDataAccessor(" + mdInfo + pad + ")");
        }
        if (this._metaDataAccess == null) {
            ErrorMessage.raiseError("JZ0SJ");
        }
        if ((mda = (MetaDataAccessor)this._metaDataAccess.get(mdInfo)) == null) {
            ErrorMessage.raiseError("JZ0SJ");
        }
        if (mda._queryType == 3) {
            ErrorMessage.raiseWarning("010SK", mdInfo);
        }
        PreparedStatement ps = null;
        switch (mda._queryType) {
            case 1: {
                if (catalog != null && this._prependDBName == 1) {
                    ps = this._conn.prepareCall("{call " + catalog + ".." + mda._query + "}" + pad);
                    break;
                }
                ps = this._conn.prepareCall("{call " + mda._query + "}" + pad);
                break;
            }
            case 2: {
                ps = this._conn.prepareStatement(String.valueOf(mda._query) + pad, false);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                ps = new SybLiteral(mda._query, mda._queryType);
                break;
            }
            default: {
                ErrorMessage.raiseError("JZ0SJ");
            }
        }
        if (!(ps instanceof SybLiteral)) {
            SybStatement s = (SybStatement)((Object)ps);
            s._context.setSponsor(pc);
        }
        return ps;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadMetaData(ProtocolContext pc) throws SQLException {
        Debug.println(this, "loadMetaData()");
        if (this._metaDataAccess == null) {
            Debug.println(this, "allocating new _metaDataAccess");
            this._metaDataAccess = new Hashtable();
        }
        SybStatement cs = null;
        try {
            try {
                ResultSet resultSet;
                Debug.println(this, "sending query...");
                cs = (SybCallableStatement)this._conn.prepareCall("{call sp_mda(?,?)}");
                cs._context.setSponsor(pc);
                ((SybPreparedStatement)cs).setInt(1, 1);
                ((SybPreparedStatement)cs).setInt(2, this._requestedVersion);
                try {
                    resultSet = ((SybCallableStatement)cs).executeQuery();
                }
                catch (SQLException sQLException) {
                    if (cs != null) {
                        cs.close();
                    }
                    cs = (SybCallableStatement)this._conn.prepareCall("{call dba.sp_mda(?,?)}");
                    cs._context.setSponsor(pc);
                    ((SybPreparedStatement)cs).setInt(1, 1);
                    ((SybPreparedStatement)cs).setInt(2, this._requestedVersion);
                    resultSet = ((SybCallableStatement)cs).executeQuery();
                }
                while (resultSet.next()) {
                    String key = resultSet.getString(1).trim();
                    int queryType = resultSet.getInt(2);
                    String query = resultSet.getString(3);
                    MetaDataAccessor mda = new MetaDataAccessor(queryType, query);
                    Debug.println(this, "putting key = " + key + ", type = " + queryType + " query = " + query);
                    this._metaDataAccess.put(key, mda);
                }
                resultSet.close();
            }
            catch (SQLException e) {
                Debug.println(this, "couldn't get function info, exception: " + e.toString());
                ErrorMessage.raiseError("JZ0SJ");
            }
            Object var4_9 = null;
            if (cs == null) return;
        }
        catch (Throwable throwable) {
            Object var4_10 = null;
            if (cs == null) throw throwable;
            cs.close();
            throw throwable;
        }
        cs.close();
    }
}

