/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.jdbc;

import com.sybase.jdbc2.jdbc.RawInputStream;
import com.sybase.jdbc2.utils.CacheManager;
import com.sybase.jdbc2.utils.Debug;
import java.io.IOException;
import java.io.InputStream;

public abstract class PadByteInputStream
extends RawInputStream {
    protected int _padByteLengthRemaining;
    protected int[] _bytes = new int[2];
    protected boolean _even;

    public PadByteInputStream(InputStream stream, int length, int lengthLimit, CacheManager cm) throws IOException {
        super(stream, length, lengthLimit, cm);
        this._padByteLengthRemaining = lengthLimit * 2;
        this._even = true;
    }

    public int available() throws IOException {
        int avail = super.available() * 2;
        return this._even ? avail : ++avail;
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        if (this._padByteLengthRemaining == 0) {
            return -1;
        }
        length = length < this._padByteLengthRemaining ? length : this._padByteLengthRemaining;
        int i = offset;
        while (i < length) {
            buf[i] = (byte)this.read();
            ++i;
        }
        return length;
    }

    public long skip(long n) throws IOException {
        n = n < (long)this._padByteLengthRemaining ? n : (long)this._padByteLengthRemaining;
        Debug.println(this, "skipping " + n + " bytes.");
        int i = 0;
        while ((long)i < n) {
            this.read();
            ++i;
        }
        return n;
    }
}

