/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;

public class BlobOutputStream
extends OutputStream {
    protected static final int HIBIT = Integer.MIN_VALUE;
    private DataOutput _dout;

    public BlobOutputStream(DataOutput os) throws IOException {
        this._dout = os;
    }

    public void close() throws IOException {
        this._dout.writeInt(0);
        this._dout = null;
    }

    public void flush() throws IOException {
    }

    public void write(int b) throws IOException {
        this._dout.writeInt(-2147483647);
        this._dout.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if ((len & Integer.MIN_VALUE) != 0) {
            ErrorMessage.raiseIOException("JZ0IA");
        }
        this._dout.writeInt(len | Integer.MIN_VALUE);
        this._dout.write(b, off, len);
    }
}

