/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.tds.TdsCursor;
import com.sybase.jdbc2.tds.TdsDataOutputStream;
import com.sybase.jdbc2.tds.TdsOutputStream;
import com.sybase.jdbc2.tds.Token;
import com.sybase.jdbc2.utils.Debug;
import java.io.IOException;
import java.sql.SQLException;

public class CurDeclareToken
extends Token {
    protected TdsCursor _cursor;
    protected String _query;
    protected int _nameLen;
    protected long _queryLen;
    protected int _colLen;

    protected CurDeclareToken() {
    }

    public CurDeclareToken(TdsCursor cursor, String query) throws SQLException {
        this._query = query;
        this._cursor = cursor;
    }

    protected String getTokenNameAsString() {
        return "CurDeclareToken";
    }

    public void send(TdsDataOutputStream out) throws IOException {
        int options = this._cursor._type;
        byte[] cvtName = out.stringToByte(this._cursor.getName());
        this._nameLen = cvtName.length;
        byte[] cvtQuery = out.stringToByte(this._query);
        this._queryLen = cvtQuery.length;
        this._colLen = 0;
        if (this._cursor._columns != null) {
            this._colLen = this._cursor._columns.length;
            int i = 0;
            while (i < this._cursor._columns.length) {
                byte[] cvtCol = out.stringToByte(this._cursor._columns[i]);
                this._colLen += cvtCol.length;
                ++i;
            }
        }
        try {
            this.sendTokenName(out);
            StringBuffer s = new StringBuffer(String.valueOf(this.getTokenNameAsString()) + ": ");
            s.append(" name= " + this._cursor.getName());
            s.append(", options= " + this._cursor._type);
            s.append(", status= " + this._cursor._hasArgs);
            s.append(", statement= " + this._query);
            int colLen = this._cursor._columns == null ? 0 : this._cursor._columns.length;
            s.append(", numcolumns = " + colLen);
            Debug.println(this, s.toString());
            this.sendTokenLength(out);
            out.writeByte(this._nameLen);
            out.write(cvtName);
            out.writeByte(options);
            out.writeByte(this._cursor._hasArgs);
            this.sendQueryLen(out);
            out.write(cvtQuery);
            if (this._cursor._columns != null) {
                this.sendNumColumns(out, this._cursor._columns.length);
                int i = 0;
                while (i < this._cursor._columns.length) {
                    byte[] cvtCol = out.stringToByte(this._cursor._columns[i]);
                    int colNameLen = cvtCol.length;
                    out.writeByte(colNameLen);
                    out.write(cvtCol);
                    ++i;
                }
            } else {
                this.sendNumColumns(out, 0);
            }
        }
        catch (IOException ioe) {
            Token.writeSQE(ioe);
        }
    }

    protected void sendNumColumns(TdsOutputStream out, int num) throws IOException {
        out.writeByte(num);
    }

    protected void sendQueryLen(TdsOutputStream out) throws IOException {
        out.writeShort((int)this._queryLen);
    }

    protected void sendTokenLength(TdsOutputStream out) throws IOException {
        long len = (long)(1 + this._nameLen + 1 + 1 + 2) + this._queryLen + 1L + (long)this._colLen;
        out.writeShort((int)len);
    }

    protected void sendTokenName(TdsOutputStream out) throws IOException {
        out.writeByte(134);
    }
}

