/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.ParamManager;
import com.sybase.jdbc2.tds.MsgToken;
import com.sybase.jdbc2.tds.Tds;
import com.sybase.jdbc2.tds.TdsDataOutputStream;
import com.sybase.jdbc2.tds.TdsJdbcInputStream;
import com.sybase.jdbc2.tds.TdsProtocolContext;
import com.sybase.jdbc2.utils.Debug;
import com.sybase.jdbc2.utils.HexConverts;
import java.io.IOException;
import java.sql.SQLException;

public class HASessionContext {
    private byte[] _haSessionID = new byte[6];
    private int _haLogin = 0;
    private boolean _haRequested = false;
    private boolean _failover = false;
    private Tds _protocol = null;

    protected HASessionContext(boolean hafailover, Tds protocol) {
        Debug.println(this, "HASessionContext(" + hafailover + ")");
        this._haRequested = hafailover;
        this._protocol = protocol;
        this._failover = false;
        if (this._haRequested) {
            this._haLogin = 1;
        }
    }

    protected void acknowledgeSessionID(TdsDataOutputStream out, TdsProtocolContext context) throws SQLException, IOException {
        Debug.println(this, "begin acknowledgeSessionID()");
        MsgToken msgT = new MsgToken(1, 12);
        ParamManager pm = new ParamManager(1, context);
        pm.setParam(1, -3, new byte[0], 0);
        Debug.println(this, "sending HA response message.");
        msgT.send(out);
        this._protocol.sendParamStream(pm, out);
        out.flush();
    }

    public int getLogin() {
        Debug.println(this, "HA login = " + this._haLogin);
        return this._haLogin;
    }

    public byte[] getSessionID() {
        Debug.println(this, "Session ID = " + HexConverts.hexConvert(this._haSessionID));
        return this._haSessionID;
    }

    public boolean isInFailoverMode() {
        return this._failover;
    }

    protected void readSessionID(TdsProtocolContext context) throws IOException, SQLException {
        Debug.println(this, "begin readSessionID()");
        int resType = this._protocol.nextResult(context);
        Debug.assert(this, resType == 101, "Result type should be MSG (101), instead it is " + resType);
        MsgToken msg = new MsgToken(context._in);
        int msgID = msg.getMessageID();
        Debug.assert(this, msgID == 12, "Message ID should be MSG_HAFAILOVER (12), instead it is " + msgID);
        resType = this._protocol.nextResult(context);
        Debug.assert(this, context._lastTds == 236, "TDS token should be PARAMFMT (236), instead it is " + context._lastTds);
        resType = context._in.readUnsignedByte();
        Debug.assert(this, resType == 215, "TDS token should be TDS_PARAMS (215), instead it is " + resType);
        TdsJdbcInputStream strm = new TdsJdbcInputStream(context, this._protocol);
        strm._dataFmt = context._paramFmts.getDataFormat(0);
        byte[] haID = strm.getBytes();
        Debug.println(this, "session id was " + haID.length + " bytes long.");
        if (this.getLogin() != 7 || this.getLogin() == 1 && !this.isInFailoverMode()) {
            System.arraycopy(haID, 0, this._haSessionID, 0, 6);
        }
        Debug.println(this, "Session ID is: " + HexConverts.hexConvert(this._haSessionID));
        context._lastResult = -1;
        resType = this._protocol.nextResult(context);
        Debug.assert(this, context._lastTds == 253, "Result type should be TDS_DONE (253), instead it is " + context._lastTds);
    }

    protected void setFailoverMode(boolean failover) {
        this._failover = failover;
    }

    protected void setHALogin(int login) {
        this._haLogin = login;
    }

    public boolean wasHARequested() {
        return this._haRequested;
    }
}

