/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.jdbc.SybProperty;
import com.sybase.jdbc2.tds.HASessionContext;
import com.sybase.jdbc2.tds.Language;
import com.sybase.jdbc2.tds.TdsOutputStream;
import com.sybase.jdbc2.tds.TdsProtocolContext;
import com.sybase.jdbc2.tds.Token;
import com.sybase.jdbc2.utils.Debug;
import com.sybase.jdbc2.utils.HexConverts;
import java.io.IOException;
import java.sql.SQLException;

public class LoginToken
extends Token {
    protected static final int MAX_NAMELEN = 30;
    protected static final int MAX_REMPWDLEN = 255;
    protected static final int MAX_PROGNLEN = 10;
    protected static final int MAX_PACKETSIZELEN = 6;
    protected String _hostName;
    protected String _user;
    protected String _password;
    protected String _hostProc;
    protected int _bufSize = 512;
    protected String _appName;
    protected String _serviceName;
    protected String _remPw;
    protected int _lint2 = 2;
    protected int _lint4 = 0;
    protected int _lflt = 4;
    protected int _lflt4 = 12;
    protected int _ldate = 8;
    protected int _ldate4 = 16;
    protected static final byte[] TDSVERSION;
    private static final String PROGNAME = "jConnect";
    protected byte[] _progVers;
    protected String _language;
    protected String _charset;
    protected String _packetSize;
    protected byte[] _lhasessionid;
    protected int _lhalogin;
    protected static final byte[] SPARE;
    protected static final byte[] OLDSECURE;
    protected static final byte[] SECSPARE;
    protected static final byte[] DUMMY;

    static {
        byte[] byArray = new byte[4];
        byArray[0] = 5;
        TDSVERSION = byArray;
        SPARE = new byte[3];
        OLDSECURE = new byte[2];
        SECSPARE = new byte[2];
        DUMMY = new byte[4];
    }

    protected LoginToken() {
        byte[] byArray = new byte[4];
        byArray[0] = 1;
        this._progVers = byArray;
        this._lhasessionid = new byte[6];
    }

    public LoginToken(SybProperty info, TdsProtocolContext tpc, HASessionContext haContext) throws SQLException {
        byte[] byArray = new byte[4];
        byArray[0] = 1;
        this._progVers = byArray;
        this._lhasessionid = new byte[6];
        this._user = info.getString(3);
        if (this._user == null) {
            ErrorMessage.raiseError("JZ004");
        }
        if (this._user.length() > 30) {
            ErrorMessage.raiseError("JZ001", this._user);
        }
        this._password = info.getString(4);
        if (this._password == null) {
            this._password = "";
        }
        if (this._password.length() > 30) {
            ErrorMessage.raiseError("JZ002", "");
        }
        this._hostName = info.getString(1);
        if (this._hostName != null && this._hostName.length() > 30) {
            tpc._conn.chainWarnings(ErrorMessage.createWarning("010HT", this._hostName));
            this._hostName = this._hostName.substring(0, 30);
        }
        this._hostProc = info.getString(2);
        if (this._hostProc == null || this._hostProc == "") {
            this._hostProc = "\u0000";
        }
        this._appName = info.getString(5);
        this._serviceName = info.getString(0);
        this._remPw = info.getString(9);
        this._charset = info.getString(8);
        this._language = info.getString(7);
        if (this._language == null) {
            this._language = Language.defaultLanguage();
        }
        this._packetSize = String.valueOf(info.getInteger(12));
        this._progVers[0] = 0;
        this._progVers[1] = 5;
        this._progVers[2] = 0;
        this._progVers[3] = 5;
        if (info.getBoolean(30)) {
            this._lint2 = 3;
            this._lint4 = 1;
            this._lflt = 10;
            this._lflt4 = 13;
            this._ldate = 9;
            this._ldate4 = 17;
        }
        this._lhalogin = haContext.getLogin();
        System.arraycopy(haContext.getSessionID(), 0, this._lhasessionid, 0, 6);
        Debug.println(this, "Login record\n\tuser: " + this._user + "\n\tpassword: " + this._password + "\n\tHOSTNAME: " + this._hostName + "\n\tHOSTPROC: " + this._hostProc + "\n\tAPPLICATIONNAME: " + this._appName + "\n\tSERVICENAME: " + this._serviceName + "\n\tREMOTEPWD: " + this._remPw + "\n\tCHARSET: " + this._charset + "\n\tLANGUAGE: " + this._language + "\n\tHALOGIN:  " + this._lhalogin + "\n\tHASESSIONID: " + HexConverts.hexConvert(this._lhasessionid));
    }

    protected void prepareRemPwd(TdsOutputStream out) throws IOException {
        Debug.println(this, "prepareRemPwd(" + this._remPw + ")");
        StringBuffer remPwdBuf = new StringBuffer();
        if (this._remPw == null) {
            remPwdBuf.append('\u0000');
            remPwdBuf.append((char)out.getStringByteLen(this._password));
            remPwdBuf.append(this._password);
        } else {
            char c = '\u0000';
            int next = 0;
            char[] srvNameOrPwd = new char[256];
            int remPwdLen = this._remPw.length();
            char[] remPwdCharArray = new char[remPwdLen];
            this._remPw.getChars(0, remPwdLen, remPwdCharArray, 0);
            while (next < remPwdLen && (c = remPwdCharArray[next++]) != ',') {
                if (c != '\\') continue;
                ++next;
            }
            while (next < remPwdLen) {
                int i = 0;
                while ((c = remPwdCharArray[next++]) != ',') {
                    if (c == '\\') {
                        Debug.assert(this, next < remPwdLen);
                        c = remPwdCharArray[next++];
                    }
                    srvNameOrPwd[i++] = c;
                    if (next >= remPwdLen) break;
                }
                if (i == 0) {
                    remPwdBuf.append('\u0000');
                } else {
                    String tmp = new String(srvNameOrPwd, 0, i);
                    remPwdBuf.append((char)out.getStringByteLen(tmp));
                    remPwdBuf.append(tmp);
                }
                if (remPwdCharArray[next - 1] != ',' || next < remPwdLen) continue;
                remPwdBuf.append('\u0000');
            }
        }
        this._remPw = remPwdBuf.toString();
    }

    public void send(TdsOutputStream out) throws IOException {
        try {
            out.writeStringLen(this._hostName, 30);
            out.writeStringLen(this._user, 30);
            out.writeStringLen(this._password, 30);
            out.writeStringLen(this._hostProc, 30);
            out.write(this._lint2);
            out.write(this._lint4);
            out.write(6);
            out.write(this._lflt);
            out.write(this._ldate);
            out.write(1);
            out.write(1);
            out.write(0);
            out.write(0);
            out.writeInt(this._bufSize);
            out.write(SPARE);
            out.writeStringLen(this._appName, 30);
            out.writeStringLen(this._serviceName, 30);
            this.prepareRemPwd(out);
            out.writeStringLen(this._remPw, 255);
            out.write(TDSVERSION);
            out.writeStringLen(PROGNAME, 10);
            out.write(this._progVers);
            out.write(0);
            out.write(this._lflt4);
            out.write(this._ldate4);
            out.writeStringLen(this._language, 30);
            out.write(0);
            out.write(OLDSECURE);
            out.write(0);
            out.write(0);
            out.write(this._lhalogin);
            out.write(this._lhasessionid);
            out.write(SECSPARE);
            out.writeStringLen(this._charset, 30);
            out.write(1);
            out.writeStringLen(this._packetSize, 6);
            out.write(DUMMY);
        }
        catch (IOException ioe) {
            Token.writeSQE(ioe);
        }
    }
}

