/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.tds.TdsNumeric;
import com.sybase.jdbc2.utils.Debug;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;

public class SybBigDecimal
extends BigDecimal
implements Serializable {
    protected int _precision;
    protected int _scale;

    public SybBigDecimal(BigDecimal x, int precision, int scale) throws SQLException {
        super(x.toString());
        if (precision < 1 || scale < 0 || precision < scale || precision > 38) {
            ErrorMessage.raiseError("JZ00A");
        }
        int vScale = x.scale();
        String value = TdsNumeric.unscale(x, vScale).toString();
        int vPrecision = 0;
        int i = 0;
        while (i < value.length()) {
            if (Character.isDigit(value.charAt(i))) {
                ++vPrecision;
            }
            ++i;
        }
        Debug.println(this, "determined actual precision of " + x + " to be " + vPrecision + " and scale " + vScale);
        if (vScale > scale || vPrecision > precision) {
            ErrorMessage.raiseError("JZ00C", x.toString());
        }
        this._precision = precision;
        this._scale = scale;
    }
}

