/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.tds;

import com.sybase.jdbc2.jdbc.Convert;
import com.sybase.jdbc2.jdbc.ErrorMessage;
import com.sybase.jdbc2.tds.CachedTdsReal;
import com.sybase.jdbc2.tds.TdsDataObject;
import com.sybase.jdbc2.tds.TdsProtocolContext;
import com.sybase.jdbc2.utils.Debug;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;

public class TdsReal
extends TdsDataObject {
    double _value;

    public TdsReal(TdsProtocolContext context) throws IOException {
        super(context);
    }

    protected void beginRead() throws IOException {
        Debug.println(this, "reading");
        this.startRead();
        switch (this._state) {
            case 1: {
                if (this._isNull) {
                    this._value = 0.0;
                } else {
                    switch (this._dataFmt._datatype) {
                        case 59: {
                            this._value = this.readFloat();
                            break;
                        }
                        case 62: {
                            this._value = this.readDouble();
                            break;
                        }
                        case 109: {
                            this._value = this.readFLTN();
                            break;
                        }
                        default: {
                            ErrorMessage.raiseIOException("JZ0TC");
                        }
                    }
                }
                this._state = 3;
                break;
            }
        }
    }

    public void cache() throws IOException {
        Debug.println(this, "caching");
        this.beginRead();
    }

    public void clear() throws IOException {
        Debug.println(this, "clearing");
        if (this._state == 0) {
            this.getSize();
            this.skip(this._dataLength);
        }
        this.initialize();
    }

    public TdsDataObject createCachedCopy() throws IOException, SQLException {
        return new CachedTdsReal(this);
    }

    public BigDecimal getBigDecimal(int scale) throws SQLException {
        this.doRead();
        BigDecimal retVal = null;
        if (!this._isNull) {
            retVal = new BigDecimal(this._value);
        }
        retVal = Convert.setScale(retVal, scale);
        return retVal;
    }

    public boolean getBoolean() throws SQLException {
        this.doRead();
        return this._value != 0.0;
    }

    public byte getByte() throws SQLException {
        this.doRead();
        Convert.checkByteOflo(new Double(this._value).longValue());
        return (byte)this._value;
    }

    public double getDouble() throws SQLException {
        this.doRead();
        return this._value;
    }

    public float getFloat() throws SQLException {
        this.doRead();
        return (float)this._value;
    }

    public int getInt() throws SQLException {
        this.doRead();
        Convert.checkIntOflo(new Double(this._value).longValue());
        return (int)this._value;
    }

    public long getLong() throws SQLException {
        this.doRead();
        Convert.checkLongOflo(this._value);
        return (long)this._value;
    }

    public Object getObject() throws SQLException {
        this.doRead();
        Number retVal = null;
        if (!this._isNull) {
            switch (this._dataLength) {
                case 4: {
                    retVal = new Float(this._value);
                    break;
                }
                case 8: {
                    retVal = new Double(this._value);
                    break;
                }
            }
        }
        return retVal;
    }

    public short getShort() throws SQLException {
        this.doRead();
        Convert.checkShortOflo(new Double(this._value).longValue());
        return (short)this._value;
    }

    public String getString() throws SQLException {
        this.doRead();
        String retVal = null;
        if (!this._isNull) {
            retVal = String.valueOf(this._value);
        }
        return retVal;
    }
}

