/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc2.utils;

import com.sybase.jdbc2.utils.Debug;
import java.util.StringTokenizer;

public class JavaVersion {
    private static int[] _java_version = null;

    static {
        try {
            String vmversion = System.getProperty("java.version");
            Debug.println(null, "JavaVersion is " + vmversion);
            _java_version = JavaVersion.stringToInts(vmversion);
        }
        catch (Exception e) {
            Debug.printStackTrace(null, e);
        }
    }

    private JavaVersion() {
    }

    public static boolean atOrAboveVersion(String minVersion) {
        if (_java_version == null) {
            return false;
        }
        int[] desired = JavaVersion.stringToInts(minVersion);
        if (desired == null) {
            return false;
        }
        int i = 0;
        while (i < desired.length && i < _java_version.length) {
            if (desired[i] != _java_version[i]) {
                return desired[i] < _java_version[i];
            }
            ++i;
        }
        return true;
    }

    private static int[] stringToInts(String versionString) {
        Debug.println(null, "version string is " + versionString);
        StringTokenizer st = new StringTokenizer(versionString, ".");
        int length = st.countTokens();
        int[] answer = new int[length];
        int i = 0;
        while (i < length) {
            String token = st.nextToken();
            char[] numbers = token.toCharArray();
            int j = 0;
            while (j < numbers.length) {
                if (!Character.isDigit(numbers[j])) {
                    Debug.println(null, "encountered a letter in the version string: " + numbers[j]);
                    token = new String(numbers, 0, j);
                    break;
                }
                ++j;
            }
            try {
                answer[i] = Integer.parseInt(token);
            }
            catch (NumberFormatException nfe) {
                Debug.printStackTrace(null, nfe);
                return null;
            }
            ++i;
        }
        String array = "[ ";
        int i2 = 0;
        while (i2 < answer.length) {
            array = String.valueOf(array) + answer[i2] + (i2 + 1 < answer.length ? ", " : " ]");
            ++i2;
        }
        Debug.println(null, "array contents are: " + array);
        return answer;
    }
}

