/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.ovm.mgr.ws.model;

import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class IPAddress {
    private String address;
    private String netmask;
    private IPAddressType type;
    private IPAddressConfigType configType;

    public IPAddress() {
        this.type = IPAddressType.IPV4;
        this.configType = IPAddressConfigType.STATIC;
        this.address = null;
        this.netmask = null;
    }

    public IPAddress(IPAddress addr) {
        this.address = addr.address;
        this.netmask = addr.netmask;
        this.type = addr.type;
        this.configType = addr.configType;
    }

    public void setType(IPAddressType type) {
        this.type = type;
    }

    public IPAddressType getType() {
        return this.type;
    }

    public void setConfigType(IPAddressConfigType configType) {
        this.configType = configType;
    }

    public IPAddressConfigType getConfigType() {
        return this.configType;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public void setNetmask(String netmask) {
        this.netmask = netmask;
    }

    public String getNetmask() {
        return this.netmask;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.netmask == null ? 0 : this.netmask.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.configType == null ? 0 : this.configType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IPAddress other = (IPAddress)obj;
        if (this.type != other.getType() || this.configType != other.getConfigType()) {
            return false;
        }
        if (!this.address.equals(other.address)) {
            return false;
        }
        return this.netmask.equals(other.netmask);
    }

    public static enum IPAddressConfigType {
        STATIC,
        DYNAMIC,
        STATELESS_AUTOCONFIG,
        UNKNOWN;

    }

    public static enum IPAddressType {
        IPV4,
        IPV6,
        UNKNOWN;

    }
}

