/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.ovm.mgr.ws.model;

import com.oracle.ovm.mgr.ws.model.WsErrorCode;
import com.oracle.ovm.mgr.ws.model.WsErrorDetails;
import java.io.PrintStream;

public class WsException
extends Exception {
    private WsErrorDetails errorDetails;

    public WsException(WsErrorCode errorCode, Object ... parameters) {
        this(new WsErrorDetails(errorCode, parameters));
    }

    public WsException(Throwable cause, WsErrorCode errorCode, Object ... parameters) {
        this(new WsErrorDetails(errorCode, parameters), cause);
    }

    public WsException(Throwable cause) {
        this(cause, WsErrorCode.GENERAL_UNKNOWN_EXCEPTION, new Object[0]);
    }

    public WsException(WsErrorDetails errorDetails) {
        this(errorDetails, null);
    }

    public WsException(WsErrorDetails errorDetails, Throwable cause) {
        super(errorDetails.getMessage(), cause);
        this.errorDetails = errorDetails;
        if (cause != null) {
            StringBuilder sb = new StringBuilder();
            while (cause != null) {
                sb.append("Caused by: ");
                sb.append(cause.getClass().getName());
                sb.append(": ");
                sb.append(cause.getLocalizedMessage());
                sb.append('\n');
                cause = cause.getCause();
            }
            this.errorDetails.setCause(sb.toString());
        }
    }

    public WsErrorDetails getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(WsErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
    }

    @Override
    public void printStackTrace(PrintStream stream) {
        super.printStackTrace(stream);
        if (this.errorDetails.getCause() != null) {
            stream.print(this.errorDetails.getCause());
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getName());
        String errorCode = this.errorDetails.getErrorCode();
        String message = this.getLocalizedMessage();
        if (errorCode != null || message != null) {
            b.append(": ");
            if (message != null) {
                b.append(message);
                b.append(' ');
            }
            if (errorCode != null) {
                b.append('(');
                b.append(errorCode);
                b.append(')');
            }
        }
        return b.toString();
    }
}

