/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.chart;

import com.objectplanet.chart.BarChart;
import com.objectplanet.chart.Chart;
import com.objectplanet.chart.ChartData;
import com.objectplanet.chart.ChartDataLoader;
import com.objectplanet.chart.ChartSample;
import com.objectplanet.chart.GenericChart;
import com.objectplanet.chart.LineChart;
import com.objectplanet.chart.NonFlickerPanel;
import com.objectplanet.chart.PieChart;
import com.objectplanet.chart.Renderer;
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class ChartApplet
extends Applet
implements ItemListener,
MouseListener,
MouseMotionListener {
    private static final String[] parameters_all = new String[]{"seriescount", "samplevalues", "charttitle", "samplecolors", "legendcolors", "valuedelimiter", "valuelabelson", "valuelabelangle", "valuelabelprefix", "valuelabelpostfix", "valuelabelstyle", "valuelabelfont", "valuelabelcolors", "legendon", "labeldelimiter", "samplelabels", "samplelabelcolors", "samplelabelson", "samplelabelstyle", "samplelabelfont", "serieslabels", "serieslabelson", "serieslabelstyle", "serieslabelcolors", "seriesLabelFont", "legendposition", "legendcolumns", "legendreverseon", "legendBoxSizeAsFont", "automaticrefreshtime", "background", "foreground", "gridimage", "chartforeground", "chartbackground", "alternatechartbackground", "titlefont", "font", "legendfont", "3dmodeon", "3ddepth", "gridoutline3don", "legendlabels", "graphinsets", "overlayinsets", "gridadjustmenton", "valuelineson", "maxvaluelineCount", "sampleaxisrange", "defaultgridlineson", "gridlines", "gridlinescolor", "defaultgridlinescolor", "gridlinecolors", "valuelinescolor", "rangelabelfont", "sampleaxislabel", "sampleaxislabelfont", "rangeaxislabelfont", "visiblesamples", "sampleaxislabelangle", "barlabelangle", "samplelabelangle", "rangeadjusterposition", "sampledecimalcount", "printasbitmap", "floatinglabelfont", "floatingonlegendoff", "urltarget", "exporturl", "label", "samplescrolleron", "zoomOn", "samplelabelselectioncolor", "targetlabelsposition", "singleclickurlon", "thousandsdelimeter", "thousandsdelimiter", "locale", "data", "datainterval", "displayversion", "format", "antialias", "complexLabelSeparator", "multilineLabelAlignment"};
    private static final String[] bar_parameters_all = new String[]{"barLabels", "barLabelsOn", "barLabelStyle", "barLabelFont", "barLabelColors", "autoLabelSpacingOn", "multiColorOn", "multiSeriesOn", "barOutlineOff", "barOutlineColor", "barAlignment", "barType", "barShape", "barWidth"};
    private static final String[] line_parameters_all = new String[]{"sampleDecimalCount", "autoLabelSpacingOn", "seriesLineOff", "connectedLinesOn", "lineWidth", "lineStroke", "lineStyle", "line3DLayout", "line3DDepth", "stackedOn", "outlineOff", "missingValuesInterpolated", "sampleHighlightOn", "sampleHighlightStyle", "sampleHighlightSize"};
    private static final String[] pie_parameters_all = new String[]{"angle", "depth", "percentLabelsOn", "percentLabelStyle", "pieLabelsOn", "percentDecimalCount", "sliceSeperatorOn", "sliceSeperatorColor", "selectionStyle", "startAngle", "pieLabelFont", "insideLabelFont", "outsideLabelFont", "pointingLabelFont", "detachedDistance", "pieRotationOn", "gradientSamplesOn"};
    private static final String[] time_line_parameters_all = new String[]{"timeFormatInputLocale", "timeFormatInput", "timeFormatOutLocale", "timeFormatOut", "lowerTime", "upperTime", "timeScale", "autoTimeLabelsOn", "timeLabels"};
    private static final String[] plotter_parameters_all = new String[]{"plots", "XUpperRange", "YUpperRange", "XLowerRange", "YLowerRange", "XRangeInterval", "YRangeInterval", "XRangeDecimalCount", "YRangeDecimalCount", "XAxisOn", "YAxisOn", "XAxisColor", "YAxisColor", "rangeOn", "rangeColor", "rangeAdjusterOn_right", "rangeAdjusterOn_bottom", "rangeAxisLabel_right", "rangeAxisLabel_left", "rangeAxisLabel_top", "rangeAxisLabel_bottom", "rangeAxisLabelAngle_right", "rangeAxisLabelAngle_left", "rangeAxisLabelAngle_top", "rangeAxisLabelAngle_bottom", "XRangeLabels", "XRangeLabelAngle", "XRangeLabelFont", "XValueLinesOn", "YValueLinesOn", "XValueLinesColor", "YValueLinesColor", "XMaxValueLineCount", "YMaxValueLineCount", "seriesOn", "plotSize", "plotStyle", "plotLabels", "autoLabelSpacingOn", "lineWidth", "connectedLinesOn", "legendOn", "legendLabels", "legendColors", "legendPosition", "legendColumns", "seriesColors", "XValueLabelsOn", "YValueLabelsOn", "valueLabelStyle", "seriesLabels", "seriesLabelsOn", "sereisLabelStyle", "seriesLabelColors", "XValueLabelPrefix", "XValueLabelPostfix", "YValueLabelPrefix", "YValueLabelPostfix", "XValueDecimalCount", "YValueDecimalCount", "floatingOnLegendOff", "chartTitle", "titleFont", "gridImage", "plotImage", "graphInsets", "gridAdjustmenton", "locale", "thousandsDelimiter", "rangelabelfont", "plotlabelangle", "plotlabelson", "plotlabelstyle", "plotlabelfont", "plotsortingon", "antialias"};
    private static final String[] gauge_parameters = new String[]{"startangle", "endangle", "range", "lowerrange", "rangeinterval", "rangecolor", "rangelabelson", "rangelabelstyle", "rangelabelfont", "rangelabelcolor", "rangetickstyle", "rangeticksize", "rangeStartAngle", "rangeEndAngle", "floatinglabelson", "background", "foreground", "chartbackground", "chartforeground", "rangehighlight", "charttitle", "rangelabelprefix", "rangelabelpostfix", "legendon", "legendlabels", "legendcolors", "legendposition", "legendcolumns", "legendfont", "legendimage", "pointerLabelsOn", "pointerLabels", "edgeColor", "gaugeAlignment", "floatingLabelColor"};
    private static final String[] gauge_parameters_n = new String[]{"pointer", "pointercolor", "pointerstyle", "pointersize", "sectorhighlight", "sectorcolor", "border", "bordercolor", "rangedecimalcount"};
    private static final String[] applet_parameters = new String[]{"chart", "exporturl", "automaticrefreshtime", "urltarget", "url", "singleclickurlon", "legendimage_", "plotimage", "gridimage", "samplehighlightimage", "data", "datainterval"};
    private static final String[] parameters_series = new String[]{"samplevalues_", "valuelabelprefix_", "valuelabelpostfix_", "seriesrange_", "valuelabelson_", "sampledecimalcount_"};
    private static final String[] parameters_range = new String[]{"rangeon", "rangecolor", "rangeposition", "rangedecimalcount", "rangelabelsoff", "rangelabelprefix", "rangelabelpostfix", "rangeaxislabel", "rangeaxislabelangle", "rangeadjusted", "rangestep", "range", "lowerrange", "rangeinterval", "currentrange", "currentlowerrange", "rangeadjusteron"};
    public Chart chart;
    public BarChart barChart;
    public LineChart lineChart;
    public PieChart pieChart;
    public Chart theChart;
    public GenericChart plotterChart;
    public Component gaugeChart;
    String chartType;
    protected String labelDelimiter = ",";
    protected String valueDelimiter = ",";
    private Applet parentApplet;
    private Hashtable overlayCharts;
    private String dataURL;
    private int dataInterval;
    private boolean dataIntervalReset;
    private Thread dataIntervalThread;
    private Thread refreshThread;
    private static final int THREAD_REFRESH = 0;
    private static final int THREAD_DATA_INTERVAL = 1;
    private static Cursor HAND_CURSOR = new Cursor(12);
    private static Cursor POINT_CURSOR = new Cursor(0);
    protected int sampleCountRead;
    protected int seriesCountRead;
    private String parameterPrefix;
    private double[] rangeStep;
    private int automaticRefreshTime;
    private Hashtable urlList;
    private Hashtable urlTargetList;
    private Hashtable urlParameters;
    protected Hashtable timePlots;
    private boolean singleClickURLOn;
    private int lastSelectedSample;
    private int lastSelectedSeries;
    private long lastSelectedTime;
    private long lastClickTime;
    private boolean doubleBufferingOff;
    private static final int DOUBLE_CLICK_TIME = 350;
    private boolean sampleCountSet;
    private boolean URLOpened;
    public ChartDataLoader dataLoader;
    private NonFlickerPanel barPanel;
    private NonFlickerPanel linePanel;
    private NonFlickerPanel piePanel;
    private Hashtable parameters;

    public ChartApplet() {
        this("bar");
    }

    public ChartApplet(String type) {
        this.chartType = type;
        this.rangeStep = new double[25];
        this.urlList = new Hashtable();
        this.urlTargetList = new Hashtable();
        this.urlTargetList.put("urltarget", "_self");
        this.urlParameters = new Hashtable();
        this.overlayCharts = new Hashtable();
        this.timePlots = new Hashtable();
        this.automaticRefreshTime = 3600000;
        this.lastSelectedSample = -1;
        this.lastSelectedSeries = -1;
        this.barChart = new BarChart();
        this.lineChart = new LineChart();
        this.pieChart = new PieChart();
        this.barChart.addItemListener(this);
        this.lineChart.addItemListener(this);
        this.pieChart.addItemListener(this);
        this.barChart.addMouseListener(this);
        this.lineChart.addMouseListener(this);
        this.pieChart.addMouseListener(this);
        this.barChart.addMouseMotionListener(this);
        this.lineChart.addMouseMotionListener(this);
        this.pieChart.addMouseMotionListener(this);
        this.theChart = this.barChart;
        if (this.chartType.equals("line")) {
            this.theChart = this.lineChart;
        } else if (this.chartType.equals("pie")) {
            this.theChart = this.pieChart;
        } else if (this.chartType.equals("time_line") || this.chartType.equals("spline") || this.chartType.equals("plotter") || this.chartType.equals("gauge")) {
            this.dataLoader = ChartApplet.createDataLoaderExt();
        }
        this.chart = this.theChart;
        ChartData data = this.barChart.getChartData();
        if (data != null) {
            this.lineChart.setChartData(data);
            this.pieChart.setChartData(data);
        }
        this.dataLoader = new ChartDataLoader();
        this.dataLoader.setChartType(this.chartType);
        this.dataLoader.barChart = this.barChart;
        this.dataLoader.lineChart = this.lineChart;
        this.dataLoader.pieChart = this.pieChart;
        this.chart = this.theChart = (Chart)this.dataLoader.setChart(this.theChart);
        this.setLayout(null);
    }

    private void setDataLoader(ChartDataLoader dataLoader) {
        this.dataLoader = dataLoader;
        this.chart = this.theChart = dataLoader.theChart;
        this.barChart = dataLoader.barChart;
        this.lineChart = dataLoader.lineChart;
        this.pieChart = dataLoader.pieChart;
        this.chartType = dataLoader.chartType;
    }

    public void reset() {
        this.urlList.clear();
        this.urlTargetList.clear();
        this.urlTargetList.put("urltarget", "_self");
        this.urlParameters.clear();
        this.timePlots.clear();
        this.lastSelectedSample = -1;
        this.lastSelectedSeries = -1;
        this.overlayCharts.clear();
        this.sampleCountSet = false;
        for (int i = 0; i < 25; ++i) {
            this.rangeStep[i] = -1.0;
        }
        this.labelDelimiter = ",";
        this.valueDelimiter = ",";
        this.singleClickURLOn = false;
        this.barChart.reset();
        this.lineChart.reset();
        this.pieChart.reset();
        this.dataLoader.reset();
    }

    protected Chart createChart(String type, String className) {
        if (className == null || className.equals("")) {
            System.out.println("invalid chartClass parameter");
            if (type.equals("bar")) {
                return this.barChart;
            }
            if (type.equals("line")) {
                return this.lineChart;
            }
            if (type.equals("pie")) {
                return this.pieChart;
            }
        }
        try {
            Class<?> c = Class.forName(className);
            if (type.equals("bar")) {
                return (BarChart)c.newInstance();
            }
            if (type.equals("line")) {
                return (LineChart)c.newInstance();
            }
            if (type.equals("pie")) {
                return (PieChart)c.newInstance();
            }
        }
        catch (ClassNotFoundException e) {
            System.out.println("Class not found: " + className);
        }
        catch (InstantiationException e) {
            System.out.println("Could not create an instance of the class: " + className);
        }
        catch (IllegalAccessException e) {
            System.out.println("Illegal access, could not create an instance of class: " + className);
        }
        catch (ClassCastException e) {
            String baseClassName = "com.objectplanet.chart.BarChart";
            if (type.equals("line")) {
                baseClassName = "com.objectplanet.chart.LineChart";
            } else if (type.equals("pie")) {
                baseClassName = "com.objectplanet.chart.PieChart";
            }
            System.out.println("The class " + className + ", does not extend from " + baseClassName + " and therefore could not be used as a " + type + " chart");
        }
        if (type.equals("line")) {
            return this.lineChart;
        }
        if (type.equals("pie")) {
            return this.pieChart;
        }
        return this.barChart;
    }

    private GenericChart createPlotterChart(String className) {
        if (className == null || className.equals("")) {
            System.out.println("invalid chartClass parameter");
            return this.plotterChart;
        }
        try {
            Class<?> c = Class.forName(className);
            return (GenericChart)c.newInstance();
        }
        catch (ClassNotFoundException e) {
            System.out.println("Class not found: " + className);
        }
        catch (InstantiationException e) {
            System.out.println("Could not create an instance of the class: " + className);
        }
        catch (IllegalAccessException e) {
            System.out.println("Illegal access, could not create an instance of class: " + className);
        }
        catch (ClassCastException e) {
            System.out.println("The class " + className + ", does not extend from com.objectplanet.chart.ext.PlotterChart and therefore could not be used as a plotter chart");
        }
        return this.plotterChart;
    }

    static ChartDataLoader createDataLoaderExt() {
        ChartDataLoader dataLoader = null;
        try {
            Class<?> loader_class = Class.forName("com.objectplanet.chart.ext.ChartDataLoaderExt");
            if (loader_class != null) {
                Object instance = loader_class.newInstance();
                if (instance instanceof ChartDataLoader) {
                    dataLoader = (ChartDataLoader)instance;
                } else {
                    System.out.println("Could not create class com.objectplanet.chart.ext.ChartDataLoaderExt");
                }
            }
        }
        catch (ClassNotFoundException e) {
            System.out.println("com.objectplanet.chart.ext.ChartDataLoaderExt class not found.");
        }
        catch (InstantiationException e) {
            System.out.println("Could not instantiate com.objectplanet.chart.ext.ChartDataLoaderExt.");
            System.out.println(e.getMessage());
        }
        catch (IllegalAccessException e) {
            System.out.println("Could not instantiate com.objectplanet.chart.ext.ChartDataLoaderExt.");
            System.out.println(e.getMessage());
        }
        catch (Throwable e) {
            System.out.println("Could not create com.objectplanet.chart.ext.ChartDataLoaderExt, we keep running anyway");
            System.out.println(e.getMessage());
        }
        return dataLoader;
    }

    public void init() {
        String double_buffering_off;
        String className;
        String type = this.getParameter("chart");
        if (type == null) {
            type = this.chartType;
        }
        if ((className = this.getParameter("chartClass")) != null) {
            if (type.equals("bar")) {
                this.barChart = (BarChart)this.createChart("bar", className);
            } else if (type.equals("line")) {
                this.lineChart = (LineChart)this.createChart("line", className);
            } else if (type.equals("pie")) {
                this.pieChart = (PieChart)this.createChart("pie", className);
            }
        }
        if ((className = this.getParameter("chartClass_bar")) != null) {
            this.barChart = (BarChart)this.createChart("bar", className);
        }
        if ((className = this.getParameter("chartClass_line")) != null) {
            this.lineChart = (LineChart)this.createChart("line", className);
        }
        if ((className = this.getParameter("chartClass_pie")) != null) {
            this.pieChart = (PieChart)this.createChart("pie", className);
        }
        if ((className = this.getParameter("chartClass_plotter")) != null) {
            this.plotterChart = this.createPlotterChart(className);
            this.plotterChart.addMouseListener(this);
        }
        this.theChart = this.barChart;
        if (this.chartType.equals("line")) {
            this.theChart = this.lineChart;
        } else if (this.chartType.equals("pie")) {
            this.theChart = this.pieChart;
        }
        this.chart = this.theChart;
        ChartData data = this.barChart.getChartData();
        if (data != null) {
            this.lineChart.setChartData(data);
            this.pieChart.setChartData(data);
        }
        if ((double_buffering_off = this.getParameter("doubleBufferingOff")) != null && double_buffering_off.equals("true")) {
            this.doubleBufferingOff = true;
        }
        if (this.doubleBufferingOff) {
            this.add(this.barChart);
            this.add(this.lineChart);
            this.add(this.pieChart);
            this.barChart.setVisible(false);
            this.lineChart.setVisible(false);
            this.pieChart.setVisible(false);
            this.theChart.setVisible(true);
        } else {
            this.barPanel = new NonFlickerPanel(null);
            this.linePanel = new NonFlickerPanel(null);
            this.piePanel = new NonFlickerPanel(null);
            this.barPanel.add(this.barChart);
            this.linePanel.add(this.lineChart);
            this.piePanel.add(this.pieChart);
            this.add(this.barPanel);
            this.add(this.linePanel);
            this.add(this.piePanel);
            this.barChart.getParent().setVisible(false);
            this.lineChart.getParent().setVisible(false);
            this.pieChart.getParent().setVisible(false);
            this.theChart.getParent().setVisible(true);
        }
        type = this.getParameter("chart");
        if (type == null) {
            type = this.chartType;
            this.chartType = null;
        }
        this.setParameter("chart", type);
        this.theChart.setAutomaticRepaintOn(false);
        this.reset();
        if (this.getParameter("data") != null) {
            this.loadURLParameters(this.getParameter("data"), this.urlParameters);
        }
        this.loadOverlayParameters();
        this.parameters = new Hashtable();
        String dataURL = (String)this.urlParameters.get("data");
        this.loadParameters(this.parameters);
        if (dataURL != null) {
            this.parameters.put("data", dataURL);
        }
        if (this.parameters.get("chart") != null) {
            this.setParameter("chart", (String)this.parameters.remove("chart"));
        }
        Enumeration e = this.parameters.keys();
        this.dataLoader.setParameters(this.parameters);
        this.setParameters(this.parameters);
        this.theChart.setAutomaticRepaintOn(true);
        this.theChart.repaint();
    }

    public void loadOverlayParameters() {
        ChartDataLoader overlayLoader;
        Hashtable parameters;
        ChartApplet overlay;
        if (this.getParameter("overlay") != null) {
            this.setParameter("overlay", this.getParameter("overlay"));
            overlay = (ChartApplet)this.overlayCharts.get("overlay");
            if (overlay != null) {
                parameters = new Hashtable();
                overlay.loadParameters(parameters);
                overlayLoader = this.dataLoader.getOverlayDataLoader("overlay");
                overlayLoader.setParameters(parameters);
                overlay.setParameters(parameters);
            }
        }
        if (this.getParameter("overlay0") != null) {
            this.setParameter("overlay0", this.getParameter("overlay0"));
            overlay = (ChartApplet)this.overlayCharts.get("overlay0");
            if (overlay != null) {
                parameters = new Hashtable();
                overlay.loadParameters(parameters);
                overlayLoader = this.dataLoader.getOverlayDataLoader("overlay0");
                overlayLoader.setParameters(parameters);
                overlay.setParameters(parameters);
            }
        }
        int count = 1;
        while (this.getParameter("overlay" + count) != null) {
            this.setParameter("overlay" + count, this.getParameter("overlay" + count));
            ChartApplet overlay2 = (ChartApplet)this.overlayCharts.get("overlay" + count);
            if (overlay2 != null) {
                Hashtable parameters2 = new Hashtable();
                overlay2.loadParameters(parameters2);
                ChartDataLoader overlayLoader2 = this.dataLoader.getOverlayDataLoader("overlay" + count);
                overlayLoader2.setParameters(parameters2);
                overlay2.setParameters(parameters2);
            }
            ++count;
        }
    }

    public void loadParameters(Hashtable parameters) {
        int i;
        String param;
        String param2;
        String value;
        boolean line_type;
        String param3;
        if (parameters == null) {
            return;
        }
        if (this.getParameter("chart") != null) {
            parameters.put("chart", this.getParameter("chart"));
        }
        this.sampleCountRead = 0;
        if (this.getParameter("sampleCount") != null) {
            String value2 = this.getParameter("sampleCount");
            try {
                this.sampleCountRead = Integer.parseInt(value2);
                this.sampleCountSet = true;
                parameters.put("samplecount", value2);
            }
            catch (NumberFormatException e) {
                System.out.println("Invalid sampleCount: " + value2);
            }
        }
        for (int p = 0; p < parameters_all.length; ++p) {
            String param4 = parameters_all[p].toLowerCase();
            String value3 = this.getParameter(param4);
            if ((value3 == null || value3.trim().length() <= 0) && (value3 == null || !value3.equals("\t"))) continue;
            parameters.put(param4, value3);
            try {
                if (this.sampleCountSet || !param4.equalsIgnoreCase("sampleValues")) continue;
                Double[] values = ChartApplet.getDoubleValues(value3, this.valueDelimiter);
                this.sampleCountRead = Math.max(values != null ? values.length : 0, this.sampleCountRead);
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.seriesCountRead = 1;
        if (parameters.containsKey("seriescount")) {
            try {
                this.seriesCountRead = Integer.parseInt((String)parameters.get("seriescount"));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        for (int p = 0; p < parameters_series.length; ++p) {
            for (int serie = 0; serie < this.seriesCountRead; ++serie) {
                String param5 = parameters_series[p] + serie;
                String value4 = this.getParameter(param5 = param5.toLowerCase());
                if (value4 == null || value4.trim().length() <= 0) continue;
                parameters.put(param5, value4);
                if (this.sampleCountSet || !param5.startsWith("samplevalues")) continue;
                Double[] values = this.getDoubleValues(value4);
                this.sampleCountRead = Math.max(values != null ? values.length : 0, this.sampleCountRead);
            }
        }
        int count = 0;
        String target = this.getParameter("targetvalueline_0");
        while (target != null && target.length() > 0) {
            parameters.put("targetvalueline_" + count, target);
            target = this.getParameter("targetvalueline_" + ++count);
        }
        for (int i2 = 0; i2 < 100; ++i2) {
            String param6 = "legendimage_" + i2;
            if (this.getParameter(param6) == null) continue;
            String image_name = this.getParameter(param6);
            parameters.put(param6, image_name);
        }
        count = 0;
        String label = this.getParameter("label_0");
        String label_url = this.getParameter("labelurl_0");
        String label_url_target = this.getParameter("labelurltarget_0");
        String label_angle = this.getParameter("labelangle_0");
        String label_color = this.getParameter("labelcolor_0");
        String label_font = this.getParameter("labelfont_0");
        while (label != null && label.length() > 0) {
            parameters.put("label_" + count, label);
            if (label_url != null && label_url.length() > 0) {
                parameters.put("labelurl_" + count, label_url);
                if (label_url_target != null && label_url_target.length() > 0) {
                    parameters.put("labelurltarget_" + count, label_url_target);
                }
            }
            if (label_angle != null && label_angle.length() > 0) {
                parameters.put("labelangle_" + count, label_angle);
            }
            if (label_color != null && label_color.length() > 0) {
                parameters.put("labelcolor_" + count, label_color);
            }
            if (label_font != null && label_font.length() > 0) {
                parameters.put("labelfont_" + count, label_font);
            }
            label = this.getParameter("label_" + ++count);
            label_url = this.getParameter("labelurl_" + count);
            label_url_target = this.getParameter("labelurltarget_" + count);
            label_angle = this.getParameter("labelangle_" + count);
            label_color = this.getParameter("labelcolor_" + count);
            label_font = this.getParameter("labelfont_" + count);
        }
        for (int i3 = 0; i3 < this.seriesCountRead; ++i3) {
            param3 = "seriesLabelFont_" + i3;
            if (this.getParameter(param3) == null) continue;
            parameters.put(param3, this.getParameter(param3));
        }
        if (this.chartType.equals("bar") && parameters != null) {
            for (int p = 0; p < bar_parameters_all.length; ++p) {
                param3 = bar_parameters_all[p].toLowerCase();
                String value5 = this.getParameter(param3);
                if (value5 == null || value5.trim().length() <= 0) continue;
                parameters.put(param3, value5);
            }
        }
        boolean bl = line_type = this.chartType.equals("line") || this.chartType.equals("time_line") || this.chartType.equals("spline");
        if (line_type && parameters != null) {
            int i4;
            String param7;
            int p;
            for (p = 0; p < line_parameters_all.length; ++p) {
                param7 = line_parameters_all[p].toLowerCase();
                value = this.getParameter(param7);
                if (value == null || value.trim().length() <= 0) continue;
                parameters.put(param7, value);
            }
            if (this.getParameter("sampleHighlightImage") != null) {
                parameters.put("samplehighlightimage", this.getParameter("samplehighlightimage"));
            }
            for (i4 = 0; i4 < this.seriesCountRead; ++i4) {
                param7 = "sampleHighlightImage_" + i4;
                if (this.getParameter(param7) == null) continue;
                parameters.put(param7.toLowerCase(), this.getParameter(param7));
            }
            for (i4 = 0; i4 < this.seriesCountRead; ++i4) {
                for (int j = 0; j < this.sampleCountRead; ++j) {
                    param2 = "sampleHighlightImage_" + i4 + "_" + j;
                    if (this.getParameter(param2) == null) continue;
                    parameters.put(param2.toLowerCase(), this.getParameter(param2));
                }
            }
            for (i4 = 0; i4 < 25; ++i4) {
                String param8 = "area_" + i4;
                if (this.getParameter(param8) == null) continue;
                parameters.put(param8.toLowerCase(), this.getParameter(param8));
            }
            if (this.chartType.equals("time_line") && parameters != null) {
                for (p = 0; p < time_line_parameters_all.length; ++p) {
                    String param9 = time_line_parameters_all[p].toLowerCase();
                    value = this.getParameter(param9);
                    if (value == null || value.trim().length() <= 0) continue;
                    parameters.put(param9, value);
                }
                for (i4 = 0; i4 < this.seriesCountRead; ++i4) {
                    String param10 = "timeplots_" + i4;
                    value = this.getParameter(param10);
                    if (value == null) continue;
                    String[] plots = ChartApplet.getStringValues(value, ",");
                    for (int j = 0; j < plots.length; ++j) {
                        String[] plot = ChartApplet.getStringValues(plots[j], "|");
                        if (this.timePlots.containsKey(plot[0])) continue;
                        this.timePlots.put(plot[0], plot[0]);
                    }
                    parameters.put(param10, value);
                }
                Enumeration e = this.timePlots.elements();
                while (e.hasMoreElements()) {
                    String timeplot = (String)e.nextElement();
                    param2 = "url_" + timeplot;
                    if (this.getParameter(param2) != null) {
                        parameters.put(param2, this.getParameter(param2));
                    }
                    if (this.getParameter(param2 = "urltarget_" + timeplot) == null) continue;
                    parameters.put(param2, this.getParameter(param2));
                }
                for (int serie = 0; serie < this.seriesCountRead; ++serie) {
                    e = this.timePlots.elements();
                    while (e.hasMoreElements()) {
                        String timeplot = (String)e.nextElement();
                        param = "url_" + serie + "_" + timeplot;
                        if (this.getParameter(param) != null) {
                            parameters.put(param, this.getParameter(param));
                        }
                        if (this.getParameter(param = "urltarget_" + serie + "_" + timeplot) == null) continue;
                        parameters.put(param, this.getParameter(param));
                    }
                }
            }
        }
        if (this.chartType.equals("pie")) {
            int i5;
            if (parameters != null) {
                for (int p = 0; p < pie_parameters_all.length; ++p) {
                    String param11 = pie_parameters_all[p].toLowerCase();
                    value = this.getParameter(param11);
                    if (value == null || value.trim().length() <= 0) continue;
                    parameters.put(param11, value);
                }
            }
            if (this.getParameter("detachedSlices") != null) {
                parameters.put("detachedslices", this.getParameter("detachedSlices"));
            }
            int pie_count = this.seriesCountRead == 1 ? 1 : this.sampleCountRead;
            for (i5 = 0; i5 < pie_count; ++i5) {
                param2 = "detachedslices_" + i5;
                if (this.getParameter(param2) == null) continue;
                parameters.put(param2, this.getParameter(param2));
            }
            if (this.getParameter("insideLabelsColor") != null) {
                parameters.put("insidelabelcolor", this.getParameter("insidelabelcolor"));
            }
            for (i5 = 0; i5 < pie_count; ++i5) {
                param2 = "insidelabelcolor_" + i5;
                if (this.getParameter(param2) == null) continue;
                parameters.put(param2, this.getParameter(param2));
            }
            if (this.getParameter("outsideLabelsColor") != null) {
                parameters.put("outsidelabelcolor", this.getParameter("outsidelabelcolor"));
            }
            for (i5 = 0; i5 < pie_count; ++i5) {
                param2 = "outsidelabelcolor_" + i5;
                if (this.getParameter(param2) == null) continue;
                parameters.put(param2, this.getParameter(param2));
            }
            if (this.getParameter("pointingLabelsColor") != null) {
                parameters.put("pointinglabelcolor", this.getParameter("pointinglabelcolor"));
            }
            for (i5 = 0; i5 < pie_count; ++i5) {
                param2 = "pointinglabelcolor_" + i5;
                if (this.getParameter(param2) == null) continue;
                parameters.put(param2, this.getParameter(param2));
            }
        }
        if (this.chartType.equals("plotter")) {
            String image_name;
            int i6;
            String[] values;
            if (parameters != null) {
                for (int p = 0; p < plotter_parameters_all.length; ++p) {
                    String param12 = plotter_parameters_all[p].toLowerCase();
                    value = this.getParameter(param12);
                    if (value == null || value.trim().length() <= 0) continue;
                    parameters.put(param12, value);
                    if (!param12.equalsIgnoreCase("plots")) continue;
                    values = ChartApplet.getStringValues(value, this.labelDelimiter);
                    this.sampleCountRead = Math.max(values != null ? values.length : 0, this.sampleCountRead);
                }
            }
            for (i6 = 0; i6 < this.seriesCountRead; ++i6) {
                String param13 = "plots_" + i6;
                value = this.getParameter(param13);
                if (value != null) {
                    parameters.put(param13, value);
                    if (param13.startsWith("plots_")) {
                        values = ChartApplet.getStringValues(value, this.labelDelimiter);
                        this.sampleCountRead = Math.max(values != null ? values.length : 0, this.sampleCountRead);
                    }
                }
                if (this.getParameter(param13 = "plotSize_" + i6) != null) {
                    parameters.put(param13, this.getParameter(param13));
                }
                if (this.getParameter(param13 = "plotLabels_" + i6) == null) continue;
                parameters.put(param13, this.getParameter(param13));
            }
            for (i6 = 0; i6 < this.seriesCountRead; ++i6) {
                String param14 = "XValueLabelPrefix_" + i6;
                if (this.getParameter(param14) != null) {
                    parameters.put(param14, this.getParameter(param14));
                }
                if (this.getParameter(param14 = "XValueLabelPostfix_" + i6) != null) {
                    parameters.put(param14, this.getParameter(param14));
                }
                if (this.getParameter(param14 = "YValueLabelPrefix_" + i6) != null) {
                    parameters.put(param14, this.getParameter(param14));
                }
                if (this.getParameter(param14 = "YValueLabelPostfix_" + i6) == null) continue;
                parameters.put(param14, this.getParameter(param14));
            }
            for (i6 = 0; i6 < this.seriesCountRead; ++i6) {
                String param15 = "XValueLabelsOn_" + i6;
                if (this.getParameter(param15) != null) {
                    parameters.put(param15, this.getParameter(param15));
                }
                if (this.getParameter(param15 = "YValueLabelsOn_" + i6) == null) continue;
                parameters.put(param15, this.getParameter(param15));
            }
            for (i6 = 0; i6 < this.seriesCountRead; ++i6) {
                String param16 = "XValueDecimalCount_" + i6;
                if (this.getParameter(param16) != null) {
                    parameters.put(param16, this.getParameter(param16));
                }
                if (this.getParameter(param16 = "YValueDecimalCount_" + i6) == null) continue;
                parameters.put(param16, this.getParameter(param16));
            }
            for (i6 = 0; i6 < 100; ++i6) {
                String param17 = "legendimage_" + i6;
                image_name = this.getParameter(param17);
                if (image_name == null) continue;
                parameters.put(param17, image_name);
            }
            for (i6 = 0; i6 < this.seriesCountRead; ++i6) {
                String param18 = "plotimage_" + i6;
                image_name = this.getParameter(param18);
                if (image_name == null) continue;
                parameters.put(param18, image_name);
            }
        }
        if (this.chartType.equals("gauge")) {
            if (parameters != null) {
                for (int p = 0; p < gauge_parameters.length; ++p) {
                    String param19 = gauge_parameters[p].toLowerCase();
                    value = this.getParameter(param19);
                    if (value == null || value.trim().length() <= 0) continue;
                    parameters.put(param19, value);
                }
            }
            if (parameters != null) {
                for (int p = 0; p < gauge_parameters_n.length; ++p) {
                    String value6 = this.getParameter(gauge_parameters_n[p]);
                    if (value6 != null && value6.trim().length() > 0) {
                        parameters.put(gauge_parameters_n[p], value6);
                    }
                    for (int n = 0; n < 25; ++n) {
                        param = gauge_parameters_n[p] + "_" + n;
                        value6 = this.getParameter(param);
                        if (value6 == null || value6.trim().length() <= 0) continue;
                        parameters.put(param, value6);
                    }
                }
            }
        }
        if (this.getParameter("url") != null) {
            parameters.put("url", this.getParameter("url"));
        }
        if (this.getParameter("urltarget") != null) {
            parameters.put("urltarget", this.getParameter("urltarget"));
        }
        int url_count = Math.max(this.seriesCountRead, this.sampleCountRead);
        for (i = 0; i < url_count; ++i) {
            String param20 = "url_" + i;
            if (this.getParameter(param20) != null) {
                parameters.put(param20, this.getParameter(param20));
            }
            if (this.getParameter(param20 = "urltarget_" + i) != null) {
                parameters.put(param20, this.getParameter(param20));
            }
            if (this.getParameter(param20 = "url_x_" + i) == null) continue;
            parameters.put(param20, this.getParameter(param20));
        }
        for (int serie = 0; serie < this.seriesCountRead; ++serie) {
            for (int sample = 0; sample < this.sampleCountRead; ++sample) {
                param = "url_" + serie + "_" + sample;
                if (this.getParameter(param) != null) {
                    parameters.put(param, this.getParameter(param));
                }
                if (this.getParameter(param = "urltarget_" + serie + "_" + sample) == null) continue;
                parameters.put(param, this.getParameter(param));
            }
        }
        if (this.getParameter("url_default") != null) {
            parameters.put("url_default", this.getParameter("url_default"));
        }
        if (this.getParameter("urltarget_default") != null) {
            parameters.put("urltarget_default", this.getParameter("urltarget_default"));
        }
        for (i = 0; i < parameters_range.length; ++i) {
            for (int j = 0; j <= 25; ++j) {
                param = parameters_range[i];
                if (j > 0) {
                    param = param + "_" + j;
                }
                if (this.getParameter(param) == null) continue;
                parameters.put(param, this.getParameter(param));
            }
        }
    }

    public void loadURLParameters(String url, Hashtable parameters) {
        if (url == null || url.trim().length() == 0) {
            return;
        }
        if (parameters == null) {
            return;
        }
        URL data_url = this.createURL(url);
        if (data_url != null) {
            try {
                String line;
                int pos;
                URLConnection connection = data_url.openConnection();
                connection.setUseCaches(false);
                String contentType = connection.getContentType();
                String encoding = null;
                if (contentType != null && (pos = contentType.indexOf("charset=")) >= 0) {
                    encoding = contentType.substring(pos + 8);
                }
                InputStream url_in = connection.getInputStream();
                BufferedReader in = encoding != null ? new BufferedReader(new InputStreamReader(url_in, encoding)) : new BufferedReader(new InputStreamReader(url_in));
                while ((line = in.readLine()) != null) {
                    int equals = line.indexOf("=");
                    if (equals <= 0) continue;
                    String name = line.substring(0, equals).trim().toLowerCase();
                    String value = line.substring(equals + 1).trim();
                    parameters.put(name, value);
                }
                in.close();
                url_in.close();
            }
            catch (FileNotFoundException e) {
                System.out.println("Could not find resource: " + data_url.toExternalForm());
            }
            catch (IOException e) {
                System.out.println("Error reading from the URL resource: " + data_url.toExternalForm());
            }
            catch (SecurityException e) {
                System.out.println("Security exception reading from the URL resource: " + data_url.toExternalForm());
                e.printStackTrace();
            }
        }
    }

    public void setParameters(Hashtable parameters) {
        Enumeration keys = parameters.keys();
        block0: while (keys.hasMoreElements()) {
            String param = (String)keys.nextElement();
            String value = (String)parameters.get(param);
            for (int i = 0; i < applet_parameters.length; ++i) {
                if (!param.startsWith(applet_parameters[i])) continue;
                this.setParameter(param, value);
                continue block0;
            }
        }
    }

    public void setParameter(String name, String value) {
        block108: {
            URL url;
            String cache_size;
            if (name == null) {
                return;
            }
            if (this.getParameter("labelAngleCacheSize") != null && (cache_size = this.getParameter("labelAngleCacheSize")) != null && cache_size.trim().length() > 0) {
                try {
                    Renderer.setLabelAngleCacheSize(Integer.parseInt(cache_size));
                }
                catch (NumberFormatException e) {
                    System.out.println("Invalid labelAngleCacheSize: " + cache_size);
                }
            }
            if ((name = name.toLowerCase()).equals("chart")) {
                if (value != null && !value.equals(this.chartType) && value.trim().length() > 0) {
                    value = value.trim().toLowerCase();
                    Chart newChart = null;
                    this.chartType = value;
                    if (value.equals("line") || value.equals("time_line") || value.equals("spline")) {
                        if ((value.equals("time_line") || value.equals("spline")) && newChart != this.lineChart) {
                            this.dataLoader = ChartApplet.createDataLoaderExt();
                            this.dataLoader.setChartType(this.chartType);
                            if (!this.doubleBufferingOff) {
                                this.theChart.getParent().setVisible(false);
                            }
                            this.theChart = this.chart = (Chart)this.dataLoader.setChart(this.theChart);
                            this.lineChart = (LineChart)this.theChart;
                            this.lineChart.addItemListener(this);
                            this.lineChart.addMouseListener(this);
                            this.lineChart.addMouseMotionListener(this);
                            if (this.doubleBufferingOff) {
                                this.removeAll();
                                this.add(this.theChart);
                                this.theChart.setVisible(true);
                            } else {
                                this.linePanel.removeAll();
                                this.linePanel.add(this.theChart);
                                this.linePanel.setVisible(true);
                            }
                        }
                        newChart = this.lineChart;
                    } else if (value.equals("bar")) {
                        this.chartType = "bar";
                        newChart = this.barChart;
                    } else if (value.equals("pie")) {
                        this.chartType = "pie";
                        newChart = this.pieChart;
                    } else if (value.equals("plotter")) {
                        this.dataLoader = ChartApplet.createDataLoaderExt();
                        this.chartType = "plotter";
                        this.plotterChart = this.dataLoader.createExtChart(this.chartType);
                        this.dataLoader.setChartType(this.chartType);
                        this.dataLoader.setChart(this.plotterChart);
                        this.plotterChart.addMouseListener(this);
                        this.removeAll();
                        if (this.doubleBufferingOff) {
                            this.add(this.plotterChart);
                            this.plotterChart.setSize(this.getSize().width, this.getSize().height);
                        } else {
                            NonFlickerPanel plotterPanel = new NonFlickerPanel(null);
                            plotterPanel.add(this.plotterChart);
                            this.add(plotterPanel);
                            plotterPanel.setSize(this.getSize().width, this.getSize().height);
                            this.plotterChart.setSize(this.getSize().width, this.getSize().height);
                        }
                        this.dataLoader.addChartItemListener(this);
                    } else if (value.equals("gauge")) {
                        this.dataLoader = ChartApplet.createDataLoaderExt();
                        try {
                            Class<?> loader_class = Class.forName("com.objectplanet.chart.ext.GaugeChart");
                            if (loader_class != null) {
                                Object instance = loader_class.newInstance();
                                if (instance instanceof Component) {
                                    this.gaugeChart = (Component)instance;
                                } else {
                                    System.out.println("Could not create class com.objectplanet.chart.ext.GaugeChart");
                                }
                            }
                        }
                        catch (ClassNotFoundException e) {
                            System.out.println("com.objectplanet.chart.ext.GaugeChart class not found.");
                        }
                        catch (InstantiationException e) {
                            System.out.println("Could not instantiate com.objectplanet.chart.ext.GaugeChart.");
                            System.out.println(e.getMessage());
                        }
                        catch (IllegalAccessException e) {
                            System.out.println("Could not instantiate com.objectplanet.chart.ext.GaugeChart.");
                            System.out.println(e.getMessage());
                        }
                        catch (Throwable e) {
                            System.out.println("Could not create com.objectplanet.chart.ext.GaugeChart, we keep running anyway");
                            System.out.println(e.getMessage());
                        }
                        this.chartType = "gauge";
                        this.dataLoader.setChartType(this.chartType);
                        this.dataLoader.setChart(this.gaugeChart);
                        this.removeAll();
                        if (this.doubleBufferingOff) {
                            this.add(this.gaugeChart);
                            this.gaugeChart.setSize(this.getSize().width, this.getSize().height);
                        } else {
                            NonFlickerPanel gaugePanel = new NonFlickerPanel(null);
                            gaugePanel.add(this.gaugeChart);
                            this.add(gaugePanel);
                            gaugePanel.setSize(this.getSize().width, this.getSize().height);
                            this.gaugeChart.setSize(this.getSize().width, this.getSize().height);
                        }
                        this.dataLoader.addChartItemListener(this);
                    } else {
                        System.out.println("invalid " + name + " " + value);
                    }
                    if (newChart != null && newChart != this.theChart) {
                        if (newChart.getParent() instanceof NonFlickerPanel) {
                            newChart.getParent().setVisible(true);
                            this.theChart.getParent().setVisible(false);
                        } else {
                            newChart.setVisible(true);
                            this.theChart.setVisible(false);
                        }
                        this.chartType = value;
                        this.chart = this.theChart = newChart;
                        this.dataLoader.setChartType(this.chartType);
                        this.dataLoader.setChart(this.theChart);
                        this.doLayout();
                    }
                }
                return;
            }
            if (this.theChart == null) {
                throw new IllegalStateException("theChart has not been set");
            }
            if (name.equals("width")) {
                if (value != null && value.trim().length() > 0) {
                    try {
                        int width = Integer.parseInt(value.trim());
                        this.setSize(width, this.theChart.getSize().height);
                        this.theChart.setSize(width, this.theChart.getSize().height);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid width: " + value);
                    }
                }
            } else if (name.equals("height")) {
                if (value != null && value.trim().length() > 0) {
                    try {
                        int height = Integer.parseInt(value.trim());
                        this.setSize(this.theChart.getSize().width, height);
                        this.theChart.setSize(this.theChart.getSize().width, height);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid height: " + value);
                    }
                }
            } else if (name.equals("automaticrefreshtime")) {
                try {
                    if (value != null && value.trim().length() > 0) {
                        this.automaticRefreshTime = Math.max(100, Integer.parseInt(value));
                        break block108;
                    }
                    this.automaticRefreshTime = 3600000;
                }
                catch (NumberFormatException e) {
                    System.out.println("Invalid automaticRefreshTime: " + value);
                    this.automaticRefreshTime = 3600000;
                }
            } else if (name.startsWith("urltarget")) {
                if (value != null && value.trim().length() > 0) {
                    this.urlTargetList.put(name, value);
                } else if (name.equals("urltarget")) {
                    this.urlTargetList.put(name, "_self");
                } else {
                    this.urlTargetList.remove(name);
                }
            } else if (name.startsWith("url")) {
                if (value != null && value.trim().length() > 0) {
                    if (value.trim().toLowerCase().startsWith("javascript:") || name.trim().toLowerCase().equals("url_default")) {
                        this.urlList.put(name, value);
                    } else {
                        url = this.createURL(value);
                        if (url != null) {
                            this.urlList.put(name, url);
                        }
                    }
                } else {
                    this.urlList.remove(name);
                }
            } else if (name.equals("singleclickurlon")) {
                this.singleClickURLOn = value != null && value.trim().equalsIgnoreCase("true");
            } else if (name.startsWith("legendimage_") || name.startsWith("plotimage")) {
                try {
                    if (value == null || value.trim().length() <= 0) break block108;
                    Image image = null;
                    try {
                        url = this.getDocumentBase();
                        image = this.getImage(url, value);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    this.dataLoader.setImage(name, image);
                }
                catch (SecurityException e) {
                    System.out.println("Security exception, could not load image: " + value);
                }
            } else if (name.equals("gridimage")) {
                try {
                    if (value == null || value.trim().length() <= 0) break block108;
                    Image image = null;
                    try {
                        url = this.getDocumentBase();
                        image = this.getImage(url, value);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    this.dataLoader.setImage("gridimage", image);
                }
                catch (SecurityException e) {
                    System.out.println("Security exception, could not load image: " + value);
                }
            } else if (name.startsWith("overlay")) {
                this.dataLoader.setParameter(name, value);
                ChartDataLoader overlayLoader = this.dataLoader.getOverlayDataLoader(name);
                int index = name.indexOf("_");
                if (index == -1 && !this.overlayCharts.containsKey(name)) {
                    if (value != null) {
                        value = value.trim().toLowerCase();
                        ChartApplet overlay = null;
                        if (value != null) {
                            if (value.equals("bar") || value.equals("line") || value.equals("spline") || value.equals("time_line") || value.equals("pie") || value.equals("plotter")) {
                                overlay = new ChartApplet(value);
                            } else {
                                System.out.println("Invalid overlay: " + name + " " + value);
                            }
                        }
                        if (overlay != null) {
                            overlay.setParentApplet(this);
                            overlay.setParameterPrefix(name + "_");
                            this.overlayCharts.put(name, overlay);
                            overlay.setDataLoader(overlayLoader);
                        }
                    } else {
                        this.overlayCharts.remove(name);
                    }
                }
            } else if (name.startsWith("samplehighlightimage")) {
                if (value != null && value.trim().length() > 0) {
                    Image image = null;
                    try {
                        url = this.getDocumentBase();
                        image = this.getImage(url, value);
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                    if (image != null) {
                        this.theChart.addImage(name, image);
                        try {
                            if (name.equals("samplehighlightimage")) {
                                this.lineChart.setSampleHighlightImage(-1, -1, name);
                                break block108;
                            }
                            if (name.indexOf(95, 21) == -1) {
                                int serie = Integer.parseInt(name.substring(21));
                                this.lineChart.setSampleHighlightImage(serie, -1, name);
                                break block108;
                            }
                            int serie = Integer.parseInt(name.substring(21, name.indexOf(95, 21)));
                            int sample = Integer.parseInt(name.substring(name.indexOf(95, 21) + 1));
                            this.lineChart.setSampleHighlightImage(serie, sample, name);
                        }
                        catch (NumberFormatException e) {
                            System.out.println("Invalid index in insideLableColor_N parameter: " + name);
                        }
                    }
                }
            } else if (name.equalsIgnoreCase("data")) {
                this.dataURL = value;
            } else if (name.equalsIgnoreCase("dataInterval")) {
                if (value != null && value.trim().length() > 0) {
                    try {
                        StringTokenizer st = new StringTokenizer(value, ",");
                        if (st.hasMoreTokens()) {
                            this.dataInterval = Integer.parseInt(st.nextToken().trim());
                        }
                        if (st.hasMoreTokens()) {
                            this.dataIntervalReset = st.nextToken().trim().equalsIgnoreCase("reset");
                        }
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid " + name + " " + value);
                    }
                }
            } else if (name.equalsIgnoreCase("exportURL")) {
                this.theChart.setLabel("export", "export", this.getSize().width - 40, this.getSize().height - 2);
                this.theChart.setLabelURL("export", value.trim());
                this.dataLoader.labelURLs.put("export", value.trim());
                this.dataLoader.labelURLTargets.put("export", "export_window");
            } else {
                this.dataLoader.setParameter(name, value);
            }
        }
    }

    public static Color createColor(String color) {
        return ChartDataLoader.createColor(color);
    }

    public Font createFont(String value, String name, int type, int size) {
        return this.dataLoader.createFont(value, name, type, size);
    }

    public void setParentApplet(Applet parent) {
        if (parent == this) {
            parent = null;
        }
        this.parentApplet = parent;
    }

    public AppletContext getAppletContext() {
        if (this.parentApplet != null) {
            return this.parentApplet.getAppletContext();
        }
        return super.getAppletContext();
    }

    public URL getDocumentBase() {
        if (this.parentApplet != null) {
            return this.parentApplet.getDocumentBase();
        }
        return super.getDocumentBase();
    }

    public void callJavaScript(String javascript) {
        if (javascript == null || !javascript.trim().toLowerCase().startsWith("javascript:")) {
            return;
        }
        try {
            String name;
            Class<?> jsObjectClass = Class.forName("netscape.javascript.JSObject");
            Method method = jsObjectClass.getMethod("getWindow", Class.forName("java.applet.Applet"));
            Object jsObject = method.invoke(null, this);
            Method jsmethod = jsObjectClass.getMethod("call", "".getClass(), new Object[0].getClass());
            int index = javascript.indexOf(":");
            javascript = javascript.substring(index + 1);
            index = javascript.indexOf("(");
            if (index >= 0) {
                name = javascript.substring(0, index);
                javascript = javascript.substring(index + 1);
            } else {
                name = javascript + "";
                javascript = "";
            }
            if (javascript.length() > 0 && javascript.endsWith(");")) {
                javascript = javascript.substring(0, javascript.length() - 2);
            } else if (javascript.length() > 0 && javascript.endsWith(")")) {
                javascript = javascript.substring(0, javascript.length() - 1);
            }
            StringTokenizer st = new StringTokenizer(javascript, ",");
            Object[] arguments = new Object[st.countTokens()];
            int count = 0;
            String token = null;
            boolean inside_quotes = false;
            while (st.hasMoreTokens()) {
                token = inside_quotes && token != null ? token + "," + st.nextToken() : st.nextToken();
                if (token.startsWith("'") && !inside_quotes) {
                    token = token.substring(1);
                    inside_quotes = true;
                }
                if (token.endsWith("'")) {
                    token = token.substring(0, token.length() - 1);
                    inside_quotes = false;
                }
                if (inside_quotes) continue;
                arguments[count++] = token;
            }
            jsmethod.invoke(jsObject, name, arguments);
        }
        catch (ClassNotFoundException ex) {
            System.out.println("ERROR: javascript call failed, could not find required netscape.javascript.JSObject class");
        }
        catch (NoSuchMethodException ex) {
            System.out.println("ERROR: javascript call failed, could not find JSObject.getWindow() method");
        }
        catch (SecurityException ex) {
            System.out.println("ERROR. javascript call failed, security exception");
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            System.out.println("ERROR: javascript call failed");
            ex.getTargetException().printStackTrace();
        }
        catch (Throwable ex) {
            System.out.println("ERROR: javascript url's not supported by browser");
            ex.printStackTrace();
        }
    }

    public String getParameter(String parameter) {
        String value = null;
        if (parameter != null) {
            if (this.parameterPrefix != null && this.parameterPrefix.length() > 0) {
                parameter = this.parameterPrefix + parameter;
            }
            if (this.parentApplet != null) {
                value = this.parentApplet.getParameter(parameter);
            } else {
                try {
                    value = super.getParameter(parameter);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (value == null && this.urlParameters != null) {
                    value = (String)this.urlParameters.get(parameter);
                }
            }
        }
        return value;
    }

    public void setParameterPrefix(String prefix) {
        this.parameterPrefix = prefix;
    }

    public String getParameterPrefix() {
        return this.parameterPrefix;
    }

    public String toString() {
        return this.theChart.toString();
    }

    protected Double[] getDoubleValues(String string) {
        return ChartApplet.getDoubleValues(string, this.valueDelimiter);
    }

    protected static Double[] getDoubleValues(String string, String delimiter) {
        return ChartDataLoader.getDoubleValues(string, delimiter);
    }

    protected String[] getStringValues(String string) {
        return ChartApplet.getStringValues(string, this.labelDelimiter);
    }

    protected static String[] getStringValues(String string, String delimiter) {
        return Chart.getStringValues(string, delimiter);
    }

    public String createArrayString(int[] array) {
        return this.dataLoader.createArrayString(array);
    }

    protected Color[] getColorValues(String string) {
        return this.dataLoader.getColorValues(string);
    }

    private URL createURL(String urlString) {
        URL url;
        block14: {
            if (urlString == null) {
                return null;
            }
            url = null;
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException e) {
                int paramIndex;
                if (urlString.trim().toLowerCase().startsWith("javascript:")) break block14;
                URL documentBase = null;
                try {
                    documentBase = this.getDocumentBase();
                }
                catch (NullPointerException ex) {
                    System.out.println("Not an applet, could not create url: " + urlString);
                }
                String base = "";
                if (documentBase != null) {
                    base = documentBase.toExternalForm();
                }
                if ((paramIndex = base.lastIndexOf("?")) > -1) {
                    base = base.substring(0, paramIndex);
                }
                if (urlString.startsWith("/")) {
                    int index = base.indexOf("//");
                    if (index >= 0 && (index = base.indexOf("/", index + 2)) >= 0) {
                        base = base.substring(0, index);
                    }
                } else if (!base.endsWith("/")) {
                    base = base.substring(0, base.lastIndexOf("/") + 1);
                }
                if (base.startsWith("file:/\\")) {
                    base = "file://" + base.substring(8);
                }
                try {
                    url = new URL(base + urlString);
                }
                catch (MalformedURLException ex) {
                    System.out.println("Invalid URL: " + base + urlString);
                }
            }
        }
        return url;
    }

    static String convertLineBreaks(String label) {
        return ChartDataLoader.convertLineBreaks(label);
    }

    public void print(Graphics g) {
        this.theChart.print(g);
    }

    public void doLayout() {
        if (this.chartType.equals("plotter")) {
            if (this.plotterChart != null) {
                if (this.plotterChart.getParent() instanceof NonFlickerPanel) {
                    this.plotterChart.getParent().setSize(this.getSize().width, this.getSize().height);
                }
                this.plotterChart.setSize(this.getSize().width, this.getSize().height);
            }
        } else if (this.chartType.equals("gauge")) {
            if (this.gaugeChart != null) {
                if (this.gaugeChart.getParent() instanceof NonFlickerPanel) {
                    this.gaugeChart.getParent().setSize(this.getSize().width, this.getSize().height);
                }
                this.gaugeChart.setSize(this.getSize().width, this.getSize().height);
            }
        } else if (this.theChart != null) {
            if (this.theChart.getParent() instanceof NonFlickerPanel) {
                this.theChart.getParent().setSize(this.getSize().width, this.getSize().height);
            }
            this.theChart.setSize(this.getSize().width, this.getSize().height);
        }
    }

    public void start() {
        if (this.automaticRefreshTime > 0) {
            this.refreshThread = new ChartAppletThread(0, this.toString() + ".THREAD_REFRESH");
            this.refreshThread.start();
        }
        if (this.dataInterval > 0) {
            this.dataIntervalThread = new ChartAppletThread(1, this.toString() + ".THREAD_DATA_INTERVAL");
            this.dataIntervalThread.start();
        }
    }

    public void stop() {
        Thread thisThread;
        if (this.refreshThread != null) {
            thisThread = this.refreshThread;
            this.refreshThread = null;
            thisThread.interrupt();
        }
        if (this.dataIntervalThread != null) {
            thisThread = this.dataIntervalThread;
            this.dataIntervalThread = null;
            thisThread.interrupt();
        }
    }

    public void destroy() {
        if (this.barPanel != null) {
            this.barPanel.release();
        }
        if (this.linePanel != null) {
            this.linePanel.release();
        }
        if (this.piePanel != null) {
            this.piePanel.release();
        }
    }

    private void refresh() {
        this.theChart.repaint();
    }

    public void itemStateChanged(ItemEvent e) {
        Object index;
        Object series;
        Object sample;
        if (this.chartType.equals("plotter")) {
            sample = (int[])e.getItem();
            if (sample == null || ((Object)sample).length < 2) {
                return;
            }
            series = sample[0];
            index = sample[1];
        } else {
            sample = (ChartSample)e.getItem();
            if (sample == null) {
                return;
            }
            index = ((ChartSample)sample).getIndex();
            series = ((ChartSample)sample).getSeries();
        }
        Component chart = (Component)e.getSource();
        if (e.getStateChange() == 1 && chart != null && (series != -1 || index != -1)) {
            boolean do_open;
            boolean same_sample;
            long time = System.currentTimeMillis();
            boolean bl = same_sample = index == this.lastSelectedSample && series == this.lastSelectedSeries;
            if (this.singleClickURLOn) {
                do_open = true;
            } else {
                boolean bl2 = do_open = same_sample && time - this.lastSelectedTime < 350L;
            }
            if (do_open) {
                Object url;
                ChartApplet source = this;
                if (!this.chartType.equals("plotter") && this.overlayCharts != null) {
                    Enumeration overlays = this.overlayCharts.elements();
                    while (overlays.hasMoreElements()) {
                        ChartApplet overlay = (ChartApplet)overlays.nextElement();
                        if (overlay == null || overlay.theChart != chart) continue;
                        source = overlay;
                        break;
                    }
                }
                if ((url = source.getSampleURL(this.seriesCountRead, (int)series, (int)index)) != null && url instanceof URL) {
                    String url_param = this.createURLParam("urltarget", (int)series, (int)index);
                    String target = (String)source.urlTargetList.get(url_param);
                    if (target == null) {
                        url_param = this.seriesCountRead > 1 ? this.createURLParam("urltarget", (int)series, -1) : this.createURLParam("urltarget", -1, (int)index);
                        target = (String)source.urlTargetList.get(url_param);
                    }
                    if (target == null) {
                        target = (String)source.urlTargetList.get("urltarget");
                    }
                    try {
                        AppletContext context = this.getAppletContext();
                        if (context != null) {
                            context.showDocument((URL)url, target);
                            this.URLOpened = true;
                        }
                    }
                    catch (NullPointerException ex) {
                        System.out.println("Not an applet, could not open url " + url);
                    }
                } else if (url != null && url instanceof String) {
                    this.callJavaScript((String)url);
                }
            }
            this.lastSelectedSample = index;
            this.lastSelectedSeries = series;
            this.lastSelectedTime = time;
        }
    }

    public void mouseMoved(MouseEvent event) {
        if (this.urlList == null || this.urlList.size() == 0) {
            return;
        }
        Chart chart = (Chart)event.getSource();
        Point point = new Point(event.getX(), event.getY());
        ChartSample selection = chart.checkSelection(point);
        int seriesCount = chart.getSeriesCount();
        Rectangle graphBounds = new Rectangle(chart.getGraphBounds());
        if (graphBounds == null) {
            return;
        }
        if (chart.is3DModeOn()) {
            graphBounds.x -= chart.depth3dPoint.x;
            graphBounds.width += chart.depth3dPoint.x;
            graphBounds.height -= chart.depth3dPoint.y;
        }
        if (this.urlList.get("url_default") != null && (graphBounds.contains(point) || this.chartType.equals("pie"))) {
            if (chart.new_cursor == Renderer.DEFAULT_CURSOR) {
                chart.setCursor(HAND_CURSOR);
            }
        } else if (graphBounds.contains(point) || this.chartType.equals("pie") || point.y == -1) {
            String id;
            Object url;
            Cursor cursor = Renderer.DEFAULT_CURSOR;
            if (selection != null && (url = this.getSampleURL(seriesCount, selection.getSeries(), selection.getIndex())) != null) {
                cursor = Renderer.HAND_CURSOR;
            }
            if ((id = chart.getLabelAtPoint(point.x, point.y)) != null && chart.labelURLs.get(id) != null) {
                cursor = HAND_CURSOR;
            }
            chart.setCursor(cursor);
        } else {
            chart.new_cursor = null;
        }
    }

    public void mouseDragged(MouseEvent event) {
    }

    public void mouseClicked(MouseEvent event) {
        int xpos = event.getX();
        int ypos = event.getY();
        GenericChart chart = (GenericChart)event.getSource();
        Point point = new Point(xpos, ypos);
        String id = chart.getLabelAtPoint(xpos, ypos);
        String adress = null;
        if (id != null) {
            adress = (String)this.dataLoader.labelURLs.get(id);
        } else {
            boolean do_open;
            boolean bl = do_open = !this.URLOpened;
            do_open = this.singleClickURLOn ? (do_open &= true) : (do_open &= System.currentTimeMillis() - this.lastClickTime < 350L);
            if (do_open &= chart.getGraphBounds().contains(point) || this.chartType.equals("pie")) {
                adress = (String)this.urlList.get("url_default");
            }
        }
        if (adress != null) {
            if (adress.trim().toLowerCase().startsWith("javascript:")) {
                this.callJavaScript(adress);
            } else {
                if (id != null && id.equals("export")) {
                    int height = this.getSize().height + 20;
                    int width = this.getSize().width + 20;
                    String new_window = "javascript:open('','export_window','height=" + height + ",width=" + width + "');";
                    this.callJavaScript(new_window);
                    adress = adress + "?";
                    this.parameters.put("width", this.getSize().width + "");
                    this.parameters.put("height", this.getSize().height + "");
                    Enumeration keys = this.parameters.keys();
                    while (keys.hasMoreElements()) {
                        String param = (String)keys.nextElement();
                        String value = (String)this.parameters.get(param);
                        adress = adress + param + "=" + URLEncoder.encode(value) + "&";
                    }
                }
                URL url = this.createURL(adress);
                String target = id != null ? (String)this.dataLoader.labelURLTargets.get(id) : (String)this.urlTargetList.get("urltarget_default");
                if (target == null) {
                    target = (String)this.dataLoader.labelURLTargets.get("urltarget");
                }
                try {
                    AppletContext context = this.getAppletContext();
                    if (context != null) {
                        context.showDocument(url, target);
                    }
                }
                catch (NullPointerException ex) {
                    System.out.println("Not an applet, could not open url " + url);
                }
            }
        }
        this.lastClickTime = System.currentTimeMillis();
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    private Object getSampleURL(int seriesCount, int series, int sample) {
        if (this.urlList == null) {
            return null;
        }
        String url_param = this.createURLParam("url", series, sample);
        Object url = this.urlList.get(url_param);
        if (url == null) {
            if (seriesCount > 1) {
                url_param = this.createURLParam("url", series, -1);
                url = this.urlList.get(url_param);
                if (url == null) {
                    url_param = this.createURLParam("url", -1, sample);
                }
            } else {
                url_param = this.createURLParam("url", -1, sample);
            }
            url = this.urlList.get(url_param);
        }
        if (url == null) {
            url = this.urlList.get(this.createURLParam("url", -1, -1));
        }
        return url;
    }

    private String createURLParam(String prefix, int serie, int sample) {
        String param = prefix;
        if (serie >= 0) {
            param = param + "_" + serie;
        } else if (this.theChart.getSeriesCount() > 1) {
            param = param + "_x";
        }
        if (sample >= 0) {
            if (this.chartType.equals("time_line")) {
                String timeplot = null;
                try {
                    Class<?> timeChartClass = Class.forName("com.objectplanet.chart.ext.TimeLineChart");
                    Class[] parameters = new Class[]{Integer.TYPE};
                    Method method = timeChartClass.getMethod("createTimeLabelBySample", parameters);
                    Object[] params = new Object[]{new Integer(sample)};
                    timeplot = (String)method.invoke((Object)this.lineChart, params);
                }
                catch (ClassNotFoundException e) {
                    System.out.println(e);
                }
                catch (NoSuchMethodException e) {
                    System.out.println(e);
                }
                catch (IllegalAccessException e) {
                    System.out.println(e);
                }
                catch (InvocationTargetException e) {
                    System.out.println(e);
                }
                param = param + "_" + timeplot;
            } else {
                param = param + "_" + sample;
            }
        }
        return param;
    }

    private class ChartAppletThread
    extends Thread {
        int threadType = -1;

        public ChartAppletThread(int type, String str) {
            super(str);
            this.threadType = type;
        }

        public void run() {
            switch (this.threadType) {
                case 0: {
                    try {
                        Thread thisThread = Thread.currentThread();
                        Thread.sleep((int)Math.random() * 1000);
                        while (ChartApplet.this.refreshThread == thisThread) {
                            Thread.sleep(ChartApplet.this.automaticRefreshTime);
                            if (ChartApplet.this.refreshThread != thisThread) continue;
                            if (!ChartApplet.this.chartType.equals("plotter") && !ChartApplet.this.chartType.equals("gauge")) {
                                ChartApplet.this.theChart.repaint();
                                continue;
                            }
                            if (ChartApplet.this.chartType.equals("plotter") && ChartApplet.this.plotterChart != null) {
                                ChartApplet.this.plotterChart.repaint();
                                continue;
                            }
                            if (!ChartApplet.this.chartType.equals("gauge") || ChartApplet.this.gaugeChart == null) continue;
                            ChartApplet.this.gaugeChart.repaint();
                        }
                        break;
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                case 1: {
                    try {
                        Thread thisThread = Thread.currentThread();
                        while (ChartApplet.this.dataInterval > 0 && ChartApplet.this.dataIntervalThread == thisThread) {
                            Hashtable parameters;
                            Dimension original_size;
                            Thread.sleep(ChartApplet.this.dataInterval * 1000);
                            if (ChartApplet.this.dataIntervalThread != thisThread) continue;
                            if (!ChartApplet.this.chartType.equals("plotter")) {
                                ChartApplet.this.theChart.setAutomaticRepaintOn(false);
                                original_size = ChartApplet.this.theChart.getSize();
                                parameters = new Hashtable();
                                if (ChartApplet.this.dataIntervalReset) {
                                    ChartApplet.this.reset();
                                    ChartApplet.this.loadOverlayParameters();
                                    ChartApplet.this.loadParameters(parameters);
                                }
                                ChartApplet.this.loadURLParameters(ChartApplet.this.dataURL, parameters);
                                ChartApplet.this.dataLoader.setParameters(parameters);
                                ChartApplet.this.setParameters(parameters);
                                ChartApplet.this.theChart.setSize(original_size);
                                ChartApplet.this.theChart.setAutomaticRepaintOn(true);
                                ChartApplet.this.theChart.repaint();
                                continue;
                            }
                            original_size = ChartApplet.this.plotterChart.getSize();
                            parameters = new Hashtable();
                            if (ChartApplet.this.dataIntervalReset) {
                                ChartApplet.this.reset();
                                ChartApplet.this.loadOverlayParameters();
                                ChartApplet.this.loadParameters(parameters);
                            }
                            ChartApplet.this.loadURLParameters(ChartApplet.this.dataURL, parameters);
                            ChartApplet.this.dataLoader.setParameters(parameters);
                            ChartApplet.this.setParameters(parameters);
                            ChartApplet.this.plotterChart.setSize(original_size);
                            ChartApplet.this.plotterChart.repaint();
                        }
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

