/*
 * Decompiled with CFR 0.152.
 */
package com.objectplanet.image;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

abstract class Encoder
implements ImageConsumer {
    private ImageProducer producer;
    protected ByteArrayOutputStream headerChunk;
    protected ByteArrayOutputStream idatChunk;
    protected DeflaterOutputStream deflaterOut;
    protected Deflater deflater;
    private CRC32 crc;
    protected int colorType;
    protected byte[] pngPixels;
    private boolean encoding;

    Encoder(int compression) {
        if (compression < -1 || compression > 9) {
            throw new IllegalArgumentException("Invalid compression: " + compression);
        }
        this.headerChunk = new ByteArrayOutputStream();
        this.idatChunk = new ByteArrayOutputStream();
        this.deflater = new Deflater(compression);
        this.crc = new CRC32();
    }

    void setCompression(int level) {
        this.deflater.setLevel(level);
    }

    synchronized void encode(Image image, DataOutputStream out) throws IOException {
        if (image == null || out == null) {
            return;
        }
        this.idatChunk.reset();
        this.idatChunk.write("IDAT".getBytes());
        this.deflater.reset();
        this.deflaterOut = new DeflaterOutputStream((OutputStream)this.idatChunk, this.deflater);
        this.encoding = true;
        this.producer = image.getSource();
        this.producer.startProduction(this);
        while (this.encoding) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.deflaterOut.finish();
        this.writeChunks(out);
    }

    public void setDimensions(int width, int height) {
        this.headerChunk.reset();
        try {
            DataOutputStream header = new DataOutputStream(this.headerChunk);
            header.write("IHDR".getBytes());
            header.writeInt(width);
            header.writeInt(height);
            header.write(8);
            header.write(this.colorType);
            header.write(0);
            header.write(0);
            header.write(0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setColorModel(ColorModel model) {
    }

    public abstract void setPixels(int var1, int var2, int var3, int var4, ColorModel var5, int[] var6, int var7, int var8);

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        if (model == null || pixels == null) {
            return;
        }
        int[] int_pixels = new int[pixels.length];
        for (int i = 0; i < pixels.length; ++i) {
            int_pixels[i] = pixels[i] & 0xFF;
        }
        this.setPixels(x, y, w, h, model, int_pixels, off, scansize);
    }

    public synchronized void imageComplete(int status) {
        this.producer.removeConsumer(this);
        this.encoding = false;
        this.notifyAll();
    }

    protected void writeChunks(DataOutputStream out) throws IOException {
        this.writeChunk(this.headerChunk, out);
        this.writeChunk(this.idatChunk, out);
    }

    protected void writeChunk(ByteArrayOutputStream chunk, DataOutputStream out) throws IOException {
        if (chunk != null && out != null) {
            out.writeInt(chunk.size() - 4);
            byte[] data = chunk.toByteArray();
            out.write(data);
            this.crc.reset();
            this.crc.update(data);
            out.writeInt((int)this.crc.getValue());
        }
    }

    public void setProperties(Hashtable props) {
    }

    public void setHints(int hintflags) {
    }
}

