/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.JmxMBeanData;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnector;
import javax.management.remote.rmi.RMIServer;
import javax.rmi.ssl.SslRMIClientSocketFactory;

public class DiscoverMBeans {
    private JMXServiceURL jmxService = null;
    private JMXConnector jmxConnector = null;
    private RMIConnector rmiConnector = null;
    private MBeanServerConnection beanServerConn = null;
    private String targetHost = null;
    private String jvmPort = null;
    private String jndiName = null;
    private String userName = null;
    private String password = null;

    public DiscoverMBeans() {
    }

    public DiscoverMBeans(String string, String string2, String string3, String string4, String string5) {
        this.targetHost = string;
        this.jvmPort = string2;
        this.jndiName = string3;
        this.userName = string4;
        this.password = string5;
    }

    private boolean connectToJVM() {
        boolean bl = false;
        if (this.jndiName == null || "None".equalsIgnoreCase(this.jndiName) || "Null".equalsIgnoreCase(this.jndiName)) {
            this.jndiName = "jmxrmi";
        }
        if (this.userName == null) {
            this.userName = "none";
        }
        if (this.password == null) {
            this.password = "none";
        }
        String string = "service:jmx:rmi:///jndi/rmi://" + this.targetHost + ":" + this.jvmPort + "/" + this.jndiName;
        try {
            String[] stringArray;
            this.jmxService = new JMXServiceURL(string);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("jmx.remote.protocol.provider.pkgs", "com.sun.jmx.remote.protocol");
            boolean bl2 = false;
            if (this.userName.equalsIgnoreCase("none") || this.password.equalsIgnoreCase("none")) {
                try {
                    this.jmxConnector = JMXConnectorFactory.connect(this.jmxService, hashMap);
                }
                catch (IOException iOException) {
                    bl2 = true;
                }
            } else {
                stringArray = new String[]{this.userName, this.password};
                hashMap.put("jmx.remote.credentials", stringArray);
                try {
                    this.jmxConnector = JMXConnectorFactory.connect(this.jmxService, hashMap);
                }
                catch (IOException iOException) {
                    bl2 = true;
                }
            }
            if (bl2) {
                stringArray = new SslRMIClientSocketFactory();
                Registry registry = LocateRegistry.getRegistry(this.targetHost, Integer.parseInt(this.jvmPort), (RMIClientSocketFactory)stringArray);
                RMIServer rMIServer = (RMIServer)registry.lookup(this.jndiName);
                this.rmiConnector = new RMIConnector(rMIServer, hashMap);
                this.rmiConnector.connect(hashMap);
                this.beanServerConn = this.rmiConnector.getMBeanServerConnection();
            } else {
                this.beanServerConn = this.jmxConnector.getMBeanServerConnection();
            }
            if (this.beanServerConn == null) {
                System.out.println("MBean Discovery  : connection to JVM is not established for " + this.targetHost);
                return false;
            }
            bl = true;
        }
        catch (Exception exception) {
            System.out.println("MBean Discovery  : connection to JVM is not established for " + this.targetHost);
            exception.printStackTrace();
            this.closeJVMConn();
            return false;
        }
        return bl;
    }

    private void closeJVMConn() {
        try {
            if (this.jmxConnector != null) {
                this.jmxConnector.close();
            }
            if (this.rmiConnector != null) {
                this.rmiConnector.close();
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public ArrayList getMBeanNames(String string) {
        ArrayList<Object> arrayList = new ArrayList();
        try {
            if (!this.connectToJVM()) {
                return arrayList;
            }
            Hashtable hashtable = this.displayAll(this.beanServerConn, string);
            Set set = hashtable.keySet();
            arrayList = new ArrayList(set);
        }
        catch (Exception exception) {
            System.out.println("Exception Occured in getMBeanNames..!!!!!!!!");
        }
        this.closeJVMConn();
        Collections.sort(arrayList);
        return arrayList;
    }

    public ArrayList getMBeanAttributeNames(String string, String string2) {
        ArrayList<Object> arrayList = new ArrayList();
        try {
            if (!this.connectToJVM()) {
                return arrayList;
            }
            Hashtable hashtable = this.displayAll(this.beanServerConn, string);
            Hashtable hashtable2 = (Hashtable)hashtable.get(string2);
            Set set = hashtable2.keySet();
            arrayList = new ArrayList(set);
        }
        catch (Exception exception) {
            System.out.println("Exception Occured in getMBeanAttributeNames..!!!!!!!!");
        }
        this.closeJVMConn();
        Collections.sort(arrayList);
        return arrayList;
    }

    public Hashtable getData() {
        Hashtable<String, Hashtable> hashtable;
        block4: {
            hashtable = new Hashtable<String, Hashtable>();
            try {
                if (this.connectToJVM()) {
                    String[] stringArray = this.beanServerConn.getDomains();
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string = stringArray[i];
                        Hashtable hashtable2 = this.displayAll(this.beanServerConn, string);
                        hashtable.put(string, hashtable2);
                    }
                    break block4;
                }
                return hashtable;
            }
            catch (Exception exception) {
                System.out.println("Exception Occured in Discoverying Domains !!!");
            }
        }
        this.closeJVMConn();
        return hashtable;
    }

    public ArrayList getDomains() {
        ArrayList<String> arrayList;
        block4: {
            arrayList = new ArrayList<String>();
            try {
                if (this.connectToJVM()) {
                    String[] stringArray = this.beanServerConn.getDomains();
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string = stringArray[i];
                        arrayList.add(string);
                    }
                    break block4;
                }
                return arrayList;
            }
            catch (Exception exception) {
                System.out.println("Exception Occured in Discoverying Domains !!!");
            }
        }
        this.closeJVMConn();
        Collections.sort(arrayList);
        return arrayList;
    }

    public Hashtable displayAll(MBeanServerConnection mBeanServerConnection, String string) throws IOException, JMException {
        JmxMBeanData jmxMBeanData = new JmxMBeanData(mBeanServerConnection, "manager");
        ObjectName objectName = new ObjectName(string + ":*");
        Set<ObjectName> set = mBeanServerConnection.queryNames(objectName, null);
        Iterator<ObjectName> iterator = set.iterator();
        ObjectName objectName2 = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, Hashtable<String, String>> hashtable2 = new Hashtable<String, Hashtable<String, String>>();
        String string2 = "";
        while (iterator.hasNext()) {
            objectName2 = iterator.next();
            String string3 = jmxMBeanData.toString(objectName2);
            StringTokenizer stringTokenizer = new StringTokenizer(string3, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken().trim();
                if (string4 != null && string4.startsWith("MBean:")) {
                    if (hashtable != null && hashtable.size() > 0) {
                        hashtable2.put(string2, hashtable);
                        hashtable = new Hashtable();
                    }
                    string2 = string4.substring(string4.indexOf(":") + 1).trim();
                    continue;
                }
                if (string4 == null || string4.length() <= 0 || string4.indexOf("=") <= 0) continue;
                String string5 = string4.substring(0, string4.indexOf("=")).trim();
                String string6 = string4.substring(string4.indexOf("=") + 1).trim();
                if (string5 == null || string6 == null) continue;
                hashtable.put(string5, string6);
            }
            if (hashtable == null || hashtable.size() <= 0) continue;
            hashtable2.put(string2, hashtable);
        }
        return hashtable2;
    }

    public Hashtable readFromDiscoveryFile(String string) {
        Hashtable hashtable = new Hashtable();
        try {
            Object object;
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string2 = "";
            String string3 = "";
            TreeSet<Object> treeSet = new TreeSet<Object>();
            Hashtable<Object, String> hashtable2 = new Hashtable<Object, String>();
            Hashtable<String, Hashtable<Object, String>> hashtable3 = new Hashtable<String, Hashtable<Object, String>>();
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2 != null && string2.startsWith("MBean:")) {
                    if (hashtable2 != null && hashtable2.size() > 0) {
                        hashtable3.put(string3, hashtable2);
                        hashtable2 = new Hashtable();
                    }
                    string3 = string2.substring(string2.indexOf(":") + 1).trim();
                    object = string3.substring(0, string3.indexOf(":")).trim();
                    treeSet.add(object);
                    continue;
                }
                if (string2 == null || string2.length() <= 0 || string2.indexOf("=") <= 0) continue;
                object = string2.substring(0, string2.indexOf("=")).trim();
                String string4 = string2.substring(string2.indexOf("=") + 1).trim();
                if (object == null || string4 == null) continue;
                hashtable2.put(object, string4);
            }
            if (hashtable2 != null && hashtable2.size() > 0) {
                hashtable3.put(string3, hashtable2);
            }
            bufferedReader.close();
            fileReader.close();
            object = new ArrayList(treeSet);
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                String string5 = (String)((ArrayList)object).get(i);
                Set set = hashtable3.keySet();
                Iterator iterator = set.iterator();
                Hashtable<String, Hashtable> hashtable4 = new Hashtable<String, Hashtable>();
                while (iterator.hasNext()) {
                    String string6 = (String)iterator.next();
                    if (!string6.startsWith(string5)) continue;
                    Hashtable hashtable5 = (Hashtable)hashtable3.get(string6);
                    hashtable4.put(string6, hashtable5);
                }
                hashtable.put(string5, hashtable4);
            }
            return hashtable;
        }
        catch (Exception exception) {
            System.out.println("Exception Occured while reading discovery file......!!!");
            exception.printStackTrace();
            return hashtable;
        }
    }
}

