/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgCheckDb;
import com.eg.EgCheckManagerThread;
import com.eg.EgConfigInfo;
import com.eg.EgDateInfo;
import com.eg.EgInstallInfo;
import com.eg.EgMailAlert;
import com.eg.EgReadHostInfo;
import com.eg.EgRecoverInfo;
import com.eg.EgSSL;
import com.eg.EgServicesInfo;
import com.eg.EgSms;
import com.eg.IniFile;
import com.eg.MyHostnameVerifier;
import com.eg.MyX509TrustManager;
import egurkha.BackupBean;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class EgCheckManager {
    public boolean debug = true;
    private String ent = "EgCheckManager";
    private String os;
    private String mailHost;
    private String mailPort;
    private String mailProtocol;
    private String localHost = this.getHostName();
    private int managerRestartCtr;
    private int managerToDbCtr;
    private int dbAlertCtr;
    private String monitorMailId;
    private EgConfigInfo confInfo = new EgConfigInfo("manager");
    EgServicesInfo servInfo = new EgServicesInfo("manager");
    EgRecoverInfo recoverInfo = new EgRecoverInfo("manager");
    EgDateInfo dateInfo = new EgDateInfo();
    private EgCheckDb dbCheck = new EgCheckDb();
    private String installDir = EgInstallInfo.getInstallDir();
    private String workFile = this.installDir + "/manager/.work";
    private String message = "";
    private String errMessage = "";
    private String subject = "eG Critical Alert!!!";
    private String host = "";
    private String port = "";
    private String ssl = "";
    private String s_urlString = null;
    private String context = "final";
    private String egInitState = "";
    private String egMgrInitState = "";
    private boolean needMgrRestart = false;
    HttpURLConnection url_connection = null;
    private String mailUser = null;
    private String mailPass = null;
    private boolean bool_alert = false;
    private long maxAllowedWorkRefresh = 900000L;
    private boolean isSSL = false;
    private boolean bkp_messflag = false;
    private String s_backupfailmess = "The eG manager failed to take a backup of the Config Files. Please check the eG manager config files for any corruption. \n Please check the eG Manager immediately! To revert to the last good backup of the eG manager configuration, you must copy the config files (.ini files) from <eG Install Dir>/manager/configbkp to the dir <eG Install Dir>/manager/config and restart the eG manager!";
    private String managerToDbFailMessage;
    private String alertMailFailMessage;
    private static String checkMgrLog = EgInstallInfo.getInstallDir() + "/manager/logs/checkmgr_log";
    Calendar cal;

    public EgCheckManager() {
        this.managerToDbFailMessage = "eG Manager on " + this.localHost + " : OK.\nDatabase on " + this.dbCheck.dbHost + " : OK.\neG Manager to Database: NOT OK\neG manager failed to connect to database. Possible reasons could be - The manager is running out of number of connections to the database. So try increasing the number of connections to the database and restart the manager. ";
        this.alertMailFailMessage = "Failed to send alert mail.";
        this.cal = Calendar.getInstance();
    }

    public static void main(String[] stringArray) {
        EgCheckManager egCheckManager = new EgCheckManager();
        if (stringArray.length > 0) {
            egCheckManager.debug = new Boolean(stringArray[0]);
        }
        egCheckManager.backupCheck();
        egCheckManager.checkManager();
    }

    public static synchronized void logToErrorFile(String string, String string2, String string3) {
        PrintWriter printWriter;
        EgDateInfo egDateInfo = new EgDateInfo();
        String string4 = egDateInfo.egetDate(false);
        try {
            printWriter = new PrintWriter(new FileWriter(checkMgrLog, true));
        }
        catch (Exception exception) {
            System.err.println("Cannot open log file " + checkMgrLog);
            return;
        }
        String string5 = new String(string4 + " " + string + " " + string2 + " " + string3);
        printWriter.println(string5);
        printWriter.flush();
        printWriter.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkManager() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object var9_14;
        Object object5;
        Object object6;
        String string;
        boolean bl;
        block48: {
            block49: {
                block47: {
                    System.setProperty("jsse.enableCBCProtection", "false");
                    File file = new File(checkMgrLog);
                    try {
                        file.delete();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.readProps();
                    EgReadHostInfo egReadHostInfo = new EgReadHostInfo();
                    String[] stringArray = egReadHostInfo.getHostInfo();
                    bl = false;
                    EgCheckManager.logToErrorFile("INFO", "EgCheckManager", "Check manager started ...");
                    if (stringArray == null || stringArray.length <= 1) break block47;
                    this.host = stringArray[0];
                    this.port = stringArray[1];
                    this.ssl = stringArray[2];
                    EgCheckManager.logToErrorFile("INFO", "EgCheckManager", "Host " + this.host + " port " + this.port + " ssl " + this.ssl);
                    string = "http://";
                    if (this.ssl == null) break block48;
                    break block49;
                }
                this.errMessage = "Failed to get host and port info";
                this.confInfo.logToErrorFile(this.ent, this.errMessage);
                this.errMessage = "";
                this.cleanUp();
                return;
            }
            if (this.ssl.equals("1")) {
                string = "https://";
                this.isSSL = true;
            }
        }
        this.s_urlString = string + this.host + ":" + this.port + "/" + this.context + "/servlet/com.eg.EgManagerAlertServlet";
        if (this.isSSL) {
            object6 = new EgServicesInfo("manager");
            bl = ((EgServicesInfo)object6).getSslMgrRestart();
            EgSSL egSSL = EgSSL.getInstance();
            egSSL.enableSSL();
            object5 = (SSLSocketFactory)SSLSocketFactory.getDefault();
            var9_14 = null;
            try {
                object4 = new MyX509TrustManager();
                KeyManager[] keyManagerArray = null;
                object3 = new TrustManager[]{object4};
                object2 = SSLContext.getInstance("SSL");
                ((SSLContext)object2).init(keyManagerArray, (TrustManager[])object3, new SecureRandom());
                object = ((SSLContext)object2).getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory((SSLSocketFactory)object);
                HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                EgCheckManager.logToErrorFile("INFO", "EgCheckManager", "Failed to set SSL properties");
                this.errMessage = "Failed to set SSL properties";
                this.confInfo.logToErrorFile(this.ent, this.errMessage);
                this.errMessage = "";
                this.cleanUp();
                return;
            }
        }
        object6 = new IniFile(EgConfigInfo.egMgrConfigDir + "eg_services.ini");
        int n = -1;
        try {
            object5 = ((IniFile)object6).getValue("MISC_ARGS", "CheckManager_restart_counter");
            if (object5 != null && ((String)object5).trim().length() > 0) {
                n = Integer.parseInt((String)object5);
            }
        }
        catch (Exception exception) {
            n = -1;
        }
        try {
            block50: {
                block51: {
                    block52: {
                        int n2;
                        int n3;
                        block45: {
                            n3 = 0;
                            var9_14 = null;
                            object4 = "";
                            try {
                                n2 = 0;
                                n3 = 0;
                                object3 = null;
                                while (true) {
                                    EgCheckManager.logToErrorFile("INFO", "EgCheckManager", "Connecting to " + this.s_urlString);
                                    object2 = new URL(this.s_urlString);
                                    try {
                                        ++n2;
                                        this.url_connection = (HttpURLConnection)((URL)object2).openConnection();
                                        this.url_connection.setUseCaches(false);
                                        this.url_connection.setDefaultUseCaches(false);
                                        this.url_connection.setRequestMethod("POST");
                                        this.url_connection.setDoOutput(true);
                                        object = new PrintWriter(this.url_connection.getOutputStream());
                                        ((PrintWriter)object).close();
                                        EgCheckManager.logToErrorFile("INFO", "EgCheckManager", "Started HTTP connection thread");
                                        object3 = new EgCheckManagerThread(this.url_connection);
                                        EgCheckManager.logToErrorFile("INFO", "EgCheckManager", "After starting HTTP connection thread");
                                        boolean bl2 = this.checkForTimeout((EgCheckManagerThread)object3);
                                        EgCheckManager.logToErrorFile("INFO", "EgCheckManager", "After timeout check - flag is " + bl2);
                                        if (bl2) {
                                            n3 = object3.code;
                                            EgCheckManager.logToErrorFile("INFO", "EgCheckManager", "Code is " + n3 + " result: " + object3.result + " initState: " + object3.egInitState + " mgrInitState: " + object3.egMgrInitState + " needMgrRestart: " + object3.needMgrRestart);
                                            if (n3 >= 200 && n3 < 300) {
                                                object4 = this.getServletResponse(this.url_connection, (EgCheckManagerThread)object3);
                                                if (object4 != null && (((String)object4).equalsIgnoreCase("null") || ((String)object4).equalsIgnoreCase("null<br>"))) {
                                                    object4 = null;
                                                }
                                                EgCheckManager.logToErrorFile("INFO", "EgCheckManager", "db_state is " + (String)object4);
                                                EgCheckManager.logToErrorFile("INFO", "EgCheckManager", "" + this.egInitState);
                                                EgCheckManager.logToErrorFile("INFO", "EgCheckManager", "" + this.egMgrInitState);
                                                EgCheckManager.logToErrorFile("INFO", "EgCheckManager", "needMgrRestart is " + this.needMgrRestart);
                                                if (object4 != null && ((String)object4).length() > 0 && !this.needMgrRestart) {
                                                    object2 = null;
                                                    break;
                                                }
                                            }
                                        }
                                        this.url_connection.disconnect();
                                    }
                                    catch (Exception exception) {
                                        EgCheckManager.logToErrorFile("INFO", "EgCheckManager", "Exception was " + exception.toString());
                                        n3 = 0;
                                        this.url_connection.disconnect();
                                    }
                                    if (n2 == 3) {
                                        object2 = null;
                                        break;
                                    }
                                    try {
                                        this.threadSleep(30000L);
                                    }
                                    catch (Exception exception) {}
                                }
                                object3 = null;
                                if (n3 < 200 || n3 >= 300 || object4 == null || ((String)object4).length() == 0 || this.needMgrRestart) {
                                    throw new Exception();
                                }
                                EgCheckManager.logToErrorFile("INFO", "EgCheckManager", "Checking work file " + this.workFile);
                                object2 = new File(this.workFile);
                                if (object2 == null) break block45;
                                long l = ((File)object2).lastModified();
                                EgCheckManager.logToErrorFile("INFO", "EgCheckManager", "Comparing work file time " + System.currentTimeMillis() + " " + l);
                                if (System.currentTimeMillis() - l <= this.maxAllowedWorkRefresh) break block45;
                                try {
                                    IniFile iniFile = new IniFile(EgConfigInfo.egMgrConfigDir + "eg_services.ini", true);
                                    iniFile.setValue("State_Maintain", "forceStop", "yes");
                                    iniFile.saveFile();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                EgCheckManager.logToErrorFile("INFO", "EgCheckManager", "Work file not updated properly!");
                                throw new Exception();
                            }
                            catch (Exception exception) {
                                EgCheckManager.logToErrorFile("INFO", "EgCheckManager", "Exception reached. isSSL " + this.isSSL + " sslMgrRestart " + bl + " ManagerRestartCtr " + this.managerRestartCtr);
                                if ((!this.isSSL || bl) && this.managerRestartCtr == 3) {
                                    this.sendManagerAlertMail();
                                    ++this.managerRestartCtr;
                                    this.recoverInfo.setManagerRestartCtr("" + this.managerRestartCtr);
                                }
                                if ((!this.isSSL || bl) && n > 0 && this.managerRestartCtr >= n) {
                                    int n4 = this.managerRestartCtr + 1;
                                    this.recoverInfo.setManagerRestartCtr("" + n4);
                                    this.cleanUp(true);
                                    return;
                                }
                                if (this.isSSL && !bl && this.managerRestartCtr == 0) {
                                    this.sendManagerAlertMail();
                                    ++this.managerRestartCtr;
                                    this.recoverInfo.setManagerRestartCtr("" + this.managerRestartCtr);
                                    this.cleanUp(true);
                                    return;
                                }
                                EgCheckManager.logToErrorFile("INFO", "EgCheckManager", "Trying to direct connect to the database ...");
                                boolean bl3 = this.directConnectToDb();
                                EgCheckManager.logToErrorFile("INFO", "EgCheckManager", "Database connection status is " + bl3);
                                if (!bl3) {
                                    this.message = this.message + this.dbCheck.getDbMessage();
                                    this.message = this.message + "\n" + this.getDetectDateTime();
                                    this.sop(this.dbCheck.getDbMessage());
                                    this.sop(this.getDetectDateTime());
                                    this.sop("");
                                    this.confInfo.logToErrorFile(this.ent, this.dbCheck.getDbMessage());
                                    if (this.managerRestartCtr <= 3) {
                                        this.bool_alert = this.sendAlert(this.message);
                                        this.message = "";
                                        if (this.bool_alert) {
                                            this.sop("DB Mail Alert Sent to eG monitor");
                                            this.sop("");
                                        } else {
                                            this.confInfo.logToErrorFile(this.ent, this.alertMailFailMessage);
                                        }
                                    }
                                } else {
                                    this.sop("");
                                }
                                if (!(this.isSSL && !bl || this.managerRestartCtr >= n && n != -1)) {
                                    EgCheckManager.logToErrorFile("INFO", "EgCheckManager", "Restarting the manager ...");
                                    this.startManager();
                                    EgCheckManager.logToErrorFile("INFO", "EgCheckManager", "After restarting the manager ...");
                                    int n5 = this.managerRestartCtr + 1;
                                    this.recoverInfo.setManagerRestartCtr("" + n5);
                                }
                                this.cleanUp(true);
                                return;
                            }
                        }
                        EgCheckManager.logToErrorFile("INFO", "EgCheckManager", "Response from the manager is " + n3);
                        if (n3 < 200 || n3 >= 300 || object4 == null || ((String)object4).length() <= 0) break block50;
                        if (this.managerRestartCtr > 0) {
                            this.recoverInfo.setManagerRestartCtr("0");
                        }
                        this.message = "\neG Manager: OK\n";
                        EgCheckManager.logToErrorFile("INFO", "EgCheckManager", "To get getServletResponse");
                        EgCheckManager.logToErrorFile("INFO", "EgCheckManager", "Servlet response is " + (String)object4);
                        if (object4 == null) break block51;
                        if (!((String)object4).equals("CONNECTIONFAILED")) break block52;
                        EgCheckManager.logToErrorFile("INFO", "EgCheckManager", "Trying to direct connect to the database ...");
                        n2 = this.directConnectToDb() ? 1 : 0;
                        EgCheckManager.logToErrorFile("INFO", "EgCheckManager", "After direct connecting to the database ...");
                        if (n2 != 0) {
                            if (this.dbAlertCtr > 0) {
                                EgCheckManager.logToErrorFile("INFO", "EgCheckManager", "Database Alert Counter is 0");
                                this.recoverInfo.setDbAlertCtr("0");
                            }
                            if (this.managerToDbCtr <= 3) {
                                this.sop("The eG Manager is running.");
                                this.sop("The eG Database is also running.");
                                this.sop("But the eG Manager failed to connect to database");
                                this.confInfo.logToErrorFile(this.ent, this.managerToDbFailMessage);
                                this.bool_alert = this.sendAlert(this.managerToDbFailMessage + "\n" + this.getDetectDateTime());
                                ++this.managerToDbCtr;
                                this.recoverInfo.setManagerToDbCtr("" + this.managerToDbCtr);
                                if (!this.bool_alert) {
                                    this.confInfo.logToErrorFile(this.ent, this.alertMailFailMessage);
                                    this.cleanUp(true);
                                    return;
                                }
                                this.sop("Mail Alert Sent to the eG admin");
                                this.sop("");
                                this.cleanUp(true);
                            }
                            break block50;
                        } else {
                            EgCheckManager.logToErrorFile("INFO", "EgCheckManager", "Database Alert Counter is " + this.dbAlertCtr);
                            if (this.dbAlertCtr < 3) {
                                this.message = this.message + this.dbCheck.getDbMessage();
                                this.message = this.message + "\n" + this.getDetectDateTime();
                                this.sop("Manager is running");
                                this.sop(this.dbCheck.getDbMessage());
                                this.sop(this.getDetectDateTime());
                                this.confInfo.logToErrorFile(this.ent, this.dbCheck.getDbMessage());
                                this.bool_alert = this.sendAlert(this.message);
                                ++this.dbAlertCtr;
                                this.recoverInfo.setDbAlertCtr("" + this.dbAlertCtr);
                                this.message = "";
                                if (!this.bool_alert) {
                                    this.confInfo.logToErrorFile(this.ent, this.alertMailFailMessage);
                                    this.cleanUp(true);
                                    return;
                                }
                                this.sop("Mail Alert Sent to eG monitor");
                                this.cleanUp(true);
                            }
                        }
                        break block50;
                    }
                    if (this.dbAlertCtr > 0) {
                        this.recoverInfo.setDbAlertCtr("0");
                    }
                    if (this.managerToDbCtr > 0) {
                        this.recoverInfo.setManagerToDbCtr("0");
                    }
                    break block50;
                }
                this.sop("Servlet response is null");
            }
            this.cleanUp();
        }
        catch (Exception exception) {
            this.cleanUp();
            exception.printStackTrace();
        }
        EgCheckManager.logToErrorFile("INFO", "EgCheckManager", "Done with eG Self Monitor check");
    }

    private void cleanUp(boolean bl) {
        try {
            if (this.url_connection != null) {
                this.url_connection.disconnect();
                this.url_connection = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.dbCheck != null) {
            this.dbCheck = null;
        }
        if (bl && this.managerRestartCtr <= 3) {
            this.saveLog();
        }
    }

    private void saveLog() {
        this.cal.clear();
        this.cal.setTime(new Date(this.dateInfo.egetUTCDate(false)));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm");
        String string = simpleDateFormat.format(this.cal.getTime());
        String string2 = EgInstallInfo.getInstallDir() + "/manager/logs/checkmgr_log." + string;
        EgInstallInfo.fileCopy(checkMgrLog, string2);
        File file = new File(string2);
        if (file.exists() && file.length() == 0L) {
            try {
                file.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void cleanUp() {
        this.cleanUp(false);
    }

    private String getServletResponse(HttpURLConnection httpURLConnection, EgCheckManagerThread egCheckManagerThread) {
        EgCheckManager.logToErrorFile("INFO", "EgCheckManager", "Before starting getServletResponse thread");
        EgCheckManager.logToErrorFile("INFO", "EgCheckManager", "After starting getServletResponse thread");
        this.egInitState = egCheckManagerThread.egInitState;
        this.egMgrInitState = egCheckManagerThread.egMgrInitState;
        this.needMgrRestart = egCheckManagerThread.needMgrRestart;
        return egCheckManagerThread.result;
    }

    private void readProps() {
        String string;
        this.os = this.servInfo.getManagerOs();
        this.mailHost = this.servInfo.getMailHostAdds();
        this.monitorMailId = this.servInfo.sendAgentManagerStatusToMultipleUsers() ? this.servInfo.getMailIDstoSendAgentManagertatus() : this.servInfo.getMonitorMailAdds();
        this.mailUser = this.servInfo.getMonitorMailUser();
        this.mailPass = this.servInfo.getMonitorMailPasswd();
        this.mailPort = this.servInfo.getMailHostPort();
        this.mailProtocol = this.servInfo.getMailHostProtocol();
        try {
            this.managerRestartCtr = Integer.parseInt(this.recoverInfo.getManagerRestartCtr());
        }
        catch (Exception exception) {
            string = this.recoverInfo.getManagerRestartCtr();
            if (string == null || string.equals("")) {
                this.recoverInfo.setManagerRestartCtr("0");
            }
            this.managerRestartCtr = 0;
        }
        try {
            this.dbAlertCtr = Integer.parseInt(this.recoverInfo.getDbAlertCtr());
        }
        catch (Exception exception) {
            string = this.recoverInfo.getDbAlertCtr();
            if (string == null || string.equals("")) {
                this.recoverInfo.setDbAlertCtr("0");
            }
            this.dbAlertCtr = 0;
        }
        try {
            this.managerToDbCtr = Integer.parseInt(this.recoverInfo.getManagerToDbCtr());
        }
        catch (Exception exception) {
            string = this.servInfo.getDbAlertTime();
            if (string == null || string.equals("")) {
                this.recoverInfo.setManagerToDbCtr("0");
            }
            this.managerToDbCtr = 0;
        }
    }

    private boolean directConnectToDb() {
        return this.dbCheck.isDbRunning();
    }

    private boolean sendAlert(String string) {
        int n;
        if (this.monitorMailId == null || this.monitorMailId.equals("")) {
            this.errMessage = "The eG administrator mail ID is not specified. Failed to send a mail alert ...";
            this.confInfo.logToErrorFile(this.ent, this.errMessage);
            this.errMessage = "";
            return false;
        }
        if (this.mailHost == null || this.mailHost.equals("")) {
            this.errMessage = "No Mail Host specified. Failed to send the mail alert.";
            this.confInfo.logToErrorFile(this.ent, this.errMessage);
            this.errMessage = "";
            return false;
        }
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(this.monitorMailId, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = stringTokenizer.nextToken().trim();
        }
        for (n = 0; n < stringArray.length; ++n) {
            String string3;
            int n2 = stringArray[n].indexOf("@");
            if (n2 >= 0) {
                string3 = "eG Status Report from manager on " + this.localHost + ": \n" + string + " \n" + string2;
                Vector<String> vector = new Vector<String>();
                vector.addElement(stringArray[n]);
                vector.addElement(this.subject);
                vector.addElement(string3);
                EgMailAlert egMailAlert = null;
                egMailAlert = new EgMailAlert(this.mailHost, this.mailPort, "EgCheckManager", this.mailUser, this.mailPass, this.mailProtocol);
                boolean bl = egMailAlert.sendMail(vector);
                vector = null;
                continue;
            }
            if (!EgSms.checkSettings()) continue;
            string3 = "eG Status:" + this.localHost + ": \n" + string;
            EgSms.send((String)stringArray[n], (String)string3);
        }
        return true;
    }

    private void sendManagerAlertMail() {
        try {
            String string = "The eG manager on " + this.localHost + " was not running. The third successive attempt is being made to restart it automatically...\n\n";
            this.confInfo.logToErrorFile(this.ent, string);
            string = string + this.getDetectDateTime();
            boolean bl = this.sendAlert(string);
            if (bl) {
                this.sop("Manager Alert mail Send");
                this.sop("");
            } else {
                this.confInfo.logToErrorFile(this.ent, this.alertMailFailMessage);
                this.sop("Failed to send Manager mail Alert");
                this.sop("");
            }
        }
        catch (Throwable throwable) {
            EgCheckManager.logToErrorFile("INFO", "EgCheckManager", "Failed to send Manager mail Alert." + throwable.toString());
        }
    }

    private void sop(String string) {
        if (this.debug) {
            System.out.println(string);
        }
    }

    private void sep(String string) {
        System.err.println(string);
    }

    private void startManager() {
        if (this.os == null || this.os.equals("")) {
            this.confInfo.logToErrorFile(this.ent, "Manager Os not defined in the ini file. Failed to start the manager.");
            return;
        }
        this.sop("Manager is not Running.");
        this.sop(this.getDetectDateTime());
        this.sop("Starting the manager. Please wait ......");
        boolean bl = false;
        bl = this.os.indexOf("WINDOWS") != -1 ? this.startManagerOnWindowsFromSixDotZero() : this.startManagerOnUnix("/bin/sh " + this.installDir + "/bin/start_manager");
        if (bl) {
            this.confInfo.logToErrorFile(this.ent, "The eG Manager was not functioning. So started the manager.");
        } else {
            this.confInfo.logToErrorFile(this.ent, "The eG Manager is not functioning. Failed to start the manager.");
        }
    }

    private boolean startManagerOnUnix(String string) {
        BufferedReader bufferedReader = null;
        EgCheckManager.logToErrorFile("INFO", "EgCheckManager", "Starting the eG Manager using the command ..." + string);
        bufferedReader = EgCheckManager.executeProgram(string);
        if (bufferedReader != null) {
            try {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    EgCheckManager.logToErrorFile("INFO", "EgCheckManager", string2);
                }
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                bufferedReader = null;
                return true;
            }
            catch (Exception exception) {
                System.out.println("EgCheckManager: " + exception.toString());
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                bufferedReader = null;
                return false;
            }
        }
        System.out.println("EgCheckManager:executeProgram returned null");
        return false;
    }

    private boolean startManagerOnWindows(String string) {
        String string2;
        BufferedReader bufferedReader = null;
        Vector<String> vector = new Vector<String>();
        Object[] objectArray = null;
        String string3 = EgConfigInfo.homeDir;
        int n = this.getSiteId();
        String string4 = "cmd /c cscript " + string3 + "/lib/startweb.vbs -a " + n;
        System.out.println(string4);
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
            while ((string2 = bufferedReader.readLine()) != null) {
                vector.addElement(string2);
            }
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            bufferedReader.close();
            bufferedReader = null;
        }
        catch (Exception exception) {
            System.out.println("Failed to start the manager");
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            bufferedReader = null;
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            bufferedReader = EgCheckManager.executeProgram("cmd /c " + (String)objectArray[i]);
            if (bufferedReader != null) {
                try {
                    while ((string2 = bufferedReader.readLine()) != null) {
                    }
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    bufferedReader = null;
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("EgCheckManager: " + exception.toString());
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Exception exception3) {
                            // empty catch block
                        }
                    }
                    bufferedReader = null;
                    return false;
                }
            }
            System.out.println("EgCheckManager:executeProgram returned null");
            return false;
        }
        bufferedReader = EgCheckManager.executeProgram(string4);
        if (bufferedReader != null) {
            try {
                while ((string2 = bufferedReader.readLine()) != null) {
                }
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                bufferedReader = null;
                return true;
            }
            catch (Exception exception) {
                System.out.println("EgCheckManager: " + exception.toString());
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception4) {
                        // empty catch block
                    }
                }
                bufferedReader = null;
                return false;
            }
        }
        System.out.println("EgCheckManager:executeProgram returned null");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startManagerOnWindowsFromSixDotZero() {
        BufferedReader bufferedReader = EgCheckManager.executeProgram(EgInstallInfo.getInstallDir() + "/lib/start_manager.bat");
        if (bufferedReader != null) {
            String string = null;
            try {
                while ((string = bufferedReader.readLine()) != null) {
                }
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        bufferedReader = null;
                    }
                }
                return true;
            }
            catch (Exception exception) {
                System.out.println("EgCheckManager: " + exception.toString());
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception2) {
                    }
                    finally {
                        bufferedReader = null;
                    }
                }
                return false;
            }
        }
        System.out.println("EgCheckManager:executeProgram returned null");
        return false;
    }

    private int getSiteId() {
        IniFile iniFile = new IniFile(EgConfigInfo.egMgrConfigDir + "eg_setup.ini");
        String string = iniFile.getValue("EGURKHA SITE", "ID");
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
        return n;
    }

    private static BufferedReader executeProgram(String string) {
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            process = runtime.exec(string);
            if (process == null) {
                return null;
            }
            return new BufferedReader(new InputStreamReader(process.getInputStream()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getDetectDateTime() {
        return "Detection Time : " + this.dateInfo.egetDate();
    }

    private boolean checkForTimeout(EgCheckManagerThread egCheckManagerThread) {
        long l;
        long l2 = EgConfigInfo.getResponseCodeTimeout;
        long l3 = 0L;
        long l4 = 100L;
        do {
            this.threadSleep(l4);
            if (egCheckManagerThread.done) {
                return true;
            }
            if ((l3 += l4) >= l2) {
                egCheckManagerThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                egCheckManagerThread.stop();
                return false;
            }
            l = l4 * 2L;
            if (l2 - l3 >= l) continue;
            l = l2 - l3;
        } while ((l4 = l) > 0L);
        egCheckManagerThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        egCheckManagerThread.stop();
        return false;
    }

    public void threadSleep(long l) {
        long l2 = this.dateInfo.egetUTCDate() + l;
        while (l > 0L) {
            block3: {
                try {
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    long l3 = this.dateInfo.egetUTCDate();
                    l = l2 - l3;
                    if (l >= 0L) break block3;
                    return;
                }
            }
            long l4 = this.dateInfo.egetUTCDate();
            l = l2 - l4;
        }
    }

    private String getHostName() {
        return EgInstallInfo.getHostName();
    }

    public void backupCheck() {
        try {
            String string = this.recoverInfo.getLastBkpTime();
            String string2 = this.recoverInfo.getBkpInterval();
            long l = 0L;
            long l2 = 3600L;
            if (string != null && string.trim().length() > 0) {
                try {
                    l = new Long(string);
                }
                catch (Exception exception) {
                    this.confInfo.logToErrorFile(this.ent, "Error reading backup time from recover config! " + exception.toString());
                }
            } else {
                this.recoverInfo.setBkpInterval("3600");
            }
            if (string2 != null && string2.trim().length() > 0) {
                try {
                    l2 = new Long(string2);
                }
                catch (Exception exception) {
                    this.confInfo.logToErrorFile(this.ent, "Error reading backup interval from recover config! " + exception.toString());
                }
            }
            this.dateInfo = new EgDateInfo();
            if (this.dateInfo.egetUTCDate() - l > l2 * 1000L) {
                if (this.backupMgrConfig()) {
                    this.recoverInfo.setLastBkpTime(Long.toString(this.dateInfo.egetUTCDate()));
                } else {
                    Thread.sleep(15000L);
                    this.bkp_messflag = true;
                    if (this.backupMgrConfig()) {
                        this.recoverInfo.setLastBkpTime(Long.toString(this.dateInfo.egetUTCDate()));
                    } else {
                        this.confInfo.logToErrorFile(this.ent, "Config Backup Failed!");
                    }
                }
            }
        }
        catch (Exception exception) {
            this.confInfo.logToErrorFile(this.ent, "Error while doing backup Check! " + exception.toString());
        }
    }

    private boolean backupMgrConfig() {
        try {
            EgConfigInfo egConfigInfo = new EgConfigInfo("manager");
            String string = "Site_servers";
            File file = new File(EgConfigInfo.egMgrConfigDir + EgConfigInfo.egDiscoveryConfigFile);
            if (file.length() == 0L) {
                this.sop("File is dead");
                this.sendBackupAlert();
                return false;
            }
            IniFile iniFile = new IniFile(EgConfigInfo.egMgrConfigDir + EgConfigInfo.egDiscoveryConfigFile);
            String[] stringArray = iniFile.getSubjects();
            if (stringArray == null || stringArray.length <= 0) {
                this.sendBackupAlert();
                return false;
            }
            boolean bl = false;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals(string)) {
                    bl = true;
                    continue;
                }
                String[] stringArray2 = iniFile.getVariables(stringArray[i]);
                if (stringArray2 == null || stringArray2.length <= 0) {
                    this.sendBackupAlert();
                    return false;
                }
                if (stringArray2[0].startsWith("Format:")) continue;
                this.sendBackupAlert();
                return false;
            }
            if (!bl) {
                this.sendBackupAlert();
                return false;
            }
            return BackupBean.doConfigBackup();
        }
        catch (Exception exception) {
            this.confInfo.logToErrorFile(this.ent, "Error while performing config backup!");
            return false;
        }
    }

    public void sendBackupAlert() {
        if (this.bkp_messflag) {
            boolean bl = this.sendAlert(this.s_backupfailmess + "\n" + this.getDetectDateTime());
        }
    }
}

