/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.JmxMBeanData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnector;
import javax.management.remote.rmi.RMIServer;
import javax.rmi.ssl.SslRMIClientSocketFactory;

public class MBeanDiscover {
    private JMXServiceURL jmxService = null;
    private JMXConnector jmxConnector = null;
    private RMIConnector rmiConnector = null;
    private MBeanServerConnection beanServerConn = null;
    private String targetHost = null;
    private String jvmPort = null;
    private String jndiName = null;
    private String userName = null;
    private String password = null;
    private File file = null;
    private PrintWriter pw = null;
    private String outputFileName = null;
    private String jmxServiceURL = null;
    private String provider = null;
    private static final String defaultProvider = "com.sun.jmx.remote.protocol";
    private static final String jbossProvider = "org.jboss.mx.remoting.provider";

    public MBeanDiscover(String string, String string2, String string3, String string4, String string5, String string6) {
        this.targetHost = string;
        this.jvmPort = string2;
        this.jndiName = string3;
        this.userName = string5;
        this.password = string6;
        this.provider = string4;
        if (string4 == null) {
            string4 = defaultProvider;
        }
    }

    public MBeanDiscover(String string, String string2, String string3, String string4) {
        this.jmxServiceURL = string;
        this.userName = string3;
        this.password = string4;
        this.provider = string2;
        if (string2 == null) {
            string2 = defaultProvider;
        }
    }

    private boolean connectToJVM() {
        boolean bl = false;
        if (this.jndiName == null || "None".equalsIgnoreCase(this.jndiName) || "Null".equalsIgnoreCase(this.jndiName)) {
            this.jndiName = "jmxrmi";
        }
        if (this.userName == null) {
            this.userName = "none";
        }
        if (this.password == null) {
            this.password = "none";
        }
        String string = "";
        string = this.jmxServiceURL != null && this.jmxServiceURL.length() > 0 ? this.jmxServiceURL : "service:jmx:rmi:///jndi/rmi://" + this.targetHost + ":" + this.jvmPort + "/" + this.jndiName;
        try {
            String[] stringArray;
            this.jmxService = new JMXServiceURL(string);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("jmx.remote.protocol.provider.pkgs", this.provider);
            boolean bl2 = false;
            if (this.userName.equalsIgnoreCase("none") || this.password.equalsIgnoreCase("none")) {
                try {
                    this.jmxConnector = JMXConnectorFactory.connect(this.jmxService, hashMap);
                }
                catch (IOException iOException) {
                    bl2 = true;
                }
            } else {
                stringArray = new String[]{this.userName, this.password};
                hashMap.put("jmx.remote.credentials", stringArray);
                try {
                    this.jmxConnector = JMXConnectorFactory.connect(this.jmxService, hashMap);
                }
                catch (IOException iOException) {
                    bl2 = true;
                }
            }
            if (bl2) {
                stringArray = new SslRMIClientSocketFactory();
                Registry registry = LocateRegistry.getRegistry(this.targetHost, Integer.parseInt(this.jvmPort), (RMIClientSocketFactory)stringArray);
                RMIServer rMIServer = (RMIServer)registry.lookup(this.jndiName);
                this.rmiConnector = new RMIConnector(rMIServer, hashMap);
                this.rmiConnector.connect(hashMap);
                this.beanServerConn = this.rmiConnector.getMBeanServerConnection();
            } else {
                this.beanServerConn = this.jmxConnector.getMBeanServerConnection();
            }
            if (this.beanServerConn == null) {
                System.out.println("connection to JVM is not established for " + this.targetHost);
                return false;
            }
            bl = true;
        }
        catch (Exception exception) {
            System.out.println("connection to JVM is not established for " + this.targetHost);
            this.closeJVMConn();
            return false;
        }
        return bl;
    }

    private void closeJVMConn() {
        try {
            if (this.jmxConnector != null) {
                this.jmxConnector.close();
            }
            if (this.rmiConnector != null) {
                this.rmiConnector.close();
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public void displayAll(MBeanServerConnection mBeanServerConnection, ObjectName objectName) throws IOException, JMException {
        JmxMBeanData jmxMBeanData = new JmxMBeanData(mBeanServerConnection, "agent");
        Set<ObjectName> set = mBeanServerConnection.queryNames(objectName, null);
        Iterator<ObjectName> iterator = set.iterator();
        ObjectName objectName2 = null;
        while (iterator.hasNext()) {
            objectName2 = iterator.next();
            String string = jmxMBeanData.toString(objectName2);
            this.pw.println(string);
        }
    }

    public void writeToFile() {
        try {
            String string;
            this.connectToJVM();
            if (this.jmxServiceURL != null && this.jmxServiceURL.length() > 0) {
                int n = this.jmxServiceURL.lastIndexOf("//");
                String string2 = "MBeans_";
                if (n > 0) {
                    string = this.jmxServiceURL.substring(n + 2);
                    int n2 = string.indexOf("/");
                    if (n2 > 0) {
                        string = string.substring(0, n2);
                    }
                    if (string.indexOf(":") > 0) {
                        string = string.replaceAll(":", "_");
                    }
                    string2 = string2 + string + ".txt";
                }
                this.outputFileName = string2;
            } else {
                this.outputFileName = "MBeans_" + this.targetHost + "_" + this.jvmPort + ".txt";
            }
            this.file = new File(this.outputFileName);
            this.pw = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(this.file, false), "UTF-8"), true);
            String[] stringArray = this.beanServerConn.getDomains();
            for (int i = 0; i < stringArray.length; ++i) {
                string = stringArray[i];
                ObjectName objectName = new ObjectName(string + ":*");
                this.displayAll(this.beanServerConn, objectName);
            }
            System.out.println("MBean Information are stored in " + this.outputFileName);
            this.pw.close();
        }
        catch (Exception exception) {
            System.out.println("Exception in discoverMbeans");
            exception.printStackTrace();
        }
        this.closeJVMConn();
    }

    public static void main(String[] stringArray) throws IOException {
        Object object;
        BufferedReader bufferedReader;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        block34: {
            block33: {
                string7 = "";
                string6 = "";
                string5 = "";
                string4 = "";
                string3 = "";
                string2 = "";
                String string8 = "";
                string = "";
                int n = stringArray.length;
                bufferedReader = new BufferedReader(new InputStreamReader(System.in));
                System.out.println("***************************************************************************");
                System.out.println("             Please choose below option to connect JMX server               ");
                System.out.println("***************************************************************************");
                System.out.println("\t 1. Using HostName or IP & JMX Port \n");
                System.out.println("\t 2. Using JMX Service URL ");
                System.out.print("\nEnter the Choice <1>                               : ");
                string8 = bufferedReader.readLine();
                if (string8 != null && string8.length() == 0) {
                    string8 = "1";
                }
                if (!string8.equals("1")) break block33;
                switch (n) {
                    case 0: {
                        System.out.print("\nEnter the Target Host IP   <localhost>             : ");
                        string7 = bufferedReader.readLine();
                        if (string7 != null && string7.length() == 0) {
                            string7 = "localhost";
                        }
                        System.out.print("\nEnter the Jmx Port                                 : ");
                        string6 = bufferedReader.readLine();
                        System.out.print("\nEnter the JNDIPath   <jmxrmi>                      : ");
                        string5 = bufferedReader.readLine();
                        if (string5 != null && string5.length() == 0) {
                            string5 = "jmxrmi";
                        }
                        System.out.print("\nEnter the Provider   <com.sun.jmx.remote.protocol> : ");
                        string2 = bufferedReader.readLine();
                        if (string2 != null && string2.length() == 0) {
                            string2 = defaultProvider;
                        }
                        System.out.print("\nEnter the Username   <none>                        : ");
                        string4 = bufferedReader.readLine();
                        if (string4 != null && string4.length() == 0) {
                            string4 = "none";
                        }
                        System.out.print("\nEnter the Password   <none>                        : ");
                        string3 = bufferedReader.readLine();
                        if (string3 != null && string3.length() == 0) {
                            string3 = "none";
                        }
                        break block34;
                    }
                    case 2: {
                        string7 = stringArray[0];
                        string6 = stringArray[1];
                        break block34;
                    }
                    case 3: {
                        string7 = stringArray[0];
                        string6 = stringArray[1];
                        string5 = stringArray[2];
                        break block34;
                    }
                    case 4: {
                        string7 = stringArray[0];
                        string6 = stringArray[1];
                        string5 = stringArray[2];
                        string2 = stringArray[3];
                        break block34;
                    }
                    case 6: {
                        string7 = stringArray[0];
                        string6 = stringArray[1];
                        string5 = stringArray[2];
                        string2 = stringArray[3];
                        string4 = stringArray[4];
                        string3 = stringArray[5];
                        break block34;
                    }
                    default: {
                        System.out.println("\n");
                        System.out.println("Usage : java MBeanDiscover <HostIP> <RmiPort> [<JndiPath> <Provider>[<User> <password>]]");
                        System.out.println("\n");
                        System.out.println("\t (e.g) java MBeanDiscover 192.168.10.85 13600 ");
                        System.out.println("\n");
                        System.out.println("\t (e.g) java MBeanDiscover 192.168.10.85 13600 jmxrmi");
                        System.out.println("\n");
                        System.out.println("\t (e.g) java MBeanDiscover 192.168.10.85 13600 jmxrmi com.sun.jmx.remote.protocol");
                        System.out.println("\n");
                        System.out.println("\t (e.g) java MBeanDiscover 192.168.10.85 13600 jmxrmi com.sun.jmx.remote.protocol controlRole jboss");
                        System.out.println("\n");
                        return;
                    }
                }
            }
            System.out.print("\nEnter the JMX Service URL                          : ");
            string = bufferedReader.readLine();
            System.out.print("\n");
            System.out.println("\t Select a suitable JMX provider from the below");
            System.out.println("\t ----------------------------------------------");
            System.out.println("\t a. Default JMX Provider                   : com.sun.jmx.remote.protocol");
            System.out.println("\t b. JBossEAP / WildFly Provider            : org.jboss.mx.remoting.provider");
            System.out.println("\t c. Other JMX Provider (Type in manually) ");
            System.out.print("\nChoose the Provider   <a>                          : ");
            object = bufferedReader.readLine();
            if (object != null && ((String)object).length() > 0) {
                if (((String)object).equalsIgnoreCase("a")) {
                    string2 = defaultProvider;
                } else if (((String)object).equalsIgnoreCase("b")) {
                    string2 = jbossProvider;
                } else if (((String)object).equalsIgnoreCase("c")) {
                    System.out.print("\nEnter the JMX Provider                             : ");
                    String string9 = bufferedReader.readLine();
                    if (string9 != null) {
                        string2 = string9.length() == 0 ? defaultProvider : string9;
                    }
                } else {
                    string2 = defaultProvider;
                    System.out.println("\nInvalid choice, considering Default JMX Provider   :com.sun.jmx.remote.protocol");
                }
            }
            System.out.print("\nEnter the Username   <none>                        : ");
            string4 = bufferedReader.readLine();
            if (string4 != null && string4.length() == 0) {
                string4 = "none";
            }
            System.out.print("\nEnter the Password   <none>                        : ");
            string3 = bufferedReader.readLine();
            if (string3 != null && string3.length() == 0) {
                string3 = "none";
            }
        }
        object = null;
        boolean bl = false;
        if (string != null && string.length() > 0) {
            object = new MBeanDiscover(string, string2, string4, string3);
            bl = true;
        } else {
            object = new MBeanDiscover(string7, string6, string5, string2, string4, string3);
        }
        boolean bl2 = ((MBeanDiscover)object).connectToJVM();
        if (bl2) {
            if (bl) {
                System.out.println("\nJMX is ENABLED for the service url  : " + string + "  & CONNECTED SUCCESSFULLY !!");
            } else {
                System.out.println("\nJMX is ENABLED for the port : " + string6 + "  & CONNECTED SUCCESSFULLY !!");
            }
            ((MBeanDiscover)object).writeToFile();
        } else if (bl) {
            System.out.println("\nJMX connection is FAILED for the service url  : " + string);
        } else {
            System.out.println("\nJMX connection is FAILED for the port : " + string6);
        }
        try {
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

