/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jdbc;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.mock.jdbc.MockResultSet;
import com.mockrunner.util.common.ArrayUtil;
import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

public class MockArray
implements java.sql.Array,
Cloneable {
    private String sqlTypeName = "";
    private int baseType = 0;
    private Object array;
    private boolean wasFreeCalled = false;

    public MockArray(Object object) {
        this.array = ArrayUtil.convertToArray(object);
    }

    public void setBaseType(int n) {
        this.baseType = n;
    }

    public void setBaseTypeName(String string) {
        this.sqlTypeName = string;
    }

    public int getBaseType() throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        return this.baseType;
    }

    public String getBaseTypeName() throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        return this.sqlTypeName;
    }

    public Object getArray() throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        return this.array;
    }

    public Object getArray(Map map) throws SQLException {
        return this.getArray();
    }

    public Object getArray(long l, int n) throws SQLException {
        return ArrayUtil.truncateArray(this.getArray(), (int)(l - 1L), n);
    }

    public Object getArray(long l, int n, Map map) throws SQLException {
        return this.getArray(l, n);
    }

    public ResultSet getResultSet() throws SQLException {
        return this.getResultSet(1L, Array.getLength(this.array));
    }

    public ResultSet getResultSet(long l, int n) throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        Object[] objectArray = new Integer[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = new Integer(n2 + 1);
            ++n2;
        }
        Object[] objectArray2 = ArrayUtil.convertToObjectArray(this.array);
        objectArray2 = (Object[])ArrayUtil.truncateArray(objectArray2, (int)(l - 1L), n);
        MockResultSet mockResultSet = new MockResultSet(String.valueOf(this.hashCode()));
        mockResultSet.setResultSetType(1004);
        mockResultSet.setResultSetConcurrency(1007);
        mockResultSet.addColumn(objectArray);
        mockResultSet.addColumn(objectArray2);
        return mockResultSet;
    }

    public ResultSet getResultSet(long l, int n, Map map) throws SQLException {
        return this.getResultSet(l, n);
    }

    public ResultSet getResultSet(Map map) throws SQLException {
        return this.getResultSet();
    }

    public void free() throws SQLException {
        this.wasFreeCalled = true;
    }

    public boolean wasFreeCalled() {
        return this.wasFreeCalled;
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        MockArray mockArray = (MockArray)object;
        if (this.baseType != mockArray.baseType) {
            return false;
        }
        if (null == this.sqlTypeName && null != mockArray.sqlTypeName) {
            return false;
        }
        if (null != this.sqlTypeName && !this.sqlTypeName.equals(mockArray.sqlTypeName)) {
            return false;
        }
        if (this.wasFreeCalled != mockArray.wasFreeCalled()) {
            return false;
        }
        return ArrayUtil.areArraysEqual(this.array, mockArray.array);
    }

    public int hashCode() {
        int n = ArrayUtil.computeHashCode(this.array);
        n = 31 * n + this.baseType;
        if (null != this.sqlTypeName) {
            n = 31 * n + this.sqlTypeName.hashCode();
        }
        n = 31 * n + (this.wasFreeCalled ? 31 : 62);
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Array data: [");
        Object[] objectArray = ArrayUtil.convertToObjectArray(this.array);
        int n = 0;
        while (n < objectArray.length) {
            stringBuffer.append(objectArray[n]);
            if (n < objectArray.length - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public Object clone() {
        try {
            MockArray mockArray = (MockArray)super.clone();
            mockArray.array = ArrayUtil.copyArray(this.array);
            return mockArray;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new NestedApplicationException(cloneNotSupportedException);
        }
    }
}

