/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.web;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.mock.web.MockFilterChain;
import com.mockrunner.mock.web.MockFilterConfig;
import com.mockrunner.mock.web.MockHttpServletRequest;
import com.mockrunner.mock.web.MockHttpServletResponse;
import com.mockrunner.mock.web.MockHttpSession;
import com.mockrunner.mock.web.MockJspFactory;
import com.mockrunner.mock.web.MockPageContext;
import com.mockrunner.mock.web.MockServletConfig;
import com.mockrunner.mock.web.MockServletContext;
import java.lang.reflect.Constructor;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspFactory;

public class WebMockObjectFactory {
    private HttpServletRequest wrappedRequest;
    private HttpServletResponse wrappedResponse;
    private MockHttpServletRequest request;
    private MockHttpServletResponse response;
    private MockServletConfig config;
    private MockServletContext context;
    private MockHttpSession session;
    private MockPageContext pageContext;
    private MockFilterConfig filterConfig;
    private MockFilterChain filterChain;
    private JspFactory jspFactory;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletRequest;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletResponse;

    public WebMockObjectFactory() {
        this.createMockObjects();
    }

    public WebMockObjectFactory(WebMockObjectFactory webMockObjectFactory) {
        this.createMockObjectsBasedOn(webMockObjectFactory);
    }

    public WebMockObjectFactory(WebMockObjectFactory webMockObjectFactory, boolean bl) {
        this.createMockObjectsBasedOn(webMockObjectFactory, bl);
    }

    private void createMockObjects() {
        this.createNewMockObjects(true);
        this.context = this.createMockServletContext();
        this.setUpDependencies();
        JspFactory.setDefaultFactory((JspFactory)this.jspFactory);
    }

    private void createMockObjectsBasedOn(WebMockObjectFactory webMockObjectFactory) {
        this.createMockObjectsBasedOn(webMockObjectFactory, true);
    }

    private void createMockObjectsBasedOn(WebMockObjectFactory webMockObjectFactory, boolean bl) {
        this.createNewMockObjects(bl);
        if (!bl) {
            this.session = webMockObjectFactory.getMockSession();
        }
        this.context = webMockObjectFactory.getMockServletContext();
        this.setUpDependencies();
        JspFactory.setDefaultFactory((JspFactory)this.jspFactory);
    }

    private void createNewMockObjects(boolean bl) {
        this.request = this.createMockRequest();
        this.response = this.createMockResponse();
        this.wrappedRequest = this.request;
        this.wrappedResponse = this.response;
        if (bl) {
            this.session = this.createMockSession();
        }
        this.config = this.createMockServletConfig();
        this.filterChain = this.createMockFilterChain();
        this.filterConfig = this.createMockFilterConfig();
        this.jspFactory = this.createMockJspFactory();
    }

    private void setUpDependencies() {
        this.config.setServletContext(this.context);
        this.request.setSession(this.session);
        this.session.setupServletContext(this.context);
        this.pageContext = this.createMockPageContext();
        this.pageContext.setServletConfig(this.config);
        this.pageContext.setServletRequest((ServletRequest)this.request);
        this.pageContext.setServletResponse((ServletResponse)this.response);
        this.filterConfig.setupServletContext(this.context);
        this.setUpJspFactory();
    }

    private void setUpJspFactory() {
        if (this.jspFactory instanceof MockJspFactory) {
            ((MockJspFactory)this.jspFactory).setPageContext(this.pageContext);
        }
    }

    public void setDefaultJspFactory(JspFactory jspFactory) {
        JspFactory.setDefaultFactory((JspFactory)jspFactory);
        this.jspFactory = jspFactory;
        this.setUpJspFactory();
    }

    public void refresh() {
        this.pageContext = new MockPageContext(this.config, (ServletRequest)this.wrappedRequest, (ServletResponse)this.wrappedResponse);
        this.setUpJspFactory();
    }

    public MockServletContext createMockServletContext() {
        return new MockServletContext();
    }

    public MockServletConfig createMockServletConfig() {
        return new MockServletConfig();
    }

    public MockHttpServletResponse createMockResponse() {
        return new MockHttpServletResponse();
    }

    public MockHttpServletRequest createMockRequest() {
        return new MockHttpServletRequest();
    }

    public MockHttpSession createMockSession() {
        return new MockHttpSession();
    }

    public MockPageContext createMockPageContext() {
        return new MockPageContext();
    }

    public MockFilterConfig createMockFilterConfig() {
        return new MockFilterConfig();
    }

    public MockFilterChain createMockFilterChain() {
        return new MockFilterChain();
    }

    public MockJspFactory createMockJspFactory() {
        return new MockJspFactory();
    }

    public MockServletConfig getMockServletConfig() {
        return this.config;
    }

    public MockServletContext getMockServletContext() {
        return this.context;
    }

    public MockHttpServletRequest getMockRequest() {
        return this.request;
    }

    public MockHttpServletResponse getMockResponse() {
        return this.response;
    }

    public HttpServletRequest getWrappedRequest() {
        return this.wrappedRequest;
    }

    public HttpServletResponse getWrappedResponse() {
        return this.wrappedResponse;
    }

    public MockHttpSession getMockSession() {
        return this.session;
    }

    public MockHttpSession getSession() {
        return this.getMockSession();
    }

    public MockPageContext getMockPageContext() {
        return this.pageContext;
    }

    public MockFilterConfig getMockFilterConfig() {
        return this.filterConfig;
    }

    public MockFilterChain getMockFilterChain() {
        return this.filterChain;
    }

    public MockJspFactory getMockJspFactory() {
        if (this.jspFactory instanceof MockJspFactory) {
            return (MockJspFactory)this.jspFactory;
        }
        return null;
    }

    public JspFactory getJspFactory() {
        return this.jspFactory;
    }

    public void addRequestWrapper(Class clazz) {
        try {
            Constructor constructor = clazz.getConstructor(class$javax$servlet$http$HttpServletRequest == null ? (class$javax$servlet$http$HttpServletRequest = WebMockObjectFactory.class$("javax.servlet.http.HttpServletRequest")) : class$javax$servlet$http$HttpServletRequest);
            this.wrappedRequest = (HttpServletRequest)constructor.newInstance(this.wrappedRequest);
        }
        catch (Exception exception) {
            throw new NestedApplicationException(exception);
        }
    }

    public void addRequestWrapper(HttpServletRequest httpServletRequest) {
        this.wrappedRequest = httpServletRequest;
    }

    public void addResponseWrapper(Class clazz) {
        try {
            Constructor constructor = clazz.getConstructor(class$javax$servlet$http$HttpServletResponse == null ? (class$javax$servlet$http$HttpServletResponse = WebMockObjectFactory.class$("javax.servlet.http.HttpServletResponse")) : class$javax$servlet$http$HttpServletResponse);
            this.wrappedResponse = (HttpServletResponse)constructor.newInstance(this.wrappedResponse);
        }
        catch (Exception exception) {
            throw new NestedApplicationException(exception);
        }
    }

    public void addResponseWrapper(HttpServletResponse httpServletResponse) {
        this.wrappedResponse = httpServletResponse;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

